/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/symbol2.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: routines used by the type checking procedure		*
*									*
*									*
\* ******************************************************************* */

#include <stdio.h>
#include "SemAssert.h"
#include "macros.h"

Boolean  contains();

/***********************************************************************\
*	dot_type	types dot expressions				*
*									*
*	Last revised:	May 25, 1986					*
************************************************************************/

dot_type(dexp)
dotted	dexp;			/* dot expression to type */
{
    NamedType		nt;	/* nonterminal that is type of 
				   left expression */
    Boolean		TypeOK;	/* is type a user defined type? */
    Boolean 		lhsOK;  /* is lhs a collection? */
    Boolean		found;	/* has attribute been found? */
    AssertTypeOrError	lefttype;/* the type of left side of the dotted exp */
    SEQAttribute	SAtt;
    Attribute 		AnAtt;

    Assume((Isdotted(dexp)), "dot_type");

    TypeOK = FALSE;
    lhsOK = TRUE;

    lefttype = dexp->syn_left.IDLclassCommon->sem_type;
    if (typeof(lefttype) == Ksingleton)
    {
	if (IsNamedType(lefttype.Vsingleton->sem_type))
	{
	    nt = lefttype.Vsingleton->sem_type.VNamedType;
	    TypeOK = TRUE;
	    dexp->sem_type.Vsingleton = Nsingleton;
	}
    }
    else if (typeof(lefttype) == Karbitrary)
    {
	if (IsNamedType(lefttype.Varbitrary->sem_type))
	{
	    nt = lefttype.Varbitrary->sem_type.VNamedType;
	    TypeOK = TRUE;
	    dexp->sem_type.Varbitrary = Narbitrary;
	}
    }
    else lhsOK = FALSE;

    if (TypeOK)
    {
	if (typeof(nt) == KClass)
	/* check all attributes of class and node nonterminals for
	   a match with specified attribute			*/
	{
	    found = FALSE;
	    foreachinSEQAttribute(nt.VClass->sem_allattributes, SAtt, AnAtt){
		if (AnAtt->lex_name == dexp->syn_right->lex_name) {
		    found = TRUE;
		    SetAttributeEntity(dexp->syn_right, AnAtt);
		    dexp->sem_type.Vcollection.IDLclassCommon->sem_type.VTypeEntity =
				GetTypeEntity(AnAtt->syn_type);
		    break;
		}
	    }
	    if (!found) {
	        Warning0(750, dexp->syn_right->lex_namepos);
		SetErrorEntity(dexp->syn_right);
		dexp->sem_type.Varbitrary = Narbitrary;
		dexp->sem_type.Varbitrary->sem_type.Verror = Nerror;
	    }
	}
	else
	{
	    /* error: lhs of dotted exp must be a class */
	    Warning0(752, dexp->syn_left.IDLclassCommon->lex_expos);
	    dexp->sem_type.Varbitrary = Narbitrary;
	    dexp->sem_type.Varbitrary->sem_type.Verror = Nerror;
	}
    }
    else
    {
	dexp->sem_type.Varbitrary = Narbitrary;
	dexp->sem_type.Varbitrary->sem_type.Verror = Nerror;
	SetErrorEntity(dexp->syn_right);
	if (!lhsOK)
	    Warning0(751, dexp->syn_left.IDLclassCommon->lex_expos);
    }

}

/***********************************************************************
*	check_arg_types		checks types of a list of arguments	*
*				against the formal types of the 	*
*				declared declaration			*
*									*
*	Last revised:	April 19, 1986					*
************************************************************************/

check_arg_types(defn,arglist, instancematched)
Definition	defn;		/* definition declared */
SEQexpression	arglist;	/* list of arguments */
DefInstance 	*instancematched; /* instance which matches */
{
	Boolean 	match;  /* TRUE if an instance is matched */
	SETDefInstance	Sin;
	DefInstance	in;

	Assume((IsDefinition(defn)), "check_arg_types");
	match = FALSE;

	/* first check if there is an instance for which the arguments
	   are not distinct by type; if so, then arguments check out */

	foreachinSETDefInstance(defn->sem_overload,Sin,in)
	{
	    if (!distinct_arg(in.IDLclassCommon->syn_list,arglist)) {
	       match = TRUE;
	       *instancematched = in;
	       break;
	    }
	}

	/* if first check fails, then if then if any of the actual arguments
	 * are a class, see if there is an instance for each node of the class 
	 */
	 /***************Still needs to be coded *****/


	return(match);	
}


/***********************************************************************
*	distinct_formal		determine whether two sets of formal	*
*				arguments can be distinguished by length*
*				or by types				*
*									*
*	Last revised:	April 19, 1986					*
************************************************************************/

distinct_formal(form1,form2)
SEQFormal	form1,form2;	/* formal arguments to check	*/
{

	Formal		arg1,arg2;
	TypeEntity 	argtype1, argtype2;
	int 		form1len, form2len;
	int		i;

	Assume((TRUE), "distinct_formal");

	form1len = lengthSEQFormal(form1);
	form2len = lengthSEQFormal(form2);
	if (form1len != form2len)
	    return(TRUE);
	else for (i=1; i<=form1len; i++){
	    ithinSEQFormal(form1,i,arg1);
	    ithinSEQFormal(form2,i,arg2);
	    if (!EntityIsError(arg1->syn_type.IDLclassCommon) &&
		!EntityIsError(arg2->syn_type.IDLclassCommon)){
		argtype1 = GetTypeEntity(arg1->syn_type);
		argtype2 = GetTypeEntity(arg2->syn_type);
	    }
	    else {
		return(TRUE);
	    }
	    if (!(contains(argtype1, argtype2)||contains(argtype2, argtype1))){
		return(TRUE);
	    }
	}
	return(FALSE);
}



/***********************************************************************
*	distinct_arg	determine whether a set of formal arguments	*
*			and a set of actual arguments can be		*
*			distinguished by length or types		*
*									*
*	Last revised:	April 19, 1986					*
************************************************************************/

distinct_arg(form,args)
SEQFormal	form;	/* formal arguments to check	*/
SEQexpression	args;	/* actual arguments */
{

	Formal		arg_formal;
	expression	arg_actual;
	int 		formlen, argslen;
	TypeEntity	formaltype;
	TypeEntityOrError	actualtype;
	int		i;

	Assume((TRUE), "distinct_arg");

	formlen = lengthSEQFormal(form);
	argslen = lengthSEQexpression(args);
	if (formlen != argslen)
	    return(TRUE);
	else for (i=1; i<=formlen; i++) {
	    ithinSEQFormal(form,i,arg_formal);
	    ithinSEQexpression(args,i,arg_actual);
	    if (!EntityIsError(arg_formal->syn_type.IDLclassCommon))
		formaltype = GetTypeEntity(arg_formal->syn_type);
	    else return(TRUE);
	    if (Iscollection(arg_actual.IDLclassCommon->sem_type))
		actualtype = arg_actual.IDLclassCommon->sem_type.Vcollection.
				IDLclassCommon->sem_type;
	    else if (IsError(arg_actual.IDLclassCommon->sem_type))
		return(TRUE);
	    else actualtype.VTypeEntity = arg_actual.IDLclassCommon->sem_type.VTypeEntity;
#ifdef DEBUG2
(void) fprintf(stderr, "distinct_arg: (formal-actual) "); 
print_2types(formaltype, actualtype);
#endif

	    if (!(contains(formaltype, actualtype) || 
		  contains(actualtype, formaltype))) {
		return(TRUE);
	    }
	}
	return(FALSE);
}


/***********************************************************************
*	type_recursion	type all recursive references of a definition	*
*			to itself					*
*									*
*	Last revised:	June 11, 1986					*
************************************************************************/

type_recursion(def,body)
Definition	def;		/* definition that had a recursive call */
expression	body;		/* body of recursive definition 	*/	
{

    SEQexpressionPair	Sep;
    expressionPair	ep;
    SEQexpression	Sarg;
    expression		arg;
    SEQcase_select	Scs;
    case_select		Acs;


    Assume((IsDefinition(def)), "type_recursion");

    switch (typeof(body)) {

	case Kconditional:
	    type_recursion(def,body.Vconditional->syn_test);
	    type_recursion(def,body.Vconditional->syn_then);
	    type_recursion(def,body.Vconditional->syn_else);
	    foreachinSEQexpressionPair(body.Vconditional->syn_orif,Sep,ep)
	    {
	        type_recursion(def,ep->syn_test);
	        type_recursion(def,ep->syn_then);
	    }
	    break;

	case Kforallq:
	case Kexistsq:
	    type_recursion(def,body.Vquantifier.IDLclassCommon->syn_set);
	    type_recursion(def,body.Vquantifier.IDLclassCommon->syn_body);
	    break;

	case Kbinary:
	    type_recursion(def,body.Vbinary->syn_left);
	    type_recursion(def,body.Vbinary->syn_right);
	    break;

	case Kunary:
	    type_recursion(def,body.Vunary->syn_body);
	    break;

	case Kdotted:
	    type_recursion(def,body.Vdotted->syn_left);
	    break;

	case Kapplication:
	    foreachinSEQexpression(body.Vapplication->syn_arguments,Sarg,arg)
		type_recursion(def,arg);
	    if (streq(body.Vapplication->syn_instance->lex_name,def->sem_name))
		body.VExpNameRef->sem_type = def->sem_resulttype;
	    break;

	case KExpNameRef:
	    if (streq(body.VExpNameRef->lex_name,def->sem_name))
		body.VExpNameRef->sem_type = def->sem_resulttype;
	    break;

	case KcaseExp:
	    type_recursion(def, body.VcaseExp->syn_exp);
	    foreachinSEQcase_select(body.VcaseExp->syn_select, Scs, Acs)
		type_recursion(def, Acs->syn_exp);
	    if (typeof(body.VcaseExp->syn_otherwise) != KVoid)
		type_recursion(def, body.VcaseExp->syn_otherwise.Vexpression);
	    break;

	default:
	    /* no other expressions can include a definition call */
	    break;

	}  /* end of switch */
}

/* test if any arguments in sequence have type Class */
Boolean ArgIsClass(args)
SEQexpression args;
{
	SEQexpression Sexp;
	expression Aexp;

	foreachinSEQexpression(args, Sexp, Aexp)
	    if (typeof(Aexp.IDLclassCommon->sem_type)==KClass)
		return(TRUE);
	    else if (Iscollection(Aexp.IDLclassCommon->sem_type) &&
		     typeof(Aexp.IDLclassCommon->sem_type.Vcollection.
		     IDLclassCommon->sem_type)==KClass)
		return(TRUE);
	
	/* if this point is reached, no arguments had type Class */
	return(FALSE);
}
