/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/symbol.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: 								*
*									*
*               	x_type						*
*									*
\* ******************************************************************* */

#include "SemAssert.h"
#include <stdio.h>
#include "macros.h"


/************************************************************************
*	x_type								*
* Function which types expressions.					*
*  Recursively calls itself as it types subexpressions			*
*  Returns a typed expression that is the semantic meaning of the	*
*  given expression.							*
*									*
*	Last Revised:	June 10, 1986					*
************************************************************************/

expression	x_type(exp,SP,defcall,inst)
expression 		exp;	  /* expression to type */
StructureOrProcess	SP;	  /* structure or process */
Boolean			defcall;  /* true if typing a definition */
DefInstance		inst;     /* instance whose body is being typed */
{
	SEQexpressionPair	Sorif;
	expressionPair		ep;
	SEQFormal		Sf;
	Formal			Aformal;

	AssertTypeOrError	get_type_union_intersect();
	AssertTypeOrError	left_type;	/* type binary left subexp  */
	AssertTypeOrError	right_type;	/* type binary right subexp */
	int			boper;		/* binary operator	    */
	AssertType		type_name();	/* returns user type with
						   a given name		   */
	AssertTypeOrError	obj_type1;	/* type of objects in 
							collection */
	AssertTypeOrError	obj_type2;	/* type of objects in 
							collection */
	AssertTypeOrError	q_type;		/* type of a quantifier */
	AssertTypeOrError	OrIftype;
	Boolean			OK;		/* is type OK?		*/

	Definition		def;
	SEQexpression		Sexp;		/*  iterators ...	    */
	expression		a;

	SEQquantifier		quantStk;
	DefInstance		instancematched;

	SETPort			Spt;		/* iterators ...	   */
	Port			pt;
	SETDefInstance		Sin;
	DefInstance		in;
	SEQquantifier		Squant;
	quantifier		q;
	SEQcase_select		Scs;
	case_select		Acs;
	SEQcaseExp		Sce;
	caseExp			Ace;

	Boolean			form;		/* is expression a formal */
	Boolean			contrl;		/* is expression a control */
	Boolean			df;		/* is expression a definition */
	Boolean			te;		/* is expression a type exp */
	String			tempname;	/* name of a name expression 
						   or application	*/
	expression		tmpexp;		/* temporary expression */
	expression		tmpexp2;	/* temporary expression */
	portExpression		portExp;	/* temporary port exp */
	StructureEntity		st;		/* temporary structure */
	Port			port;		/* temporary port */
	AssertTypeOrError	case_type;
	TypeEntityOrError	tmptype;
	AssertTypeOrError	tmpatype;
	Boolean			casename;
	AssertType		GetPreludeDefType();
        Boolean                 ArgIsClass();
        Boolean                 IsPreludeDef();


	Assume((IsStructureOrProcess(SP)&&IsBoolean(defcall)), "x_type");

	Assume(((defcall&&IsDefInstance(inst))||TRUE), "x_type2");

	/* type each kind of expression			*/
	switch (typeof(exp)) {

	    case KcaseExp:
		typeExp(exp.VcaseExp->syn_exp);
		/* add case exp to stack */
		appendfrontSEQcaseExp(SP.IDLclassCommon->expStack, 
					exp.VcaseExp);
		case_type.Verror = Nerror;
		foreachinSEQcase_select(exp.VcaseExp->syn_select, Scs, Acs) {
		    if (EntityIsError(Acs->syn_type.IDLclassCommon))
			tmptype.Verror = Nerror;
		    else 
			tmptype.VTypeEntity = GetTypeEntity(Acs->syn_type);
		    appendfrontSEQTypeEntityOrError(SP.IDLclassCommon->exptypeStack,
						tmptype);
		    tmpexp = Acs->syn_exp;
		    typeExp(tmpexp);
		    if ((IsError(tmpexp.IDLclassCommon->sem_type))&&
		       (!IsArbitraryUniversal(tmpexp.IDLclassCommon->sem_type)))
		    {
			case_type = tmpexp.IDLclassCommon->sem_type;
		    }
		    removeSEQTypeEntityOrError(SP.IDLclassCommon->exptypeStack, 
					tmptype);
		}
		if (typeof(exp.VcaseExp->syn_otherwise) != KVoid) {
		    tmpatype = exp.VcaseExp->syn_exp.IDLclassCommon->sem_type;
		    if (Iscollection(tmpatype)) 
			tmptype = tmpatype.Vcollection.IDLclassCommon->sem_type;
		    else if (IsError(tmpatype))
			tmptype.Verror = tmpatype.Verror;
		    else 
			tmptype.VTypeEntity = tmpatype.VTypeEntity;
		    appendfrontSEQTypeEntityOrError(SP.IDLclassCommon->exptypeStack,
						tmptype);
		    tmpexp = exp.VcaseExp->syn_otherwise.Vexpression;
		    typeExp(tmpexp);
		    if (IsError(case_type)) {
			case_type = tmpexp.IDLclassCommon->sem_type;
		    }
		    removeSEQTypeEntityOrError(SP.IDLclassCommon->exptypeStack, 
					tmptype);
		}
		exp.VcaseExp->sem_type = case_type;
		/* remove case exp from stack */
		removeSEQcaseExp(SP.IDLclassCommon->expStack, exp.VcaseExp);
		break;

	    case Kconditional:

		/* type subexpressions of the conditional... 	*/
		tmpexp = exp.Vconditional->syn_test;
		typeExp(tmpexp);
		typeExp(exp.Vconditional->syn_then);
		typeExp(exp.Vconditional->syn_else);

		/* type all OrIf expressions		*/
		OrIftype.Verror = Nerror;
		foreachinSEQexpressionPair(exp.Vconditional->syn_orif,Sorif,ep) 
		{
		    typeExp(ep->syn_test);
		    typeExp(ep->syn_then);

		    tmpexp2 = ep->syn_then;
		    if ((!IsError(tmpexp2.IDLclassCommon->sem_type))&&
			(!IsArbitraryUniversal(tmpexp2.IDLclassCommon->sem_type)))
			OrIftype = tmpexp2.IDLclassCommon->sem_type;
	        }

		/* set type of conditional */
		tmpexp = exp.Vconditional->syn_then;
		tmpexp2 = exp.Vconditional->syn_else;
		if ((!IsError(tmpexp.IDLclassCommon->sem_type))&&
		    (!IsArbitraryUniversal(tmpexp.IDLclassCommon->sem_type)))
		    exp.Vconditional->sem_type = 
				tmpexp.IDLclassCommon->sem_type;
		else if ((!IsError(OrIftype))&&
		    (!IsArbitraryUniversal(OrIftype)))
		    exp.Vconditional->sem_type = OrIftype;
		else 
		    exp.Vconditional->sem_type=tmpexp2.IDLclassCommon->sem_type;
		break;

	    case Kforallq:	/* quantifiers */
	    case Kexistsq:

		/* Keep a record of all quantifiers		*/
		appendfrontSEQquantifier(SP.IDLclassCommon->quantStack,
						exp.Vquantifier);
		/* type set subexp and body			*/
		tmpexp = exp.Vquantifier.IDLclassCommon->syn_set;
		typeExp(tmpexp);
		tmpexp2 = exp.Vquantifier.IDLclassCommon->syn_body;
		typeExp(tmpexp2);

		exp.Vquantifier.IDLclassCommon->sem_type.VAtomic = 
						GetBooleanType(SP);


		/* remove quantifier from record of quantifiers	*/
		removeSEQquantifier(SP.IDLclassCommon->quantStack,
					exp.Vquantifier);

		break;

	    case Kbinary:

		/* type left and right subexps			*/
		typeExp(exp.Vbinary->syn_left);
		typeExp(exp.Vbinary->syn_right);

		left_type = exp.Vbinary->syn_left.IDLclassCommon->sem_type;
		right_type = exp.Vbinary->syn_right.IDLclassCommon->sem_type;

		/* singleton collection may be operands of value operators,
		   in which case type is type of object in collection	*/

		boper = typeof(exp.Vbinary->syn_op);
		if (!(boper == KsameOp || boper == Ksubset || 
			boper == KpropSubset || boper == KunionOp || 
			boper == KintersectOp)) {
		    if (typeof(left_type) == Ksingleton) {
			if (IsError(left_type.Vsingleton->sem_type))
			    left_type.Verror = Nerror;
			else
			    left_type.VTypeEntity = left_type.Vsingleton->sem_type.VTypeEntity;
		    }
		    if (typeof(right_type) == Ksingleton) {
			if (IsError(right_type.Vsingleton->sem_type))
			    right_type.Verror = Nerror;
			else
			    right_type.VTypeEntity= right_type.Vsingleton->sem_type.VTypeEntity;
		    }
		}

		/* default type for binary is Boolean */
		exp.Vbinary->sem_type.VAtomic = GetBooleanType(SP);

	/*  Handle errors in types of operands for various operators... */

		switch (boper) {

		case KunionOp:
		case KintersectOp:
		    OK = TRUE;
		    if ((typeof(left_type) != Ksingleton 
			    && typeof(left_type) != Karbitrary
			    && !IsError(left_type) ) ||
		       (typeof(right_type) != Ksingleton
			    && typeof(right_type) != Karbitrary
			    && !IsError(right_type) ))
			    OK = FALSE;			    

		    if (OK)
		    {
			if (IsError(left_type)) {
			    obj_type1.Verror = left_type.Verror;
			}
			else {
			    if (IsError(left_type.Vcollection.IDLclassCommon
				->sem_type))
				obj_type1.Verror = Nerror;
			    else
				obj_type1.VTypeEntity = left_type.Vcollection.
				IDLclassCommon->sem_type.VTypeEntity;
			}
			if (IsError(right_type) ) {
			    obj_type2.Verror = right_type.Verror;
			}
			else {
			    if (IsError(right_type.Vcollection.IDLclassCommon->
					sem_type) )
				obj_type2.Verror = Nerror;
			    else
				obj_type2.VTypeEntity = right_type.Vcollection.
				IDLclassCommon->sem_type.VTypeEntity;
			}
		    }			   
				   
		    exp.Vbinary->sem_type =
			get_type_union_intersect(left_type, right_type, boper);

		    break;

		case Kplus:
		case Kminus:
		case Ktimes:
		case Kdivide:
		    if ((typeof(left_type)==Karbitrary)||
			(typeof(left_type)==Ksingleton))
			if (IsError(left_type.Vcollection.IDLclassCommon->sem_type))
			    left_type.Verror = Nerror;
			else
			    left_type.VTypeEntity = 
				left_type.Vcollection.IDLclassCommon->sem_type.VTypeEntity;
		    if ((typeof(right_type)==Karbitrary)||
			(typeof(right_type)==Ksingleton))
			if (IsError(right_type.Vcollection.IDLclassCommon->sem_type))
			    right_type.Verror = Nerror;
			else
			    right_type.VTypeEntity = 
				right_type.Vcollection.IDLclassCommon->sem_type.VTypeEntity;
				
		    if (IsError(left_type) && IsError(right_type) )
			exp.Vbinary->sem_type.Verror = Nerror;
		    else
			if (IsRationalType(left_type) ||
			   IsRationalType(right_type))
			    exp.Vbinary->sem_type.VAtomic = GetRationalType(SP);
			else exp.Vbinary->sem_type.VAtomic = GetIntegerType(SP);
		    break;
		} /* end switch (boper) */

		break;

	    case Kunary:

		/* type body of unary exp		*/
		typeExp(exp.Vunary->syn_body);
		exp.Vunary->sem_type =
			exp.Vunary->syn_body.IDLclassCommon->sem_type;
		break;



	    case Kapplication:

		/* type arguments */
		foreachinSEQexpression(exp.Vapplication->syn_arguments,Sexp,a)
		{
		    typeExp(a);
		}


		/* check if an existing definition applies		*/

		if (TypeOfEntity(exp.Vapplication->syn_instance)==KDefinition) {
		    /* if def found, check argument types  */
		    def = GetDefineEntity(exp.Vapplication->syn_instance);
		    if (!check_arg_types(def,exp.Vapplication->syn_arguments, 
						&instancematched)) {
			/* if one of the arg types is a class, then
			 * assign the definition type
			 */
			if (ArgIsClass(exp.Vapplication->syn_arguments)) {
			    exp.Vapplication->sem_type = def->sem_resulttype;
			}
			else {
			    Warning1(723,exp.Vapplication->lex_expos,
				     def->sem_name);
			    exp.Vapplication->sem_type.Verror = Nerror;
			}
		    }
		    else {
			SetDefInstanceEntity(exp.Vapplication->syn_instance,
						instancematched);

			/* check if it's a prelude definition, if so
			 * determine correct type for application */
			if (IsPreludeDef(def)) {
			    exp.Vapplication->sem_type.VAssertType =
				    GetPreludeDefType(def, instancematched,
					exp.Vapplication->syn_arguments);
			}

			/* else set type of application to type of def */
			else exp.Vapplication->sem_type = def->sem_resulttype;
		    }
		}

		/* else nothing matches ...  */
		else {
		    Warning1(724, exp.Vapplication->lex_expos,
			     exp.Vapplication->syn_instance->lex_name);
		    exp.Vapplication->sem_type.Verror = Nerror;
		}

		break;

	    case Kdotted:
		typeExp(exp.Vdotted->syn_left);
		dot_type(exp.Vdotted);
		break;


	    case KportExpression:
		portExp = exp.VportExpression;
		portExp->sem_type.Varbitrary = Narbitrary;
		if (!EntityIsError(portExp->syn_type.IDLclassCommon)) {
		    portExp->sem_type.Varbitrary->sem_type.VTypeEntity
			= GetTypeEntity(portExp->syn_type);
		}
		else {
		    portExp->sem_type.Verror = Nerror;
		}

	    	if (typeof(SP) == KStructureEntity)
	    	{
		    /* Parser will not return a port expression unless the
		    port is specified, so we know there must be an error */
		    Warning0(725,portExp->lex_expos);
	    	}
		else /* a process port expression */
		{
		    foreachinSETPort(SP.VProcessEntity->sem_ports,Spt,pt) {
			if (streq(pt->lex_name,exp.VportExpression
				->syn_portName->lex_name)) {
			    SetPortEntity(portExp->syn_portName, pt);
			    break;
			}
		    }

		    if (TypeOfEntity(portExp->syn_portName) != KPort) {
			Warning0(726,portExp->syn_portName->lex_namepos);
		    }
		}

		break;

	    case KExpSetRef:
		exp.VExpSetRef->sem_type.Vsingleton = Nsingleton;
		exp.VExpSetRef->sem_type.Vsingleton->sem_type.VSetOf = 
				GetSetEntity(exp.VExpSetRef);
		break;

	    case KExpSeqRef:
		exp.VExpSeqRef->sem_type.Vsingleton = Nsingleton;
		exp.VExpSeqRef->sem_type.Vsingleton->sem_type.VSeqOf = 
				GetSeqEntity(exp.VExpSeqRef);
		break;

	    case KExpNameRef:
		
		tempname = exp.VExpNameRef->lex_name;
		form = FALSE;
		contrl = FALSE;
		df = FALSE;
		te = FALSE;

		/* check for a parameter-less definition */
		if (TypeOfEntity(exp.VExpNameRef) == KDefinition) {
		    df = TRUE;
		    def = GetDefineEntity(exp.VExpNameRef);
		    exp.VExpNameRef->sem_type.Verror = Nerror;
		    foreachinSETDefInstance(def->sem_overload,Sin,in) {
			if (lengthSEQFormal(in.IDLclassCommon->syn_list)==0) {
			    SetDefInstanceEntity(exp.VExpNameRef, in);
			    exp.VExpNameRef->sem_type = def->sem_resulttype;
			}
		    }
		}

		/* check if name refers to a named type */
		else if ((TypeOfEntity(exp.VExpNameRef)==KClass)||
			 (TypeOfEntity(exp.VExpNameRef)==KAtomic)) {
		    te = TRUE;
		    exp.VExpNameRef->sem_type.Vsingleton = Nsingleton;
		    exp.VExpNameRef->sem_type.Vsingleton->sem_type.VNamedType =
			exp.VExpNameRef->sem_entity.VNamedType;
		}

		/* if within a definition, check if name is a formal param */
		if (!df && !te && (defcall == TRUE)) {
		    foreachinSEQFormal(inst.IDLclassCommon->syn_list, Sf, 
					Aformal) {
			if (tempname == Aformal->lex_name){
			    SetFormalEntity(exp.VExpNameRef, Aformal);
			    form = TRUE;
			    break;
			}
		    }
		    if (form) {
			if (!EntityIsError(Aformal->syn_type.IDLclassCommon)) {
			    exp.VExpNameRef->sem_type.Vsingleton = Nsingleton;
			    exp.VExpNameRef->sem_type.Vsingleton->sem_type.VTypeEntity =
				GetTypeEntity(Aformal->syn_type);
			}
			else {
			    exp.VExpNameRef->sem_type.Verror = Nerror;
			}
		    }
		}

		/* check if control var for quantifier */
		if (!df && !te && !form) {
	    
		    quantStk = SP.IDLclassCommon->quantStack;
		    foreachinSEQquantifier(quantStk,Squant,q) {
			if (tempname ==
				  q.IDLclassCommon->syn_control->lex_name) {
			    exp.VExpNameRef->sem_entity.VControl = 
						q.IDLclassCommon->syn_control;

			    exp.VExpNameRef->sem_type.Vsingleton = Nsingleton;
			    q_type = q.IDLclassCommon->syn_set.IDLclassCommon
					->sem_type;
			    if ((typeof(q_type) == Karbitrary) ||
				(typeof(q_type) == Ksingleton)) {
				exp.VExpNameRef->sem_type.Vsingleton->
					sem_type = q_type.Vcollection.
						IDLclassCommon->sem_type;
			    }
			    else {
				exp.VExpNameRef->sem_type.Vsingleton
				    ->sem_type.Verror = Nerror;
			    }

			    contrl = TRUE;
			    break;
			}
		    }
		}
		/* test for CaseName */
		if (!df && !te && !form && !contrl) {
		    foreachinSEQcaseExp(SP.IDLclassCommon->expStack, Sce, Ace) {
			if (tempname == Ace->syn_casename->lex_name) {
			    casename = TRUE;
			    exp.VExpNameRef->sem_entity.VCaseName = 
						Ace->syn_casename;
			    retrievefirstSEQTypeEntityOrError(SP.IDLclassCommon->
						exptypeStack, tmptype);
			    exp.VExpNameRef->sem_type.Vsingleton = Nsingleton;
			    exp.VExpNameRef->sem_type.Vsingleton->sem_type
						= tmptype;
			    break;
			}
		    }
		    if (!casename) {
			SetErrorEntity(exp.VExpNameRef);
		    }
		}
		break;

	    case KrootExp:
		exp.VrootExp->sem_type.Vsingleton = Nsingleton;
		exp.VrootExp->sem_type.Vsingleton->sem_type.Verror = Nerror;

		if (typeof(exp.VrootExp->syn_portName) == KVoid)
		{
		    if (typeof(SP) == KStructureEntity) {
			st = SP.VStructureEntity;
			if (typeof(st->sem_root)!=KVoid) {
			    exp.VrootExp->sem_type.Vsingleton->sem_type.VTypeEntity
				= st->sem_root.VTypeEntity;
			}
			else {  /* error no root in structure */
				/* can't happen since port structure */
			}
		    }
		    else /* in a process without a port specified */
			Warning0(731,exp.VrootExp->lex_expos);
		}
		else  /* port is specified */
		{
		    tempname = exp.VrootExp->syn_portName.VPortRef->lex_name;
		    if (typeof(SP) == KStructureEntity) {
			    Warning0(725,exp.VrootExp->lex_expos);
		    }
		    else /* within a process */ {
			foreachinSETPort(SP.VProcessEntity->sem_ports,Spt,pt) {
			    if (pt->lex_name == tempname) {
				SetPortEntity(exp.VrootExp->syn_portName.
						VPortRef, pt);
				break;
			    }
			}
			if (TypeOfEntity(exp.VrootExp->syn_portName.VPortRef)
				    == KPort) {
			    port = GetPortEntity(exp.VrootExp->syn_portName.
							VPortRef);
			    st = GetStructureEntity(port->syn_data);
			    exp.VrootExp->sem_type.Vsingleton->sem_type.VTypeEntity
				    = st->sem_root.VTypeEntity;
			}
			else {  /* port not found */
			    Warning0(726,exp.VrootExp->lex_expos);
			}
		    }
	        }
		break;


	    case KemptyExp:
		exp.VemptyExp->sem_type.Varbitrary = Narbitrary;
		exp.VemptyExp->sem_type.Varbitrary->sem_type.VAtomic = 
					GetUniversalType(SP);
		break;


	    case KtrueExp:
		exp.VtrueExp->sem_type.VAtomic = GetBooleanType(SP);
		break;

	    case KfalseExp:
		exp.VfalseExp->sem_type.VAtomic = GetBooleanType(SP);
		break;

	    case KintegerToken:
		exp.VintegerToken->sem_type.VAtomic = GetIntegerType(SP);
		break;

	    case KrationalToken:
		exp.VrationalToken->sem_type.VAtomic = GetRationalType(SP);
		break;

	    case KstringToken:
		exp.VstringToken->sem_type.VAtomic = GetStringType(SP);
		break;

	    default:
		Assume((FALSE), "Default case in x_type");
		break;
	} /* end of switch */

	return(exp);
} /* End of x_type */
