/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/main.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									*
*   Function: main driver for semantic analysis of assertions		*
*									*
*           main	      						*
*									*
\* ******************************************************************* */



#include "SemAssert.h"
#include <stdio.h>
#include "macros.h"

extern FILE  *errorfile;
extern Boolean ReaderOK;	/* indicator of successful read */
extern SEQPreludeType preludetypes;
extern SETDefinition preludedefs;
Boolean verbosemode = FALSE;
StructureOrProcess IDLStructureOrProcess;
TypeEntity IDLTypeEntity;
dotted IDLdotted;

main(argc,argv)
int	argc;
char	*argv[];
{
	compilationUnit		symbolTable;	/* root of symbol table */
	int			index;
	FILE			*fopen();
        void                    exit(); 


	errorfile = stderr;

	/* process command line arguments */
	for(index=1;index<argc;index++) {
	    if (!strcmp(argv[index],"-e")) {
		if (++index >= argc)
		    Fatal0(16,0);
		else if ((errorfile = fopen(argv[index],"w"))==NULL)
		    Fatal0(17, 0);
	    }
	    else if (!strcmp(argv[index], "-v"))
		verbosemode = TRUE;
	    else Warning1(13, 0, argv[index]);
	}

	/* read in Candle Semantic structure */
	symbolTable = INCandleSem(stdin);
	if (!ReaderOK)
	    exit(1);
	if (verbosemode) {
	    (void) fprintf(stderr, "idlc: semantic analysis of assertions\n");
	}
	preludetypes = symbolTable->sem_preludetypes;
	preludedefs = symbolTable->sem_preludedefs;

	/* analyze all StructureEntitys and ProcessEntitys */
	Analyze(symbolTable, verbosemode);

	/* output Candle Semantic */
	OUTCandleSem(stdout,symbolTable,TWOPASS);

        return 0;

} /* of main */
