/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/macros.h 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*									*
*   Function: macros used by all phases of semantic analysis		*
*									*
*									*
\* ******************************************************************* */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	macros.h,v $
 * Revision 1.1  89/07/05  16:33:10  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  06:18:21  cheung
 * macros.h  Ver 4.0
 * 
 * Revision 3.9  89/03/30  13:17:48  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.9  89/03/26  15:28:13  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 1.1  87/04/18  12:13:09  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     	May 24 1986 (kickenson).					*
*									*
\* ******************************************************************* */

#include <stdio.h>

#define K(str)		(void)fprintf(stderr,"str\n");
#define typeExp(X)	x_type(X,SP,defcall,inst)

#define BOOL	"bool"
#define INT	"int"
#define RAT	"rat"
#define STR	"str"
#define SET	"set"
#define SEQ	"seq"

#define HEAD	"Head"
#define MEMBERS	"Members"
#define TYPE	"Type"
#define SIZE	"Size"
#define TAIL	"Tail"

#define UNKNOWN	NewString("Unknown")
#define UNIVERSAL NewString("Universal")
#define IsBooleanType(t)  \
	(typeof(t)==KAtomic && !strcmp(t.VAtomic->sem_name, "Boolean"))
#define IsIntegerType(t)  \
	(typeof(t)==KAtomic && !strcmp(t.VAtomic->sem_name, "Integer"))
#define IsStringType(t)  \
	(typeof(t)==KAtomic && !strcmp(t.VAtomic->sem_name, "String"))
#define IsRationalType(t)  \
	(typeof(t)==KAtomic && !strcmp(t.VAtomic->sem_name, "Rational"))
#define IsUniversalType(t) \
	(typeof(t)==KAtomic && !strcmp(t.VAtomic->sem_name, "Universal"))
#define IsArbitraryUniversal(t) \
	(typeof(t)==Karbitrary && IsUniversalType(t.Varbitrary->sem_type))
#define IsNumeric(t) \
	(typeof(t)==KAtomic && \
	(!strcmp(t.VAtomic->sem_name, "Rational") || \
	 !strcmp(t.VAtomic->sem_name, "Integer")))

Atomic GetAtomicType(); /* needed for macro expansions -GetBooleanType, etc */
#define GetBooleanType(SP)	GetAtomicType(SP, "Boolean")
#define GetIntegerType(SP)	GetAtomicType(SP, "Integer")
#define GetStringType(SP)	GetAtomicType(SP, "String")
#define GetRationalType(SP)	GetAtomicType(SP, "Rational")
#define GetUniversalType(SP)	GetAtomicType(SP, "Universal")

#define streq(s1,s2)	strcmp(s1,s2) == 0

void exit();

/* macros for debugging --eventually will be conditionally compiled out */
#ifdef DEBUG1
char Assumebuf[100];
#define Assume(cond, procname)	\
	{if (!(cond)) {(void)fprintf(stderr,"DEBUG: failed in %s\n", procname);\
		       exit(1); } \
	 else (void)fprintf(stderr, "DEBUG: %s\n", procname); }
#define Assume1(cond, string, arg)	\
	 {(void)sprintf(Assumebuf, string, arg); \
	 if (!(cond)) {(void)fprintf(stderr,"DEBUG: failed in %s\n", Assumebuf);\
		       exit(1); } \
	 else (void)fprintf(stderr, "DEBUG: %s\n", Assumebuf); }
#else 
#ifdef DEBUG2
char Assumebuf[100];
#define Assume(cond, procname)	\
	{if (!(cond)) {(void)fprintf(stderr,"DEBUG: failed in %s\n", procname);\
		       exit(1); } }
#define Assume1(cond, string, arg)	\
	 {(void)sprintf(Assumebuf, string, arg); \
	 if (!(cond)) {(void)fprintf(stderr,"DEBUG: failed in %s\n", Assumebuf);\
		       exit(1); } }
#else
#define Assume(cond, procname)
#define Assume1(cond, string, arg)
#endif
#endif

/* sequence copying macros */
#define CopySETClassOperation(set) (SETClassOperation)IDLListCopy(set)
#define CopySETAtomicOperation(set) (SETAtomicOperation)IDLListCopy(set)
#define CopySETSetOperation(set) (SETSetOperation)IDLListCopy(set)
#define CopySETSeqOperation(set) (SETSeqOperation)IDLListCopy(set)

/* macro for setting an entity to error */
#define SetErrorEntity(ref)	ref->sem_entity.Verror = Nerror;

/* macro for testing if an entity is error */
#define EntityIsError(ref)	(typeof(ref->sem_entity) == Kerror)


/* macros for returning the type of an entity */
#define TypeOfEntity(ref)	typeof(ref->sem_entity)

/* macros for setting entities of references to th correct types */
#define SetAssertEntity(ref, as)	ref->sem_entity.VAssertion = as
#define SetAtomicEntity(ref, at)	ref->sem_entity.VAtomic = at
#define SetAttOpEntity(ref, op)		ref->sem_entity.VAttributeOperation = op
#define SetAttributeEntity(ref, att)	ref->sem_entity.VAttribute = att
#define SetClassEntity(ref, cl)		ref->sem_entity.VClass = cl
#define SetClassOpEntity(ref, op)	ref->sem_entity.VClassOperation = op
#define SetDefineEntity(ref, def)	ref->sem_entity.VDefinition = def
#define SetDefInstanceEntity(ref, in)	ref->sem_entity.VDefInstance = in
#define SetFormalEntity(ref, f)		ref->sem_entity.VFormal = f
#define SetNamedTypeEntity(ref, nt)	ref->sem_entity.VNamedType = nt
#define SetOpEntity(ref, op)		ref->sem_entity.VOperation = op
#define SetPortEntity(ref, aport)	ref->sem_entity.VPort = aport
#define SetProcessEntity(ref, pr)	ref->sem_entity.VProcessEntity = pr
#define SetRepEntity(ref, arep)		ref->sem_entity.VRep = arep
#define SetSetEntity(ref, aset)		ref->sem_entity.VSetOf = aset
#define SetSeqEntity(ref, aseq)		ref->sem_entity.VSeqOf = aseq
#define SetStructureEntity(ref, st)	ref->sem_entity.VStructureEntity = st
#define SetTargetEntity(ts, t)		ts->sem_entity.VTargetLanguage = t
#define SetTypeEntity(ref, t)	ref.IDLclassCommon->sem_entity.VTypeEntity = t
#define SetTypeRepEntity(ref, atrep)	ref->sem_entity.VTypeRep = atrep;

/* macros for getting entities of references */
#define GetAssertEntity(ref) ref->sem_entity.VAssertion
#define GetAtomicEntity(ref) ref->sem_entity.VAtomic
#define GetAttOpEntity(ref) ref->sem_entity.VAttOp
#define GetAttributeEntity(ref) ref->sem_entity.VAttribute
#define GetClassEntity(ref) ref->sem_entity.VClass
#define GetClassOpEntity(ref) ref->sem_entity.VClassOp
#define GetDefineEntity(ref) ref->sem_entity.VDefinition
#define GetNamedTypeEntity(ref) ref->sem_entity.VNamedType
#define GetOpEntity(ref)  ref->sem_entity.VOperation
#define GetPortEntity(ref) ref->sem_entity.VPort
#define GetPortRepEntity(ref) ref->sem_entity.VPortRep
#define GetProcessEntity(ref) ref->sem_entity.VProcessEntity
#define GetRepEntity(ref) ref->sem_entity.VRep
#define GetSeqEntity(ref) ref->sem_entity.VSeqOf
#define GetSetEntity(ref) ref->sem_entity.VSetOf
#define GetSetOrSeqEntity(ref) ref.IDLclassCommon->sem_entity.VSetOrSeq
#define GetStructureEntity(ref) ref->sem_entity.VStructureEntity
#define GetTypeEntity(ref) ref.IDLclassCommon->sem_entity.VTypeEntity

/* macro for getting a type name */
#define GetTypeName(t)	t.IDLclassCommon->sem_name


/* macro for testing equality of 2 strings */
#define strequal(s1,s2) (s1 == s2)

/* macros to get position of type */
#define GetTypePos(t)  (typeof(t)==KNamedTypeRef) ? \
			t.VNamedTypeRef->lex_namepos : \
			t.VSetOrSeqRef.IDLclassCommon->lex_keywordpos

/* macros for testing for correct node type */
#define ntypeof(n)	(n->IDLhidden.TypeID)
#define IsAssertion(n) (ntypeof(n)==KAssertion)
#define IsAssertOrDef(n) ((typeof(n)==KAssertion)||(typeof(n)==KDefinition))
#define IsAssertType(n) (IsTypeEntity(n)||Iscollection(n))
#define IsAtomic(n)	(ntypeof(n)==KAtomic)
#define IsatomicDecl(n) (ntypeof(n)==KatomicDecl)
#define IsAtomicRep(n) (ntypeof(n)==KAtomicRep)
#define IsAttOrAll(n)  ((typeof(n)==KAttributeRef)||(typeof(n)==KAllAttributes))
#define IsAttribute(n) (ntypeof(n)==KAttribute)
#define IsattributeProduction(n) (ntypeof(n)==KattributeProduction)
#define IsattributeRep(n) (ntypeof(n)==KattributeRep)
#define IsattributeRestriction(n) (ntypeof(n)==KattributeRestriction)
#define IsBoolean(n) ((n==TRUE)||(n==FALSE))
#define IsClass(n) (ntypeof(n)==KClass)
#define IsClassOrAll(n) ((typeof(n)==KNamedTypeRef)||(typeof(n)==KAllClasses))
#define IsClassRep(n) (ntypeof(n)==KClassRep)
#define Iscollection(n) ((typeof(n)==Ksingleton)||(typeof(n)==Karbitrary))
#define IscompilationUnit(n) (ntypeof(n)==KcompilationUnit)
#define IsContext(n) (ntypeof(n)==KContext)
#define IsDefinition(n) (ntypeof(n)==KDefinition)
#define IsDefInstance(n) ((typeof(n)==Kcyclicdef)||(typeof(n)==Knoncyclicdef)||\
		(typeof(n)==KPrivateDefInstance))
#define Isdotted(n) (ntypeof(n)==Kdotted)
#define IsError(n)  (typeof(n)==Kerror)
#define IsExpRef(n) ((typeof(n)==KExpSetRef)||(typeof(n)==KExpSeqRef)||\
			 (typeof(n)==KExpNameRef))
#define Isexpression(n) ((typeof(n)==Kconditional)||(typeof(n)==Kforall)||\
			 (typeof(n)==Kexists)||(typeof(n)==Kbinary)||\
			 (typeof(n)==Kunary)||(typeof(n)==Kapplication)||\
			 (typeof(n)==Kdotted)||(typeof(n)==KportExpression)||\
			 IsExpRef(n)||Isliteral(n))
#define IsInputPort(n)  (typeof(n->sem_portType)==KPrePort)
#define Isliteral(n) ((typeof(n)==KintegerToken)||(typeof(n)==KstringToken)||\
		      (typeof(n)==KrationalToken)||(typeof(n)==Kroot)||\
		      (typeof(n)==Kempty)||(typeof(n)==Ktrue)||\
		      (typeof(n)==Kfalse))
#define IsNamedType(n)	((typeof(n)==KClass) || (typeof(n)==KAtomic))
#define IsNamedTypeRef(n) (ntypeof(n)==KNamedTypeRef)
#define IsOutputPort(n) (typeof(n->sem_portType)==KPostPort)
#define IsportAssociation(n) (ntypeof(n)==KportAssociation)
#define IsportDefinition(n) (ntypeof(n)==KportDefinition)
#define IsProcessEntity(n) (ntypeof(n)==KProcessEntity)
#define Isproduction(n) \
	((typeof(n)==KattributeProduction)||(typeof(n)==KsubclassProduction))
#define IsRepRef(n) (ntypeof(n)==KRepRef)
#define Isrestriction(n) \
	((typeof(n)==KtypeRestriction)||(typeof(n)==KattributeRestriction))
#define IsSeqRef(n) (ntypeof(n)==KSeqRef)
#define IsSeqRep(n) (ntypeof(n)==KSeqRep)
#define IsSetOrSeqRep(n) ((typeof(n)==KSetRep)||(typeof(n)==KSeqRep))
#define IsSetRef(n) (ntypeof(n)==KSetRef)
#define IsSetRep(n) (ntypeof(n)==KSetRep)
#define IsString(n) (n!=NULL)
#define IsStructureEntity(n) (ntypeof(n)==KStructureEntity)
#define IsStructureRef(n) (ntypeof(n)==KStructureRef)
#define IsStructureOrProcess(n) \
	((typeof(n)==KStructureEntity)||(typeof(n)==KProcessEntity))
#define IssubclassProduction(n) (ntypeof(n)==KsubclassProduction)
#define IsTargetLanguage(n) (ntypeof(n)==KTargetLanguage)
#define IstargetStmt(n) (ntypeof(n)==KtargetStmt)
#define IsTypeEntity(n) ((typeof(n)==KClass)||(typeof(n)==KAtomic) ||\
			 (typeof(n)==KSetOf)||(typeof(n)==KSeqOf))
#define IsTypeRef(n) ((typeof(n)==KNamedTypeRef)||(typeof(n)==KSetRef)||\
		(typeof(n)==KSeqRef))
#define IsTypeRefOrVoid(n) (IsTypeRef(n)||typeof(n)==KVoid)
#define IstypeRepDecl(n) (ntypeof(n)==KtypeRepDecl)
#define IstypeRestriction(n) (ntypeof(n)==KtypeRestriction)
#define IswithoutAssert(n) (ntypeof(n)==KwithoutAssert)
#define IswithoutClause(n) (ntypeof(n)==KwithoutClause)
#define IswithoutDefine(n) (ntypeof(n)==KwithoutDefine)
#define IswithoutProduction(n) \
		((typeof(n)==KwithoutAttribute)||(typeof(n)==KwithoutSubclass))
#define IswithoutType(n) (ntypeof(n)==KwithoutType)


/* macros to handle errors */
#include "error.h"

/* macros for type conversion */

extern StructureOrProcess IDLStructureOrProcess;
#define StructureEntityToStructureOrProcess(IDLA) \
  (IDLStructureOrProcess.VStructureEntity=IDLA, IDLStructureOrProcess)
extern StructureOrProcess IDLStructureOrProcess;
#define ProcessEntityToStructureOrProcess(IDLA) \
  (IDLStructureOrProcess.VProcessEntity=IDLA, IDLStructureOrProcess)
extern TypeEntity IDLTypeEntity;
#define ClassToTypeEntity(IDLA) (IDLTypeEntity.VClass=IDLA, IDLTypeEntity)
extern dotted IDLdotted;
#define expressionTodotted(IDLA) (IDLdotted.Vexpression=IDLA, IDLdotted)
