/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/expand.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "SemAssert.h"
#include "macros.h"

expand(st)
StructureEntity st;
{
	SETTypeEntity SType;
	TypeEntity    AType;

	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    expand_type(AType);
	}
}

expand_type(thetype)
TypeEntity thetype;
{

	SETClass SClass;
	Class AClass;
	SETTypeEntity SType;
	TypeEntity AType;

	if (thetype.IDLclassCommon->isexpanded)
	    return;

	thetype.IDLclassCommon->isexpanded = TRUE;
	addSETTypeEntity(thetype.IDLclassCommon->expand, thetype);

	if (typeof(thetype)==KClass) {
	    foreachinSETClass(thetype.VClass->sem_subclasses, SClass, AClass) {
		expand_type(ClassToTypeEntity(AClass));
		foreachinSETTypeEntity(AClass->expand, SType, AType)
		    addSETTypeEntity(thetype.IDLclassCommon->expand, AType);
	    }
	}
}
