/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/debug.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "SemAssert.h"

print_2types(type1, type2)
AssertType type1, type2;
{
    (void) fprintf(stderr, "Types: ");
    print_type(type1);
    (void) fprintf(stderr, " ");
    print_type(type2);
    (void) fprintf(stderr, "\n");
}


print_type(atype)
AssertType atype;
{
    switch (typeof(atype)) {
	case Karbitrary:
	    (void) fprintf(stderr, "arbitrary ");
	    print_type(atype.Varbitrary->sem_type);
	    break;
	case Ksingleton:
	    (void) fprintf(stderr, "singleton ");
	    print_type(atype.Vsingleton->sem_type);
	    break;
	default: /* TypeEntity */
	    (void) fprintf(stderr, "%s", 
                atype.VTypeEntity.IDLclassCommon->sem_name);
	    break;
    }
}
