/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semassert/analyze.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: primary routine for semantic analysis of assertions	*
*									*
*           Analyze	      						*
*									*
\* ******************************************************************* */



#include "SemAssert.h"
#include <stdio.h>
#include "macros.h"

extern FILE  *errorfile;

Analyze(compUnit, verbosemode)
compilationUnit compUnit;
Boolean verbosemode;
{
	SEQStructureEntity	SSt;
	StructureEntity		St;
	SEQProcessEntity	SPr;
	ProcessEntity		Pr;

	/* expand all types of structures and process invariants */
	foreachinSEQStructureEntity(compUnit->sem_structures,SSt,St) {
		(void)expand(St);
	}
	foreachinSEQProcessEntity(compUnit->sem_processes,SPr,Pr) {
		(void)expand(Pr->sem_invariant);
	}

	/* analyze all StructureEntitys and ProcessEntitys */
	foreachinSEQStructureEntity(compUnit->sem_structures,SSt,St) {
		AnalyzeSP(StructureEntityToStructureOrProcess(St), verbosemode);
	}
	foreachinSEQProcessEntity(compUnit->sem_processes,SPr,Pr) {
		AnalyzeSP(ProcessEntityToStructureOrProcess(Pr), verbosemode);
	}
} /* of Analyze */



AnalyzeSP(SP, verbosemode)
StructureOrProcess SP;
Boolean verbosemode;
{

        SEQDefinition           Sdefn;
	Definition		defn;
	SETDefInstance		Sin;
	DefInstance		inst;
	SETAssertion		Sas;
	Assertion		as;
     /* SETDefinition		Sdef; */        /* Commented out below */
     /* Definition		def;  */        /* Commented out below */
	expression 		tmpexp;		/* temporary exp */
	SEQDefinition 		alldefs;	/* sorted definitions 	*/
	Boolean			defcall;
	expression		x_type();	/* typing function 	*/
	SEQDefInstance		allinstances;
	Boolean ShouldSwap();
	Boolean SwapInst();
	Boolean haserror;


	if (verbosemode) {
	    if (typeof(SP)==KStructureEntity)
		(void) fprintf(stderr, "idlc:    analyzing structure '%s'\n",
			SP.VStructureEntity->lex_name);
	    else (void) fprintf(stderr, "idlc:    analyzing process '%s'\n",
			SP.VProcessEntity->lex_name);
	}

	/* check that all instances of the same definition are
	   distinguishable by formals */
	check_defInstances(SP);

	/* collect all definitions that a definition calls */
	/* used to check that a noncyclic definition is,  */
	/* in fact, noncyclic	*/
	findcalls(SP);

	/* mark all definitions as part of a cycle or not */
	findcycles(SP);

	/* mark definitions as cyclic or noncyclic depending on
	   the instances they contain */
	markcyclic(SP);

	/* check noncyclic definitions - if in a cycle report error */
	/***
	foreachinSETDefinition(SP.IDLclassCommon->sem_definitions,Sdef,def){
	    if (def->cycle && !(def->hascyclic)) {
		Warning1(800, SP.IDLclassCommon->lex_endpos, def->sem_name);
	    }
	}
	***/
		
	/* sort definitions by calls to other definitions */
	alldefs = 
	    sortSEQDefinition(SP.IDLclassCommon->sem_definitions, ShouldSwap);

	defcall = TRUE;
	foreachinSEQDefinition(alldefs, Sdefn,defn) {
	    if (verbosemode) {
		(void) fprintf(stderr, "idlc:        typing definition '%s'\n",
			defn->sem_name);
	    }

	    /* sort instances non-recursive first */
	    allinstances  = sortSEQDefInstance(defn->sem_overload, SwapInst);

	    /* type all noncyclic and cyclic definitions   */
	    /* analyze bodies of definition instances		*/
	    if (!defn->hascyclic) /* type assigned for cyclic */
		defn->sem_resulttype.Verror = Nerror;
	    
	    foreachinSETDefInstance(allinstances,Sin,inst)
	    {
		if (typeof(inst) != KPrivateDefInstance) {
		    typeExp(inst.VIDLDefInstance.IDLclassCommon->syn_body);
		    AssignDefType(defn, inst);
		}
	    }

	    /* backpatch recursive calls */
	    foreachinSETDefInstance(defn->sem_overload,Sin,inst)
	    {
		if (typeof(inst) != KPrivateDefInstance) {
		    if (inst.VIDLDefInstance.IDLclassCommon->isrecursive)
			type_recursion(defn,
			    inst.VIDLDefInstance.IDLclassCommon->syn_body);
		}
	    }

	    /* check all expressions for correct types */
	    foreachinSETDefInstance(defn->sem_overload,Sin,inst) {
		if(typeof(inst) != KPrivateDefInstance){
		    tmpexp = inst.VIDLDefInstance.IDLclassCommon->syn_body;
		    checkExp(tmpexp, &haserror);
		    inst.IDLclassCommon->inv_error = haserror;
		    if (haserror)
			tmpexp.IDLclassCommon->sem_type.Verror = Nerror;
		}
	    }
	}

	/* check that all instances of the same definition 
	   have the same type */
	check_instance_types(SP);

	/* type and check bodies of assertions 	*/     
	defcall = FALSE;
	foreachinSETAssertion(SP.IDLclassCommon->sem_assertions, Sas,as)  {
	    if (verbosemode) {
		if (strlen(as->lex_name)>0)
		    (void) fprintf(stderr, 
                        "idlc:        typing assertion '%s'\n", as->lex_name);
		else
		    (void) fprintf(stderr, 
                        "idlc:        typing unnamed assertion\n");
	    }
	    typeExp(as->syn_body);
	    checkExp(as->syn_body, &haserror);
	    if (haserror)
		as->syn_body.IDLclassCommon->sem_type.Verror = Nerror;
	    as->inv_error = haserror;
	}

} /* of AnalyzeSP */


/* return true if definition 1 calls definition 2 */
Boolean ShouldSwap(def1, def2)
Definition def1, def2;
{
	if (inSETDefinition(def1->calls, def2))
	    return(TRUE);
	else return(FALSE);
}

/* returns true if inst1 is recursive and inst2 is not */
Boolean SwapInst(inst1, inst2)
DefInstance inst1, inst2;
{
	if (typeof(inst1) != KPrivateDefInstance &&
	    typeof(inst2) != KPrivateDefInstance)  {
		if (inst1.VIDLDefInstance.IDLclassCommon->isrecursive &&
		    !inst2.VIDLDefInstance.IDLclassCommon->isrecursive)
			return(TRUE);
		else return(FALSE);
	}
	else return(FALSE);
}


/* assign the definition type based on the type of the instance */
AssignDefType(def, inst)
Definition     def;
IDLDefInstance inst;
{
	AssertTypeOrError 	instype; 	/* instance temporary type */
	AssertTypeOrError	deftype; 	/* def temporary type */
	Boolean			contains();

	instype = inst.IDLclassCommon->syn_body.IDLclassCommon->sem_type;

	if (typeof(instype) != Kerror) {
	    deftype = def->sem_resulttype;
#ifdef DEBUG
(void) fprintf(stderr, "AddDefType: \n\tdeftype = "); 
print_type(deftype);
(void) fprintf(stderr, " instype = "); print_type(instype); 
(void) fprintf(stderr, "\n");
#endif

	    /* if definition does not yet have a type assign inst type */
	    if (typeof(deftype) == Kerror)
		def->sem_resulttype = instype;

	    /* else only assign instance type if instance type contains 
	     * def type 
	     */
	    else if (contains(instype, deftype)) {
		def->sem_resulttype = instype;
	    }
	}
}

