/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/type.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Routines for adding types or type information		*
*									*
*	     AddTypeRep  AddTypeSpec					*
*	     AddExpressionTypes AttachType GetUserName			*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: type.c,v 1.1 89/07/05 16:32:14 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	type.c,v $
 * Revision 1.1  89/07/05  16:32:14  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  02:50:24  cheung
 * type.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  13:24:35  cheung
 * type.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  15:05:15  cheung
 * type.c  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:22:41  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:40:53  shannon
 * Initial revision
 * 
 * Revision 1.1  86/06/06  14:47:30  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:22:12  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.10  86/01/22  07:09:45  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.9  85/07/31  13:45:42  shannon
 * changed expression ::= nameToken to expression ::= nameExpr
 * 
 * Revision 1.8  85/07/26  10:01:45  shannon
 * added assertion processing
 * 
 * Revision 1.7  85/07/25  10:36:34  shannon
 * changed code for new null and empty class rep
 * 
 * Revision 1.6  85/07/18  19:39:56  shannon
 * added type representation for classes
 * added node types for unknown types
 * 
 * Revision 1.5  85/07/05  20:38:06  shannon
 * added new node type for each unknown attribute type
 * 
 * Revision 1.4  85/07/04  14:54:58  shannon
 * changed set of symbols to sequence
 * 
 * Revision 1.3  85/06/27  19:20:41  shannon
 * deleted node representation, just using sequence of targetrep now
 * 
 * Revision 1.2  85/06/20  10:12:28  shannon
 * fixed bug in representation attribute of sets and sequences of
 * scalar types
 * 
 * Revision 1.1  85/06/11  10:19:03  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include "Semantic.h"
#include "macros.h"
#include <stdio.h>
#include <ctype.h>







/***********************************************************************
 *
 * Procedure AddTypeRep
 *
 * Purpose: Add type represenation information to type
 *
 * Algorithm:
 *
 * Errors Checked For: invalid classname in for clause
 *		       invalid nonterminal in for clause
 *
 * Assumptions/Limitations: not fully implemented yet.
 *
 **********************************************************************/

AddTypeRep(st, AtypeRepDecl)
StructureEntity st;
typeRepDecl AtypeRepDecl;
{
	SEQparameter Sparm;
	parameter parm;
	TypeEntity type;
	static Atomic IntType, StrType, RatType;
	static Boolean init=TRUE;
	Atomic GetIntegerType(),
	       GetStringType(),
	       GetRationalType();

	Assume((IsStructureEntity(st)&&IstypeRepDecl(AtypeRepDecl)),
		"AddTypeRep");

	if (init) {
	    init = FALSE;
	    IntType = GetIntegerType();
	    StrType = GetStringType();
	    RatType = GetRationalType();
	}

	if (FindType(st, AtypeRepDecl->syn_type)==NOTFOUND){
	    Warning0(151, GetTypePos(AtypeRepDecl->syn_type));
	    SetErrorEntity(AtypeRepDecl->syn_type.IDLclassCommon);
	}
	else {
	    type = GetTypeEntity(AtypeRepDecl->syn_type);
	    appendrearSEQRepRef(type.IDLclassCommon->sem_reps, 
				AtypeRepDecl->syn_spec);
	}

	/* set types for all integerTokens stringTokens and rationalTokens */
	foreachinSEQparameter(AtypeRepDecl->syn_spec->syn_id, Sparm, parm) {
	    switch (typeof(parm)) {
		case KintegerToken:
		    parm.VintegerToken->sem_type.VAtomic = IntType;
		    break;
		case KstringToken:
		    parm.VstringToken->sem_type.VAtomic = StrType;
		    break;
		case KrationalToken:
		    parm.VrationalToken->sem_type.VAtomic = RatType;
		    break;
	    }
	}
}




/***********************************************************************
 *
 * Procedure AddAttributeRep
 *
 * Purpose: Add information from an internal representation type
 *
 * Algorithm: 
 *
 * Errors Checked For: 
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
AddAttributeRep(st, AnAttributeRep)
StructureEntity st;
attributeRep AnAttributeRep;
{
	NamedType tfound;	/* the type found */
	Class cfound;		/* the class found */
	Attribute attfound;	/* attribute found */
	SEQparameter Sparm;
	parameter parm;
	static Atomic IntType, StrType, RatType;
	static Boolean init=TRUE;
	Atomic GetIntegerType(),
	       GetStringType(),
	       GetRationalType();
        Boolean PropagatedAttribute();

	Assume((IsStructureEntity(st)&&IsattributeRep(AnAttributeRep)),
		"AddAttributeRep");

	if (init) {
	    init = FALSE;
	    IntType = GetIntegerType();
	    StrType = GetStringType();
	    RatType = GetRationalType();
	}

	/* find the nonterminal which has a type change */

	if (FindNamedType(st, AnAttributeRep->syn_class->lex_name, &tfound) 
				== NOTFOUND) {
	    Warning0(151, AnAttributeRep->syn_class->lex_namepos);
	    SetErrorEntity(AnAttributeRep->syn_class);
	}
	else if (typeof(tfound) != KClass) {
	    Warning0(152, AnAttributeRep->syn_class->lex_namepos);
	    SetErrorEntity(AnAttributeRep->syn_class);
	}
	else {
	    cfound = tfound.VClass;
	    SetClassEntity(AnAttributeRep->syn_class, cfound);
	}


	/* find the attribute of cfound which has new type */
	if (EntityIsError(AnAttributeRep->syn_class)) {
	    SetErrorEntity(AnAttributeRep->syn_attribute);
	}
	else if (FindClassAttribute(cfound, 
		    AnAttributeRep->syn_attribute->lex_name, &attfound) 
		    == NOTFOUND) {
	    if (PropagatedAttribute(cfound, 
				    AnAttributeRep->syn_attribute->lex_name)) {
		Warning0(278, AnAttributeRep->syn_attribute->lex_namepos);
		SetErrorEntity(AnAttributeRep->syn_attribute);
	    }
	    else {
		Warning0(277, AnAttributeRep->syn_attribute->lex_namepos);
		SetErrorEntity(AnAttributeRep->syn_attribute);
	    }
	}
	else {
	    SetAttributeEntity(AnAttributeRep->syn_attribute, attfound);
	}


	/* if attribute ref is not error, add the rep to it */
	if (!EntityIsError(AnAttributeRep->syn_attribute)) {
	    appendrearSEQRepRef(attfound->sem_reps, AnAttributeRep->syn_rep);
	}

	/* set types for all integerTokens stringTokens and rationalTokens */
	foreachinSEQparameter(AnAttributeRep->syn_rep->syn_id, Sparm, parm) {
	    switch (typeof(parm)) {
		case KintegerToken:
		    parm.VintegerToken->sem_type.VAtomic = IntType;
		    break;
		case KstringToken:
		    parm.VstringToken->sem_type.VAtomic = StrType;
		    break;
		case KrationalToken:
		    parm.VrationalToken->sem_type.VAtomic = RatType;
		    break;
	    }
	}
}


		

/***********************************************************************
 *
 * Procedure ParmsAreTypeRef
 *
 * Purpose: Check if the three parameters are {Set|Seq} Of <name>
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
Boolean ParmsAreTypeRef(p1, p2, p3, asetseqref) 
parameter p1, p2, p3;
SetOrSeqRef *asetseqref;
{
    Boolean istyperef;
    String n1, n2, n3;		/* names */
    NamedTypeRef component;
    Boolean NCStringMatch();

    if ((typeof(p1)==KnameToken) && (typeof(p2)==KnameToken) &&
				     (typeof(p3)==KnameToken)) {
	n1 = p1.VnameToken->lex_name;
	n2 = p2.VnameToken->lex_name;
	n3 = p3.VnameToken->lex_name;
	if (NCStringMatch(n2, "of") &&
	    (NCStringMatch(n1, "set") || 
	     NCStringMatch(n1, "seq"))) {

	    if (NCStringMatch(n1, "set")) {
		asetseqref->VSetRef = NSetRef;
	    }
	    else {
		asetseqref->VSeqRef = NSeqRef;
	    }
	    asetseqref->IDLclassCommon->lex_keywordpos = 
			p1.VnameToken->lex_namepos;
	    component = NNamedTypeRef;
	    component->lex_name = n3;
	    component->lex_namepos = p3.VnameToken->lex_namepos;
	    asetseqref->IDLclassCommon->syn_component= component;
	    istyperef = TRUE;
	}
	else istyperef = FALSE;
    }
    else istyperef = FALSE;

    return(istyperef);
}


