/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/prelude.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Semantic.h"
#include "macros.h"
#include <stdio.h>

extern Context StandardPrelude;

AddPreludeTypes(st)
StructureEntity st;
{
    SEQPreludeType SPType;
    PreludeType APType;
    String name;
    Boolean NCStringMatch();

    Assume((IsStructureEntity(st)), "AddPreludeTypes");

    foreachinSEQPreludeType(StandardPrelude->pre_types, SPType, APType){
	if (IsTypeEntity(APType)) {
	    name = APType.VTypeEntity.IDLclassCommon->sem_name;
	    if (!NCStringMatch(name, "Universal") &&
		!NCStringMatch(name, "Set Of Universal") &&
		!NCStringMatch(name, "Seq Of Universal"))

		addSETTypeEntity(st->sem_types, APType.VTypeEntity);
	}
    }
}

AddTarget(pr, AtargetStmt)
ProcessEntity pr;
targetStmt AtargetStmt;
{
	SEQTargetType STL;
	TargetType Atarget;
	SEQTargetTransition Stran;
	TargetTransition Atran;
	SEQparameter Sparm;
	parameter Aparm;
	SourcePosition pos;
	Boolean match;
	Boolean MatchParms();
	Atomic GetIntegerType();
	Atomic GetRationalType();
	Atomic GetStringType();

	Assume((IsProcessEntity(pr)&&IstargetStmt(AtargetStmt)),
		"AddTarget");

	/* set the types of the integer, rational, and string tokens */
	foreachinSEQparameter(AtargetStmt->syn_id, Sparm, Aparm){
	    switch (typeof(Aparm)) {
		case KintegerToken:
		    Aparm.VintegerToken->sem_type.VAtomic = GetIntegerType();
		    break;
		case KrationalToken:
		    Aparm.VrationalToken->sem_type.VAtomic = GetRationalType();
		    break;
		case KstringToken:
		    Aparm.VstringToken->sem_type.VAtomic = GetStringType();
		    break;
	    }
	}

	if (typeof(pr->sem_target)==KVoid) {
	    foreachinSEQTargetType(StandardPrelude->pre_targets, STL, Atarget) {
		if (typeof(Atarget)==KAnyTarget)
		    break;
	    }
	}
	else Atarget.VTargetEntity = pr->sem_target.VTargetEntity;
	Assume((typeof(Atarget)==KTargetEntity || typeof(Atarget)==KAnyTarget),
		"AddTarget2");

	/* check for match */
	match = FALSE;
	foreachinSEQTargetTransition(Atarget.IDLclassCommon->pre_targettransitions,
					Stran, Atran){
	    match = MatchParms(AtargetStmt->syn_id, Atran->pre_id->pre_params);
	    if (match) break;
	}
	if (match) {
	    pr->sem_target.VTargetEntity = Atran->pre_nextstate;
	    SetTargetEntity(AtargetStmt, Atran->pre_nextstate);
	}
	else {
	    SetErrorEntity(AtargetStmt);
	    retrievefirstSEQparameter(AtargetStmt->syn_id, Aparm);
	    if (typeof(Aparm)==KnameToken)
		pos = Aparm.VnameToken->lex_namepos;
	    else pos = Aparm.VotherToken.IDLclassCommon->lex_expos;
	    Warning0(407, pos);
	}
}

FindPreludeType(atyperef)
TypeRef atyperef;
{
	SEQPreludeType SPType;
	PreludeType APType;
	TypeEntity AType;
	String typename;
	Boolean found = NOTFOUND;
	NamedTypeRef component;
	Boolean NCStringMatch();


	Assume((IsTypeRef(atyperef)&&IsContext(StandardPrelude)), 
			"FindPreludeType");

	if (typeof(atyperef)==KNamedTypeRef) {
	    typename = atyperef.VNamedTypeRef->lex_name;
	}
	else {
	    component = atyperef.VSetOrSeqRef.IDLclassCommon->syn_component;
	    typename = (String)GetHeap(strlen(component->lex_name)+8);
	    if (typeof(atyperef)==KSetRef)
		(void)sprintf(typename, "Set Of %s", component->lex_name);
	    else (void)sprintf(typename, "Seq Of %s", component->lex_name);
	}
	foreachinSEQPreludeType(StandardPrelude->pre_types, SPType, APType) {
	    if (IsTypeEntity(APType)){
		AType = APType.VTypeEntity;
		if (NCStringMatch(AType.IDLclassCommon->sem_name, typename)) {
		    SetTypeEntity(atyperef, AType);
		    found = FOUND;
		    break;
		}
	    }
	}

	return(found);
}

FindPreludeDefinition(defname, deffound)
String defname;
Definition *deffound;
{
    SETDefinition SDef;
    Definition ADef;
    int found=NOTFOUND;

    Assume((IsString(defname)&&(deffound!=NULL)), "FindPreludeDefinition");

    foreachinSETDefinition(StandardPrelude->pre_definitions, SDef, ADef) {
	if (strequal(ADef->sem_name, defname)) {
	    *deffound = ADef;
	    found = FOUND;
	    break;
	}
    }
    return(found);
}



Atomic GetIntegerType()
{
    static Atomic IntType;
    static Boolean init=TRUE;
    NamedTypeRef nameref;

    Assume((init || IsAtomic(IntType)), "GetIntegerType");
    if (init) {
	init = FALSE;
	nameref = NNamedTypeRef;
	nameref->lex_name = "Integer";
	if (FindPreludeType(NamedTypeRefToTypeRef(nameref)) == FOUND) {
	    IntType = GetAtomicEntity(nameref);
	}
	else {
	    Assume((FALSE), "No Integer Type in StandardPrelude");
	    IntType = NAtomic;
	    IntType->sem_name = nameref->lex_name;
	}
    }
    return(IntType);
}

Atomic GetStringType()
{
    static Atomic StrType;
    static Boolean init=TRUE;
    NamedTypeRef nameref;

    Assume((init || IsAtomic(StrType)), "GetStringType");
    if (init) {
	init = FALSE;
	nameref = NNamedTypeRef;
	nameref->lex_name = "String";
	if (FindPreludeType(NamedTypeRefToTypeRef(nameref)) == FOUND) {
	    StrType = GetAtomicEntity(nameref);
	}
	else {
	    Assume((FALSE), "No String Type in StandardPrelude");
	    StrType = NAtomic;
	    StrType->sem_name = nameref->lex_name;
	}
    }
    return(StrType);
}

Atomic GetRationalType()
{
    static Atomic RatType;
    static Boolean init=TRUE;
    NamedTypeRef nameref;

    Assume((init || IsAtomic(RatType)), "GetRationalType");
    if (init) {
	init = FALSE;
	nameref = NNamedTypeRef;
	nameref->lex_name = "Rational";
	if (FindPreludeType(NamedTypeRefToTypeRef(nameref)) == FOUND) {
	    RatType = GetAtomicEntity(nameref);
	}
	else {
	    Assume((FALSE), "No Rational Type in StandardPrelude");
	    RatType = NAtomic;
	    RatType->sem_name = nameref->lex_name;
	}
    }
    return(RatType);
}

Atomic GetBooleanType()
{
    static Atomic BoolType;
    static Boolean init=TRUE;
    NamedTypeRef nameref;

    Assume((init || IsAtomic(BoolType)), "GetBooleanType");
    if (init) {
	init = FALSE;
	nameref = NNamedTypeRef;
	nameref->lex_name = "Boolean";
	if (FindPreludeType(NamedTypeRefToTypeRef(nameref)) == FOUND) {
	    BoolType = GetAtomicEntity(nameref);
	}
	else {
	    Assume((FALSE), "No Boolean Type in StandardPrelude");
	    BoolType = NAtomic;
	    BoolType->sem_name = nameref->lex_name;
	}
    }
    return(BoolType);
}


Boolean MatchParms(parmseq, idparmseq)
SEQparameter parmseq;
SEQIdparameter idparmseq;
{
    Boolean match=TRUE;		/* indicator of match so far*/
    int len1, len2;		/* sequence lengths */
    int i;			/* index */
    int ival;			/* value of parameter integer token */
    float rval;			/* value of parameter rational token */
    parameter nextparm;		/* next parameter in parameter seq */
    Idparameter nextidparm;	/* next Idparameter in Idparameter seq */
    double atof();

    Assume((TRUE), "MatchParms");

    len1 = lengthSEQparameter(parmseq);
    len2 = lengthSEQIdparameter(idparmseq);
    if (len1 == len2){
	for (i=1; i<=len1; i++){
	    ithinSEQparameter(parmseq, i, nextparm);
	    ithinSEQIdparameter(idparmseq, i, nextidparm);

	    switch (typeof(nextidparm)){
		case KnameValue:
		    if (typeof(nextparm) == KnameToken) {
			 if (!NCStringMatch(nextparm.VnameToken->lex_name,
			       nextidparm.VnameValue->pre_name)) {
			     match = FALSE;
			 }
		    }
		    else match = FALSE;
		    break;
		case KintegerValue:
		    if (typeof(nextparm)==KintegerToken){
			ival = atoi(nextparm.VintegerToken->lex_externalform);
			if (ival != nextidparm.VintegerValue->pre_integer){
			    match = FALSE;
			}
	   	    }
		    else match = FALSE;
		    break;
		case KrationalValue:
		    if (typeof(nextparm)==KrationalToken){
			rval = atof(nextparm.VrationalToken->lex_externalform);
			if (rval != nextidparm.VrationalValue->pre_rational){
			    match = FALSE;
			}
	   	    }
		    else match = FALSE;
		    break;
		case KnameSpec:
		    if (typeof(nextparm) != KnameToken){
			match = FALSE;
		    }
		    break;
		case KintegerSpec:
		    if (typeof(nextparm) != KintegerToken){
			match = FALSE;
		    }
		    break;
		case KrationalSpec:
		    if (typeof(nextparm) != KrationalToken){
			match = FALSE;
		    }
		    break;
		case KintegerRange:
		    if (typeof(nextparm)==KintegerToken){
			ival = atoi(nextparm.VintegerToken->lex_externalform);
			if (!(ival >= nextidparm.VintegerRange->pre_low &&
			      ival <= nextidparm.VintegerRange->pre_high)){
			    match = FALSE;
			}
		    }
		    else match = FALSE;
		    break;
		case KrationalRange:
		    if (typeof(nextparm)==KrationalToken){
			rval = atoi(nextparm.VrationalToken->lex_externalform);
			if (!(rval >= nextidparm.VrationalRange->pre_low &&
			      rval <= nextidparm.VrationalRange->pre_high)){
			    match = FALSE;
			}
		    }
		    else match = FALSE;
		    break;
	    }
	    if (!match)
		break;
	}
    }
    else match = FALSE;

    return(match);
}
