/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/misc.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: This file contains miscellaneous files for error 		*
*		handling, etc 						*
*									*
*           ErrHandler							*
*									*
\* ******************************************************************* */

#ifndef lint 
    static char rcsid[] = "$Header: misc.c,v 1.1 89/07/05 16:32:00 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	misc.c,v $
 * Revision 1.1  89/07/05  16:32:00  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  02:48:52  cheung
 * misc.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  13:23:52  cheung
 * misc.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  15:04:32  cheung
 * misc.c  Ver 3.9
 * 
 * Revision 1.1  87/04/18  11:40:43  shannon
 * Initial revision
 * 
 * Revision 1.1  86/06/06  14:47:08  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:22:01  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.2  86/01/22  07:09:40  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.1  85/06/11  10:18:21  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include <stdio.h>
#include "Semantic.h"
#include "macros.h"

Boolean SeriousError = FALSE;	/* indicator of serious error */
extern Boolean warningsoff; 	/* indicator if warnings are off */
extern FILE *err_out;



/***********************************************************************
 *
 * Procedure ErrHandler
 *
 * Purpose: Write an error message to file err_out and handle 
 *	    error appropriately
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

ErrHandler(type, number, sourcepos, arg1, arg2)

int type;		/* type of error */
int number;		/* error number */
SourcePosition sourcepos;/* source position of error */
char *arg1,*arg2;	/* arguments */
{

        extern void ERRNewErrorInstance();
        extern void ERRAddStringArg();
        extern void ERRWriteErrorInstance();
        
	static int num_warnings=0;

	ERRNewErrorInstance(err_out, number, sourcepos);
	if (strcmp(arg1, "")) {
	    ERRAddStringArg(arg1);
	    if (strcmp(arg2, "")) 
		ERRAddStringArg(arg2);
	}
	ERRWriteErrorInstance();

	if (type == SERIOUS)
	    SeriousError = TRUE;
	else if (type == WARNING) {
	    if (++num_warnings > 10)
		SeriousError = TRUE;
	}
	else if (type == FATAL)
	    exitSA(1);
}
