/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: main driver for the semantic analysis process		*
*									*
*           main exitSA							*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: main.c,v 1.1 89/07/05 16:31:57 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	main.c,v $
 * Revision 1.1  89/07/05  16:31:57  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  02:48:41  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  13:23:42  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  15:04:23  cheung
 * main.c  Ver 3.9
 * 
 * Revision 1.1  87/04/18  11:40:41  shannon
 * Initial revision
 * 
 * Revision 1.1  86/06/06  14:46:52  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:21:54  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.7  86/01/22  07:09:33  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.6  85/08/27  20:26:10  shannon
 * fixed command line processing bug
 * 
 * Revision 1.5  85/07/26  10:12:20  shannon
 * revised processing of command line arguments
 * 
 * Revision 1.4  85/07/05  20:39:09  shannon
 * added search through ancestor structures when checking for
 * unused structures
 * 
 * Revision 1.3  85/07/04  14:55:59  shannon
 * changed set of symbols to sequence
 * 
 * Revision 1.2  85/07/04  10:09:51  shannon
 * added -c flag so that main.c does not write out target input
 * structure when this flag is given
 * 
 * Revision 1.1  85/06/11  10:17:55  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include "Semantic.h"
#include "macros.h"
#include <stdio.h>
#include <string.h>

extern Boolean SeriousError;	/* indicator of serious error */
Boolean warningsoff = FALSE;    /* indicator if warning messages are off */
Boolean V2conform = FALSE;	/* indicator if IDL Version2 conformace is on */
Context StandardPrelude; 	/* the prelude */
extern Boolean ReaderOK;	/* indicator of read error, exits if one */
FILE *err_out;			/* the error file ptr */
char *error_file;		/* the name of the error file */
String emptystring;		/* the emptystring */
StructureOrProcess IDLStructureOrProcess;
TypeRef IDLTypeRef;
AssertOrDef IDLAssertOrDef;
void exit();

/***********************************************************************
 *
 * Procedure main
 *
 * Purpose: Call the routines for the semantic analysis process
 *
 * Algorithm: Read in the Candle Syntax structure
 *	      Sort the structures and processes into processing order
 *	      Analyze all structures and processes
 *	      Check that all structures are used by a process
 *	      Check that there exists at least one process
 *	      Write out Candle and CandleExpanded structures
 *
 * Errors Checked For: incorrect usage
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
int main(argc, argv)
int argc;
char *argv[];
{

	compilationUnit cunit;	/* the list of structure and process decls */
	FILE *fopen(), 
	     *fp,	 	/* the input file pointer */
	     *filetrans=stderr,	/* the file where the transition structure
				   is written */
	     *preludefp=NULL;	/* the prelude file pointer */
	SEQPreludeType SPtype;  /* seq traversal and value */
	PreludeType APtype;
	char *parser;		/* parser path */
	SEQString includes;	/* directories to look for files in */
	Boolean verbosemode = FALSE;
				/* indicator if mode is verbose */
	int i;			/* index */
	transitions alltrans;	/* all file transitions */
	char parse_flags[20];
	Boolean remove_assertions=FALSE;
	String includefilename;
	Assume((TRUE), "main");

	/* initialize */
	err_out = stderr;
	error_file = "/tmp/error_file";
	fp = stdin;
	emptystring = NewString("\0");
	initializeSEQString(includes);
	parser = NULL;
	(void) strcpy(parse_flags, "\0");

	Assume(((err_out==stderr)&&(fp==stdin)), "main after initialize");

	for (i = 1; i<argc; i++) {
	    if (!strncmp(argv[i], "-I", 2)) {
	      includefilename = NewString(&(argv[i][2]));
	      appendrearSEQString(includes, includefilename);
	    }
	    else if (!strcmp(argv[i], "-parse")) {
		if (i+1 >= argc) {
		    (void) fprintf(stderr, "no file after -parse option\n");
		    exit(1);
		}
		else {
		    ++i;
		    parser = argv[i];
		}
	    }
	    else if (!strcmp(argv[i], "-f")) {
		if (i+1 >= argc) {
		    (void) fprintf(stderr, "no file after -f option\n");
		    exit(1);
		}
		else {
		    ++i;
		    if ((filetrans = fopen(argv[i], "w")) == NULL){
			(void) fprintf(stderr, "Can't open transition file\n");
			exit(1);
		    }
		}
	    }
	    else if (!strcmp(argv[i], "-e")) {
		if (i+1 >= argc)
		    Fatal0(16, 0);
		else {
		    ++i;
		    if ((err_out = fopen(argv[i], "w")) == NULL){
			Fatal1(17, 0, argv[i]);
		    }
		}
	    }
	    else if (!strcmp(argv[i], "-pe")) {
		if (i+1 >= argc)
		    Fatal0(16, 0);
		else {
		    ++i;
		    error_file = argv[i];
		}
	    }
	    else if (!strcmp(argv[i], "-p")) {
		if (i+1 >= argc)
		    Fatal0(18, 0);
		else {
		    ++i;
		    if ((preludefp = fopen(argv[i], "r")) == NULL){
			Fatal1(19, 0, argv[i]);
		    }
		}
	    }
	    else if (!strcmp(argv[i], "-nl")) {
		(void) strcat(parse_flags, "-nl ");
	    }
	    else if (!strcmp(argv[i], "-na")) {
		remove_assertions = TRUE;
	    }
	    else if (!strcmp(argv[i], "-v")) {
		verbosemode = TRUE;
	    }
	    else if (!strcmp(argv[i], "-V2")) {
		V2conform = TRUE;
		(void) strcat(parse_flags, "-V2 ");
	    }
	    else if (!strcmp(argv[i], "-w")) {
		warningsoff = TRUE;
	    }
	    else if (!strcmp(argv[i], "-")) {
		    fp = stdin;
	    }
	    else if (argv[i][0] != '-') {
		if ((fp = fopen(argv[i], "r")) == NULL){
		    Fatal1(12, 0, argv[i]);
		}
	    }
	    else Warning1(13, 0, argv[i]);
	}

	if (parser == NULL) {
	    (void) fprintf(stderr, "no parser given \n");
	    exit(1);
	}

	/* read in Candle Syntax */
	cunit = INSyntax(fp);
	if ((!ReaderOK) || (cunit == NULL))
	   exitSA(1);

	Assume(((fp!=NULL)&&(err_out!=NULL)), "main after args processed");
	/* read in the Prelude */
	if (preludefp != NULL) {
	    StandardPrelude = INPrelude(preludefp);
	}
	else {
	    (void) fprintf(stderr, "no prelude\n");
	    exit(1);
	}


	/* assign the prelude types to the compilationUnit and mark
	 * all classes, privates, sets, and seqs as prelude types */
	foreachinSEQPreludeType(StandardPrelude->pre_types, SPtype, APtype){
	    if (IsTypeEntity(APtype)) {
		APtype.VTypeEntity.IDLclassCommon->sem_isPreludeType = TRUE;
	    }
	    appendrearSEQPreludeType(cunit->sem_preludetypes, APtype);
	}

	/* assign the prelude definitions to the compilationUnit */
	cunit->sem_preludedefs = StandardPrelude->pre_definitions;

	if (verbosemode)
		(void) fprintf(stderr, "idlc: semantic analysis\n");

	Assume((IscompilationUnit(cunit)&&IsContext(StandardPrelude)),
		"main after input");

	/* process the import clauses */
	ProcessImportClauses(cunit, cunit, parser, includes, 
				verbosemode, parse_flags);

	/* sort the structures and processes into processing order */

	SortCompilationUnit(cunit);
	Assume((TRUE), "main after sort");

	/* analyze all structures & processes */

	Analyze(cunit, verbosemode);

	Assume((TRUE), "main after Analyze");


	/* check that all structures are used by a process 
	   print out warnings if they are not		  */


	/* write out Candle Semantic and filetransitions*/

	if (!SeriousError) {
	      Assume((TRUE), "Writing Candle Semantic");
	      if (remove_assertions)
		  RemoveAssertions(cunit);
	      OUTCandleSem(stdout, cunit, TWOPASS); 

	      alltrans = Ntransitions;
	      alltrans->transitions = cunit->inv_alltransitions;
	      OUTtransitions(filetrans, alltrans, TWOPASS);
	}
	else {
	      alltrans = Ntransitions;
	      alltrans->transitions = cunit->inv_alltransitions;
	      OUTtransitions(filetrans, alltrans, TWOPASS);
	      exitSA(1);
	}
	return 0;
}





/***********************************************************************
 *
 * Procedure exitSA
 *
 * Purpose: exit the semantic analysis process. 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

exitSA(status)
int status;
{

	exit(status);
}



RemoveAssertions(cunit)
compilationUnit cunit;
{
	SEQProcessEntity Spr;
	ProcessEntity Apr;
	SEQStructureEntity Sst;
	StructureEntity Ast;
	SETAssertion Sa;
	Assertion a;
	SETDefinition Sdef;
	Definition d;
	SETDefInstance Sdi;
	DefInstance di;
	structureStatement Astst;
      	processStatement Aprst;

	foreachinSEQStructureEntity(cunit->sem_structures, Sst, Ast) {
	    foreachinSETAssertion(Ast->sem_assertions, Sa, a) {
		Astst.VAssertion = a;
		removeSEQstructureStatement(Ast->syn_body, Astst);
	    }
	    foreachinSETDefinition(Ast->sem_definitions, Sdef, d) {
		foreachinSETDefInstance(d->sem_overload, Sdi, di) {
		    Astst.VDefInstance = di;
		    removeSEQstructureStatement(Ast->syn_body, Astst);
	        }
	    }
	    Ast->sem_assertions = NULL;
	    Ast->sem_definitions = NULL;
	}
	foreachinSEQProcessEntity(cunit->sem_processes, Spr, Apr) {
	    foreachinSETAssertion(Apr->sem_assertions, Sa, a) {
		Aprst.VAssertion = a;
		removeSEQprocessStatement(Apr->syn_body, Aprst);
	    }
	    foreachinSETDefinition(Apr->sem_definitions, Sdef, d) {
		foreachinSETDefInstance(d->sem_overload, Sdi, di){
		    Aprst.VDefInstance = di;
		    removeSEQprocessStatement(Apr->syn_body, Aprst);
		}
	    }
	    Apr->sem_assertions = NULL;
	    Apr->sem_definitions = NULL;

	    Ast = Apr->sem_invariant;
	    foreachinSETAssertion(Ast->sem_assertions, Sa, a) {
		Astst.VAssertion = a;
		removeSEQstructureStatement(Ast->syn_body, Astst);
	    }
	    foreachinSETDefinition(Ast->sem_definitions, Sdef, d) {
		foreachinSETDefInstance(d->sem_overload, Sdi, di){
		    Astst.VDefInstance = di;
		    removeSEQstructureStatement(Ast->syn_body, Astst);
		}
	    }
	    Ast->sem_assertions = NULL;
	    Ast->sem_definitions = NULL;
	}
}
