/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/init.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: This file contains all the node attribute initializing 	*
*		routines 						*
*									*
*	     IAtomic  IClass  						*
*	     IAttribute IProcessEntity					*
*	     IPort ISetOf ISeqOf IStructureEntity			*
*									*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: init.c,v 1.1 89/07/05 16:31:52 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	init.c,v $
 * Revision 1.1  89/07/05  16:31:52  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  02:48:21  cheung
 * init.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  13:23:26  cheung
 * init.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  15:04:08  cheung
 * init.c  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:22:11  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:40:38  shannon
 * Initial revision
 * 
 * Revision 1.1  86/06/06  14:46:36  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:21:45  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.4  86/01/22  07:09:28  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.3  85/07/25  10:36:17  shannon
 * changed code for new null and empty class rep
 * 
 * Revision 1.2  85/06/27  19:20:16  shannon
 * deleted node representation, just using sequence of targetrep now.
 * 
 * Revision 1.1  85/06/11  10:17:32  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include "Semantic.h"
#include "macros.h"
extern String emptystring;
#define DEFAULTSETPACKAGE NewString("LinkedList")
#define DEFAULTSEQPACKAGE NewString("LinkedList")


/***********************************************************************
 *
 * Procedure IAtomic
 *
 * Purpose: Initialize the attributes of Atomic 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

Atomic IAtomic(AnAtomic)
Atomic AnAtomic;
{
	AnAtomic -> sem_copiedfrom.VVoid = NVoid;
	AnAtomic->inv_parent.VVoid = NVoid;
	AnAtomic->rep_internalType.VVoid = NVoid;
	AnAtomic->rep_externalType.VVoid = NVoid;

	return(AnAtomic);
}


/***********************************************************************
 *
 * Procedure IClass
 *
 * Purpose: Initialize the attributes of Class 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

Class IClass(cnt)
Class cnt;
{
	cnt->sem_copiedfrom.VVoid = NVoid;
	cnt->inv_parent.VVoid = NVoid;

	return(cnt);
}



/***********************************************************************
 *
 * Procedure IAttribute
 *
 * Purpose: Initialize the attributes of Attribute 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

Attribute IAttribute(att)
Attribute att;
{
	SETAttributeOperation DefaultAttributeOperations();

	att->lex_name = emptystring;
	att->sem_copiedfrom.VVoid = NVoid;
	return(att);
}




/***********************************************************************
 *
 * Procedure IProcessEntity
 *
 * Purpose: Initialize the attributes of a ProcessEntity
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
ProcessEntity IProcessEntity(pr)
ProcessEntity pr;
{
	pr->sem_target.VVoid = NVoid;
	return(pr);
}

/***********************************************************************
 *
 * Procedure IPort
 *
 * Purpose: Initialize the attributes of a Port
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
Port IPort(aport)
Port aport;
{
	return(aport);
}
/***********************************************************************
 *
 * Procedure ISetOf
 *
 * Purpose: Initialize the attributes of a SetOf
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
SetOf ISetOf(aset)
SetOf aset;
{
	aset->sem_copiedfrom.VVoid = NVoid;
	aset->inv_parent.VVoid = NVoid;
	aset->rep_numelements.Vanynumber = Nanynumber;
	return(aset);
}

/***********************************************************************
 *
 * Procedure ISeqOf
 *
 * Purpose: Initialize the attributes of a SeqOf
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
SeqOf ISeqOf(aseq)
SeqOf aseq;
{
	aseq->sem_copiedfrom.VVoid = NVoid;
	aseq->inv_parent.VVoid = NVoid;
	aseq->rep_numelements.Vanynumber = Nanynumber;
	return(aseq);
}

/***********************************************************************
 *
 * Function IStructureEntity
 *
 * Purpose: Initialize attributes of a structure
 *
 * Return Value: the structure with initialized values
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
StructureEntity IStructureEntity(st)
StructureEntity(st);
{
	st->syn_root.VVoid = NVoid;
	st->syn_refines.VVoid = NVoid;
	st->sem_root.VVoid = NVoid;
	return(st);
}

NamedTypeRef INamedTypeRef(tref)
NamedTypeRef tref;
{
	tref->sem_entity.Verror = Nerror;
	return(tref);
}
SetRef ISetRef(tref)
SetRef tref;
{
	tref->sem_entity.Verror = Nerror;
	return(tref);
}
SeqRef ISeqRef(tref)
SeqRef tref;
{
	tref->sem_entity.Verror = Nerror;
	return(tref);
}
