/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/import.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Semantic.h"
#include "macros.h"
#include <stdio.h>
#include <sys/file.h>

extern Boolean ReaderOK;

#undef FreeHeap
#define FreeHeap(x)

ProcessImportClauses(parentcompUnit, compUnit, parser, includes, vmode, pf)
compilationUnit parentcompUnit;	/* the parent compUnit */
compilationUnit compUnit;       /* the compilationUnit */
char *parser;		        /* complete path to the parser */
SEQString includes;	        /* directories to look for the files in */
Boolean vmode;	        	/* indicator of verbose mode  */
char *pf;			/* parser flags */
{
    static Boolean init=TRUE;
    static int currpos=0;
    static int indent=1;
    SEQDeclaration SDecl;	/* seq traversals and values */
    Declaration ADecl;
    SEQDeclaration SDecl2;
    Declaration ADecl2;
    SEQfiletransition Sft;
    filetransition Aft;
    SEQStructureOrProcessRef SStPrRef;
    StructureOrProcessRef AStPrRef;
    ImportDecl import;		/* an import decl */
    StructureOrProcess stpr;	/* a structure or process decl */
    String filename;		/* the file name */
    char *filenamebuf;		/* complete path to file */
    Boolean foundfilepath;	/* indicator if file path is found */
				/*   and file is accessible        */
    compilationUnit newcompUnit;/* the new compilation unit read in */
    int matches;		/* number of matches for structure or */
				/*   process reference */
    int i, lengthseq, seqint;
    Boolean foundcompUnit;
    Boolean alreadypresent;
    Boolean FindFilePath();
    Boolean RunParserSuccessfully();

    Assume((IscompilationUnit(parentcompUnit)&&
	    IscompilationUnit(compUnit)&&(parser !=NULL)), 
	   "ProcessImportClauses");

    if (init) {
	Assume((parentcompUnit==compUnit), "ProcessImportClauses2");
	init = FALSE;
	currpos = parentcompUnit->lex_endpos+1;
	foreachinSEQDeclaration(compUnit->syn_body, SDecl, ADecl) {
	    if ((typeof(ADecl)==KStructureEntity) || 
		(typeof(ADecl)==KProcessEntity)) {
		ADecl.VStructureOrProcess.IDLclassCommon->inv_used = TRUE;
	    }
	}
    }
    addSETcompilationUnit(parentcompUnit->inv_compUnits, compUnit);
    foreachinSEQfiletransition(compUnit->syn_transitions, Sft, Aft) {
	appendrearSEQfiletransition(parentcompUnit->inv_alltransitions, Aft);
    }

    foreachinSEQDeclaration(compUnit->syn_body, SDecl, ADecl) {
	if (typeof(ADecl)==KStructureEntity) {
	    appendrearSEQStructureEntity(parentcompUnit->sem_structures,
					  ADecl.VStructureEntity);
	}
	else if (typeof(ADecl)==KProcessEntity) {
	    appendrearSEQProcessEntity(parentcompUnit->sem_processes,
					  ADecl.VProcessEntity);
	}
	else if (typeof(ADecl)==KImportDecl) {
	    import = ADecl.VImportDecl;
	    filename = import->syn_compUnit->lex_name;
	    if (vmode) {
		(void) fprintf(stderr, "idlc:");
		for (i=0; i<indent; i++)
		    (void) fprintf(stderr, "    ");
		(void) fprintf(stderr, "processing import '");
		lengthseq = lengthSEQStructureOrProcessRef(import->syn_specs);
		seqint = 1;
	        foreachinSEQStructureOrProcessRef(import->syn_specs, SStPrRef,
							AStPrRef) {
		    (void) fprintf(stderr, "%s", AStPrRef->lex_name);
		    if (seqint != lengthseq)
			(void) fprintf(stderr, ", ");
		}
		(void) fprintf(stderr, "' clause\n");
	    }

            foundcompUnit = FALSE;
	    alreadypresent = FALSE;
	    /* first check if file has already been read in */
	    if (FindCompUnit(parentcompUnit, filename, &newcompUnit)==FOUND){
		alreadypresent = TRUE;
		foundcompUnit = TRUE;
	    }

	    /* else check for file in directories given */
	    else {
		foundfilepath = FindFilePath(includes, &filenamebuf, filename);
		if (foundfilepath) {
		    /* run the parser on the file and read in compilationUnit
		     * if successful, set to the reference
		     */
		    if (RunParserSuccessfully(parser, filenamebuf, 
				      currpos, &newcompUnit,
				      import, pf )) {
			currpos = newcompUnit->lex_endpos+1;
			foundcompUnit = TRUE;
		    }
		}
	    }
	    /* Find the structure or process and
	     * set to the reference 
	     */
	    if (foundcompUnit) {
	      foreachinSEQStructureOrProcessRef(import->syn_specs, SStPrRef,
							AStPrRef) {
		matches = 0;
		foreachinSEQDeclaration(newcompUnit->syn_body, SDecl2, ADecl2) {
		    if (IsStructureOrProcess(ADecl2)){
			stpr = ADecl2.VStructureOrProcess;
			if (stpr.IDLclassCommon->lex_name==AStPrRef->lex_name) {
			    SetStPrEntity(AStPrRef, stpr);
			    stpr.IDLclassCommon->inv_used = TRUE;
			    ++matches;
			}
		    }
		}
		if (matches == 0) {
		    SetErrorEntity(AStPrRef);
		    Warning1(125, AStPrRef->lex_namepos, filename);
		}
		else if (matches > 1) {
		    Warning0(126, AStPrRef->lex_namepos);
		}
	      }
	      /* process import clauses for the new compUnit */
	      if (!alreadypresent){
		    ++indent;
		    ProcessImportClauses(parentcompUnit, newcompUnit, parser, 
						     includes, vmode, pf);
		    --indent;
	      }
	    }
	    else {
		/* can't find file */
		Warning1(129, import->syn_compUnit->lex_namepos, filename);
	        foreachinSEQStructureOrProcessRef(import->syn_specs, SStPrRef,
							AStPrRef) {
		    SetErrorEntity(AStPrRef);
		}
	    }
	}
    }
}

Boolean FindFilePath(includes, finalfilenamebuf, filename)
SEQString includes;
char **finalfilenamebuf;
String filename;
{
    SEQString SStr;
    String AStr;
    char *filenamebuf;
    Boolean foundfilepath;
    String directory;
    int buflen;


    /* check for file in directories given */
    foundfilepath = FALSE;
    directory = NewString(".");
    buflen = strlen(filename)+strlen(directory)+6;
    filenamebuf = (char *)GetHeap(buflen);
    (void)sprintf(filenamebuf, "%s/%s.idl", directory, filename);
    if (access(filenamebuf, F_OK) != 0) {
	foreachinSEQString(includes, SStr, AStr) {
	    FreeHeap(filenamebuf);
	    directory = AStr;
	    buflen = strlen(filename)+strlen(directory)+6;
	    filenamebuf = (char *)GetHeap(buflen);
	    (void)sprintf(filenamebuf, "%s/%s.idl", directory, filename);
	    if (access(filenamebuf, F_OK) == 0) {
		foundfilepath = TRUE;
		*finalfilenamebuf = filenamebuf;
		break;
	    }
	}
    }
    else {
	foundfilepath = TRUE;
	*finalfilenamebuf = filenamebuf;
    }
    return(foundfilepath);
}


Boolean RunParserSuccessfully(parser, filenamebuf, pos, newcunit, import,pflags)
char *parser;
char *filenamebuf;
int pos;
compilationUnit *newcunit;
ImportDecl import;
char *pflags;
{
    Boolean success = FALSE;
    int buflen;
    FILE *tmpfileptr;
    FILE *fopen();
    char *tmpfilename;  	/* unique temporary file name */
    char *parsebuf;
    extern char *error_file;	/* defined in main.c */
    char mktempbuf[30];
    char *mktemp();


    (void)sprintf(mktempbuf, "/tmp/parseXXXXXX");
    tmpfilename = mktemp(mktempbuf);
    buflen = strlen(parser)+strlen(filenamebuf)+strlen(tmpfilename)+
	     strlen(pflags)+strlen(error_file)+50; 
    parsebuf = (char *)GetHeap(buflen);
    (void)sprintf(parsebuf, "(%s %s %s -p %d -f %s 2>&1) >> %s", 
		parser, filenamebuf, pflags, pos, tmpfilename, error_file);
    if (system(parsebuf)) {
	/* parser failed */
	Warning1(127, import->syn_compUnit->lex_namepos, filenamebuf);
    }
    else {
	/* read in the new compilationUnit */
	if ((tmpfileptr = fopen(tmpfilename, "r"))==NULL) {
	    Fatal1(128, 0, tmpfilename);
	}
	else {
	    *newcunit = INSyntax(tmpfileptr);
	    if (ReaderOK) 
		success = TRUE;
	}
    }
    FreeHeap(parsebuf);
    (void) unlink(tmpfilename);
    return(success);
}
