/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/find.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: lower level procedures called mainly from copy.c		*
*									*
* 	     FindStructure  FindNamedType  				*
*	     FindClassAttribute						*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: find.c,v 1.1 89/07/05 16:31:46 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	find.c,v $
 * Revision 1.1  89/07/05  16:31:46  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  02:47:58  cheung
 * find.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  13:23:09  cheung
 * find.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  15:03:49  cheung
 * find.c  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:22:07  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:40:35  shannon
 * Initial revision
 * 
 * Revision 1.1  86/06/06  14:56:01  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:21:19  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.3  86/01/22  07:09:02  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.2  85/07/04  14:54:48  shannon
 * changed set of symbols to sequence
 * 
 * Revision 1.1  85/06/11  10:16:10  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include "Semantic.h"
#include "macros.h"
#include <stdio.h>
#include <string.h>



/***********************************************************************
 *
 * Procedure FindStructure
 *
 * Purpose: Find the structure with name 'st_name' in compilationUnit 
 *	    'compUnit'.
 *
 * Algorithm: search for the structure in the body of 'compUnit'. If
 *	      found assign to 'stfound' and return FOUND else return
 *	      NOTFOUND.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

FindStructure(st_name, compUnit, stfound)
String st_name;		  /* name of strucure */
compilationUnit compUnit; /* compilation unit */
StructureEntity *stfound; /* the structure found */
{

	SEQStructureEntity SSt; /* traveral of structure seq */
	StructureEntity ASt;    /* a value in the seq */

	Assume((IsString(st_name)&&IscompilationUnit(compUnit)),
		"FindStructure");

	foreachinSEQStructureEntity(compUnit->sem_structures, SSt, ASt) {
	    if (strequal(ASt->lex_name,st_name)){
		*stfound = ASt;
		return(FOUND);
	    }
	}

	/* if this point is reached, structure 'stname' is not found */

	return(NOTFOUND);
}

/***********************************************************************
 *
 * Procedure FindProcess
 *
 * Purpose: Find the process with name 'pr_name' in compilationUnit 
 *	    'compUnit'.
 *
 * Algorithm: search for the process in the body of 'compUnit'. If
 *	      found assign to 'prfound' and return FOUND else return
 *	      NOTFOUND.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

FindProcess(compUnit, pr_name, prfound)
compilationUnit compUnit; /* compilation unit */
String pr_name;		  /* name of process */
ProcessEntity *prfound; /* the process found */
{

	SEQProcessEntity SPr; /* traveral of process seq */
	ProcessEntity APr;    /* a value in the seq */

	Assume((IsString(pr_name)&&IscompilationUnit(compUnit)),
		"FindProcess");

	foreachinSEQProcessEntity(compUnit->sem_processes, SPr, APr) {
	    if (strequal(APr->lex_name,pr_name)){
		*prfound = APr;
		return(FOUND);
	    }
	}

	/* if this point is reached, process 'prname' is not found */

	return(NOTFOUND);
}



/***********************************************************************
 *
 * Procedure FindNamedType
 *
 * Purpose: Find the type given by 'tname' in structure 'st'
 *
 * Algorithm: Search through the types of 'st'. If the type
 *	      is found, assign to tfound and return FOUND, else return 
 *	      NOTFOUND.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

int FindNamedType(st, tname, tfound)
StructureEntity st;		/* structure */
String tname;			/* name of type */
NamedType *tfound;		/* the type found */
{

	SETTypeEntity SType;	/* traversal of types of structure */
	TypeEntity AType;	/* value of type in set */

	Assume((IsStructureEntity(st)&&IsString(tname)), 
		"FindNamedType");

	foreachinSETTypeEntity(st->sem_types, SType, AType)
	    if (IsNamedType(AType)) {
		if (strequal(AType.IDLclassCommon->sem_name, tname)){
		    *tfound = AType.VNamedType;
		    return(FOUND);
		}
	    }

	/* if this point is reached, type 'tname' is not found */
	return(NOTFOUND);
}

/***********************************************************************
 *
 * Procedure FindType
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindType(st, AtypeRef)
StructureEntity st;
TypeRef AtypeRef;
{
	int found;
	TypeEntity preludetype;
	NamedType component;
	NamedType component2;
	TypeEntity AType1;

	Assume((IsStructureEntity(st)&&IsTypeRef(AtypeRef)),
		"FindType");


	switch (typeof(AtypeRef)) {
	    case KSetRef:
		found = FindSetType(st, AtypeRef.VSetRef, 
			(SetOf *) &(AtypeRef.VSetRef->sem_entity));
		break;

	    case KSeqRef:
		found = FindSeqType(st, AtypeRef.VSeqRef, 
			(SeqOf *) &(AtypeRef.VSeqRef->sem_entity));
		break;

	    case KNamedTypeRef:
		found = FindNamedType(st, AtypeRef.VNamedTypeRef->lex_name,
			&(AtypeRef.VNamedTypeRef->sem_entity));
		break;
	}
	if (found == NOTFOUND) {
	    if (FindPreludeType(AtypeRef)==FOUND) {
		preludetype = GetTypeEntity(AtypeRef);
		addSETTypeEntity(st->sem_types, preludetype);
		if ((typeof(preludetype)==KSetOf)||
		    (typeof(preludetype)==KSeqOf)) {
		    component = preludetype.VSetOrSeq.IDLclassCommon->sem_component;
		    if (FindNamedType(st, component.IDLclassCommon->sem_name, 
					&component2)) {
			preludetype.VSetOrSeq.IDLclassCommon->sem_component =
				component2;
		    }
		    else {
			AType1.VNamedType = component;
			addSETTypeEntity(st->sem_types, AType1);
		    }
		}
		found = FOUND;
	    }
	}
	return(found);
}
/***********************************************************************
 *
 * Procedure FindSetType
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindSetType(st, settyperef, settypefound)
StructureEntity st;
SetRef settyperef;
SetOf *settypefound;
{
    SETTypeEntity SType;	/* set traversal and value */
    TypeEntity AType;
    NamedTypeRef component;	/* component of setref */
    int found = FALSE;		/* indicator if set is found */
    NamedType comptype;		/* type of component */

    Assume((IsStructureEntity(st)&&IsSetRef(settyperef)),
	    "FindSetType");

    component = settyperef->syn_component;
    if (FindNamedType(st, component->lex_name, 
			&(comptype)) == FOUND){
	SetNamedTypeEntity(component, comptype);
	foreachinSETTypeEntity(st->sem_types, SType, AType){
	    if (typeof(AType) == KSetOf) {
		if (SameType(comptype,AType.VSetOf->sem_component)){
		    *settypefound = AType.VSetOf;
		    found = TRUE;
		    break;
		}
	    }
	}
	if (!found)
	    SetErrorEntity(settyperef);
    }
    else SetErrorEntity(component);
    return(found);
}

/***********************************************************************
 *
 * Procedure FindSeqType
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindSeqType(st, seqtyperef, seqtypefound)
StructureEntity st;
SeqRef seqtyperef;
SeqOf *seqtypefound;
{
    SETTypeEntity SType;	/* seq traversal and value */
    TypeEntity AType;
    NamedTypeRef component;	/* component of seqref */
    NamedType comptype;		/* type of component */
    int found = FALSE;		/* indicator if seq is found */

    Assume((IsStructureEntity(st)&&IsSeqRef(seqtyperef)),
	    "FindSeqType");

    component = seqtyperef->syn_component;
    if (FindNamedType(st, component->lex_name, 
			&(comptype)) == FOUND){
	SetNamedTypeEntity(component, comptype);
	foreachinSETTypeEntity(st->sem_types, SType, AType){
	    if (typeof(AType) == KSeqOf) {
		if (SameType(comptype, AType.VSeqOf->sem_component)){
		    *seqtypefound = AType.VSeqOf;
		    found = TRUE;
		    break;
		}
	    }
	}
	if (!found)
	    SetErrorEntity(seqtyperef);
    }
    else SetErrorEntity(component);
    return(found);
}


/***********************************************************************
 *
 * Procedure FindClassAttribute
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindClassAttribute(aclass, attname, attfound)
Class aclass;
String attname;
Attribute *attfound;
{
	register SEQAttribute SAtt;
	register Attribute AnAtt;

	Assume((IsClass(aclass)&&IsString(attname)),
		"FindClassAttribute");

	foreachinSEQAttribute(aclass->sem_allattributes, SAtt, AnAtt)
	    if (strequal(AnAtt->lex_name, attname))  {
		*attfound = AnAtt;
		return(FOUND);
	    }
	
	/* if this point is reached, attribute is not found */
	return(NOTFOUND);
}


/***********************************************************************
 *
 * Procedure FindDefinition
 *
 * Purpose: Find the definition with name 'defname' in structure 'st'
 *
 * Algorithm: search for the definition in the body of 'st'. If
 *	      found assign to 'deffound' and return FOUND else return
 *	      NOTFOUND.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindDefinition(stpr, defname, deffound)
StructureOrProcess stpr;
String defname;
Definition *deffound;
{
	SETDefinition SDef;
	Definition ADef;
	int found = NOTFOUND;
	SETDefinition DefSet;
	int type;

	type = typeof(stpr);
	Assume((((type==KStructureEntity)||(type==KProcessEntity))
			&&IsString(defname)&&(deffound != NULL)),
		"FindDefinition");
	if (type == KStructureEntity) {
	    DefSet = stpr.VStructureEntity->sem_definitions;
	}
	else {
	    DefSet = stpr.VProcessEntity->sem_definitions;
	}

	foreachinSETDefinition(DefSet, SDef, ADef) {
	    if (strequal(ADef->sem_name, defname)) {
		*deffound = ADef;
		found = FOUND;
		break;
	    }
	}
	if (!found) {
	    found = FindPreludeDefinition(defname, deffound);
	}
	return(found);
}


int FindCompUnit(compUnit, name, foundcunit)
compilationUnit compUnit;
String name;
compilationUnit *foundcunit;
{
    SETcompilationUnit Scu;
    compilationUnit Acu;
    SEQfiletransition Sft;
    filetransition Aft;
    char filename[300];
    int len;
    int found=NOTFOUND;
    char *cp;
    
    Assume((IscompilationUnit(compUnit)), "FindCompUnit");

    foreachinSETcompilationUnit(compUnit->inv_compUnits, Scu, Acu) {
	foreachinSEQfiletransition(Acu->syn_transitions, Sft, Aft){
	    len = strlen(Aft->filename);
	    /* strip off preceding "./(etc)" */
	    for (cp = Aft->filename+len; cp !=Aft->filename && *cp !='/';
				     cp--) ;
	    if (*cp == '/')
		(void) strcpy(filename, cp+1);
	    else (void) strcpy(filename, Aft->filename);

	    /* strip off suffix */
	    len = strlen(filename);
	    if (!strcmp(&(filename[len-4]), ".idl"))
		filename[len-4]='\0';

	    if (!strcmp(filename, name)){
		found = FOUND;
		*foundcunit = Acu;
		break;
	    }
	}
	if (found == FOUND)
	    break;
    }
    return(found);
}
