/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/copyassert.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Semantic.h"
#include "macros.h"


/* only copy lexical and syntactic attributes and let semantic
 * analysis take care of the rest
 */
CopyAssertion(newassert, oldassert)
Assertion newassert,	/* already has storage allocated */
          oldassert;
{
	newassert->lex_name = oldassert->lex_name;
	newassert->lex_namepos = 0;
	newassert->lex_stmtpos = 0;
	newassert->lex_endpos = 0;
	Copyexp(&newassert->syn_body, oldassert->syn_body);
}

CopyDefinition(newdef, olddef)
Definition newdef,	/* already has storage allocated */
	   olddef;
{
	SETDefInstance 	SDefInst;
	DefInstance	ADefInst;
	DefInstance	newDefInst;

	newdef->sem_name = olddef->sem_name;
	foreachinSETDefInstance(olddef->sem_overload, SDefInst, ADefInst) {
	    CopyDefInstance(&newDefInst, ADefInst);
	    SetDefineEntity(newDefInst.IDLclassCommon->syn_def, newdef);
	    addSETDefInstance(newdef->sem_overload, newDefInst);
	}
}

CopyDefInstance(retinst, oldinst)
DefInstance *retinst,	/* no storage allocated */
	    oldinst;
{
	DefInstance 	newinst;
	SEQFormal	Sform;
	Formal		Aform;
	Formal		newform;

	switch (typeof(oldinst)) {
	    case Knoncyclicdef:
		newinst.Vnoncyclicdef = Nnoncyclicdef;
		newinst.Vnoncyclicdef->lex_name =
		    oldinst.Vnoncyclicdef->lex_name;
		foreachinSEQFormal(oldinst.Vnoncyclicdef->syn_list, 
					Sform, Aform) {
		    newform = NFormal;
		    newform->lex_name = Aform->lex_name;
		    CopyTypeRef(&newform->syn_type, Aform->syn_type);
		    appendrearSEQFormal(newinst.Vnoncyclicdef->syn_list,
					newform);
		}
		newinst.Vnoncyclicdef->syn_def = NDefineRef;
		newinst.Vnoncyclicdef->syn_def->lex_name =
		    oldinst.Vnoncyclicdef->syn_def->lex_name;
		Copyexp(&newinst.Vnoncyclicdef->syn_body,
		         oldinst.Vnoncyclicdef->syn_body);
		break;
	    case Kcyclicdef:
		newinst.Vcyclicdef = Ncyclicdef;
		newinst.Vcyclicdef->lex_name =
		    oldinst.Vcyclicdef->lex_name;
		foreachinSEQFormal(oldinst.Vcyclicdef->syn_list, 
					Sform, Aform) {
		    newform = NFormal;
		    newform->lex_name = Aform->lex_name;
		    CopyTypeRef(&newform->syn_type, Aform->syn_type);
		    appendrearSEQFormal(newinst.Vcyclicdef->syn_list,
					newform);
		}
		newinst.Vcyclicdef->syn_def = NDefineRef;
		newinst.Vcyclicdef->syn_def->lex_name =
		    oldinst.Vcyclicdef->syn_def->lex_name;
		Copyexp(&newinst.Vcyclicdef->syn_body,
		         oldinst.Vcyclicdef->syn_body);
		CopyTypeRef(&newinst.Vcyclicdef->syn_returnType,
		             oldinst.Vcyclicdef->syn_returnType);
		break;
	    case KPrivateDefInstance:
		newinst.VPrivateDefInstance = NPrivateDefInstance;
		newinst.VPrivateDefInstance->lex_name =
		    oldinst.VPrivateDefInstance->lex_name;
		foreachinSEQFormal(oldinst.VPrivateDefInstance->syn_list, 
					Sform, Aform) {
		    newform = NFormal;
		    newform->lex_name = Aform->lex_name;
		    CopyTypeRef(&newform->syn_type, Aform->syn_type);
		    appendrearSEQFormal(newinst.VPrivateDefInstance->syn_list,
					newform);
		}
		newinst.VPrivateDefInstance->syn_def = NDefineRef;
		newinst.VPrivateDefInstance->syn_def->lex_name =
		    oldinst.VPrivateDefInstance->syn_def->lex_name;
		CopyTypeRef(&newinst.VPrivateDefInstance->syn_returnType,
		             oldinst.VPrivateDefInstance->syn_returnType);
		break;
	}

	*retinst = newinst;
}

Copyexp(retexp, oldexp)
expression *retexp,	/* no storage allocated */
	   oldexp;
{
	SEQexpressionPair SexpPair;
	expressionPair    AexpPair;
	SEQexpression	  Sexp;
	expression	  Aexp;
	SEQcase_select	  Scs;
	case_select	  Acs;
	expressionPair    NewexpPair;
	expression	  Newexp;
	case_select	  Newcs;
	quantifier	  newq,oldq;
	expression	  newexp;

	switch (typeof(oldexp)) {
	    case Kconditional:
		newexp.Vconditional = Nconditional;
		Copyexp(&newexp.Vconditional->syn_test,
		               oldexp.Vconditional->syn_test);
		Copyexp(&newexp.Vconditional->syn_then,
		               oldexp.Vconditional->syn_then);
		Copyexp(&newexp.Vconditional->syn_else,
		               oldexp.Vconditional->syn_else);
		foreachinSEQexpressionPair(oldexp.Vconditional->syn_orif,
					   SexpPair, AexpPair) {
		    NewexpPair = NexpressionPair;
		    Copyexp(&NewexpPair->syn_test, AexpPair->syn_test);
		    Copyexp(&NewexpPair->syn_then, AexpPair->syn_then);
		    appendrearSEQexpressionPair(newexp.Vconditional->syn_orif,
						NewexpPair);
		}
		break;
	    case Kexistsq:	/* quantifiers */
	    case Kforallq:
		oldq = oldexp.Vquantifier;
		if (typeof(oldq)==Kexistsq)
		    newq.Vexistsq = Nexistsq;
		else 
		    newq.Vforallq = Nforallq;
		newexp.Vquantifier = newq;
		Copyexp(&newq.IDLclassCommon->syn_set, 
			       oldq.IDLclassCommon->syn_set);
		Copyexp(&newq.IDLclassCommon->syn_body, 
			       oldq.IDLclassCommon->syn_body);
		newq.IDLclassCommon->syn_control = NControl;
		newq.IDLclassCommon->syn_control->lex_name =
			       oldq.IDLclassCommon->syn_control->lex_name;
		break;
	    case Kbinary:
		newexp.Vbinary = Nbinary;
		newexp.Vbinary->syn_op = oldexp.Vbinary->syn_op;
		Copyexp(&newexp.Vbinary->syn_left, oldexp.Vbinary->syn_left);
		Copyexp(&newexp.Vbinary->syn_right, oldexp.Vbinary->syn_right);
		break;
	    case Kunary:
		newexp.Vunary = Nunary;
		newexp.Vunary->syn_op = oldexp.Vunary->syn_op;
		Copyexp(&newexp.Vunary->syn_body, oldexp.Vunary->syn_body);
		break;
	    case Kapplication:
		newexp.Vapplication = Napplication;
		foreachinSEQexpression(oldexp.Vapplication->syn_arguments,
					Sexp, Aexp) {
		    Copyexp(&Newexp, Aexp);
		    appendrearSEQexpression(newexp.Vapplication->syn_arguments,
					    Newexp);
		}
		newexp.Vapplication->syn_instance = NDefInstanceOrDefineRef;
		newexp.Vapplication->syn_instance->lex_name =
		    oldexp.Vapplication->syn_instance->lex_name;
		break;
	    case Kdotted:
		newexp.Vdotted = Ndotted;
		Copyexp(&newexp.Vdotted->syn_left, oldexp.Vdotted->syn_left);
		newexp.Vdotted->syn_right = NAttributeRef;
		newexp.Vdotted->syn_right->lex_name =
			oldexp.Vdotted->syn_right->lex_name;
		break;
	    case KportExpression:
		newexp.VportExpression = NportExpression;
		newexp.VportExpression->syn_portName = NPortRef;
		newexp.VportExpression->syn_portName->lex_name =
		    oldexp.VportExpression->syn_portName->lex_name;
		CopyTypeRef(&newexp.VportExpression->syn_type,
		             oldexp.VportExpression->syn_type);
		break;
	    case KExpNameRef:
		newexp.VExpNameRef = NExpNameRef;
		newexp.VExpNameRef->lex_name = oldexp.VExpNameRef->lex_name;
		break;
	    case KExpSetRef:
		newexp.VExpSetRef = NExpSetRef;
		newexp.VExpSetRef->syn_component = NNamedTypeRef;
		newexp.VExpSetRef->syn_component->lex_name =
		    oldexp.VExpSetRef->syn_component->lex_name;
		break;
	    case KExpSeqRef:
		newexp.VExpSeqRef = NExpSeqRef;
		newexp.VExpSeqRef->syn_component = NNamedTypeRef;
		newexp.VExpSeqRef->syn_component->lex_name =
		    oldexp.VExpSeqRef->syn_component->lex_name;
		break;
	    case KfalseExp:
		newexp.VfalseExp = NfalseExp;
		break;
	    case KtrueExp:
		newexp.VtrueExp = NtrueExp;
		break;
	    case KemptyExp:
		newexp.VemptyExp = NemptyExp;
		break;
	    case KrootExp:
		newexp.VrootExp = NrootExp;
		if (typeof(oldexp.VrootExp->syn_portName) == KPortRef) {
		    newexp.VrootExp->syn_portName.VPortRef = NPortRef;
		    newexp.VrootExp->syn_portName.VPortRef->lex_name =
			oldexp.VrootExp->syn_portName.VPortRef->lex_name;
		}
		else
		    newexp.VrootExp->syn_portName.VVoid = NVoid;
		break;
	    case KintegerToken:
		newexp.VintegerToken = NintegerToken;
		newexp.VintegerToken->lex_externalform = 
		    oldexp.VintegerToken->lex_externalform;
		break;
	    case KrationalToken:
		newexp.VrationalToken = NrationalToken;
		newexp.VrationalToken->lex_externalform = 
		    oldexp.VrationalToken->lex_externalform;
		break;
	    case KstringToken:
		newexp.VstringToken = NstringToken;
		newexp.VstringToken->lex_externalform = 
		    oldexp.VstringToken->lex_externalform;
		break;
	    case KcaseExp:
		newexp.VcaseExp = NcaseExp;
		if (typeof(oldexp.VcaseExp->syn_otherwise)==KVoid)
		    newexp.VcaseExp->syn_otherwise.VVoid = NVoid;
		else {
		    Copyexp(&newexp.VcaseExp->syn_otherwise.Vexpression,
		            oldexp.VcaseExp->syn_otherwise.Vexpression);
		}
		foreachinSEQcase_select(oldexp.VcaseExp->syn_select, Scs, Acs){
		    Newcs = Ncase_select;
		    CopyTypeRef(&Newcs->syn_type, Acs->syn_type);
		    Copyexp(&Newcs->syn_exp, Acs->syn_exp);
		    appendrearSEQcase_select(newexp.VcaseExp->syn_select,Newcs);
		}
		Copyexp(&newexp.VcaseExp->syn_exp, oldexp.VcaseExp->syn_exp);
		newexp.VcaseExp->syn_casename = NCaseName;
		newexp.VcaseExp->syn_casename->lex_name =
		    oldexp.VcaseExp->syn_casename->lex_name;
		break;
	}
	*retexp = newexp;
}
