/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/semantic/assert.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Semantic.h"
#include "macros.h"
#include <stdio.h>

/***********************************************************************
 *
 * Procedure AddStPrAssertionTypes
 *
 * Purpose: Add the user types to the assertions contained in the
 *	    assertion seq of structure or process
 *
 * Algorithm: Call AddAssertionType for each Assertion
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

AddStPrAssertionTypes(stpr)
StructureOrProcess stpr;	/* the structure or process */
{
	SETAssertion SAs;   	/* traversal of assertions seq */
	Assertion As;		/* an assertion in the seq  */
	SETDefInstance SInst;
	DefInstance AInst;
	SETDefinition SDef;
	Definition ADef;
	Boolean first;
	TypeRef returnType;
	StructureEntity st;  /* the structure or 
			      * the created process structure */

	Assume((IsStructureOrProcess(stpr)), "AddStPrAssertionTypes");

	if (typeof(stpr)==KProcessEntity){
	    /* create a structure of types which contains for each type,
	     * the most recent ancestor common to all types in the 
	     * port structures 
	     */
	    st = NStructureEntity;
	    CreateAncTypes(st, stpr.VProcessEntity);

	    /* temporarily point to process definitions for name resolution*/
	    st->sem_definitions = stpr.VProcessEntity->sem_definitions;
	}
	else {
	    st = stpr.VStructureEntity;
	}
	foreachinSETAssertion(stpr.IDLclassCommon->sem_assertions, SAs, As) {
	    AddAssertionType(st, As);
	}
	foreachinSETDefinition(stpr.IDLclassCommon->sem_definitions,SDef,ADef){
	    first = TRUE;
	    ADef->sem_resulttype.Verror = Nerror;
	    foreachinSETDefInstance(ADef->sem_overload, SInst, AInst) { 
		AddInstanceType(st, AInst);
		if (first) {
		    if (typeof(AInst)==Knoncyclicdef)  {
			first = FALSE;
			ADef->sem_resulttype = AInst.Vnoncyclicdef
				->syn_body.IDLclassCommon->sem_type;
		    }
		    else {
			if (typeof(AInst)==Kcyclicdef)
			    returnType = AInst.Vcyclicdef->syn_returnType;
			else returnType = AInst.VPrivateDefInstance->
					syn_returnType;
			if (!EntityIsError(returnType.IDLclassCommon)) {
			    first = FALSE;
			    if (typeof(AInst)==Kcyclicdef) {
				ADef->sem_resulttype.Vsingleton = Nsingleton;
				ADef->sem_resulttype.Vsingleton->sem_type.VTypeEntity =
				    GetTypeEntity(returnType);
			    }
			    else
				ADef->sem_resulttype.VTypeEntity = 
				    GetTypeEntity(returnType);
			}
		    }
		}
	    }
	}
	if (typeof(stpr)==KProcessEntity) {
	    st->sem_definitions = NULL;
	}
}


/***********************************************************************
 *
 * Procedure AddAssertionType
 *
 * Purpose: Add types to expressions in the assertion
 *
 * Algorithm: If the assertion contains an expression, call 
 *	      AttachExpressionTypes for the expression.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

AddAssertionType(st, AnAssertion)
StructureEntity st;
Assertion AnAssertion;
{
	Assume((IsStructureEntity(st)&&IsAssertion(AnAssertion)),
		"AddAssertionType");
	AddExpressionTypes(st, AssertionToAssertOrDef(AnAssertion), AnAssertion->syn_body);
}

/***********************************************************************
 *
 * Procedure AddInstanceType
 *
 * Purpose: Add expressions in the assertion
 *
 * Algorithm: Attach types for the return type of the private instance
 *	      and cyclic instance and for the formals.
 *	      If the instance contains an expression (cyclic & noncyclic), call 
 *	      AttachExpressionTypes for the expression.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

AddInstanceType(st, ADefInstance)
StructureEntity st;
DefInstance ADefInstance;
{
	SEQFormal Sf;			/* traversal of seq of Formal */
	Formal Af;			/* a Formal in the seq */
	TypeRef thetype;		/* the type of the privateDefInstance
					   returnType 			*/
	TypeEntity typefound;		/* the type found */
	Definition thedef;		/* definition for instance */
	NamedTypeRef component;

	Assume((IsStructureEntity(st)&&IsDefInstance(ADefInstance)),
		"AddInstanceType");

	thedef = GetDefineEntity(ADefInstance.IDLclassCommon->syn_def);
	if ((typeof(ADefInstance)==KPrivateDefInstance) ||
	    (typeof(ADefInstance)==Kcyclicdef)) {

	    if (typeof(ADefInstance)==KPrivateDefInstance)
		thetype = ADefInstance.VPrivateDefInstance->syn_returnType;
	    else thetype = ADefInstance.Vcyclicdef->syn_returnType;

	    if (FindType(st, thetype)==NOTFOUND) {
		if ((typeof(thetype) != KNamedTypeRef) &&
		    (!EntityIsError(thetype.VSetOrSeqRef.IDLclassCommon))){
		      AddNewType(st, thetype.VSetOrSeqRef);
		      typefound = GetTypeEntity(thetype);
			addSETDefinition(typefound.IDLclassCommon
				    ->inv_definitions, thedef);
		}
		else {
		    SetErrorEntity(thetype.IDLclassCommon);
		    Warning0(301, GetTypePos(thetype));
		}
	    }
	    else {
		typefound = GetTypeEntity(thetype);
		addSETDefinition(typefound.IDLclassCommon->inv_definitions,
				 thedef);
	    }
	}
	foreachinSEQFormal(ADefInstance.IDLclassCommon->syn_list, Sf, Af) {
	    thetype = Af->syn_type;
	    if (FindType(st, thetype)==NOTFOUND) {
		if (typeof(thetype)==KNamedTypeRef) {
		    SetErrorEntity(thetype.IDLclassCommon);
		    Warning0(302, GetTypePos(thetype));
		}
		else {
		    component = thetype.VSetOrSeqRef.IDLclassCommon->
					syn_component;
		    if (FindNamedType(st, component->lex_name, 
					&(component->sem_entity))==FOUND) {
			AddNewType(st, thetype);
		    }
		    else {
			SetErrorEntity(thetype.IDLclassCommon);
			SetErrorEntity(component);
			Warning0(302, component->lex_namepos);
		    }
		}
	    }
	    else {
		typefound = GetTypeEntity(thetype);
		addSETDefinition(typefound.IDLclassCommon->inv_definitions,
				     thedef);
	    }
	}

	/* add types to expressions in cyclic and nonclic instances */
	switch (typeof(ADefInstance)) {
	    case Kcyclicdef:		
	    case Knoncyclicdef:
		AddExpressionTypes(st, DefinitionToAssertOrDef(thedef),
			ADefInstance.VIDLDefInstance.IDLclassCommon->syn_body);
		break;
	}
}


/***********************************************************************
 *
 * Procedure AddExpressionTypes
 *
 * Purpose: Add the user types to the expression or to an expression in the
 *	    expression
 *
 * Algorithm: If the expression is a typeExpression, call AttachType for
 *	      the type field. If the expression contains an expression,
 *	      call this procedure recursively.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

AddExpressionTypes(st, AD, Anexp)
StructureEntity st;
AssertOrDef AD;
expression Anexp;
{

	SEQexpressionPair Tep;	/* traversal of exp pair seq */
	expressionPair ep;	/* an expression pair in seq */
	SEQexpression Texp;	/* traversal of expression seq */
	expression exp;		/* an expression in the seq */
	SEQcase_select Scs;
	case_select Acs;
	TypeRef atyperef;
	TypeEntity atype,AType1;
	Definition def;
	NamedTypeRef component;
	NamedType foundtype;
	static Boolean init = TRUE;
	static Atomic IntType;
	static Atomic StrType;
	static Atomic RatType;
	static Atomic BoolType;
	Atomic GetIntegerType(),
	       GetStringType(),
	       GetRationalType(),
	       GetBooleanType();

	Assume((IsStructureEntity(st) && IsAssertOrDef(AD)),
		"AddExpressionTypes");

	if (init) {
	    init = FALSE;
	    IntType = GetIntegerType();
	    StrType = GetStringType();
	    RatType = GetRationalType();
	    BoolType = GetBooleanType();
	}

	/* all structures have a boolean type */
	if (FindNamedType(st, BoolType->sem_name, &foundtype)==NOTFOUND) {
	    AType1.VAtomic = BoolType; 
	    addSETTypeEntity(st->sem_types, AType1);
	}

	/* set the type default to error */
	Anexp.IDLclassCommon->sem_type.Verror = Nerror;

	switch (typeof(Anexp)) {
	    case Kconditional:
Assume((TRUE), "AddExpressionTypes conditional");
		AddExpressionTypes(st, AD, Anexp.Vconditional->syn_test);
		AddExpressionTypes(st, AD, Anexp.Vconditional->syn_then);
		AddExpressionTypes(st, AD, Anexp.Vconditional->syn_else);
		foreachinSEQexpressionPair(Anexp.Vconditional->syn_orif,
					   Tep, ep) {
		    AddExpressionTypes(st, AD, ep->syn_test);
		    AddExpressionTypes(st, AD, ep->syn_then);
		}
		break;
	    case Kforallq: /* quantifiers */
	    case Kexistsq:
Assume((TRUE), "AddExpressionTypes quantifier");
		Anexp.Vquantifier.IDLclassCommon->syn_control->sem_owner =
			Anexp.Vquantifier;
		AddExpressionTypes(st, AD,
				Anexp.Vquantifier.IDLclassCommon->syn_set);
		AddExpressionTypes(st, AD,
				Anexp.Vquantifier.IDLclassCommon->syn_body);
		break;
	    case Kbinary:
Assume((TRUE), "AddExpressionTypes binary");
		AddExpressionTypes(st, AD, Anexp.Vbinary->syn_left);
		AddExpressionTypes(st, AD, Anexp.Vbinary->syn_right);
		break;
	    case Kunary:
Assume((TRUE), "AddExpressionTypes unary");
		AddExpressionTypes(st, AD, Anexp.Vunary->syn_body);
		break;
	    case Kapplication:
Assume((TRUE), "AddExpressionTypes application");
		/* attach to definition for now, may be instance within def */
		if (FindDefinition(StructureEntityToStructureOrProcess(st), Anexp.Vapplication->syn_instance->
					lex_name,&def)==FOUND) {
		    SetDefineEntity(Anexp.Vapplication->syn_instance, def);
		}
		else {
		    Warning0(801,Anexp.Vapplication->syn_instance->lex_namepos);
		    SetErrorEntity(Anexp.Vapplication->syn_instance);
		}
		foreachinSEQexpression(Anexp.Vapplication->syn_arguments,
					Texp, exp) {
		    AddExpressionTypes(st, AD, exp);
		}
		break;
	    case Kdotted:
Assume((TRUE), "AddExpressionTypes dotted");
		AddExpressionTypes(st, AD, Anexp.Vdotted->syn_left);
		/* temporary name resolution */
		SetErrorEntity(Anexp.Vdotted->syn_right);
		break;
	    case KportExpression:
Assume((TRUE), "AddExpressionTypes portExpression");
		/* temporarily set port reference to error */
		SetErrorEntity(Anexp.VportExpression->syn_portName);
		atyperef = Anexp.VportExpression->syn_type;
		if (FindType(st, atyperef)==NOTFOUND){
		    Warning0(303, GetTypePos(atyperef));
		    SetErrorEntity(atyperef.IDLclassCommon);
		}
		break;
	    case KcaseExp:
Assume((TRUE), "AddExpressionTypes caseExp");
		Anexp.VcaseExp->syn_casename->sem_owner = Anexp.VcaseExp;
		AddExpressionTypes(st, AD, Anexp.VcaseExp->syn_exp);
		if (typeof(Anexp.VcaseExp->syn_otherwise) != KVoid)
		    AddExpressionTypes(st, AD, Anexp.VcaseExp->syn_otherwise);
		foreachinSEQcase_select(Anexp.VcaseExp->syn_select, Scs, Acs) {
		    atyperef = Acs->syn_type;
		    if (FindType(st, atyperef)==NOTFOUND){
			Warning0(303, GetTypePos(atyperef));
			SetErrorEntity(atyperef.IDLclassCommon);
		    }
		    AddExpressionTypes(st, AD, Acs->syn_exp);
		}
		break;
	    case KExpNameRef:
Assume((TRUE), "AddExpressionTypes ExpNameRef");
		if (FindNamedType(st, Anexp.VExpNameRef->lex_name,
				  &(atype.VNamedType))
					== FOUND){
		    SetNamedTypeEntity(Anexp.VExpNameRef, atype.VNamedType);
		    if (typeof(AD) == KAssertion) {
			addSETAssertion(atype.IDLclassCommon->inv_assertions, 
					AD.VAssertion);
		    }
		    else {
			addSETDefinition(atype.IDLclassCommon->inv_definitions, 
					AD.VDefinition);
		    }
		}
		else if (FindDefinition(StructureEntityToStructureOrProcess(st), Anexp.VExpNameRef->lex_name, &def)
					== FOUND) {
		    SetDefineEntity(Anexp.VExpNameRef, def);
		}
		else {
		    /* could be a formal or control or CaseName */
		    SetErrorEntity(Anexp.VExpNameRef);
		}
		break;
	    case KExpSetRef:
	    case KExpSeqRef:
Assume((TRUE), "AddExpressionTypes ExpSetRef ExpSeqRef");
		if (typeof(Anexp)==KExpSetRef)
		    atyperef.VSetRef = NSetRef;
		else atyperef.VSeqRef = NSeqRef;
		component = Anexp.VExpSetSeqRef.IDLclassCommon->syn_component;
		atyperef.VSetOrSeqRef.IDLclassCommon->syn_component = component;
		if (FindType(st, atyperef) == NOTFOUND){
		    if (FindNamedType(st, component->lex_name, 
					&(component->sem_entity))==NOTFOUND) {
			Warning0(303, component->lex_namepos);
			SetErrorEntity(component);
			if (typeof(Anexp)==KExpSetRef) {
			    SetErrorEntity(Anexp.VExpSetRef);
			}
			else {
			    SetErrorEntity(Anexp.VExpSeqRef);
			}
		    }
		    else {
			AddNewType(st, atyperef);
			if (typeof(Anexp)==KExpSetRef)
			    SetSetEntity(Anexp.VExpSetRef, 
					GetSetEntity(atyperef.VSetRef));
			else SetSeqEntity(Anexp.VExpSeqRef, 
					GetSeqEntity(atyperef.VSeqRef));
		    }
		}
		else {
		    if (typeof(Anexp)==KExpSetRef)
			SetSetEntity(Anexp.VExpSetRef, atype.VSetOf);
		    else SetSeqEntity(Anexp.VExpSeqRef, atype.VSeqOf);
		    if (typeof(AD)==KAssertion) {
			addSETAssertion(atype.IDLclassCommon->inv_assertions, 
					AD.VAssertion);
		    }
		    else {
			addSETDefinition(atype.IDLclassCommon->inv_definitions, 
					AD.VDefinition);
		    }
		}
		break;
	    case KintegerToken:
Assume((TRUE), "AddExpressionTypes integerToken");
		if (FindNamedType(st, IntType->sem_name, &foundtype)==NOTFOUND){
		    Anexp.VintegerToken->sem_type.VAtomic = IntType;
	      	    AType1.VAtomic = IntType;
		    addSETTypeEntity(st->sem_types, AType1);
		}
		else {
		    Anexp.VintegerToken->sem_type.VAtomic = foundtype.VAtomic;
		}
		if (typeof(AD)==KAssertion) {
		    addSETAssertion(IntType->inv_assertions, AD.VAssertion);
		}
		else {
		    addSETDefinition(IntType->inv_definitions, AD.VDefinition);
		}
		break;
	    case KstringToken:
Assume((TRUE), "AddExpressionTypes stringToken");
		if (FindNamedType(st, StrType->sem_name, &foundtype)==NOTFOUND){
		    Anexp.VstringToken->sem_type.VAtomic = StrType;
		    AType1.VAtomic = StrType;
		    addSETTypeEntity(st->sem_types, AType1);
		}
		else {
		    Anexp.VstringToken->sem_type.VAtomic = foundtype.VAtomic;
		}
		if (typeof(AD)==KAssertion) {
		    addSETAssertion(StrType->inv_assertions, AD.VAssertion);
		}
		else {
		    addSETDefinition(StrType->inv_definitions, AD.VDefinition);
		}
		break;
	    case KrationalToken:
Assume((TRUE), "AddExpressionTypes rationalToken");
		if (FindNamedType(st, RatType->sem_name, &foundtype)==NOTFOUND){
		    Anexp.VrationalToken->sem_type.VAtomic = RatType;
		    AType1.VAtomic = RatType;
		    addSETTypeEntity(st->sem_types, AType1);
		}
		else {
		    Anexp.VrationalToken->sem_type.VAtomic = foundtype.VAtomic;
		}
		if (typeof(AD)==KAssertion) {
		    addSETAssertion(RatType->inv_assertions, AD.VAssertion);
		}
		else {
		    addSETDefinition(RatType->inv_definitions, AD.VDefinition);
		}
		break;
	    case KrootExp:  /* more literals */
Assume((TRUE), "AddExpressionTypes root");
		/* temporarily set port reference to error */
		if (typeof(Anexp.VrootExp->syn_portName)==KPortRef)
		    SetErrorEntity(Anexp.VrootExp->syn_portName.VPortRef);
		break;
	    case KemptyExp:
	    case KtrueExp:
	    case KfalseExp:
Assume((TRUE), "AddExpressionTypes root, empty, true, or false");
		break;
	    default:
Assume((FALSE), "AddExpressionTypes default");
		Fatal1(1001,0, "AddExpressionTypes");
		break;
	}
}
/* create a structure of types which contains for each type,
 * the most recent ancestor common to all types in the 
 * port structures 
 */
CreateAncTypes(newst, pr)
StructureEntity newst;
ProcessEntity pr;
{
	SETPort SPort;
	Port APort;
	SETTypeEntity SType;
	TypeEntity AType;
	TypeEntity typefound;
	TypeEntity common_anctype;
	String typename;
	Boolean firstport;
	TypeEntity findcommonancestor();

	foreachinSETTypeEntity(pr->sem_invariant->sem_types, SType, AType) {
		typename = AType.IDLclassCommon->sem_name;
		firstport = TRUE;
		foreachinSETPort(pr->sem_ports, SPort, APort) {
		    if (!FindPortType(APort, typename, &typefound)) {
			continue;
		    }

		    if (firstport) {
			firstport = FALSE;
			common_anctype = typefound;
		    }
		    else {
			common_anctype = findcommonancestor(common_anctype, 
							    typefound);
		    }
		}
		if (!firstport) {
		    addSETTypeEntity(newst->sem_types, common_anctype);
		}
	}
}
FindPortType(APort, name, foundtype)
Port APort;
String name;
TypeEntity *foundtype;
{
	SETTypeEntity SType;
	TypeEntity AType;
	StructureEntity st;

	if (typeof(APort->syn_data->sem_entity) == KStructureEntity)
	    st = GetStructureEntity(APort->syn_data);
	else {
	    (void) fprintf(stderr, "error in FindPortType \n");
	    return(0);
	}

	foreachinSETTypeEntity(st->sem_types, SType, AType) {
		if (name == AType.IDLclassCommon->sem_name) {
			*foundtype = AType;
			return(1);
		}
	}
	return(0);
}
TypeEntity findcommonancestor(type1, type2)
TypeEntity type1;
TypeEntity type2;
{
	TypeEntity t1, t2;


	/* if a prelude type then they are the same type */
	if (type1.IDLclassCommon->sem_isPreludeType)
	    return(type1);

	/* see if they are the same type */
	if (SameType(type1, type2))
	    return(type1);

	/* see if one type is copied from the other type */
	t1 = type1;
	t2 = type2;
	while (typeof(t2.IDLclassCommon->sem_copiedfrom)!=KVoid) {
	    if (SameType(t1, t2.IDLclassCommon->sem_copiedfrom)) {
		    return (t1);
	    }
	    t2 = t2.IDLclassCommon->sem_copiedfrom.VTypeEntity;
	}
	t2 = type2;
	while (typeof(t1.IDLclassCommon->sem_copiedfrom)!=KVoid) {
		if (SameType(t2, t1.IDLclassCommon->sem_copiedfrom)) {
			return(t2);
		}
		t1 = t1.IDLclassCommon->sem_copiedfrom.VTypeEntity;
	}

	/* if not found yet, go down one level and try again */
	if (typeof(type1.IDLclassCommon->sem_copiedfrom) == KVoid  ||
	    typeof(type2.IDLclassCommon->sem_copiedfrom) == KVoid) {
		(void) fprintf(stderr, "error in findcommonancestor type %s\n",
			type1.IDLclassCommon->sem_name);
		return(type1);
	}
	else {
	    t1 = type1.IDLclassCommon->sem_copiedfrom.VTypeEntity;
	    t2 = type2.IDLclassCommon->sem_copiedfrom.VTypeEntity;
	    return(findcommonancestor(t1, t2));
	}
}
