/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/type.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Routines for adding types or type information		*
*									*
*	     AddTypeRep  AddTypeSpec					*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: type.c,v 1.1 89/07/05 16:34:47 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	type.c,v $
 * Revision 1.1  89/07/05  16:34:47  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  02:01:07  cheung
 * type.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  12:14:48  cheung
 * type.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:52:06  cheung
 * type.c  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:29:44  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:51:26  shannon
 * Initial revision
 * 
 * Revision 1.1  86/06/06  14:47:30  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:22:12  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.10  86/01/22  07:09:45  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.9  85/07/31  13:45:42  shannon
 * changed expression ::= nameToken to expression ::= nameExpr
 * 
 * Revision 1.8  85/07/26  10:01:45  shannon
 * added assertion processing
 * 
 * Revision 1.7  85/07/25  10:36:34  shannon
 * changed code for new null and empty class rep
 * 
 * Revision 1.6  85/07/18  19:39:56  shannon
 * added type representation for classes
 * added node types for unknown types
 * 
 * Revision 1.5  85/07/05  20:38:06  shannon
 * added new node type for each unknown attribute type
 * 
 * Revision 1.4  85/07/04  14:54:58  shannon
 * changed set of symbols to sequence
 * 
 * Revision 1.3  85/06/27  19:20:41  shannon
 * deleted node representation, just using sequence of targetrep now
 * 
 * Revision 1.2  85/06/20  10:12:28  shannon
 * fixed bug in representation attribute of sets and sequences of
 * scalar types
 * 
 * Revision 1.1  85/06/11  10:19:03  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include "Rep.h"
#include "macros.h"
#include <stdio.h>
#include <ctype.h>

AddTypeRepresentations(compUnit)
compilationUnit compUnit;
{
	SEQStructureEntity SSt;
	StructureEntity ASt;
	SEQProcessEntity SPr;
	ProcessEntity APr;
	SETPort SPort;
	Port APort;
	SETTypeEntity SType;
	TypeEntity AType;
	TypeEntity newtype;
	SEQRepRef SRepRef;
	RepRef ARepRef;
	TargetOrVoid target;

	Assume((IscompilationUnit(compUnit)), "AddTypeRepresentations");


	/* for each structure, 
	 * assign transitions for each non-prelude type using 
	 * "AnyType" prelude specifications 
	 * if type is copied, use transitions of copied from type
	 *    and also copy any rep info inherited.
	 * assign the rep_type fields for attributes,
	 * process the reps for types, and then process the reps for
	 * attributes */
	foreachinSEQStructureEntity(compUnit->sem_structures, SSt, ASt){
	    AssignTransitions(compUnit, ASt);
	    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
		if (typeof(AType)==KClass) {
		    AssignAttributeRepTypes(ASt, AType.VClass);
		}
	    }
	    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
		foreachinSEQRepRef(AType.IDLclassCommon->sem_reps,
						SRepRef, ARepRef) {
		    AddTypeSpec(ASt, AType, ARepRef);
		    if (!RepEntityIsError(ARepRef)) {
			newtype = GetRepTypeEntity(ARepRef);
			if (!SameType(AType, newtype)) {
			    ReplaceAttributeTypes(ASt, AType, newtype);
			    AType = newtype;
			}
		    }
		}
	    }
	    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
		if (typeof(AType)==KClass) {
		    AddAttributeRepresentations(ASt, AType.VClass);
		}
	    }
	}
	/* for each process invariant structure, 
	 * assign the rep_type fields for attributes,
	 * assign transitions for each non-prelude type using 
	 * "AnyType" prelude specifications 
	 * if type is copied, use transitions of copied from type
	 *    and also copy any rep info inherited.
	 * refine types due to target if any
	 * refine types of any port structures due to target if any
	 * process the reps for types, and then process the reps for
	 * attributes 
	 * Check that the private types have correct information
	 */
	foreachinSEQProcessEntity(compUnit->sem_processes, SPr, APr){
	    ASt = APr->sem_invariant;
	    target = APr->sem_target;
	    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
		if (typeof(AType)==KClass) {
		    AssignAttributeRepTypes(ASt, AType.VClass);
		}
	    }
	    AssignTransitions(compUnit, ASt);
	    if (typeof(target)==KTargetEntity) {
		RefineProcessTypes(target.VTargetEntity, ASt);
		foreachinSETPort(APr->sem_ports, SPort, APort) {
		    RefineProcessTypes(target.VTargetEntity, 
				APort->syn_data->sem_entity.VStructureEntity);
		}
	    }
	    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
		foreachinSEQRepRef(AType.IDLclassCommon->sem_reps,
						SRepRef, ARepRef) {
		    AddTypeSpec(ASt, AType, ARepRef);
		    if (!RepEntityIsError(ARepRef)) {
			newtype = GetRepTypeEntity(ARepRef);
			if (!SameType(AType, newtype)) {
			    ReplaceAttributeTypes(ASt, AType, newtype);
			    AType = newtype;
			}
		    }
		}
	    }
	    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
		if (typeof(AType)==KClass) {
		    AddAttributeRepresentations(ASt, AType.VClass);
		}
	    }
	    CheckPrivates(APr, ASt);
	}
}

AddAttributeRepresentations(st, aclass)
StructureEntity st;
Class aclass;
{
	SEQAttribute SAtt;
	Attribute AnAtt;
	SEQRepRef SRepRef;
	RepRef ARepRef;
	Boolean IsPropagated();

	Assume((IsStructureEntity(st)&&IsClass(aclass)),
		"AddAttributeRepresentations");

	foreachinSEQAttribute(aclass->sem_allattributes, SAtt, AnAtt) {
	    if (IsPropagated(aclass, AnAtt)) 
		continue;

	    foreachinSEQRepRef(AnAtt->sem_reps, SRepRef, ARepRef) {
		AddTypeSpec(st, AnAtt->rep_descriptor->rep_type, ARepRef);
		if (!RepEntityIsError(ARepRef))
		    AnAtt->rep_descriptor->rep_type.VTypeEntity = 
					GetRepTypeEntity(ARepRef);
	    }
	}
}
		



/***********************************************************************
 *
 * Procedure AddNewType
 *
 * Purpose: Add a new type to the structure
 *
 * Algorithm: Add a new type given by the type reference and set
 *	      the entity field of the type reference to the new type.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: The type does not already exist in the structure.
 *
 **********************************************************************/
AddNewType(st, atyperef)
StructureEntity st;
TypeRef atyperef;
{
     SetOf newset;
     SeqOf newseq;
     NamedTypeRef component;
     NamedType compfound;
     Class newclass;
     String compname;
     String buf;

     Assume((IsStructureEntity(st)&&IsTypeRef(atyperef)), "AddNewType");
     switch (typeof(atyperef)) {
	 case KNamedTypeRef:
	     newclass = NClass;
	     newclass->sem_name = atyperef.VNamedTypeRef->lex_name;
	     newclass->rep_name = newclass->sem_name;
	     SetClassEntity(atyperef.VNamedTypeRef, newclass);
	     break;
	 case KSetRef:
	     component = atyperef.VSetRef->syn_component;
	     newset = NSetOf;
	     if (FindNamedType(st,component->lex_name, &(compfound))
				== NOTFOUND){
		AddNewType(st, NamedTypeRefToTypeRef(component));
	     }
	     else SetNamedTypeEntity(component, compfound);

	     newset->sem_component = GetNamedTypeEntity(component);
	     compname = newset->sem_component.IDLclassCommon->sem_name;
	     buf = (String)GetHeap(strlen(compname)+8);
	     (void)sprintf(buf, "Set Of %s", compname);
	     newset->sem_name = NewString(buf);
	     newset->rep_name = newset->sem_name;
	     SetSetEntity(atyperef.VSetRef, newset);
	     break;
	 case KSeqRef:
	     component = atyperef.VSeqRef->syn_component;
	     newseq = NSeqOf;
	     if (FindNamedType(st,component->lex_name, &(compfound))
				== NOTFOUND){
		AddNewType(st, NamedTypeRefToTypeRef(component));
	     }
	     else SetNamedTypeEntity(component, compfound);

	     newseq->sem_component = GetNamedTypeEntity(component);
	     compname = newseq->sem_component.IDLclassCommon->sem_name;
	     buf = (String)GetHeap(strlen(compname)+8);
	     (void)sprintf(buf, "Seq Of %s", compname);
	     newseq->sem_name = NewString(buf);
	     newseq->rep_name = newseq->sem_name;
	     SetSeqEntity(atyperef.VSeqRef, newseq);
	     break;
	     
     }

     addSETTypeEntity(st->sem_types, GetTypeEntity(atyperef));
}




Boolean IsPropagated(theclass, att)
Class theclass;
Attribute att;
{
	SETClass SClass;
	Class AClass;

	Assume((IsClass(theclass)&&IsAttribute(att)), "IsPropagated");

	foreachinSETClass(theclass->sem_ancestors, SClass, AClass) {
	    if (inSEQAttribute(AClass->sem_allattributes, att))
		return(TRUE);
	}
	return(FALSE);
}

AssignAttributeRepTypes(st, aclass)
StructureEntity st;
Class aclass;
{
    SEQAttribute SAtt;
    Attribute Att;
    Attribute copiedfrom;
    TypeEntity typefound;

    Assume((IsStructureEntity(st)&&IsClass(aclass)), "AssignAttributeRepTypes");

    foreachinSEQAttribute(aclass->sem_allattributes, SAtt, Att){
	if (typeof(Att->sem_copiedfrom) == KVoid) {
	    Att->rep_descriptor->rep_type.VTypeEntity = 
			GetTypeEntity(Att->syn_type);
	}
	else {
	    copiedfrom = Att->sem_copiedfrom.VAttribute;
	    Assume((IsTypeEntity(copiedfrom->rep_descriptor->rep_type)), 
			"AssignAttributeRepTypes2");
	    if (copiedfrom->rep_descriptor->rep_type.VTypeEntity.IDLclassCommon->sem_isPreludeType) {
		Att->rep_descriptor->rep_type = copiedfrom->rep_descriptor->rep_type;
		addSETTypeEntity(st->sem_types, Att->rep_descriptor->rep_type.VTypeEntity);
	    }
	    else {
		if (FindTypeEntity(st, GetTypeEntity(Att->syn_type), &typefound)
							== FOUND){
		    Assume((IsTypeEntity(typefound)), 
			   "AssignAttributeRepTypes3");
		    Att->rep_descriptor->rep_type.VTypeEntity = typefound;
		}
		else {
		    /* error in semantic analysis */
		    Assume((FALSE), "AssignAttributeRepTypes4");
		}
	    }
	}
    }
}
