/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/size.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

#define CLASS_SIZE 32
#define SET_SIZE 32
#define SEQ_SIZE 32


SetAllSizes(compUnit)
compilationUnit compUnit;
{
    SEQProcessEntity SPr;		/* set traversal and value */
    ProcessEntity pr;			/* a process */
    SETPort SPort;
    Port APort;
    StructureEntity invst;		/* invariant structure of a process */
    TargetEntity target;

    Assume((IscompilationUnit(compUnit)), "SetAllSizes");

    /* set sizes for types in the invariant structure and port structures */
    foreachinSEQProcessEntity(compUnit->sem_processes, SPr, pr){
	if (typeof(pr->sem_target) == KTargetEntity) {
	    invst = pr->sem_invariant;
	    target = pr->sem_target.VTargetEntity;
	    SetSizes(target, invst);
	    foreachinSETPort(pr->sem_ports, SPort, APort) {
		SetSizes(target, APort->syn_data->sem_entity.VStructureEntity);
	    }
	}
    }
}

/*ARGSUSED*/
SetSizes(target, thestructure)
TargetEntity target;
StructureEntity thestructure;
{
    SETTypeEntity SType;
    TypeEntity AType;

    Assume((IsStructureEntity(thestructure)), "SetSizes");

    foreachinSETTypeEntity(thestructure->sem_types, SType, AType){
	if (typeof(AType)==KClass){
	    AType.VClass->rep_size = CLASS_SIZE;
	}
	else if (typeof(AType)==KSetOf) {
	    AType.VSetOf->rep_size = SET_SIZE;
	}
	else if (typeof(AType) == KSeqOf) {
	    AType.VSeqOf->rep_size = SEQ_SIZE;
	}
	else {  /* atomic */
	    switch (typeof(AType.VAtomic->rep_internalType)) {
		case KClass:
		    AType.VAtomic->rep_size = CLASS_SIZE;
		    break;
		case KSetOf:
		    AType.VAtomic->rep_size = SET_SIZE;
		    break;
		case KSeqOf:
		    AType.VAtomic->rep_size = SEQ_SIZE;
		    break;
		case KAtomic:
		    AType.VAtomic->rep_size = 
			AType.VAtomic->rep_internalType.VAtomic->rep_size;
		    break;
	    }
	}
    }
}

/*ARGSUSED*/
SetAlignments(compUnit)
compilationUnit compUnit;
{
    SEQProcessEntity SPr;		/* set traversal and value */
    ProcessEntity pr;			/* a process */
    SETPort SPort;
    Port APort;
    StructureEntity invst;		/* invariant structure of a process */
    TargetEntity target;

    Assume((IscompilationUnit(compUnit)), "SetAllSizes");

    /* set alignment for types in the invariant structure and port structures */
    foreachinSEQProcessEntity(compUnit->sem_processes, SPr, pr){
	if (typeof(pr->sem_target) == KTargetEntity) {
	    invst = pr->sem_invariant;
	    target = pr->sem_target.VTargetEntity;
	    SetStAlignment(target, invst);
	    foreachinSETPort(pr->sem_ports, SPort, APort) {
		SetStAlignment(target, APort->syn_data->sem_entity.VStructureEntity);
	    }
	}
    }
}

/*ARGSUSED*/
SetStAlignment(target, thestructure)
TargetEntity target;
StructureEntity thestructure;
{
    SETTypeEntity SType;
    TypeEntity AType;

    foreachinSETTypeEntity(thestructure->sem_types, SType, AType) {
	if (AType.IDLclassCommon->sem_isPreludeType)
	    continue;
	if (AType.IDLclassCommon->rep_alignment == 0)
	    AType.IDLclassCommon->rep_alignment =AType.IDLclassCommon->rep_size;
    }
}
