/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/restrict.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

AddRestrictions(compUnit)
compilationUnit compUnit;
{
	SEQProcessEntity SPr;	/* seq/set traversals and values */
	ProcessEntity pr;		/* for de-referencing */
	SEQprocessStatement Sps;
	processStatement Aps;
	SEQOperRef SOperRef;
	OperRef AnOperRef;
	StructureEntity invst;
	TargetEntity target;
	typeRestriction tr;
	attributeRestriction ar;
	SETTypeEntity alltypes;
	SETClass allclasses;
	SETClass GetClasses();

	Assume((IscompilationUnit(compUnit)), "AddRestrictions");

	foreachinSEQProcessEntity(compUnit->sem_processes, SPr, pr) {
		if (typeof(pr->sem_target)!=KVoid) {
		    target = pr->sem_target.VTargetEntity;
		    invst = pr->sem_invariant;
		    foreachinSEQprocessStatement(pr->syn_body, Sps, Aps) {
			if (typeof(Aps)==KtypeRestriction) {
			    tr = Aps.VtypeRestriction;
			    if (typeof(tr->syn_type) == KAllTypes) {
				alltypes = tr->syn_type.VAllTypes->sem_items;
			    }
			    else {
				if (EntityIsError(tr->syn_type.VTypeRef.
						  IDLclassCommon)) {
				    foreachinSEQOperRef(tr->syn_operations,
							SOperRef, AnOperRef){
					SetRepErrorEntity(AnOperRef);
				    }
				    /* don't process any further */
				    continue;
				}
				else {
				    initializeSETTypeEntity(alltypes);
				    addSETTypeEntity(alltypes, 
					 GetTypeEntity(tr->syn_type.VTypeRef));
				}
			    }
			    AddTypeRestrictions(target, alltypes, tr);
			}
			else if (typeof(Aps)==KattributeRestriction) {
			    ar = Aps.VattributeRestriction;
			    if (typeof(ar->syn_type) == KAllTypes) {
				allclasses = 
				  GetClasses(ar->syn_type.VAllTypes->sem_items);
			    }
			    else {
				if (EntityIsError(ar->syn_type.VTypeRef.
						  IDLclassCommon)) {
				    foreachinSEQOperRef(ar->syn_operations,
							SOperRef, AnOperRef){
					SetRepErrorEntity(AnOperRef);
				    }
				    continue;
				}
				else {
				    initializeSETClass(allclasses);
				    addSETClass(allclasses, 
					GetClassEntity(ar->syn_type.VTypeRef.
							IDLclassCommon));
				}
			    }
			    AddAttributeRestrictions(target, allclasses, ar);
			}

		    }
		    DetermineAllowedOps(invst, target);
		}
		else { /* no target so operation references are 'error' */
		    foreachinSEQprocessStatement(pr->syn_body, Sps, Aps) {
			if (typeof(Aps)==KtypeRestriction ||
			    typeof(Aps)==KattributeRestriction) {
			    foreachinSEQOperRef(Aps.Vrestriction.IDLclassCommon
					->syn_operations, SOperRef, AnOperRef) {
				SetRepErrorEntity(AnOperRef);
			    }
			}
		    }
		}
	}
}
/***********************************************************************
 *
 * Procedure AddTypeRestrictions
 *
 * Purpose: Add operation restrictions for each type in 'alltypes'
 *	    and any subclasses of each type if class
 *
 * Algorithm: Add the operation to the type. Add the operation to any 
 *	      subclasses. 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: Assumes the subclasses have been propagated up
 *
 **********************************************************************/
AddTypeRestrictions(target, alltypes, tr)
TargetEntity target;
SETTypeEntity alltypes;
typeRestriction tr;
{
	SETTypeEntity SType;	/* set/seq traversals and values */
	TypeEntity AType;
	SEQOperRef SOperRef;
	OperRef AnOperRef;
	Operation AnOp; 	/* an operation */
	Boolean first;
	int typeofOp;
	SETTypeEntity newalltypes;

	Assume((IstypeRestriction(tr)),
		"AddTypeRestrictions");

	foreachinSEQOperRef(tr->syn_operations, SOperRef, AnOperRef){
	    if (GetOperation(target, AnOperRef->lex_name, &AnOp) == FOUND){
		SetOpEntity(AnOperRef, AnOp);
	    }
	    else {
		SetRepErrorEntity(AnOperRef);
		Warning0(479, AnOperRef->lex_namepos);
	    }
	}
	/* check that all operations are the same type. Delete irrelevant
	   types */
	first = TRUE;
	foreachinSEQOperRef(tr->syn_operations, SOperRef, AnOperRef){
	    if (RepEntityIsError(AnOperRef))
		continue;
	    AnOp = GetOpEntity(AnOperRef);
	    if (first) {
		first = FALSE;
		typeofOp = typeof(AnOp);
		initializeSETTypeEntity(newalltypes);
		switch (typeofOp) {
		    case KClassOperation:
			if (typeof(tr->syn_type)==KAllTypes) {
			    foreachinSETTypeEntity(alltypes, SType, AType) {
				if (typeof(AType)==KClass) {
				    addSETTypeEntity(newalltypes, AType);
				}
			    }
			    alltypes = newalltypes;
			    tr->syn_type.VAllTypes->sem_items = alltypes;
			}
			break;
		    case KSetOperation:
			if (typeof(tr->syn_type)==KAllTypes) {
			    foreachinSETTypeEntity(alltypes, SType, AType) {
				if (typeof(AType)==KSetOf) {
				    addSETTypeEntity(newalltypes, AType);
				}
			    }
			    alltypes = newalltypes;
			    tr->syn_type.VAllTypes->sem_items = alltypes;
			}
			break;
		    case KSeqOperation:
			if (typeof(tr->syn_type)==KAllTypes) {
			    foreachinSETTypeEntity(alltypes, SType, AType) {
				if (typeof(AType)==KSeqOf) {
				    addSETTypeEntity(newalltypes, AType);
				}
			    }
			    alltypes = newalltypes;
			    tr->syn_type.VAllTypes->sem_items = alltypes;
			}
			break;
		    case KAtomicOperation:
			if (typeof(tr->syn_type)==KAllTypes) {
			    foreachinSETTypeEntity(alltypes, SType, AType) {
				if (typeof(AType)==KAtomic) {
				    addSETTypeEntity(newalltypes, AType);
				}
			    }
			    alltypes = newalltypes;
			    tr->syn_type.VAllTypes->sem_items = alltypes;
			}
			break;
		}
	    }
	    else {
		if (typeof(AnOp) != typeofOp) {
		    Warning0(481, AnOperRef->lex_namepos);
		    SetRepErrorEntity(AnOperRef);
		}
	    }
	}

	/* add operations to types */
	foreachinSEQOperRef(tr->syn_operations, SOperRef, AnOperRef){
	    if (RepEntityIsError(AnOperRef))
		continue;
	    foreachinSETTypeEntity(alltypes, SType, AType){
		Assume1((IsTypeEntity(AType)), 
			"type '%d' of all types in AddTypeRestrictions",
			 typeof(AType));
		if (typeof(tr->syn_tofrom) == Krestrictto) {
		    addSETOperRef(AType.IDLclassCommon->inv_restrictto, 
				    AnOperRef);
		}
		else {
		    addSETOperRef(AType.IDLclassCommon->inv_restrictfrom, 
				    AnOperRef);
		}
	    }
	}
}



/***********************************************************************
 *
 * Procedure  AddAttributeRestrictions
 *
 * Purpose: Add the operations restricted for specified attributes
 *
 * Algorithm: Find each attribute specified. Add the operation
 *	      to the restrictions of the attribute
 *
 * Errors Checked For: Specified attribute not found
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
/*ARGSUSED*/
AddAttributeRestrictions(target, allclasses, ar)
TargetEntity target;
SETClass allclasses;
attributeRestriction ar;
{

	SEQAttribute SAttribute;
	Attribute AnAttribute;
	SEQOperRef SOperRef;
	OperRef AnOperRef;
	SETAttribute allattributes; /* all attributes with restriction */
	AttributeOperation attOp;

	Assume((IsTargetEntity(target) && IsattributeRestriction(ar)),
		"AddAttributeRestrictions");

	if (typeof(ar->syn_attribute) == KAllAttributes) {
	    allattributes = ar->syn_attribute.VAllAttributes->sem_items;
	}
	else {
	    allattributes = ar->syn_attribute.VAttributeRefs->sem_items;
	}
	foreachinSEQOperRef(ar->syn_operations, SOperRef, AnOperRef){
	    if (GetAttributeOperation(target,AnOperRef->lex_name,&attOp)==FOUND){
		SetAttOpEntity(AnOperRef, attOp);
		foreachinSETAttribute(allattributes, SAttribute, AnAttribute) {
		    if (typeof(ar->syn_tofrom) == Krestrictto) {
			addSETOperRef(AnAttribute->inv_restrictto,
					AnOperRef);
		    }
		    else {
			addSETOperRef(AnAttribute->inv_restrictfrom,
					AnOperRef);
		    }
		}
	    }
	    else {
		SetRepErrorEntity(AnOperRef);
		Warning0(479, AnOperRef->lex_namepos);
	    }
	}
}


/***********************************************************************
 *
 * Procedure DetermineAllowedOps
 *
 * Purpose: Add the allowed operations to each type of the invariant structure
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
DetermineAllowedOps(st, target)
StructureEntity st;
TargetEntity target;
{
	SETTypeEntity SType;
	TypeEntity AType;
	SETOperRef SOperRef;
	OperRef AnOperRef;
	SETOperRef Restrictto;		/* for de-referencing */
	SETOperRef Restrictfrom;
	SETClassOperation classOps;
	SETAtomicOperation atomicOps;
	SETSetOperation setOps;
	SETSeqOperation seqOps;
	Operation Op;
	SETClassOperation defclassOps;	/* default operations */
	SETClassOperation defnodeOps;
	SETAtomicOperation defatomicOps;
	SETSetOperation defsetOps;
	SETSeqOperation defseqOps;
	Boolean isnode;

	SETClassOperation DefaultClassOperations(), CopySETClassOperation();
	SETClassOperation DefaultNodeOperations();
	SETAtomicOperation DefaultAtomicOperations(), CopySETAtomicOperation();
	SETSetOperation DefaultSetOperations(), CopySETSetOperation();
	SETSeqOperation DefaultSeqOperations(), CopySETSeqOperation();

	Assume((IsStructureEntity(st)&&IsTargetEntity(target)), 
			"DetermineAllowedOps");

	defclassOps = DefaultClassOperations(target);
	defnodeOps = DefaultNodeOperations(target);
	defatomicOps = DefaultAtomicOperations(target);
	defsetOps = DefaultSetOperations(target);
	defseqOps = DefaultSeqOperations(target);

	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    Restrictto = AType.IDLclassCommon->inv_restrictto;
	    Restrictfrom = AType.IDLclassCommon->inv_restrictfrom;
	    isnode = FALSE; 
	    if (typeof(AType) == KClass) {
		if (emptySETClass(AType.VClass->sem_subclasses))
		    isnode = TRUE;
	    }
	    switch (typeof(AType)) {
		case KClass:
		    if (emptySETOperRef(Restrictto) &&  
			emptySETOperRef(Restrictfrom)) {
			if (isnode)
			    classOps = defnodeOps;
			else classOps = defclassOps;
		    }
		    else {
			if (!emptySETOperRef(Restrictto)){
			    initializeSETClassOperation(classOps);
			    foreachinSETOperRef(Restrictto, SOperRef,AnOperRef){
				Op = GetOpEntity(AnOperRef);
				if (typeof(Op) != KClassOperation) {
				    Warning0(480, AnOperRef->lex_namepos);
				    SetRepErrorEntity(AnOperRef);
				}
				else {
				    addSETClassOperation(classOps, 
							Op.VClassOperation);
				}
			    }
			}
			else {
			    if (isnode)
				classOps = CopySETClassOperation(defnodeOps);
			    else classOps = CopySETClassOperation(defclassOps);
			}
			foreachinSETOperRef(Restrictfrom, SOperRef, AnOperRef){
			    Op = GetOpEntity(AnOperRef);
			    if (typeof(Op) != KClassOperation) {
				Warning0(480, AnOperRef->lex_namepos);
				SetRepErrorEntity(AnOperRef);
			    }
			    else removeSETClassOperation(classOps,
							Op.VClassOperation);
			}
		    }
		    AType.VClass->rep_allowedOps = classOps;
		    break;
		case KAtomic:
		    if (emptySETOperRef(Restrictto) &&  
			emptySETOperRef(Restrictfrom)) {
			atomicOps = defatomicOps;
		    }
		    else {
			if (!emptySETOperRef(Restrictto)){
			    initializeSETAtomicOperation(atomicOps);
			    foreachinSETOperRef(Restrictto, SOperRef,AnOperRef){
				Op = GetOpEntity(AnOperRef);
				if (typeof(Op) != KAtomicOperation) {
				    Warning0(480, AnOperRef->lex_namepos);
				    SetRepErrorEntity(AnOperRef);
				}
				else {
				    addSETAtomicOperation(atomicOps, 
							Op.VAtomicOperation);
				}
			    }
			}
			else {
			    atomicOps = CopySETAtomicOperation(defatomicOps);
			}
			foreachinSETOperRef(Restrictfrom, SOperRef, AnOperRef){
			    Op = GetOpEntity(AnOperRef);
			    if (typeof(Op) != KAtomicOperation) {
				Warning0(480, AnOperRef->lex_namepos);
				SetRepErrorEntity(AnOperRef);
			    }
			    else removeSETAtomicOperation(atomicOps,
							Op.VAtomicOperation);
			}
		    }
		    AType.VAtomic->rep_allowedOps = atomicOps;
		    break;
		case KSetOf:
		    if (emptySETOperRef(Restrictto) &&  
			emptySETOperRef(Restrictfrom)) {
			setOps = defsetOps;
		    }
		    else {
			if (!emptySETOperRef(Restrictto)){
			    initializeSETSetOperation(setOps);
			    foreachinSETOperRef(Restrictto, SOperRef,AnOperRef){
				Op = GetOpEntity(AnOperRef);
				if (typeof(Op) != KSetOperation) {
				    Warning0(480, AnOperRef->lex_namepos);
				    SetRepErrorEntity(AnOperRef);
				}
				else {
				    addSETSetOperation(setOps, 
							Op.VSetOperation);
				}
			    }
			}
			else {
			    setOps = CopySETSetOperation(defsetOps);
			}
			foreachinSETOperRef(Restrictfrom, SOperRef, AnOperRef){
			    Op = GetOpEntity(AnOperRef);
			    if (typeof(Op) != KSetOperation) {
				Warning0(480, AnOperRef->lex_namepos);
				SetRepErrorEntity(AnOperRef);
			    }
			    else removeSETSetOperation(setOps,
							Op.VSetOperation);
			}
		    }
		    AType.VSetOf->rep_allowedOps = setOps;
		    break;
		case KSeqOf:
		    if (emptySETOperRef(Restrictto) &&  
			emptySETOperRef(Restrictfrom)) {
			seqOps = defseqOps;
		    }
		    else {
			if (!emptySETOperRef(Restrictto)){
			    initializeSETSeqOperation(seqOps);
			    foreachinSETOperRef(Restrictto, SOperRef,AnOperRef){
				Op = GetOpEntity(AnOperRef);
				if (typeof(Op) != KSeqOperation) {
				    Warning0(480, AnOperRef->lex_namepos);
				    SetRepErrorEntity(AnOperRef);
				}
				else {
				    addSETSeqOperation(seqOps, 
							Op.VSeqOperation);
				}
			    }
			}
			else {
			    seqOps = CopySETSeqOperation(defseqOps);
			}
			foreachinSETOperRef(Restrictfrom, SOperRef, AnOperRef){
			    Op = GetOpEntity(AnOperRef);
			    if (typeof(Op) != KSeqOperation) {
				Warning0(480, AnOperRef->lex_namepos);
				SetRepErrorEntity(AnOperRef);
			    }
			    else removeSETSeqOperation(seqOps,
							Op.VSeqOperation);
			}
		    }
		    AType.VSeqOf->rep_allowedOps = seqOps;
		    break;
	    }
	}
}

SETClass GetClasses(thetypes)
SETTypeEntity thetypes;
{
	SETClass class_set;
	SETTypeEntity SType;
	TypeEntity AType;

	initializeSETClass(class_set);
	foreachinSETTypeEntity(thetypes, SType, AType) {
	    if (typeof(AType)==KClass) {
		addSETClass(class_set,AType.VClass);
	    }
	}
	return(class_set);
}
