/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/remove.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "Rep.h"
#include "macros.h"

RemoveUnusedTypes(cunit)
compilationUnit cunit;
{
    SEQStructureEntity SSt;
    StructureEntity ASt;
    SEQProcessEntity SPr;
    ProcessEntity APr;

    foreachinSEQProcessEntity(cunit->sem_processes, SPr, APr) {
	RemoveUnusedStTypes(APr->sem_invariant);
    }
    foreachinSEQStructureEntity(cunit->sem_structures, SSt, ASt) {
	RemoveUnusedStTypes(ASt);
    }

}


RemoveUnusedStTypes(ASt)
StructureEntity ASt;
{
    SETTypeEntity SType;
    TypeEntity AType;
    NamedType root;
    SETTypeEntity reachables;

    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
	AType.IDLclassCommon->sem_isUnreachable = TRUE;
    }

    if ((typeof(ASt->sem_root)==KClass)||
	(typeof(ASt->sem_root)==KAtomic)){
	root = ASt->sem_root.VNamedType;
	Marktypes(root);
	foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
	    if (AType.IDLclassCommon->sem_isUnreachable)  {
		if (!AType.IDLclassCommon->sem_isPreludeType) {
		    if ((typeof(AType) != KSetOf) &&
			(typeof(AType) != KSeqOf)) {
			Warning1(104, ASt->lex_endpos, GetTypeName(AType));
			Marktypes(AType);  /* mark all from this type */
		    }
		}
	    }
	}
    }
    else {
	foreachinSETTypeEntity(ASt->sem_types, SType, AType)  {
	    if ((typeof(AType)==KClass) ||
	        (typeof(AType)==KAtomic &&
		!AType.IDLclassCommon->sem_isPreludeType)) {
		    Marktypes(AType);
	    }
	}
    }

    initializeSETTypeEntity(reachables);
    foreachinSETTypeEntity(ASt->sem_types, SType, AType) {
	if (AType.IDLclassCommon->sem_isPreludeType) {
	    if (!AType.IDLclassCommon->sem_isUnreachable)  {
		addSETTypeEntity(reachables, AType);
	    }
	}
	else addSETTypeEntity(reachables, AType);
    }
    ASt->sem_types = reachables;
}
