/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/prelude.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

#define ANYTHING "<?>"
SEQPreludeType preludetypes;  	/* all the prelude types */

GetAttributeOperation(target, opname, attop)
TargetEntity target;
String opname;
AttributeOperation *attop;
{
	SETAttributeOperation SAttOp;
	AttributeOperation AnAttOp;

	Assume((IsTargetEntity(target)&&IsString(opname)),
		"GetAttributeOperation");

	foreachinSETAttributeOperation(target->pre_attributeOps, SAttOp,AnAttOp)
	    if (strequal(opname, AnAttOp->rep_name)) {
		*attop = AnAttOp;
		return(FOUND);
	    }
	/* if this point is reached, operation is not found */
	return(NOTFOUND);
}

GetClassOperation(target, opname, classop)
TargetEntity target;
String opname;
ClassOperation *classop;
{
	SETClassOperation SClassOp;
	ClassOperation AClassOp;

	Assume((IsTargetEntity(target)&&IsString(opname)),
		"GetClassOperation");

	foreachinSETClassOperation(target->pre_classOps, SClassOp, AClassOp)
	    if (strequal(opname, AClassOp->rep_name)){
		*classop = AClassOp;
		return(FOUND);
	    }
	/* if this point is reached, operation is not found */
	return(NOTFOUND);
}



String NameFromStringSeq(stringseq)
SEQString stringseq;
{
	
	SEQString SStr;
	String AStr;
	String name;
	int len=0;
	int numargs=0;

	foreachinSEQString(stringseq, SStr, AStr) {
	     len += strlen(AStr);
	     ++numargs;
	}
	name = (String)GetHeap(len + numargs);
	name[0] = '\0';
	foreachinSEQString(stringseq, SStr, AStr) {
	    (void)sprintf(name, "%s %s", name, AStr);
	}
	return(name);
}


SETAtomicOperation DefaultAtomicOperations(target)
TargetEntity target;
{
	Assume((IsTargetEntity(target)),
		"DefaultAtomicOperations");
   	return(target->pre_atomicOps);
}

SETClassOperation DefaultClassOperations(target)
TargetEntity target;
{
	Assume((IsTargetEntity(target)),
		"DefaultClassOperations");
	return(target->pre_classOps);
}

SETClassOperation DefaultNodeOperations(target)
TargetEntity target;
{
	Assume((IsTargetEntity(target)),
		"DefaultNodeOperations");
	return(target->pre_nodeOps);
}

SETSetOperation DefaultSetOperations(target)
TargetEntity target;
{
	Assume((IsTargetEntity(target)),
		"DefaultSetOperations");
	return(target->pre_setOps);
}

SETSeqOperation DefaultSeqOperations(target)
TargetEntity target;
{
	Assume((IsTargetEntity(target)),
		"DefaultSeqOperations");
	return(target->pre_seqOps);
}

SETAttributeOperation DefaultAttributeOperations(target)
TargetEntity target;
{
	return(target->pre_attributeOps);
}

GetOperation(target, opname, op)
TargetEntity target;
String opname;
Operation *op;
{
	SETAtomicOperation SAtOp;	/* set traversals and values */
	AtomicOperation AtOp;
	SETClassOperation SClOp;
	ClassOperation ClOp;
	SETClassOperation SNdOp;
	ClassOperation NdOp;
	SETSetOperation SStOp;
	SetOperation StOp;
	SETSeqOperation SSqOp;
	SeqOperation SqOp;
	SETAttributeOperation SAOp;
	AttributeOperation AOp;

	Assume((IsTargetEntity(target) && IsString(opname)&&(op!=NULL)), 
		"GetOperation");
	foreachinSETSetOperation(target->pre_setOps, SStOp, StOp) {
	    if (strequal(StOp->rep_name, opname)) {
		op->VSetOperation = StOp;
		return(FOUND);
	    }
	}
	foreachinSETSeqOperation(target->pre_seqOps, SSqOp, SqOp) {
	    if (strequal(SqOp->rep_name, opname)) {
		op->VSeqOperation = SqOp;
		return(FOUND);
	    }
	}
	foreachinSETAtomicOperation(target->pre_atomicOps, SAtOp, AtOp) {
	    if (strequal(AtOp->rep_name, opname)) {
		op->VAtomicOperation = AtOp;
		return(FOUND);
	    }
	    
	}
	foreachinSETClassOperation(target->pre_classOps, SClOp, ClOp) {
	    if (strequal(ClOp->rep_name, opname)) {
		op->VClassOperation = ClOp;
		return(FOUND);
	    }
	}
	foreachinSETClassOperation(target->pre_nodeOps, SNdOp, NdOp) {
	    if (strequal(NdOp->rep_name, opname)) {
		op->VClassOperation = NdOp;
		return(FOUND);
	    }
	}
	foreachinSETAttributeOperation(target->pre_attributeOps, SAOp, AOp) {
	    if (strequal(AOp->rep_name, opname)) {
		op->VAttributeOperation = AOp;
		return(FOUND);
	    }
	}

	return(NOTFOUND);
}


/*ARGSUSED*/
FindRep(target, arepref)
TargetEntity target;
RepRef arepref;
{
    return(NOTFOUND);
}


Boolean IsKeyword(targetLang, name)
TargetEntity targetLang;
String name;
{
	SETString SStr;
	String AStr;
	Boolean keyword = FALSE;

	Assume((IsTargetEntity(targetLang)&&IsString(name)),
		"IsKeyword");

	foreachinSETString(targetLang->pre_keywords, SStr, AStr) {
	    if (strequal(name, AStr)) {
	       keyword = TRUE;
	       break;
	    }
	}
	return(keyword);
}


Boolean IsPreludeType(type)
TypeEntity type;
{
	Assume((IsTypeEntity(type)), "IsPreludeType");
	return(type.IDLclassCommon->sem_isPreludeType);
}

