/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/phase_indep.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include <stdio.h>

phase_independent(compUnit, verbosemode)
compilationUnit	compUnit;
Boolean		verbosemode;
{

    if (verbosemode) {
	(void) fprintf(stderr, "idlc: independent representation phase\n");
	(void) fflush(stderr);
    }

    /* add the type representations */
    if (verbosemode) {
	(void) fprintf(stderr, "idlc:    adding type representations\n");
	(void) fflush(stderr);
    }
    AddTypeRepresentations(compUnit);

    /* add the restrictions for each process */
    if (verbosemode) {
	(void) fprintf(stderr, "idlc:    adding restrictions\n");
	(void) fflush(stderr);
    }
    AddRestrictions(compUnit);

    /* check for name conflicts */
    if (verbosemode) {
	(void) fprintf(stderr, "idlc:    checking name conflicts\n");
	(void) fflush(stderr);
    }
    CheckNameConflicts(compUnit);

    /* calculate node ids */
    if (verbosemode) {
	(void) fprintf(stderr, "idlc:    calculating node ids\n");
	(void) fflush(stderr);
    }
    calculate_nodeids(compUnit);
}
