/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/phase_dep.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

phase_dependent(compUnit, verbosemode)
compilationUnit	compUnit;
Boolean		verbosemode;
{
    SEQProcessEntity SPr;
    ProcessEntity APr;
    SETPort SPort;
    Port APort;
    Boolean has_specified_target();

    Assume((IscompilationUnit(compUnit)), "phase_dependent");


    if (verbosemode) {
	(void) fprintf(stderr, "idlc: dependent representation phase\n");
	(void) fflush(stderr);
    }

    /* determine the sizes and alignments of the types */
    if (verbosemode) {
	(void) fprintf(stderr, "idlc:    determining sizes\n");
	(void) fflush(stderr);
    }
    SetAllSizes(compUnit);
    SetAlignments(compUnit);

    /********************************/
    /* do special target processing */
    /********************************/

    /* for C targets position attributes in the processes and port structures */
    foreachinSEQProcessEntity(compUnit->sem_processes, SPr, APr){

	/* for C targets only, position the attributes	*/
	/* to allow for nonhierarchical classes 	*/
	if (!has_specified_target(APr, "C"))
	    continue;
	if (verbosemode) {
	    (void) fprintf(stderr, 
                "idlc:    positioning attributes for process '%s'\n",
                APr->lex_name);
	    (void) fflush(stderr);
	}
	PositionAttributes(APr->sem_invariant);
	foreachinSETPort(APr->sem_ports, SPort, APort) {
	    PositionAttributes(APort->syn_data->sem_entity.VStructureEntity);
	}
    }

    /* for Pascal targets, strip underscores from type and port names */
    foreachinSEQProcessEntity(compUnit->sem_processes, SPr, APr){
	if (!has_specified_target(APr, "Pascal"))
	    continue;
	if (verbosemode) {
	    (void) fprintf(stderr, 
                "idlc:    stripping underscores for process '%s'\n",
		APr->lex_name);
	    (void) fflush(stderr);
	}
	FixPascalNames(APr);
    }

    /* check for reachability, remove any unused prelude types */
    RemoveUnusedTypes(compUnit);  
}

Boolean has_specified_target(APr, target_name)
ProcessEntity APr;
String target_name;
{
  String target_name2;
  target_name2 = NewString(target_name);
  if (typeof(APr->sem_target)==KTargetEntity &&
      inSETString(APr->sem_target.VTargetEntity->sem_id, target_name2)) 
    return(TRUE);
  else 
    return(FALSE);
}
