/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/pascal.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"

FixPascalNames(aprocess)
ProcessEntity aprocess;
{
	Boolean 		fixed;
	String 			new_name;
	StructureEntity		invst;
	SETTypeEntity		SType;
	TypeEntity		AType;
	SEQAttribute		SAtt;
	Attribute		Att;
	SETPort			SPort;
	Port			APort;
	String			FixName();

	invst = aprocess->sem_invariant;
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    new_name = FixName(AType.IDLclassCommon->rep_name, &fixed);
	    if (fixed) {
		Recoverable2(373, aprocess->lex_endpos, 
				AType.IDLclassCommon->rep_name, new_name);
		AType.IDLclassCommon->rep_name = new_name;
	    }
	    if (typeof(AType)==KClass) {
		foreachinSEQAttribute(AType.VClass->sem_allattributes,SAtt,Att){
		    new_name = FixName(Att->rep_name, &fixed);
		    if (fixed) {
			Recoverable2(373, aprocess->lex_endpos, 
				    Att->rep_name, new_name);
			Att->rep_name = new_name;
		    }
		}
	    }
	}
	foreachinSETPort(aprocess->sem_ports, SPort, APort) {
	    new_name = FixName(APort->rep_name, &fixed);
	    if (fixed) {
		Recoverable2(373, aprocess->lex_endpos, 
				APort->rep_name, new_name);
		APort->rep_name = new_name;
	    }
	}
}

String FixName(name, fixed)
String 		name;
Boolean		*fixed;
{
	char buf[2000];
	char *cp, *cp2;

	*fixed = FALSE;
	/* strip underscores */
	for (cp=name, cp2=buf; *cp; cp++) {
	    if (*cp != '_')	
		*cp2++ = *cp;
	    else *fixed = TRUE;
	}
	*cp2 = '\0';

	if (*fixed)
	    return(NewString(buf));
	else return(name);
}
