/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/nodeid.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include  "Rep.h"
#include  "macros.h"
#include <stdio.h>

calculate_nodeids(compUnit)
compilationUnit compUnit;
{
    SEQProcessEntity SPr;		/* set traversal and value */
    ProcessEntity pr;			/* a process */
    SETPort SPort;
    Port APort;

    Assume((IscompilationUnit(compUnit)), "calculate_nodeids");

    /* calculate nodeids for invariant and port structures */
    foreachinSEQProcessEntity(compUnit->sem_processes, SPr, pr){
	Calc_NodeId(pr->sem_invariant);
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    Calc_NodeId(GetStructureEntity(APort->syn_data));
	}
    }
}

Calc_NodeId(invst)
StructureEntity invst;
{
	SETTypeEntity SType;
	TypeEntity AType;
	SEQClass Snode;
	Class Anode;
	SEQClass allnodes;
	int next_nodeid=2;
	int next_enumid=1;
	Boolean SwapNodes();

	/* set any enumerated types which are propagated */
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if (typeof(AType)==KClass && AType.VClass->rep_enumerated)
		SetEnums(AType.VClass);
	}

	initializeSEQClass(allnodes);
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if (typeof(AType)==KClass && 
		emptySETClass(AType.VClass->sem_subclasses)) {
		appendfrontSEQClass(allnodes, AType.VClass);
	    }
	}

	/* sort the nodes by alphabet */
	sortSEQClass(allnodes, SwapNodes);

	foreachinSEQClass(allnodes, Snode, Anode) {
	    if (Anode->rep_enumerated) {
		Anode->rep_typeId = next_enumid;
		next_enumid += 2;
	    }
	    else {
		Anode->rep_typeId = next_nodeid;
		next_nodeid += 2;
	    }
	}
}

SetEnums(cl)
Class cl;
{
	SETClass SClass;
	Class AClass;

	foreachinSETClass(cl->sem_subclasses, SClass, AClass) {
	    if (emptySEQAttribute(AClass->sem_allattributes)) {
		AClass->rep_enumerated = TRUE;
		SetEnums(AClass);
	    }
	}
}

Boolean SwapNodes(n1, n2)
Class n1, n2;
{

	Assume((IsClass(n1)&&IsClass(n2)), "SwapNodes");
	if (strcmp(n1->sem_name, n2->sem_name) > 0) /* n2 should be before n1 */
		return(TRUE);
	else return(FALSE);			/* the names are equal or
						   n1 should be before n2 */
}
