/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/newrep.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

AssignTransitions(compUnit, st)
compilationUnit compUnit;
StructureEntity st;
{
    SETTypeEntity SType;
    TypeEntity AType;
    TypeEntityOrVoid copiedfrom;
    SEQStateTransition SST;
    StateTransition AST;
    extern Boolean IsPreludeType();

    Assume((IscompilationUnit(compUnit)&&IsStructureEntity(st)),
	    "AssignTransitions");
    
    foreachinSETTypeEntity(st->sem_types, SType, AType) {
	if (!IsPreludeType(AType) || typeof(AType)==KSetOf || typeof(AType)==KSeqOf ) {
	    copiedfrom = AType.IDLclassCommon->sem_copiedfrom;
	    if (typeof(copiedfrom)==KVoid) {
		GetTransitions(compUnit, AType);
	    }
	    else {
		foreachinSEQStateTransition(copiedfrom.VTypeEntity.
				IDLclassCommon->pre_statetransitions, SST,AST){
		    appendrearSEQStateTransition(AType.IDLclassCommon->
				    pre_statetransitions, AST);
		}
		CopyTypeRepInfo(st, AType, copiedfrom.VTypeEntity);
	    }
	}
    }
}

GetTransitions(compUnit, AType)
compilationUnit compUnit;
TypeEntity AType;
{
    SEQPreludeType SPType;
    PreludeType APType;
    SEQStateTransition SST;
    StateTransition AST, newstatetran;
    Boolean found=FALSE;

    Assume((IscompilationUnit(compUnit)&&IsTypeEntity(AType)),
		"GetTransitions");

    foreachinSEQPreludeType(compUnit->sem_preludetypes, SPType, APType){
	switch (typeof(AType)) {
	    case KClass:
		if (emptySEQAttribute(AType.VClass->sem_allattributes)) {
		    if (typeof(APType)==KAnyUnattrClass)
			found = TRUE;
		}
		else if (typeof(APType)==KAnyAttrClass) {
		    found = TRUE;
		}
		break;
	    case KAtomic:
		if (typeof(APType)==KAnyPrivate) {
		    found = TRUE;
		}
		break;
	    case KSetOf:
		if (typeof(APType)==KAnySet) {
		    found = TRUE;
		}
		break;
	    case KSeqOf:
		if (typeof(APType)==KAnySeq) {
		    found = TRUE;
		}
		break;
	}
	if (found) {
	    foreachinSEQStateTransition(APType.IDLclassCommon->
				pre_statetransitions, SST,AST) {
		newstatetran = NStateTransition;
		newstatetran->pre_transition = AST->pre_transition;
		newstatetran->pre_nextstate = AST->pre_nextstate;
		appendrearSEQStateTransition(AType.IDLclassCommon->
				pre_statetransitions, newstatetran);
	    }
	    break;
	}
    }
}

RefineProcessTypes(target, st)
TargetEntity target;
StructureEntity st;
{
    SETTypeEntity SType;
    TypeEntity AType;
    TypeEntity deptype;
    TypeEntity indeptype;
    SEQRefinedTypePair SPr;
    RefinedTypePair APr;

    Assume((IsTargetEntity(target)&&IsStructureEntity(st)),
		"RefineProcessTypes");
    foreachinSETTypeEntity(target->pre_types, SType, AType) {
	AType.IDLclassCommon->sem_isPreludeType = TRUE;
    }
    foreachinSEQRefinedTypePair(target->pre_refinedtypePrs, SPr, APr) {
	if (inSETTypeEntity(st->sem_types, APr->pre_targetIndependent)) {
	    deptype = APr->pre_targetDependent;
	    indeptype = APr->pre_targetIndependent;
	    /* if the type is a set or seq, add package and numelements
	     * to the * the dependent type from the independent type
	     * ** temporary fix **
	     */
	    if (typeof(deptype)==KSetOf || typeof(deptype)==KSeqOf) {
		deptype.VSetOrSeq.IDLclassCommon->rep_package = 
		    indeptype.VSetOrSeq.IDLclassCommon->rep_package;
		deptype.VSetOrSeq.IDLclassCommon->rep_numelements = 
		    indeptype.VSetOrSeq.IDLclassCommon->rep_numelements;
	    }
	    ReplaceAttributeTypes(st, indeptype, deptype);
	    removeSETTypeEntity(st->sem_types, indeptype);
	    addSETTypeEntity(st->sem_types, deptype);
	}
    }
}


AddTypeSpec(st, thetype, arepref)
StructureEntity st;
TypeEntity thetype;
RepRef arepref;
{
    StateTransition foundtran;		/* StateTransition found */
    SEQActionType SAT;			/* seq traversals and values */
    ActionType Anaction;
    parameter parm;
    SourcePosition pos;
    TypeEntity newtype;

    Assume((IsStructureEntity(st)&&IsTypeEntity(thetype)&&IsRepRef(arepref)), 
	    "AddTypeSpec");

    if (FindTransition(thetype, arepref, &foundtran) == FOUND) {
	if (IsTypeEntity(foundtran->pre_nextstate)) {
	    SetRepTypeEntity(arepref, foundtran->pre_nextstate.VTypeEntity);
	}
	else {
	    SetRepTypeEntity(arepref, thetype);
	}
	foreachinSEQActionType(foundtran->pre_transition->pre_actions, SAT,
						Anaction){
	    PerformAction(st, thetype, Anaction, arepref, foundtran);
	    /* handle this specially */
	    if (typeof(Anaction)==Knewcopy) {
		CopyType(&newtype, thetype);
		SetRepTypeEntity(arepref, newtype);
		thetype = newtype;
	    }
	}
    }
    else {
	SetRepErrorEntity(arepref);
	retrievefirstSEQparameter(arepref->syn_id, parm);
	if (typeof(parm)==KnameToken)
	    pos = parm.VnameToken->lex_namepos;
	else pos = parm.VotherToken.IDLclassCommon->lex_expos;
	Warning0(157, pos);
    }
}


int FindTransition(atype, arepref, foundtransition)
TypeEntity atype;
RepRef arepref;
StateTransition *foundtransition;
{
    SEQStateTransition SST;	/* set/seq traversals and values */
    StateTransition AST;
    SEQparameter repid;		/* for de-referencing */
    SEQIdparameter tranid;
    int found=NOTFOUND;		/* indicator if match is found */
    Boolean MatchParms();

    Assume((IsTypeEntity(atype)&&IsRepRef(arepref)), "FindTransition");

    /* de-reference */
    repid = arepref->syn_id;

    foreachinSEQStateTransition(atype.IDLclassCommon->pre_statetransitions, 
						SST, AST){
	tranid = AST->pre_transition->pre_id;
	if (MatchParms(repid, tranid)){
	    found = FOUND;
	    *foundtransition = AST;
	    break;
	}
    }
    Assume((found && IsStateTransition((*foundtransition))|| !found), 
	"FindTransition2");
    return(found);
}

Boolean MatchParms(parmseq, idparmseq)
SEQparameter parmseq;
SEQIdparameter idparmseq;
{
    Boolean match=TRUE;		/* indicator of match so far*/
    int len1, len2;		/* sequence lengths */
    int i;			/* index */
    int ival;			/* value of parameter integer token */
    float rval;			/* value of parameter rational token */
    parameter nextparm;		/* next parameter in parameter seq */
    Idparameter nextidparm;	/* next Idparameter in Idparameter seq */
    double atof();
    extern Boolean NCStringMatch();

    Assume((TRUE), "MatchParms");

    len1 = lengthSEQparameter(parmseq);
    len2 = lengthSEQIdparameter(idparmseq);
    if (len1 == len2){
	for (i=1; i<=len1; i++){
	    ithinSEQparameter(parmseq, i, nextparm);
	    ithinSEQIdparameter(idparmseq, i, nextidparm);

	    switch (typeof(nextidparm)){
		case KnameValue:
		    if (typeof(nextparm) == KnameToken) {
			 if (!NCStringMatch(nextparm.VnameToken->lex_name,
			       nextidparm.VnameValue->pre_name)) {
			     match = FALSE;
			 }
			 else nextidparm.VnameValue->inv_token = 
						nextparm.VnameToken;
		    }
		    else match = FALSE;
		    break;
		case KintegerValue:
		    if (typeof(nextparm)==KintegerToken){
			ival = atoi(nextparm.VintegerToken->lex_externalform);
			if (ival != nextidparm.VintegerValue->pre_integer){
			    match = FALSE;
			}
			else nextidparm.VintegerValue->inv_token = 
						nextparm.VintegerToken;
	   	    }
		    else match = FALSE;
		    break;
		case KrationalValue:
		    if (typeof(nextparm)==KrationalToken){
			rval = atof(nextparm.VrationalToken->lex_externalform);
			if (rval != nextidparm.VrationalValue->pre_rational){
			    match = FALSE;
			}
			else nextidparm.VrationalValue->inv_token = 
						nextparm.VrationalToken;
	   	    }
		    else match = FALSE;
		    break;
		case KnameSpec:
		    if (typeof(nextparm) != KnameToken){
			match = FALSE;
		    }
		    else nextidparm.VnameSpec->inv_token = nextparm.VnameToken;
		    break;
		case KintegerSpec:
		    if (typeof(nextparm) != KintegerToken){
			match = FALSE;
		    }
		    else nextidparm.VintegerSpec->inv_token =
				nextparm.VintegerToken;
		    break;
		case KrationalSpec:
		    if (typeof(nextparm) != KrationalToken){
			match = FALSE;
		    }
		    else nextidparm.VrationalSpec->inv_token =
				nextparm.VrationalToken;
		    break;
		case KintegerRange:
		    if (typeof(nextparm)==KintegerToken){
			ival = atoi(nextparm.VintegerToken->lex_externalform);
			if (!(ival >= nextidparm.VintegerRange->pre_low &&
			      ival <= nextidparm.VintegerRange->pre_high)){
			    match = FALSE;
			}
			else nextidparm.VintegerRange->inv_token = 
					nextparm.VintegerToken;
		    }
		    else match = FALSE;
		    break;
		case KrationalRange:
		    if (typeof(nextparm)==KrationalToken){
			rval = atoi(nextparm.VrationalToken->lex_externalform);
			if (!(rval >= nextidparm.VrationalRange->pre_low &&
			      rval <= nextidparm.VrationalRange->pre_high)){
			    match = FALSE;
			}
			else nextidparm.VrationalRange->inv_token = 
					nextparm.VrationalToken;
		    }
		    else match = FALSE;
		    break;
	    }
	    if (!match)
		break;
	}
    }
    else match = FALSE;

    return(match);
}
	    
/*ARGSUSED*/    
PerformAction(st, thetype, Anaction, therepref, thestatetran)
StructureEntity st;
TypeEntity thetype;
ActionType Anaction;
RepRef therepref;
StateTransition thestatetran;
{
    SetRef asetref;
    SeqRef aseqref;
    nameToken anamespec;
    nameToken anameval;
    integerToken aintspec;
    NamedType typefound;

    Assume((IsStructureEntity(st)&&IsTypeEntity(thetype)&&IsRepRef(therepref)&&
		IsStateTransition(thestatetran)),
		"PerformAction");

    switch (typeof(Anaction)){
	case Knewcopy:
	    break;
	case Kcopytransitions:
	    break;
	case KassignName:
	    anamespec = Anaction.VassignName->pre_param.IDLclassCommon
			->inv_token;
	    if (FindNamedType(st, anamespec->lex_name, &typefound)==FOUND) {
		    Warning0(156, anamespec->lex_namepos);
	    }
	    else thetype.IDLclassCommon->rep_name = anamespec->lex_name;
	    break;
	case KassignExternalSet:
	case KassignInternalSet:
	case KassignSet:
	    Assume((typeof(thetype)==KAtomic), "PerformAction ExtSet");
	    asetref = NSetRef;
	    asetref->syn_component = NNamedTypeRef;
	    if (typeof(Anaction)==KassignExternalSet)
		asetref->syn_component->lex_name =
		    Anaction.VassignExternalSet->pre_param.IDLclassCommon
				->inv_token->lex_name;
	    else if (typeof(Anaction)==KassignInternalSet)
		asetref->syn_component->lex_name =
		    Anaction.VassignInternalSet->pre_param.IDLclassCommon
				->inv_token->lex_name;
	    else asetref->syn_component->lex_name =
		    Anaction.VassignSet->pre_param.IDLclassCommon
				->inv_token->lex_name;

	    if (FindType(st, SetRefToTypeRef(asetref)) ==NOTFOUND) {
		if (FindType(st, NamedTypeRefToTypeRef(asetref->syn_component)) == NOTFOUND) {
		    Warning0(151, asetref->syn_component->lex_namepos);
		}
		else AddNewType(st, SetRefToTypeRef(asetref));
	    }
	    if (TypeOfEntity(asetref)==KSetOf) {
		if (typeof(Anaction)==KassignExternalSet)
		    thetype.VAtomic->rep_externalType.VSetOf = 
			    GetSetEntity(asetref);
		else if (typeof(Anaction)==KassignInternalSet)
		    thetype.VAtomic->rep_internalType.VSetOf = 
			    GetSetEntity(asetref);
		else { /* assignSet */
		    thestatetran->pre_nextstate.VSetOf =
					  GetSetEntity(asetref);
		}
	    }
	    break;
	case KassignExternalSeq:
	case KassignInternalSeq:
	case KassignSeq:
	    Assume((typeof(thetype)==KAtomic), "PerformAction ExtSeq");
	    aseqref = NSeqRef;
	    aseqref->syn_component = NNamedTypeRef;
	    if (typeof(Anaction)==KassignExternalSeq)
		aseqref->syn_component->lex_name =
		    Anaction.VassignExternalSeq->pre_param.IDLclassCommon
				->inv_token->lex_name;
	    else if (typeof(Anaction)==KassignInternalSeq)
		aseqref->syn_component->lex_name =
		    Anaction.VassignInternalSeq->pre_param.IDLclassCommon
				->inv_token->lex_name;
	    else aseqref->syn_component->lex_name =
		    Anaction.VassignSeq->pre_param.IDLclassCommon
				->inv_token->lex_name;
	    if (FindType(st, SeqRefToTypeRef(aseqref)) ==NOTFOUND) {
		if (FindType(st, NamedTypeRefToTypeRef(aseqref->syn_component)) == NOTFOUND) {
		    Warning0(151, aseqref->syn_component->lex_namepos);
		}
		else AddNewType(st, SeqRefToTypeRef(aseqref));
	    }
	    if (TypeOfEntity(aseqref)==KSeqOf) {
		if (typeof(Anaction)==KassignExternalSeq)
		    thetype.VAtomic->rep_externalType.VSeqOf = 
			    GetSeqEntity(aseqref);
		else if (typeof(Anaction)==KassignInternalSeq)
		    thetype.VAtomic->rep_internalType.VSeqOf = 
			    GetSeqEntity(aseqref);
		else { /* assignSeq */
		    thestatetran->pre_nextstate.VSeqOf =
					  GetSeqEntity(aseqref);
		}
	    }
	    break;
	case KassignExternalNamedType:
	case KassignInternalNamedType:
	case KassignNamedType:
	    Assume((typeof(thetype)==KAtomic), "PerformAction ExtName");
	    if (typeof(Anaction)==KassignExternalNamedType) {
		anamespec = Anaction.VassignExternalNamedType->pre_param.
				IDLclassCommon->inv_token;
	    }
	    else if (typeof(Anaction)==KassignInternalNamedType) {
		anamespec = Anaction.VassignInternalNamedType->pre_param.
				IDLclassCommon->inv_token;
	    }
	    else {
		anamespec = Anaction.VassignNamedType->pre_param.
				IDLclassCommon->inv_token;
	    }
	    if (FindNamedType(st, anamespec->lex_name, &typefound )==FOUND) {
		if (typeof(Anaction)==KassignExternalNamedType)
		    thetype.VAtomic->rep_externalType.VNamedType = typefound;
		else if (typeof(Anaction)==KassignInternalNamedType)
		    thetype.VAtomic->rep_internalType.VNamedType = typefound;
		else { /* assignNamedType */
		    thestatetran->pre_nextstate.VNamedType = typefound;
		}
	    }
	    else {
		Warning0(151, anamespec->lex_namepos);
	    }
	    break;
	case KassignPackage:
	    Assume((typeof(thetype)==KAtomic), "PerformAction package");
	    anamespec = Anaction.VassignPackage->pre_param.IDLclassCommon
				->inv_token;
	    thetype.VAtomic->rep_internalType.VPackage = NPackage;
	    thetype.VAtomic->rep_internalType.VPackage->rep_name =
			    anamespec->lex_name;
	    break;
	case KassignSize:
	    Assume((typeof(thetype)==KAtomic), "PerformAction size");
	    aintspec = Anaction.VassignSize->pre_param.IDLclassCommon
				->inv_token;
	    thetype.VAtomic->rep_size = atoi(aintspec->lex_externalform);
	    break;
	case KassignAlignment:
	    Assume((typeof(thetype)==KAtomic), "PerformAction alignment");
	    aintspec = Anaction.VassignAlignment->pre_param.IDLclassCommon
				->inv_token;
	    thetype.VAtomic->rep_alignment = atoi(aintspec->lex_externalform);
	    break;
	case KassignEnum:
	    Assume((typeof(thetype)==KClass), "Perform Action enum");
	    thetype.VClass->rep_enumerated = TRUE;
	    break;
	case KassignsetseqPackage:
	    Assume((IsSetOrSeqType(thetype)), "Perform Action setseq package");
	    anameval = Anaction.VassignsetseqPackage->pre_param.IDLclassCommon
				->inv_token;
	    thetype.VSetOrSeq.IDLclassCommon->rep_package = anameval->lex_name;
	    break;
	case Kassignsetseqnumelems:
	    Assume((IsSetOrSeqType(thetype)), "Perform Action setseq numelems");
	    aintspec = Anaction.Vassignsetseqnumelems->pre_param.IDLclassCommon
				->inv_token;
	    thetype.VSetOrSeq.IDLclassCommon->rep_numelements.VintegerToken=
					aintspec;
	    break;

	default:
	    Assume((FALSE), "PerformAction2");
	    break;
    }
}



ReplaceAttributeTypes(st, oldtype, newtype)
StructureEntity st;
TypeEntity oldtype;
TypeEntity newtype;
{
    SETTypeEntity SType;
    TypeEntity AType;
    SEQAttribute SAtt;
    Attribute AnAtt;

    Assume((IsStructureEntity(st)&&IsTypeEntity(oldtype)&&
	    IsTypeEntity(newtype)), "ReplaceAttributeTypes");

    foreachinSETTypeEntity(st->sem_types, SType, AType) {
	if (typeof(AType) == KClass) {
	    foreachinSEQAttribute(AType.VClass->sem_allattributes, SAtt, AnAtt){
		if (SameType(AnAtt->rep_descriptor->rep_type, oldtype)) {
		    AnAtt->rep_descriptor->rep_type.VTypeEntity = newtype;
		}
	    }
	}
    }
}
