/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/newname.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

#define PREFIX "T"

CheckNameConflicts(compUnit) 
compilationUnit compUnit;
{
	SEQProcessEntity SPr;
	ProcessEntity APr;
	SETPort SPort;
	Port APort;
	StructureEntity invst;
	TargetEntity target;

	Assume((IscompilationUnit(compUnit)), "CheckNameConflicts");

	foreachinSEQProcessEntity(compUnit->sem_processes, SPr, APr) {
	    if (typeof(APr->sem_target) != KVoid) {
		target = APr->sem_target.VTargetEntity;
		invst = APr->sem_invariant;
		CheckTypeNameConflicts(target, invst);
		AssignRepNames(invst); /* must be called after CheckTypeName*/
		CheckPortNames(APr, target);
		foreachinSETPort(APr->sem_ports, SPort, APort) {
		    AssignRepNames(GetStructureEntity(APort->syn_data));
		}
	    }
	}
}

CheckPortNames(Aprocess, target)
ProcessEntity Aprocess;
TargetEntity target;
{

	SETPort SPort;
	Port APort;
	StructureEntity Invstructure;
	NamedType typefound;
	char *newname;
	char *newname2;
	String newname3;
	String pname;
	int namelen;
	String GetInternalName();
	extern Boolean IsKeyword();


	Invstructure=Aprocess->sem_invariant;

	/* check that port names are unique from target keywords.
	 * If not, add prefix
	 */
	foreachinSETPort(Aprocess->sem_ports, SPort, APort) {
	    pname = APort->lex_name;
	    if (IsKeyword(target, pname)) {
		newname3 = GetInternalName(Invstructure, pname);
		Recoverable2(368, APort->lex_namepos, APort->lex_name, newname3);
		APort->rep_name = NewString(newname3);
	    }
	    else APort->rep_name = pname;
	}
	

	/* check that port names are unique from nonterminal names 
	 * if not, change until they are unique			   
	 */

	foreachinSETPort(Aprocess->sem_ports, SPort, APort) {
	    pname = APort->rep_name;
	    if (FindNamedType(Invstructure,pname, &typefound)==FOUND){

		namelen = strlen(pname)+strlen(PREFIX)+1;
		newname = (char *)GetHeap(namelen);
		(void)sprintf(newname, "%s%s", PREFIX, pname);
		while (FindNamedType(Invstructure, newname, &typefound)==FOUND){
		    namelen += strlen(PREFIX);
		    newname2 = (char *)GetHeap(namelen);
		    (void)sprintf(newname2, "%s%s", PREFIX, newname);
		    FreeHeap(newname);
		    newname = newname2;
		}
		APort->rep_name = NewString(newname);
		Recoverable1(450, APort->lex_namepos, newname);
	    }
	}
}

/***********************************************************************
 *
 * Procedure AssignRepNames
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
AssignRepNames(st)
StructureEntity st;
{
	SETTypeEntity SType;
	TypeEntity AType;
	SEQAttribute SAttribute;
	Attribute AnAttribute;
	String typename;
	String compname;
	char *buf;
        extern Boolean IsPreludeType();


	Assume((IsStructureEntity(st)), "AssignRepNames");


	/* add rep names to types and attributes */

	foreachinSETTypeEntity(st->sem_types, SType, AType) {

	    if (((typeof(AType) != KClass) && (typeof(AType) != KAtomic))||
		(IsPreludeType(AType)))
		continue;
	    typename = AType.VNamedType.IDLclassCommon->rep_name;
	    if (typename == NULL || strlen(typename) == 0)
		typename = AType.VNamedType.IDLclassCommon->sem_name;

	    AType.VNamedType.IDLclassCommon->rep_name = typename;

	    if (typeof(AType)==KClass) {
		foreachinSEQAttribute( AType.VClass->sem_allattributes, 
					SAttribute, AnAttribute) {
		    AnAttribute->rep_name = AnAttribute->lex_name;
		}
	    }
	}

	/* determine names for sets and seqs */
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if ((typeof(AType)==KSetOf)||(typeof(AType)==KSeqOf)) {
		if (IsPreludeType(AType))  /* name already defined */
		    continue;

		compname = AType.VSetOrSeq.IDLclassCommon->sem_component.
				IDLclassCommon->rep_name;
		buf = (char *)GetHeap(strlen(compname)+4);
		if (typeof(AType) == KSetOf)
		    (void)sprintf(buf, "SET%s", compname);
		else (void)sprintf(buf, "SEQ%s", compname);
		AType.VSetOrSeq.IDLclassCommon->rep_name = NewString(buf);
	    }
	}
}

/***********************************************************************
 *
 * Procedure CheckTypeNameConflicts
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
CheckTypeNameConflicts(targetLang, st)
TargetEntity targetLang;
StructureEntity st;
{
	SETTypeEntity SType;
	TypeEntity AType;
	SEQAttribute SAttribute;
	Attribute AnAttribute;
	String typename;
	String newname;
	String name;
	String GetInternalName();
	extern Boolean IsKeyword();
        extern Boolean IsPreludeType();


	Assume((IsTargetEntity(targetLang)&&IsStructureEntity(st)), 
		"CheckNameConflicts");

	/* check if any class type has the same name as a keyword.
	   If so, add the default prefix.
	   Also check attribute names and add prefix */


	foreachinSETTypeEntity(st->sem_types, SType, AType) {

	    if (((typeof(AType) != KClass) && (typeof(AType) != KAtomic))||
		(IsPreludeType(AType)))
		continue;
	    typename = AType.VNamedType.IDLclassCommon->rep_name;
	    if (typename == NULL || strlen(typename)==0)
		typename = AType.VNamedType.IDLclassCommon->sem_name;

	    if (IsKeyword(targetLang, typename)){
		newname = GetInternalName(st, typename);
		Recoverable2(368, st->lex_endpos, typename, newname);
		AType.VNamedType.IDLclassCommon->rep_name = NewString(newname);
	    }
	    else AType.VNamedType.IDLclassCommon->rep_name = typename;

	    if (typeof(AType)==KClass) {
		foreachinSEQAttribute( AType.VClass->sem_allattributes, 
					SAttribute, AnAttribute) {
		    name = AnAttribute->rep_name;
		    if (IsKeyword(targetLang, name)) {
			newname = GetInternalName(st, name);
			Warning2(368, st->lex_endpos, name,newname);
			AnAttribute->rep_name = NewString(newname);
		    }
		}
	    }
	}

	/* check if any generated macros will conflict with type names */
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if (((typeof(AType) != KClass) && (typeof(AType) != KAtomic))||
		(IsPreludeType(AType)))
		continue;
	    CheckGeneratedMacro(st, 'N', AType.VNamedType);
	    CheckGeneratedMacro(st, 'F', AType.VNamedType);
	    CheckGeneratedMacro(st, 'C', AType.VNamedType);
	    CheckGeneratedMacro(st, 'L', AType.VNamedType);
	    CheckGeneratedMacro(st, 'I', AType.VNamedType);
	}
}

String GetInternalName(st, oldname)
StructureEntity st;
String oldname;
{
	SETTypeEntity SType;
	TypeEntity AType;
	Boolean conflict=TRUE;
	char *buf;
	char *strptr;

	Assume((IsStructureEntity(st)&&IsString(oldname)),
		"GetInternalName");

	strptr = StringToChar(oldname);
	while (conflict) {
	    buf = (char *)GetHeap(strlen(strptr)+strlen(PREFIX)+1);
	    (void)sprintf(buf, "%s%s", PREFIX, strptr);
	    conflict = FALSE;
	    foreachinSETTypeEntity(st->sem_types, SType, AType) {
		if (!strcmp(buf, AType.IDLclassCommon->sem_name)) {
		    conflict = TRUE;
		    strptr = buf;
		    break;
		}
	    }
	}
	return(NewString(buf));
}


CheckGeneratedMacro(st, macroprefix, ntype)
StructureEntity st;
char macroprefix;
NamedType ntype;
{
	char buf[200];
	NamedType nt;
	String typename;
	String newname;
	String GetInternalName();

	Assume((IsStructureEntity(st)&&IsNamedType(ntype)), 
		"CheckGeneratedMacro");

	typename = ntype.IDLclassCommon->rep_name;
	(void)sprintf(buf, "%c%s", macroprefix, typename);
	if (FindNamedType(st, NewString(buf), &nt)==FOUND) {
	    newname = GetInternalName(st, typename);
	    Recoverable2(366, st->lex_endpos, typename, newname);
	    ntype.IDLclassCommon->rep_name = newname;
	}
}

