/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/misc.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: This file contains miscellaneous files for error 		*
*		handling, etc 						*
*									*
*           ErrHandler							*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: misc.c,v 1.1 89/07/05 16:34:17 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	misc.c,v $
 * Revision 1.1  89/07/05  16:34:17  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:59:45  cheung
 * misc.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  12:13:05  cheung
 * misc.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:50:46  cheung
 * misc.c  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:29:22  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:51:04  shannon
 * Initial revision
 * 
 * Revision 2.4  86/05/15  05:28:37  shannon
 * Version 2.4
 * 
 * Revision 2.3  86/05/05  15:17:36  shannon
 * Version 2.3 of IDL System
 * 
 * Revision 2.2  86/04/08  12:56:33  shannon
 * Version2.2
 * 
 * Revision 2.1  86/03/20  16:58:14  shannon
 * SEI Relase
 * 
 * Revision 2.0  86/01/22  07:33:15  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.1  85/06/11  10:18:21  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include <stdio.h>
#include "Rep.h"
#include "macros.h"
extern FILE *err_out;
extern char SeriousError;
#define TRUE 1


/***********************************************************************
 *
 * Procedure ErrHandler
 *
 * Purpose: Write an error message to err_out and handle error appropriately
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

ErrHandler(type, number, sourcepos, arg1, arg2)

int type;		/* type of error */
int number;		/* error number */
int sourcepos;		/* source position of error */
char *arg1,*arg2;	/* arguments */
{

        void exit();
        extern void ERRNewErrorInstance();
        extern void ERRAddStringArg();
        extern void ERRWriteErrorInstance();

	ERRNewErrorInstance(err_out, number, sourcepos);
	if (strcmp(arg1, "")) {
	    ERRAddStringArg(arg1);
	    if (strcmp(arg2, "")) 
		ERRAddStringArg(arg2);
	}
	ERRWriteErrorInstance();

	if (type == SERIOUS) {
	    SeriousError = TRUE;
	}
	else if (type == FATAL) {
	    (void) fflush(err_out);
	    exit(1);
	}
}
