/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/mark.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include <stdio.h>
#include "Rep.h"
#include "macros.h"

Marktypes(type)
TypeEntity type;
{
    SEQAttribute SAtt;
    Attribute Att;
    SETClass SClass;
    Class AClass;

    if (type.IDLclassCommon->sem_isUnreachable == FALSE)  {
	return;
    }

    type.IDLclassCommon->sem_isUnreachable = FALSE;
    switch (typeof(type)) {
	case KAtomic:
	    if (IsTypeEntity(type.VAtomic->rep_internalType)) {
		Marktypes(type.VAtomic->rep_internalType.VTypeEntity);
	    }
	    if (IsTypeEntity(type.VAtomic->rep_externalType)) {
		Marktypes(type.VAtomic->rep_externalType.VTypeEntity);
	    }
	    break;
	case KClass:
	    foreachinSEQAttribute(type.VClass->sem_allattributes, SAtt, Att) {
		Marktypes(Att->rep_descriptor->rep_type);
	    }
	    foreachinSETClass(type.VClass->sem_subclasses, SClass, AClass) {
		Marktypes(ClassToTypeEntity(AClass));
	    }
	    foreachinSETClass(type.VClass->sem_ancestors, SClass, AClass) {
		Marktypes(ClassToTypeEntity(AClass));
	    }
	    break;
	case KSeqOf:
	case KSetOf:
	    Marktypes(type.VSetOrSeq.IDLclassCommon->sem_component);
	    break;
    }
}
