/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/main.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: The representation phase of the idl translator		*
*									*
*           main                    					*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: main.c,v 1.1 89/07/05 16:34:13 kps Locked $";
#endif 

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	main.c,v $
 * Revision 1.1  89/07/05  16:34:13  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:59:35  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  12:12:54  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:50:36  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:29:19  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:51:02  shannon
 * Initial revision
 * 
 * Revision 2.4  86/05/15  05:27:45  shannon
 * Version 2.4
 * 
 * Revision 2.3  86/05/05  15:16:42  shannon
 * Version 2.3 of IDL System
 * 
 * Revision 2.2  86/04/08  12:52:38  shannon
 * Version2.2
 * 
 * Revision 2.1  86/03/20  16:57:02  shannon
 * SEI Relase
 * 
 * Revision 2.0  86/01/22  07:27:00  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.8  85/08/27  20:27:13  shannon
 * moved init statement outside loop for keyword list
 * 
 * Revision 1.7  85/07/31  09:51:44  shannon
 * changed code for different representation of null class
 * 
 * Revision 1.6  85/07/23  21:08:39  shannon
 * changed null class restrictions in CheckForNull
 * 
 * 
 * Revision 1.5  85/07/18  19:52:11  shannon
 * added special representation processing
 * 
 * Revision 1.4  85/07/05  20:48:44  shannon
 * added unmarker port processing
 * 
 * Revision 1.3  85/07/03  19:47:43  shannon
 * added check for different target languages other than C
 * 
 * Revision 1.2  85/06/25  18:36:36  shannon
 * moved generateincludefile routine from this file to gencfile.c
 * 
 * Revision 1.1  85/06/11  10:05:13  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (rts) Created.						*
*									*
\* ******************************************************************* */

# include <stdio.h>
# include <sys/types.h>
# include <sys/stat.h>

# include "Rep.h"
#include "macros.h"

# define MAXFILENAMELENGTH 81


FILE *err_out;			/* error file */
Boolean warningsoff = FALSE;	/* indicator if warnings are turned off */
extern Boolean ReaderOK;	/* set by reader */
Boolean SeriousError=FALSE;	/* indicator of serious errors */
TypeEntity IDLTypeEntity;
TypeRef IDLTypeRef;


/* added to remove the problem of casting longs to ints
   which is objected by lint 
*/
typedef union {
  long along;
  int  aint;
} LongtoInt;

/***********************************************************************
 *
 * Procedure main
 *
 * Purpose: main driver for the representation phase
 *
 * Algorithm: set size fields for all Classes
 *            call the graph coloring algorithm to position attributes
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

int main(argc, argv)
int argc; 
char *argv[];
{
	
    FILE *candle_out;		/* the CANDLE file */
    compilationUnit compUnit;	/* the compilation unit */
    Boolean verbosemode=FALSE;	/* indicator of verbose mode */
    Boolean writeCandle=FALSE;	/* indicator if Candle structure should
				   be written */
    Boolean check_only=FALSE;	/* indicator if this is only checking 
				   i.e. no output to code generator */
    int i;			/* index */
    struct stat sbuf;		/* for call to fstat */
    void exit();
    LongtoInt LtoI;

    err_out = stderr;

    Assume((TRUE), "main");

    for (i=1; i<argc; i++) {
	if (!strcmp(argv[i],"-v")) {
	    verbosemode = TRUE;
	}
	else if (!strcmp(argv[i], "-e")) {
	    if (i+1 >= argc)
		Fatal0(16, 0);
	    else {
		++i;
		if ((err_out = fopen(argv[i], "w")) == NULL){
		    Fatal1(17, 0, argv[i]);
		}
	    }
	}
	else if (!strcmp(argv[i], "-s")) {
	    if (i+1 >= argc)
		Fatal0(10, 0);
	    else {
		++i;
		if ((candle_out = fopen(argv[i], "w")) == NULL){
		    Fatal1(11, 0, argv[i]);
		}
		else writeCandle = TRUE;
	    }
	}
	else if (!strcmp(argv[i], "-c")) {
	    check_only = TRUE;
	}
	else Warning0(13, 0);
    }
    Assume((TRUE), "main after args processed");


    /* read in CandleSemantic */

    compUnit = INCandleSem(stdin);
    if (!ReaderOK) {
	exit(1);
    }

    Assume((IscompilationUnit(compUnit)), "main after input");

    phase_independent(compUnit, verbosemode);

    phase_dependent(compUnit, verbosemode);

    /* output the Candle structure */
    if (!SeriousError && writeCandle) {
	if (verbosemode) {
	    (void) fprintf(stderr, "idlc:    writing Candle\n");
	    (void) fflush(stderr);
	}
	(void) fstat(fileno(candle_out), &sbuf);
	LtoI.along = sbuf.st_atime;
	compUnit->rep_comptimestamp = LtoI.aint;
	OutCandle(candle_out, compUnit, TWOPASS);
    }
    if (!SeriousError && !check_only) {
	OutUNCCandleCg(stdout, compUnit, TWOPASS);
    }
    return 0;
}
