/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/macros.h 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Macros for commonly used defines 				*
*									*
*									*
\* ******************************************************************* */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	macros.h,v $
 * Revision 1.1  89/07/05  16:34:11  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:59:26  cheung
 * macros.h  Ver 4.0
 * 
 * Revision 3.9  89/03/30  12:12:46  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:50:28  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:29:17  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:51:37  shannon
 * Initial revision
 * 
 * Revision 1.2  86/01/22  07:10:28  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.1  85/06/11  10:20:14  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

/* function declarations 
char *sprintf(); */

#define NOTFOUND 	0
#define FOUND 		1
#define NOTEQUAL 	0
#define EQUAL 		1


/* default names */

#define IDLDEFAULTINVARIANTNAME "IDLDefaultInvar"
#define IDLCOPIEDINVNAME "IDLCopiedInvariant"
#define DEFAULT_LANG	"C"
#define DEFAULTROOTNAME "defaultrootname"


/* macros for debugging --eventually will be conditionally compiled out */
#ifdef DEBUG1
char Assumebuf[100];
#define Assume(cond, procname)	\
	{if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", procname);\
		       exit(1); } \
	 else (void) fprintf(stderr, "DEBUG: %s\n", procname); }
#define Assume1(cond, string, arg)	\
	 {(void)sprintf(Assumebuf, string, arg); \
	 if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", Assumebuf);\
		       exit(1); } \
	 else (void) fprintf(stderr, "DEBUG: %s\n", Assumebuf); }
#else 
#ifdef DEBUG2
char Assumebuf[100];
#define Assume(cond, procname)	\
	{if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", procname);\
		       exit(1); } }
#define Assume1(cond, string, arg)	\
	 {(void)sprintf(Assumebuf, string, arg); \
	 if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", Assumebuf);\
		       exit(1); } }
#else
#define Assume(cond, procname)
#define Assume1(cond, string, arg)
#endif
#endif
/* macro for setting an entity to error */
#define SetErrorEntity(ref)	ref->sem_entity.Verror = Nerror;
#define SetRepErrorEntity(ref)	ref->rep_entity.Verror = Nerror;

/* macro for testing if an entity is error */
#define EntityIsError(ref)	(typeof(ref->sem_entity) == Kerror)
#define RepEntityIsError(ref)	(typeof(ref->rep_entity) == Kerror)


/* macros for returning the type of an entity */
#define TypeOfEntity(ref)	typeof(ref->sem_entity)

/* macros for setting entities of references to th correct types */
#define SetAssertEntity(ref, as)	ref->sem_entity.VAssertion = as
#define SetAtomicEntity(ref, at)	ref->sem_entity.VAtomic = at
#define SetAtomicRepEntity(ref, at)	ref->rep_entity.VAtomicRep = at
#define SetAttOpEntity(ref, op)		ref->rep_entity.VAttributeOperation = op
#define SetAttributeEntity(ref, att)	ref->sem_entity.VAttribute = att
#define SetClassEntity(ref, cl)		ref->sem_entity.VClass = cl
#define SetClassOpEntity(ref, op)	ref->rep_entity.VClassOperation = op
#define SetDefineEntity(ref, def)	ref->sem_entity.VDefinition = def
#define SetNamedTypeEntity(ref, nt)	ref->sem_entity.VNamedType = nt
#define SetOpEntity(ref, op)		ref->rep_entity.VOperation = op
#define SetPortEntity(ref, aport)	ref->sem_entity.VPort = aport
#define SetProcessEntity(ref, pr)	ref->sem_entity.VProcessEntity = pr
#define SetRepTypeEntity(ref, arep)	ref->rep_entity.VTypeEntity = arep
#define SetSetEntity(ref, aset)		ref->sem_entity.VSetOf = aset
#define SetSeqEntity(ref, aseq)		ref->sem_entity.VSeqOf = aseq
#define SetStructureEntity(ref, st)	ref->sem_entity.VStructureEntity = st
#define SetTypeEntity(ref, t)	ref.IDLclassCommon->sem_entity.VTypeEntity = t
#define SetTypeRepEntity(ref, t)	ref->rep_entity.VTypeRep = t

/* macros for getting entities of references */
#define GetAssertEntity(ref) ref->sem_entity.VAssertion
#define GetAtomicEntity(ref) ref->sem_entity.VAtomic
#define GetAttOpEntity(ref) ref->rep_entity.VAttOp
#define GetAttributeEntity(ref) ref->sem_entity.VAttribute
#define GetClassEntity(ref) ref->sem_entity.VClass
#define GetClassOpEntity(ref) ref->rep_entity.VClassOp
#define GetDefineEntity(ref) ref->sem_entity.VDefinition
#define GetNamedTypeEntity(ref) ref->sem_entity.VNamedType
#define GetOpEntity(ref)  ref->rep_entity.VOperation
#define GetPortEntity(ref) ref->sem_entity.VPort
#define GetProcessEntity(ref) ref->sem_entity.VProcessEntity
#define GetRepTypeEntity(ref) ref->rep_entity.VTypeEntity
#define GetSeqEntity(ref) ref->sem_entity.VSeqOf
#define GetSetEntity(ref) ref->sem_entity.VSetOf
#define GetStructureEntity(ref) ref->sem_entity.VStructureEntity
#define GetTypeEntity(ref) ref.IDLclassCommon->sem_entity.VTypeEntity

/* macro for getting a type name */
#define GetTypeName(t)	t.IDLclassCommon->sem_name

/* macro for testing the equivalence of types */
#define SameType(t1, t2) (t1.IDLinternal == t2.IDLinternal)

/* macro for testing equality of 2 strings */
#define strequal(s1,s2) (s1 == s2)

/* macros to get position of type */
#define GetTypePos(t)  (typeof(t)==KNamedTypeRef) ? \
			t.VNamedTypeRef->lex_namepos : \
			t.VSetOrSeqRef.IDLclassCommon->lex_keywordpos

/* macros for testing for correct node type */
#define ntypeof(n)	(n->IDLhidden.TypeID)
#define IsAssertion(n) (ntypeof(n)==KAssertion)
#define IsAtomic(n)	(ntypeof(n)==KAtomic)
#define IsAtomicRep(n) (ntypeof(n)==KAtomicRep)
#define IsAttOrAll(n)  ((typeof(n)==KAttributeRef)||(typeof(n)==KAllAttributes))
#define IsAttribute(n) (ntypeof(n)==KAttribute)
#define IsattributeProduction(n) (ntypeof(n)==KattributeProduction)
#define IsattributeRestriction(n) (ntypeof(n)==KattributeRestriction)
#define IsBoolean(n) ((n==TRUE)||(n==FALSE))
#define IsClass(n) (ntypeof(n)==KClass)
#define IsClassOrAll(n) ((typeof(n)==KNamedTypeRef)||(typeof(n)==KAllClasses))
#define IsClassRep(n) (ntypeof(n)==KClassRep)
#define IscompilationUnit(n) (ntypeof(n)==KcompilationUnit)
#define IsContext(n) (ntypeof(n)==KContext)
#define IsDefInstance(n) ((typeof(n)==Kcyclic)||(typeof(n)==Knoncyclic)||\
		(typeof(n)==KPrivateDefInstance))
#define IsExpRef(n) ((typeof(n)==KExpSetRef)||(typeof(n)==KExpSeqRef)||\
			 (typeof(n)==KExpNameRef))
#define Isexpression(n) ((typeof(n)==Kconditional)||(typeof(n)==Kforall)||\
			 (typeof(n)==Kexists)||(typeof(n)==Kbinary)||\
			 (typeof(n)==Kunary)||(typeof(n)==Kapplication)||\
			 (typeof(n)==Kdotted)||(typeof(n)==KportExpression)||\
			 IsExpRef(n)||Isliteral(n))
#define IsInputPort(n)  (typeof(n->sem_portType)==KPrePort)
#define Isliteral(n) ((typeof(n)==KintegerToken)||(typeof(n)==KstringToken)||\
		      (typeof(n)==KrationalToken)||(typeof(n)==Kroot)||\
		      (typeof(n)==Kempty)||(typeof(n)==Ktrue)||\
		      (typeof(n)==Kfalse))
#define IsNamedType(n)	((typeof(n)==KClass) || (typeof(n)==KAtomic))
#define IsNamedTypeRef(n) (ntypeof(n)==KNamedTypeRef)
#define IsOutputPort(n) (typeof(n->sem_portType)==KPostPort)
#define IsportDefinition(n) (ntypeof(n)==KportDefinition)
#define IsProcessEntity(n) (ntypeof(n)==KProcessEntity)
#define Isproduction(n) \
	((typeof(n)==KattributeProduction)||(typeof(n)==KsubclassProduction))
#define IsRepRef(n) (ntypeof(n)==KRepRef)
#define Isrestriction(n) \
	((typeof(n)==KtypeRestriction)||(typeof(n)==KattributeRestriction))
#define IsSetRef(n) (ntypeof(n)==KSetRef)
#define IsSeqRef(n) (ntypeof(n)==KSeqRef)
#define IsSetOrSeqRep(n) ((typeof(n)==KSetRep)||(typeof(n)==KSeqRep))
#define IsSeqRep(n) (ntypeof(n)==KSeqRep)
#define IsSetRep(n) (ntypeof(n)==KSetRep)
#define IsSetOrSeqType(n) (typeof(n)==KSetOf || typeof(n)==KSeqOf)
#define IsStateTransition(n) (ntypeof(n)==KStateTransition)
#define IsString(n) (n!=NULL)
#define IsStructureEntity(n) (ntypeof(n)==KStructureEntity)
#define IsStructureRef(n) (ntypeof(n)==KStructureRef)
#define IssubclassProduction(n) (ntypeof(n)==KsubclassProduction)
#define IsTargetEntity(n) (ntypeof(n)==KTargetEntity)
#define IsTargetOrVoid(n) ((typeof(n)==KTargetEntity)||(typeof(n)==KVoid))
#define IstargetStmt(n) (ntypeof(n)==KtargetStmt)
#define Istransition(n) (ntypeof(n)==Ktransition)
#define IsTypeEntity(n) ((typeof(n)==KAtomic)||(typeof(n)==KClass)||\
			 (typeof(n)==KSetOf)||(typeof(n)==KSeqOf))
#define IsTypeRep(n)	((typeof(n)==KClassRep)||(typeof(n)==KAtomicRep)||\
			 (typeof(n)==KSetRep)||(typeof(n)==KSeqRep))
#define IsTypeRef(n) ((typeof(n)==KNamedTypeRef)||(typeof(n)==KSetRef)||\
		(typeof(n)==KSeqRef))
#define IsTypeRefOrVoid(n) (IsTypeRef(n)||typeof(n)==KVoid)
#define IstypeRestriction(n) (ntypeof(n)==KtypeRestriction)
#define IswithoutAssert(n) (ntypeof(n)==KwithoutAssert)
#define IswithoutClause(n) (ntypeof(n)==KwithoutClause)
#define IswithoutDefine(n) (ntypeof(n)==KwithoutDefine)
#define IswithoutProduction(n) \
		((typeof(n)==KwithoutAttribute)||(typeof(n)==KwithoutSubclass))
#define IswithoutType(n) (ntypeof(n)==KwithoutType)


/* macros for error handling */
#define COMMENT		-1
#define EXTENSION	-2
#define WARNING 	-3
#define RECOVERABLE 	-4
#define SERIOUS		-5
#define FATAL		-6

#define Comment0(no, spos)		ErrHandler(COMMENT, no, spos, "", "")
#define Comment1(no, spos, a1)		ErrHandler(COMMENT, no, spos, a1, "")
#define Comment2(no, spos, a1, a2)	ErrHandler(COMMENT, no, spos, a1, a2)

#define Extension0(no, spos)		ErrHandler(EXTENSION, no, spos, "", "")
#define Extension1(no, spos, a1)	ErrHandler(EXTENSION, no, spos, a1, "")
#define Extension2(no, spos, a1, a2)	ErrHandler(EXTENSION, no, spos, a1, a2)

#define Warning0(no, spos)		ErrHandler(WARNING, no, spos, "", "")
#define Warning1(no, spos, a1)		ErrHandler(WARNING, no, spos, a1, "")
#define Warning2(no, spos, a1, a2)	ErrHandler(WARNING, no, spos, a1, a2)

#define Recoverable0(no, spos)		ErrHandler(RECOVERABLE, no, spos, "", "")
#define Recoverable1(no, spos, a1)	ErrHandler(RECOVERABLE, no, spos, a1, "")
#define Recoverable2(no, spos, a1, a2)	ErrHandler(RECOVERABLE, no, spos, a1, a2)

#define Serious0(no, spos)		ErrHandler(SERIOUS, no, spos, "", "")
#define Serious1(no, spos, a1)		ErrHandler(SERIOUS, no, spos, a1, "")
#define Serious2(no, spos, a1, a2)	ErrHandler(SERIOUS, no, spos, a1, a2)

#define Fatal0(no, spos)		ErrHandler(FATAL, no, spos, "", "")
#define Fatal1(no, spos, a1)		ErrHandler(FATAL, no, spos, a1, "")
#define Fatal2(no, spos, a1, a2)	ErrHandler(FATAL, no, spos, a1, a2)

/* macros for type conversion */

extern TypeEntity IDLTypeEntity;
#define ClassToTypeEntity(IDLA) (IDLTypeEntity.VClass=IDLA, IDLTypeEntity)
extern TypeRef IDLTypeRef;
#define SetRefToTypeRef(IDLA) (IDLTypeRef.VSetRef=IDLA, IDLTypeRef)
#define SeqRefToTypeRef(IDLA) (IDLTypeRef.VSeqRef=IDLA, IDLTypeRef)
#define NamedTypeRefToTypeRef(IDLA) (IDLTypeRef.VNamedTypeRef=IDLA, IDLTypeRef)
