/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/init.c 
*				 					* 
*   Copyright (C) 1991 Jerry Kickenson
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"

#define DEFAULTSETPACKAGE NewString("LinkedList")
#define DEFAULTSEQPACKAGE NewString("LinkedList")
#define emptystring NewString("\0")

/***********************************************************************
 *
 * Procedure IAtomic
 *
 * Purpose: Initialize the attributes of a Atomic
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
Atomic IAtomic(atom)
Atomic atom;
{
	atom->rep_internalType.VVoid = NVoid;
	atom->rep_externalType.VVoid = NVoid;
	atom->inv_replacementtype.VVoid = NVoid;
	return(atom);
}
/***********************************************************************
 *
 * Procedure IClass
 *
 * Purpose: Initialize the attributes of a Class
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
Class IClass(aclass)
Class aclass;
{
	aclass->sem_copiedfrom.VVoid = NVoid;
	return(aclass);
}

/***********************************************************************
 *
 * Procedure IPort
 *
 * Purpose: Initialize the attributes of a Port
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
Port IPort(aport)
Port aport;
{
	return(aport);
}
/***********************************************************************
 *
 * Procedure ISeqOf
 *
 * Purpose: Initialize the attributes of a SeqOf
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
SeqOf ISeqOf(seq)
SeqOf seq;
{
	seq->sem_copiedfrom.VVoid = NVoid;
	return(seq);
}
/***********************************************************************
 *
 * Procedure ISetOf
 *
 * Purpose: Initialize the attributes of a SetOf
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
SetOf ISetOf(set)
SetOf set;
{
	set->sem_copiedfrom.VVoid = NVoid;
	return(set);
}
RepRef IRepRef(arepref)
RepRef arepref;
{
	arepref->rep_entity.Verror = Nerror;
	return(arepref);
}

Attribute IAttribute(att)
Attribute att;
{
	att->rep_descriptor = Ndescriptor;
	att->rep_descriptor->rep_type.Vdescriptor = att->rep_descriptor;
	return(att);
}
