/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/find.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

/***********************************************************************
 *
 * Procedure FindType
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindType(st, AtypeRef)
StructureEntity st;
TypeRef AtypeRef;
{
	int found;

	Assume((IsStructureEntity(st)&&IsTypeRef(AtypeRef)),
		"FindType");


	switch (typeof(AtypeRef)) {
	    case KSetRef:
		found = FindSetType(st, AtypeRef.VSetRef, 
				(SetOf *) &(AtypeRef.VSetRef->sem_entity));
		break;

	    case KSeqRef:
		found = FindSeqType(st, AtypeRef.VSeqRef, 
				(SeqOf *) &(AtypeRef.VSeqRef->sem_entity));
		break;

	    case KNamedTypeRef:
		found = FindNamedType(st, AtypeRef.VNamedTypeRef->lex_name,
			&(AtypeRef.VNamedTypeRef->sem_entity));
		break;
	}
	return(found);
}
/***********************************************************************
 *
 * Procedure FindSetType
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindSetType(st, settyperef, settypefound)
StructureEntity st;
SetRef settyperef;
SetOf *settypefound;
{
    SETTypeEntity SType;	/* set traversal and value */
    TypeEntity AType;
    NamedTypeRef component;	/* component of setref */
    int found = FALSE;		/* indicator if set is found */
    NamedType comptype;		/* type of component */

    Assume((IsStructureEntity(st)&&IsSetRef(settyperef)),
	    "FindSetType");

    component = settyperef->syn_component;
    if (FindNamedType(st, component->lex_name, 
			&(comptype)) == FOUND){
	SetNamedTypeEntity(component, comptype);
	foreachinSETTypeEntity(st->sem_types, SType, AType){
	    if (typeof(AType) == KSetOf) {
		if (SameType(comptype,AType.VSetOf->sem_component)){
		    *settypefound = AType.VSetOf;
		    found = TRUE;
		    break;
		}
	    }
	}
    }
    else SetErrorEntity(component);
    return(found);
}

/***********************************************************************
 *
 * Procedure FindSeqType
 *
 * Purpose: 
 *
 * Algorithm: 
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
FindSeqType(st, seqtyperef, seqtypefound)
StructureEntity st;
SeqRef seqtyperef;
SeqOf *seqtypefound;
{
    SETTypeEntity SType;	/* seq traversal and value */
    TypeEntity AType;
    NamedTypeRef component;	/* component of seqref */
    NamedType comptype;		/* type of component */
    int found = FALSE;		/* indicator if seq is found */

    Assume((IsStructureEntity(st)&&IsSeqRef(seqtyperef)),
	    "FindSeqType");

    component = seqtyperef->syn_component;
    if (FindNamedType(st, component->lex_name, &(comptype)) == FOUND){
	SetNamedTypeEntity(component, comptype);
	foreachinSETTypeEntity(st->sem_types, SType, AType){
	    if (typeof(AType) == KSeqOf) {
		if (SameType(comptype, AType.VSeqOf->sem_component)){
		    *seqtypefound = AType.VSeqOf;
		    found = TRUE;
		    break;
		}
	    }
	}
    }
    else SetErrorEntity(component);
    return(found);
}
/***********************************************************************
 *
 * Procedure FindNamedType
 *
 * Purpose: Find the type given by 'tname' in structure 'st'
 *
 * Algorithm: Search through the types of 'st'. If the type
 *	      is found, assign to tfound and return FOUND, else return 
 *	      NOTFOUND.
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

FindNamedType(st, tname, tfound)
StructureEntity st;		/* structure */
String tname;			/* name of type */
NamedType *tfound;		/* the type found */
{

	SETTypeEntity SType;	/* traversal of types of structure */
	TypeEntity AType;	/* value of type in set */

	Assume((IsStructureEntity(st)&&IsString(tname)), 
		"FindNamedType");

	foreachinSETTypeEntity(st->sem_types, SType, AType)
	    if (IsNamedType(AType)) {
		if (strequal(AType.IDLclassCommon->sem_name, tname)){
		    *tfound = AType.VNamedType;
		    return(FOUND);
		}
	    }

	/* if this point is reached, type 'tname' is not found */
	return(NOTFOUND);
}


FindTypeEntity(st, thetype, typefound)
StructureEntity st;
TypeEntity thetype;
TypeEntity *typefound;
{
    SETTypeEntity SType;
    TypeEntity AType;
    NamedType component;
    int found = NOTFOUND;

    Assume((IsStructureEntity(st)&&IsTypeEntity(thetype)),
		"FindTypeEntity");

    foreachinSETTypeEntity(st->sem_types, SType, AType) {
	if (AType.IDLclassCommon->sem_name == thetype.IDLclassCommon->sem_name){
	    found = FOUND;
	    *typefound = AType;
	    break;
	}
    }
    if ((found == NOTFOUND)&&
	((typeof(thetype)==KSetOf)||(typeof(thetype)==KSeqOf))) {
	component = thetype.VSetOrSeq.IDLclassCommon->sem_component;
	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if (IsNamedType(AType) &&
		(AType.VNamedType.IDLclassCommon->sem_name ==
		 component.IDLclassCommon->sem_name)) {
		if (typeof(thetype)==KSetOf)
		    typefound->VSetOf = NSetOf;
		else typefound->VSeqOf = NSeqOf;
		typefound->VSetOrSeq.IDLclassCommon->sem_component = 
				AType.VNamedType;
		addSETTypeEntity(st->sem_types, *typefound);
		found = FOUND;
		break;
	    }
	}
    }
    return(found);
}
