/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/copy.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

SETClassOperation CopySETClassOperation(opset)
SETClassOperation opset;
{
	SETClassOperation newset;
	SETClassOperation Sop;
	ClassOperation op;

	Assume((TRUE), "CopySETClassOperation");
	initializeSETClassOperation(newset);
	foreachinSETClassOperation(opset, Sop, op)
	    addSETClassOperation(newset, op);
	return(newset);
}

SETAtomicOperation CopySETAtomicOperation(opset)
SETAtomicOperation opset;
{
	SETAtomicOperation newset;
	SETAtomicOperation Sop;
	AtomicOperation op;

	Assume((TRUE), "CopySETAtomicOperation");
	initializeSETAtomicOperation(newset);
	foreachinSETAtomicOperation(opset, Sop, op)
	    addSETAtomicOperation(newset, op);
	return(newset);
}

SETSetOperation CopySETSetOperation(opset)
SETSetOperation opset;
{
	SETSetOperation newset;
	SETSetOperation Sop;
	SetOperation op;

	Assume((TRUE), "CopySETSetOperation");
	initializeSETSetOperation(newset);
	foreachinSETSetOperation(opset, Sop, op)
	    addSETSetOperation(newset, op);
	return(newset);
}

SETSeqOperation CopySETSeqOperation(opset)
SETSeqOperation opset;
{
	SETSeqOperation newset;
	SETSeqOperation Sop;
	SeqOperation op;

	Assume((TRUE), "CopySETSeqOperation");
	initializeSETSeqOperation(newset);
	foreachinSETSeqOperation(opset, Sop, op)
	    addSETSeqOperation(newset, op);
	return(newset);
}


CopyTypeRepInfo(st, newtype, oldtype)
StructureEntity st;
TypeEntity newtype,
	   oldtype;
{
    InternalType oldinternal;
    ExternalType oldexternal;
    TypeEntity typefound;
    SETClassOperation CopySETClassOperation();
    SETAtomicOperation CopySETAtomicOperation();
    SETSetOperation CopySETSetOperation();
    SETSeqOperation CopySETSeqOperation();

    Assume((IsStructureEntity(st)&&IsTypeEntity(newtype)&&
	    IsTypeEntity(oldtype)&&
	    (typeof(oldtype)==typeof(newtype))),
	    "CopyTypeRepInfo");

    switch (typeof(newtype)) {
	case KClass:
	    newtype.VClass->rep_name = oldtype.VClass->rep_name;
	    newtype.VClass->rep_enumerated = oldtype.VClass->rep_enumerated;
	    newtype.VClass->rep_allowedOps = 
			CopySETClassOperation(oldtype.VClass->rep_allowedOps);
	    break;
	case KAtomic:
	    newtype.VAtomic->rep_name = oldtype.VAtomic->rep_name;
     	    newtype.VAtomic->rep_size = oldtype.VAtomic->rep_size;
	    newtype.VAtomic->rep_allowedOps =
			CopySETAtomicOperation(oldtype.VAtomic->rep_allowedOps);
	    oldinternal = oldtype.VAtomic->rep_internalType;
	    switch (typeof(oldinternal)) {
		case KAtomic:
		case KClass:
		case KSetOf:
		case KSeqOf:
		    if (FindTypeEntity(st, oldinternal.VTypeEntity, &typefound)
							== FOUND) {
			newtype.VAtomic->rep_internalType.VTypeEntity = 
					typefound;
		    }
		    else {
			/* print error */
			newtype.VAtomic->rep_internalType.VVoid = NVoid;
		    }
		    break;
		case KPackage:
		    newtype.VAtomic->rep_internalType.VPackage = NPackage;
		    newtype.VAtomic->rep_internalType.VPackage->rep_name = 
				oldinternal.VPackage->rep_name;
		    break;
		case KVoid:
		    newtype.VAtomic->rep_internalType.VVoid = NVoid;
		    break;
	    }
	    oldexternal = oldtype.VAtomic->rep_externalType;
	    switch (typeof(oldexternal)) {
		case KAtomic:
		case KClass:
		case KSetOf:
		case KSeqOf:
		    if (FindTypeEntity(st, oldexternal.VTypeEntity, &typefound)
							== FOUND) {
			newtype.VAtomic->rep_externalType.VTypeEntity = 
					typefound;
		    }
		    else {
			/* print error */
			newtype.VAtomic->rep_externalType.VVoid = NVoid;
		    }
		    break;
		case KPredefined:
		    newtype.VAtomic->rep_externalType.VPredefined = NPredefined;
		    break;
		case KVoid:
		    newtype.VAtomic->rep_externalType.VVoid = NVoid;
		    break;
	    };
	    break;
	case KSetOf:
	    newtype.VSetOf->rep_package = oldtype.VSetOf->rep_package;
	    newtype.VSetOf->rep_numelements = oldtype.VSetOf->rep_numelements;
	    newtype.VSetOf->rep_allowedOps = 
		CopySETSetOperation(oldtype.VSetOf->rep_allowedOps);
	    break;
	case KSeqOf:
	    newtype.VSeqOf->rep_package = oldtype.VSeqOf->rep_package;
	    newtype.VSeqOf->rep_numelements = oldtype.VSeqOf->rep_numelements;
	    newtype.VSeqOf->rep_allowedOps = 
		CopySETSeqOperation(oldtype.VSeqOf->rep_allowedOps);
	    break;
    }
}

CopyType(newtype, oldtype)
TypeEntity *newtype, 	/* no storage allocated */
	   oldtype;
{
	SetOrSeq nss, oss;

	switch (typeof(oldtype)) {
		case KAtomic:
		case KClass:
#ifdef DEBUG
			(void) fprintf(stderr, "rep: CopyType for prelude not implemented for Atomic and Class\n");
#endif
			*newtype = oldtype;
			break;
		case KSetOf:
		case KSeqOf:
			if (typeof(oldtype)==KSetOf) {
			    newtype->VSetOf = NSetOf;
			    newtype->VSetOf->rep_allowedOps =
				CopySETSetOperation(oldtype.VSetOf->rep_allowedOps);
			}
			else {
			    newtype->VSeqOf = NSeqOf;
			    newtype->VSeqOf->rep_allowedOps =
				CopySETSeqOperation(oldtype.VSeqOf->rep_allowedOps);
			}
			nss = newtype->VSetOrSeq;
			oss = oldtype.VSetOrSeq;
			nss.IDLclassCommon->sem_name = oss.IDLclassCommon->sem_name;
			nss.IDLclassCommon->sem_isUnreachable = oss.IDLclassCommon->sem_isUnreachable;
			nss.IDLclassCommon->sem_isPreludeType = oss.IDLclassCommon->sem_isPreludeType;
			nss.IDLclassCommon->rep_name = oss.IDLclassCommon->rep_name;
			nss.IDLclassCommon->sem_copiedfrom.VSetOrSeq = oss;
			nss.IDLclassCommon->rep_size = oss.IDLclassCommon->rep_size;
			nss.IDLclassCommon->rep_alignment = oss.IDLclassCommon->rep_alignment;
			nss.IDLclassCommon->inv_replacementtype.VVoid = NVoid;
			nss.IDLclassCommon->inv_restrictto = oss.IDLclassCommon->inv_restrictto;
			nss.IDLclassCommon->inv_restrictfrom = oss.IDLclassCommon->inv_restrictfrom;
			nss.IDLclassCommon->sem_component = oss.IDLclassCommon->sem_component;
			nss.IDLclassCommon->rep_package = oss.IDLclassCommon->rep_package;
			nss.IDLclassCommon->rep_numelements = oss.IDLclassCommon->rep_numelements;
			break;
	}
	
}
