/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/coloring.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

/* May 18, 1988: rts	Added calculation of alignment (assumes same
   			alignment as length) and greedy approach to packing
*/

#include "Rep.h"
#include "macros.h"
#include <stdio.h>

#define MAXNODESIZE 32000		/* in bits */
#define ATTRNOTPOSITIONED -1		/* offset must be positive */
#define GetAttSize(att) att->rep_descriptor->rep_type.VTypeEntity.IDLclassCommon->rep_size
#define SetAttSize(att, size) att->rep_descriptor->rep_type.VTypeEntity.IDLclassCommon->rep_size = size
#define GetAttOffset(att) att->rep_descriptor->rep_offset 
#define SetAttOffset(att, offset) att->rep_descriptor->rep_offset = offset


PositionAttributes(thestructure)
StructureEntity thestructure;
{
    SEQClass theclasses;	/* the nonhierarchical classes */
    SETTypeEntity SType;
    TypeEntity AType;
    SEQClass SClass;
    Class AClass;
    SEQAttribute SAttribute, 
		 SAttribute2,
		 SAttribute3,
		 AttributeGraph;
    Attribute AnAttribute,
	      AnAttribute2,
	      AnAttribute3;
    space Aspace, Aspace2;
    SEQspace thisspace, newspace, Sspace;
    Boolean HasMoreConnections();
    Boolean HasLowerPosition();
    Boolean HasSmallerSize();
    int stop, offset, align;

    Assume((IsStructureEntity(thestructure)), "PositionAttributes");

    /* initialize */
    initializeSEQAttribute(AttributeGraph);
    initializeSEQClass(theclasses);
    foreachinSETTypeEntity(thestructure->sem_types, SType, AType) {
	if (typeof(AType)==KClass)
	    appendfrontSEQClass(theclasses, AType.VClass);
    }


    /* relationships among attributes are represented as a graph by
     * connecting each pair of attributes that occur in the same kind
     * of node
     */

    foreachinSEQClass(theclasses, SClass, AClass) {
      if emptySETClass(AClass->sem_subclasses) {
	foreachinSEQAttribute(AClass->sem_allattributes,SAttribute,AnAttribute){
	  AddGraphAttribute(&AttributeGraph, AnAttribute);
	}
	foreachinSEQAttribute(AClass->sem_allattributes, 
			      SAttribute, AnAttribute){
	  foreachinSEQAttribute(AClass->sem_allattributes, 
				SAttribute2, AnAttribute2)
	    if (AnAttribute != AnAttribute2) {
	      if (!inSEQAttribute(AnAttribute->inv_connections, 
				  AnAttribute2)) {
		appendrearSEQAttribute(AnAttribute->inv_connections,
				       AnAttribute2);
	      }
	    }
	}
      }
    }

    /* the graph is sorted so that the attribute with the most connections is at
     * the front
     */
    AttributeGraph = sortSEQAttribute(AttributeGraph, HasMoreConnections);

    /* Attributes are repeatedly popped off the graph and assigned
     * the lowest offset where there is a free space, consistent with the
     * attributes in their list of conflicts that have already been positioned,
     * and consistent with the attribute's alignment */

    foreachinSEQAttribute(AttributeGraph, SAttribute, AnAttribute) {
	SetAttOffset(AnAttribute, ATTRNOTPOSITIONED);
	if (GetAttSize(AnAttribute) == 0)	/* assume a pointer ?????*/
	  SetAttSize(AnAttribute, 32);
    }
    foreachinSEQAttribute(AttributeGraph, SAttribute, AnAttribute) {

      /* compute empty spaces, from positioned attributes that conflict */
      initializeSEQspace(thisspace);
      Aspace = Nspace;
      Aspace->inv_start = 32; /* initialized to node header size */
      Aspace->inv_stop = MAXNODESIZE - 32 - 1;
      appendfrontSEQspace(thisspace, Aspace);

      foreachinSEQAttribute(AnAttribute->inv_connections, 
			    SAttribute3, AnAttribute3){
	if (GetAttOffset(AnAttribute3) != ATTRNOTPOSITIONED) {
	  initializeSEQspace(newspace);
	  stop = GetAttOffset(AnAttribute3) + GetAttSize(AnAttribute3) - 1;
	  foreachinSEQspace(thisspace, Sspace, Aspace) {
	    if ((Aspace->inv_start > GetAttOffset(AnAttribute3))
		|| (Aspace->inv_stop < stop))
	      /* attribute not in this space */
	      appendfrontSEQspace(newspace, Aspace); /* don't change space */
	    else if (Aspace->inv_start == GetAttOffset(AnAttribute3)) {
	      /* attribute starts at beginning of free space */
	      Aspace->inv_start += GetAttSize(AnAttribute3);
	      if (Aspace->inv_start <= Aspace->inv_stop)
		appendrearSEQspace(newspace, Aspace); /* if it is non-empty */
	    }
	    else if (Aspace->inv_stop == stop) {
	      /* attribute occurs at the end of the space */
	      Aspace->inv_stop = GetAttOffset(AnAttribute3) - 1;
	      appendrearSEQspace(newspace, Aspace);
	    }
	    else if (Aspace->inv_stop > stop) {
	      /* attribute occurs in the middle of the space */
	      Aspace2 = Nspace;	/* second space */
	      Aspace2->inv_start = stop + 1;
	      Aspace2->inv_stop = Aspace->inv_stop;
	      Aspace->inv_stop = GetAttOffset(AnAttribute3) - 1; /* first space */
	      appendrearSEQspace(newspace, Aspace);
	      appendrearSEQspace(newspace, Aspace2);
	    }
	  }
	  thisspace = newspace;
	}
      }

      /* Sort for bestfit search */
      thisspace = sortSEQspace(thisspace, HasSmallerSize);
      
      /* find first space where attribute fits */
      align = GetAttSize(AnAttribute); /* assume that alignment is same as size */
      foreachinSEQspace(thisspace, Sspace, Aspace) {
	offset = Aspace->inv_start;
	if (offset % align != 0) /* if not already aligned... */
	  offset += (align - (offset % align)); /* ensure that offset is aligned */
	if (Aspace->inv_stop >= offset + GetAttSize(AnAttribute) - 1) {
	  /* attribute fits */
	  SetAttOffset(AnAttribute, offset);
	  break;
	}
      }
    }

    /* the attributes in each class are sorted by offset */
    foreachinSEQClass(theclasses, SClass, AClass) {
      AClass->sem_allattributes = 
	sortSEQAttribute(AClass->sem_allattributes, 
				  HasLowerPosition);
    }
}

Boolean HasMoreConnections(att1, att2)
Attribute att1, att2;
{
    int c1, c2;			/* count of connections */

/*    Assume((IsAttribute(att1)&&IsAttribute(att2)), "HasMoreConnections"); */

    c1 = lengthSEQAttribute(att1->inv_connections);
    c2 = lengthSEQAttribute(att2->inv_connections);

    if (c2 > c1)
	return (TRUE);
    else if (c1 > c2)
	return (FALSE);
    else { /* equal so if att2 has equal or larger size return FALSE */
	if (GetAttSize(att2) >= GetAttSize(att1))
	    return(FALSE);
	else return(TRUE);
    }
}


Boolean HasLowerPosition(att1, att2)
Attribute att1, att2;
{
    register int pos1, pos2;

/*    Assume((IsAttribute(att1)&&IsAttribute(att2)), "HasLowerPosition");
*/

    pos1 = GetAttOffset(att1);
    pos2 = GetAttOffset(att2);
    
    if (pos2 < pos1)
	return(TRUE);
    else return(FALSE);
}

Boolean HasSmallerSize(space1, space2)
space space1, space2;
{
    register int size1, size2;

    size1 = space1->inv_stop - space1->inv_start;
    size2 = space2->inv_stop - space2->inv_start;
    
    if (size2 < size1)
	return(TRUE);
    else return(FALSE);
}

/* adds attribute to graph if not already there */
AddGraphAttribute(AttributeGraph, AnAttribute)
SEQAttribute *AttributeGraph;
Attribute AnAttribute;
{
    Assume((IsAttribute(AnAttribute)), "AddGraphAttribute");

    if (!inSEQAttribute(*AttributeGraph, AnAttribute))
	appendfrontSEQAttribute(*AttributeGraph, AnAttribute);
}


/* for debugging */
PrintAttributeGraph(attseq)
SEQAttribute attseq;
{
    SEQAttribute SAtt;
    Attribute AnAtt;
    SEQAttribute SAtt2;
    Attribute AnAtt2;

    foreachinSEQAttribute(attseq, SAtt, AnAtt) {
	(void) fprintf(stderr, "%s: ", AnAtt->lex_name);
	foreachinSEQAttribute(AnAtt->inv_connections, SAtt2, 
			AnAtt2)
	    (void) fprintf(stderr, "%s ", AnAtt2->lex_name);
	(void) fprintf(stderr, "\n");
    }
}
