/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/rep/check_privates.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*     Jan 9 1985 (shannon) Created.					* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Rep.h"
#include "macros.h"

CheckPrivates(pr, invst)
ProcessEntity pr;
StructureEntity invst;
{
	SETTypeEntity 	SType;
	TypeEntity 	AType;
	SETPort 	SPort;
	Port 		APort;
	Atomic 		atom;
	TargetEntity 	target;
	StructureEntity st;
	SETTypeEntity	ext_types;
	Boolean IsInPort();
	Boolean IsPreludeType();
	Boolean IsPreludeTypeRep();

	Assume((IsProcessEntity(pr)&&IsStructureEntity(invst)),
		"CheckPrivates");

	if (typeof(pr->sem_target) != KTargetEntity)
	    return;

	initializeSETTypeEntity(ext_types);
	target = pr->sem_target.VTargetEntity;

	/* for port structures, replace private external, internal by
	 * type in target if any
	 * check that all port structures atomics have an external type 
	 */
	 foreachinSETPort(pr->sem_ports, SPort, APort) {
	     st = GetStructureEntity(APort->syn_data);
	     foreachinSETTypeEntity(st->sem_types, SType, AType) {
		 if (typeof(AType)==KAtomic) {
		    atom = AType.VAtomic;
		    ReplaceExtIntTypes(target, atom);

		    check_external(atom, st->lex_endpos);
		    if (IsTypeEntity(atom->rep_externalType)) {
			addSETTypeEntity(ext_types,
					atom->rep_externalType.VTypeEntity);
		    }
		 }
	     }
	 }

	/* replace any private type external or internal
	 * representations by the corresponding type in
	 * the target if any.
	 * check that private types have correct information
	 * calculated --for invariant just internal and size -not external
	 */
	 foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	     if (typeof(AType)==KAtomic) {
		atom = AType.VAtomic;
		ReplaceExtIntTypes(target, atom);

		check_internal(atom, pr->lex_endpos);
		check_size(atom, pr->lex_endpos);
	    }
	}
}

ReplaceExtIntTypes(target, atom)
TargetEntity target;
Atomic atom;
{
	SEQRefinedTypePair SRPr;
	RefinedTypePair ARPr;

	foreachinSEQRefinedTypePair(target->pre_refinedtypePrs, SRPr, ARPr){
	     if (IsTypeEntity(atom->rep_internalType)) {
		 if (SameType(atom->rep_internalType.VTypeEntity,
				ARPr->pre_targetIndependent)) {
		     atom->rep_internalType.VTypeEntity =
			 ARPr->pre_targetDependent;
		 }
		 atom->rep_size = atom->rep_internalType.VTypeEntity.
				  IDLclassCommon->rep_size;
	     }
	     if (IsTypeEntity(atom->rep_externalType)) {
		 if (SameType(atom->rep_externalType.VTypeEntity,
				ARPr->pre_targetIndependent)) {
		     atom->rep_externalType.VTypeEntity =
			 ARPr->pre_targetDependent;
		 }
	     }
	}
}

Boolean IsInPort(pr, thetype)
ProcessEntity pr;
TypeEntity thetype;
{
	SETPort SPort;
	Port APort;
	SETTypeEntity SType;
	TypeEntity AType;
	StructureEntity portst;
	Boolean inport = FALSE;

	Assume((IsProcessEntity(pr)&&IsTypeEntity(thetype)),
		"IsInPort");

	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    portst = GetStructureEntity(APort->syn_data);
	    foreachinSETTypeEntity(portst->sem_types, SType, AType) {
		if (AType.IDLclassCommon->sem_name == 
		    thetype.IDLclassCommon->sem_name) {
			inport = TRUE;
			break;
		}
	    }
	}
	return(inport);
}


check_external(atom, pos)
Atomic		atom;
SourcePosition	pos;
{
	TypeEntity tmptype;

	if (typeof(atom->rep_externalType) == KVoid){
	    if (!IsTypeEntity(atom->rep_internalType)) {
		Serious1(252, pos, atom->sem_name);
	    }
	    else {
		tmptype = atom->rep_internalType.VTypeEntity;
		atom->rep_externalType.VTypeEntity = tmptype;
		Recoverable2(265, pos, atom->sem_name,
			     tmptype.IDLclassCommon->sem_name);
	    }
	}
}


check_internal(atom, pos)
Atomic 		atom;
SourcePosition	pos;
{
	TypeEntity tmptype;

	if (typeof(atom->rep_internalType) == KVoid) {
	    if (!IsTypeEntity(atom->rep_externalType)) {
		Serious1(251, pos, atom->sem_name);
	    }
	    else {
		tmptype = atom->rep_externalType.VTypeEntity;
		Recoverable2(264, pos, atom->sem_name,
			     tmptype.IDLclassCommon->sem_name);
		atom->rep_internalType.VTypeEntity = tmptype;
		atom->rep_size = tmptype.IDLclassCommon->rep_size;
	    }
	}
}

check_size(atom, pos)
Atomic 		atom;
SourcePosition	pos;
{
	if (atom->rep_size<=0 && !IsTypeEntity(atom->rep_internalType))
	    Serious1(250, pos, atom->sem_name);
}
