# line 2 "parse.y"
/* ******************************************************************* *\
*									*
*   File: scorpion/src/idlc/frontend/parse.y
*									*
*   Copyright (C) 1991 Tim Maroney, Richard Snodgrass, Karen Shannon
*									*
*   The Scorpion System is free software in the public domain; you can  *
*   redistribute it and/or modify it as you wish. We ask that you 	*
*   retain credits referencing the University of Arizona and that you	*
*   identify any changes you make.					*
*									*
*   Report problems to scorpion-project@cs.arizona.edu			*
*   Direct all inquiries to:	The Scorpion Project			*
*				Department of Computer Science		*
*				Gould-Simpson Building			*
*				University of Arizona			*
*				Tucson, AZ 85721			*
*				U.S.A.					*
*									*
*   Function: Yacc code to recognize IDL notation grammar		*
*									*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: parse.y,v 1.1 89/07/05 16:30:40 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	parse.y,v $
 * Revision 1.1  89/07/05  16:30:40  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:01:14  cheung
 * parse.y  Ver 4.0
 * 
 * Revision 3.9  89/03/30  11:48:28  cheung
 * parse.y  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:58:37  cheung
 * parse.y  Ver 3.9
 * 
 * Revision 1.1  87/04/18  11:18:12  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*     March 1985 (shannon) Edited to add new list routines		*
*									*
\* ******************************************************************* */
# include <stdio.h>
# include "Frontend.h"
#include "macros.h"
extern compilationUnit TheCompUnit;

extern FILE *errout;
extern Boolean V2conform;
Boolean declaration_error = FALSE;
Boolean statement_error = FALSE;
Boolean has_syntax_error = FALSE; 
extern int lineNumber;
extern int charcount;
extern int lasttoken;
parameter aparm, parm1, parm2, parm3;	/* temporary parameters */
nameToken name;				/* temporary name */
extern Boolean instructure, inprocess;
extern SEQString  structurelexinfo, 
		  processlexinfo, 
		  importlexinfo,
		  compUnitlexinfo;

# line 205 "parse.y"
typedef union  {
Assertion VAssertion;
AssertRef VAssertRef;
atomicDecl VatomicDecl;
Attribute VAttribute;
AttributeOrAllAttributes VAttributeOrAllAttributes;
attributeProduction VattributeProduction;
AttributeRef VAttributeRef;
attributeRep VattributeRep;
CaseName VCaseName;
case_select Vcase_select;
SEQcase_select VLcase_select;
ClassOrAllClasses VClassOrAllClasses;
compUnitRef VcompUnitRef;
Control VControl;
cyclicdef Vcyclic;
Declaration VDeclaration;
DefineRef VDefineRef;
DefInstance VDefInstance;
DefInstanceOrDefineRef VDefInstanceOrDefineRef;
expression Vexpression;
expressionOrVoid VexpOrVoid;
expressionPair VexpressionPair;
Formal VFormal;
integerToken VintegerToken;
SEQAttribute VLAttribute;
SEQexpression VLexpression;
SEQexpressionPair VLexpressionPair;
SEQFormal VLFormal;
SEQNamedTypeRef VLNamedTypeRef;
SEQOperRef VLOperRef;
SEQparameter VLparameter;
SEQPort VLPort;
SEQprocessStatement VLprocessStatement;
SEQDeclaration VLDeclaration;
SEQStructureRef VLStructureRef;
SEQStructureOrProcessRef VLStPrRef;
SEQstructureStatement VLstructureStatement;
SEQwithoutItem VLwithoutItem;
NamedTypeRef VNamedTypeRef;
nameOrVoid VnameOrVoid;
nameToken VnameToken;
noncyclicdef Vnoncyclic;
OperRef VOperRef;
parameter Vparameter;
Port VPort;
portAssociation VportAssociation;
portDefinition VportDefinition;
PortRef VPortRef;
PortType VPortType;
PrivateDefInstance VPrivateDefInstance;
ProcessEntity VProcessEntity;
ProcessRef VProcessRef;
ProcessRefOrVoid VProcessRefOrVoid;
processStatement VprocessStatement;
production Vproduction;
quantifier Vquantifier;
rationalToken VrationalToken;
RepRef VRepRef;
restriction Vrestriction;
restrictToOrFrom VrestrictToOrFrom;
rootExp Vroot;
SeqRef VSeqRef;
SetOrSeqRef VSetOrSeqRef;
SetRef VSetRef;
stringToken VstringToken;
StructureEntity VStructureEntity;
StructureOrProcess VStructureOrProcess;
StructureOrProcessRef VStructureOrProcessRef;
StructureRef VStructureRef;
StructureRefOrVoid VStructureRefOrVoid;
structureStatement VstructureStatement;
subclassProduction VsubclassProduction;
targetStmt VtargetStmt;
TypeOrAllTypes VTypeOrAllTypes;
TypeRef VTypeRef;
TypeRefOrVoid VTypeRefOrVoid;
typeRepDecl VtypeRepDecl;
withoutAssert VwithoutAssert;
withoutAttribute VwithoutAttribute;
withoutClause VwithoutClause;
withoutDefine VwithoutDefine;
withoutItem VwithoutItem;
withoutProduction VwithoutProduction;
withoutSubclass VwithoutSubclass;
withoutType VwithoutType;
} YYSTYPE;
# define BAR 257
# define COMMA 258
# define LEFTPAREN 259
# define RIGHTPAREN 260
# define Do 261
# define Fi 262
# define From 263
# define Import 264
# define Inv 265
# define Od 266
# define Refines 267
# define Returns 268
# define To 269
# define Use 270
# define DUMMY1 271
# define DUMMY2 272
# define DUMMY3 273
# define DUMMY4 274
# define DUMMY5 275
# define DUMMY6 276
# define DUMMY7 277
# define DUMMY8 278
# define And 279
# define Assert 280
# define Case 281
# define Cyclic 282
# define Define 283
# define Else 284
# define Empty 285
# define End 286
# define Exists 287
# define False 288
# define For 289
# define ForAll 290
# define If 291
# define In 292
# define Intersect 293
# define Is 294
# define Mark 295
# define Not 296
# define Of 297
# define Or 298
# define OrIf 299
# define Otherwise 300
# define Post 301
# define Pre 302
# define Process 303
# define Psub 304
# define Restrict 305
# define Root 306
# define Same 307
# define Seq 308
# define Set 309
# define Structure 310
# define Sub 311
# define Target 312
# define Then 313
# define True 314
# define Type 315
# define Union 316
# define Unmark 317
# define Without 318
# define NAME 319
# define INTEGER 320
# define RATIONAL 321
# define STRING 322
# define ANGLEARROW 323
# define COLON 324
# define COLONARROW 325
# define DOT 326
# define EQUAL 327
# define GREATER 328
# define GREATEROREQ 329
# define LESS 330
# define LESSOREQ 331
# define MINUS 332
# define NOTEQUAL 333
# define PLUS 334
# define SEMICOLON 335
# define SLASH 336
# define STAR 337
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 1435 "parse.y"



yyerror(s) char *s;
{	has_syntax_error = TRUE; }
short yyexca[] ={
-1, 0,
	0, 171,
	-2, 0,
-1, 1,
	0, -1,
	-2, 0,
-1, 3,
	0, 2,
	-2, 0,
-1, 49,
	280, 171,
	-2, 0,
-1, 77,
	280, 171,
	-2, 0,
-1, 126,
	280, 146,
	-2, 157,
-1, 151,
	259, 156,
	324, 159,
	-2, 127,
-1, 189,
	323, 46,
	325, 46,
	-2, 41,
	};
# define YYNPROD 208
# define YYLAST 955
short yyact[]={

 130, 217,  73,   2, 175, 353, 217, 204, 237, 203,
 329, 206, 205, 106, 105, 242, 206, 205, 198,  80,
  23, 217,  26,  40,  40,  32, 236, 246,  37,  18,
 308, 214, 202, 200, 168, 299, 254, 199, 253,  46,
 167, 193, 100, 216, 214,  50, 213, 195,  40, 194,
 215, 226, 129, 245,  78, 201, 216, 233, 262, 213,
 237, 186, 109, 215, 187, 217, 211, 209, 210, 207,
 208, 204, 212, 203, 241, 206, 205, 119, 217, 211,
 209, 210, 207, 208, 204, 212, 203,  94, 206, 205,
  27,  18,  95,  96,  97, 229, 188, 166,  93, 250,
  40, 198, 228,  75,  76, 221, 290, 110, 106, 105,
 123, 173,  44, 149, 214, 202, 200,  86, 193,  40,
 199,  35,  15, 106, 105,  29, 216, 331, 170, 213,
 169, 291, 218, 215,  40, 346, 122, 286, 201, 124,
 126,  51, 333, 219, 244, 222, 223, 224, 217, 211,
 209, 210, 207, 208, 204, 212, 203, 336, 206, 205,
 150,  42, 231, 354,  41, 232,  16, 107,  84, 319,
 168, 335, 247, 163, 173, 158, 167, 294,   7, 106,
 105,  38,  24, 352, 103,  33,   6,  21,  47, 344,
  40, 343,  20, 312,  62, 311, 174, 256, 260, 264,
 265, 266, 267, 268, 269, 270, 271, 272, 273, 274,
 275, 276, 277, 278, 279, 280, 281, 282, 157, 225,
  75,  76, 292, 307,  54,  10, 288,  68, 298, 345,
 297, 104,  11, 248, 128,  79, 306, 103, 192,  72,
  71,  58, 295,  70,  57,  92, 198, 234, 180, 172,
  69, 230,   1, 184, 165,  82, 148,  18,  14, 214,
 202, 200,   4,  92, 183, 199,  12, 190, 185, 235,
  88, 216,  43, 182, 213, 108, 116, 191, 215, 181,
  30, 135, 115, 201, 104,  25, 309, 310,  91,  98,
  60, 120, 313, 217, 211, 209, 210, 207, 208, 204,
 212, 203, 103, 206, 205, 111,  91,  36,  31,   5,
 342,  48, 324, 326,   9, 102, 328, 155,  61, 118,
  53,  87, 117, 198, 143,  85, 334, 133, 112, 156,
 339,  55, 340,  22, 341,  34, 214, 202, 200,  92,
 103,   8, 199, 301, 348, 350, 349, 351, 216, 104,
  67, 213, 127,  63, 138, 215, 103,  56, 164,  59,
 201, 325,  66,  64, 179,  77, 321,  13,  52,  45,
 217, 211, 209, 210, 207, 208, 204, 212, 203, 198,
 206, 205,  91, 171, 196,   3,  49, 104,  81, 257,
 255, 140, 214, 202, 200, 243, 323, 287, 199,  90,
 261, 259, 197, 104, 216, 332,  92, 213, 103, 347,
 139, 215, 137, 103, 147, 330, 201,  90,  65, 220,
 227, 240, 103,  92, 132, 198, 217, 211, 209, 210,
 207, 208, 204, 212, 203,  28, 206, 205, 214, 202,
 200, 103, 327, 317, 199, 337, 141, 134, 114,  91,
 216, 121, 284, 213,  99, 104, 315, 215, 314, 285,
 104, 113, 201, 251, 249, 136,  91,   0,   0, 104,
   0, 198, 217, 211, 209, 210, 207, 208, 204, 212,
 203,   0, 206, 205, 214, 202, 200, 283, 104, 293,
 199,   0, 303,  90,   0,  92, 216, 302,   0, 213,
   0, 164, 305, 215,   0,   0,   0,   0, 201,   0,
   0,   0,   0,   0,   0,   0, 300, 198, 217, 211,
 209, 210, 207, 208, 204, 212, 203,   0, 206, 205,
 214, 202, 200,   0,   0,   0, 199,   0,  91,   0,
   0,   0, 216,   0,   0, 213,   0,   0, 198, 215,
   0,   0,   0,   0, 201,   0,   0,   0,   0,   0,
  90, 214, 202, 200, 217, 211, 209, 210, 207, 208,
 204, 212, 203, 216, 206, 205, 213,  90, 178,   0,
 215, 101,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 214,   0, 200, 217, 211, 209, 210, 207,
 208, 204, 212, 203, 216, 206, 205, 213,   0,  39,
   0, 215,   0, 131,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 217, 211, 209, 210,
 207, 208, 204, 212, 203, 159, 206, 205,   0, 154,
   0, 161, 153, 252, 160, 142,  89,   0,   0,  90,
 146,   0,   0,   0,   0,   0,   0,  17,  19, 125,
 162,   0, 106, 105,   0,   0,   0,   0, 152,   0,
   0,   0,   0, 151,  95,  96,  97,   0,   0,   0,
   0, 289,   0,   0,   0,   0, 145,   0, 144,   0,
   0,   0,   0,   0,   0,   0,  74, 296,   0,   0,
   0,   0,   0,   0, 176, 177, 189,   0,   0,   0,
  83,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 316,
   0, 238, 239,   0, 318,   0,   0,   0,   0,   0,
   0,   0,   0, 322,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  83, 258,   0,   0,   0,
   0,   0, 338,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 189,   0,   0,   0,   0, 304,   0,   0,   0,   0,
   0,   0, 263,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 320,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 263 };
short yypact[]={

 -78,-1000,-1000, -78,-1000,-1000,-197,-120,-1000,-1000,
-290,-290,-1000, -71,-1000,-1000,-1000, -85,-1000,-216,
-194,-197, -80,-1000,-198, -86,-1000,-271,-122,-1000,
-1000,-133,-1000,-207,-1000,-1000, -75,-1000,-207,-1000,
-1000,-1000,-1000,-1000,-1000,-153,-1000,-207,-1000, -62,
-1000,-1000, -23,-1000,-1000,-316,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-290,-112,-1000,-1000,-1000,-202,-228,
-295,-1000,-1000,-1000,-1000,-116,-257,-179,-1000,-207,
-1000, -24,-1000,-272, 354, -97,-1000,-228,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-229,-1000,
-1000,-1000,-1000,-1000,-1000,-167,-169,-257, -63,-1000,
-1000,-331,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-271,-185,-219,-276,-1000,-1000,-290,-207,
 238, 354,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000, 354,-214, 354, 354, 354, -40,-273,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-217,
-1000,-1000,-1000,-228,-1000,-262,-311,-1000,-1000,-271,
-271, -63,-253,-1000,-266,-1000,-1000,-299, -98, -25,
-1000,-1000,-1000,-1000,-1000,-1000,-220,-257,-185,-1000,
-1000,-1000,-287,-1000,-271,-290,-1000,-1000, 354, 354,
 354, 354, 354, 354, 354, 354, 354, 354, 354, 354,
 354, 354, 354, 354, 354, 354, 354,-259, 192, 146,
-155,-1000,-320,-320,-248, 354,-200,-163,-1000,-1000,
-228, -36,-1000,-1000, -93,-1000,-1000,-1000,-1000,-1000,
 -91, 354,-185, -30,-1000,-289,-259,-228,-219,-1000,
-1000,-1000,-1000,-296,-311,-1000,-1000, -21,-1000,-1000,
-1000, -35,-1000,-294, 300, 269,-248, 269, 300,-320,
-320,-305,-305,-325,-325,-325,-325,-325,-325,-325,
-325,-325,-325,-1000,-1000, 354, 354, -65, 238,-1000,
-1000, 354,-262,-262,-185, 238,-1000,-1000,-266,-185,
-101,-1000,-1000,-1000,-1000,-1000,-271,-290,-185, 238,
 100,-1000, 354, 238,-1000, -36,-317,-1000,-1000,-228,
-1000,-1000,-1000,-157,-1000, 354, 238,-129,-1000, 354,
-1000, 354,-1000, 354,  44, -70,-1000,-1000, -72, 238,
 -33,-178,-1000, 354, 354,-1000, 354, -83, 238,-1000,
-261, 238,-123,-1000,-1000 };
short yypgo[]={

   0, 329, 218, 646, 175, 465, 244, 464, 461,  58,
 247, 451, 269, 448, 447, 446, 445, 442, 238, 435,
 424, 420, 419, 418, 262, 275, 241, 414, 412, 410,
   0, 409, 405, 144, 401, 400, 397, 396, 249, 395,
 391, 390, 389, 162, 251, 388, 386, 385, 369, 368,
 367, 365, 364, 363, 581, 362, 165, 270, 255, 359,
 357, 354, 256, 353, 350, 341, 335, 333, 331, 328,
 327, 324, 318, 254,  95, 317, 160, 315, 113, 258,
 314, 309, 272, 308, 307, 305, 291, 290, 289, 454,
 285, 282, 281, 279, 277, 276, 273, 248, 268, 267,
 264, 253, 252,   2 };
short yyr1[]={

   0, 102, 102,  24,  24,  24,  81,  81,  80,  90,
  90,  84,  84,  48,  48,  85,  85,  85,  85,  85,
  85,  85,  85,  69,  69,  86,  11,   9,   8,  13,
  74,  91,  95,  97,  97,  97,  97,  97,  93,  96,
 100, 101,  98,  98,  99,  94,  18,  18,  10,  10,
  65,  67,  67,  83,  83,  68,  68,  68,  68,  68,
  68,  68,  60,  63,  63,  58,  59,  87,  72,  72,
  73,  73,  88,  88,   6,  26,  26,  26,  23,  55,
  64,  33,  31,  31,  30,  30,  30,  30,  30,  30,
  30,  30,  30,  30,  30,  20,  32,  70,  71,  71,
  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,
  14,  14,  14,  14,  14,  14,  14,  14,  14,  92,
  92,  92,   5,  28,  61,  29,  29,  29,  40,  40,
  40,  40,  40,  40,  40,  15,  15,  16,  75,  75,
  57,  57,  57,  57,  57,  57,   3,   1,   2,   4,
   7,  12,  21,  19,  22,  25,  27,  54,  56,  62,
  66,  79,  82,  89,  89,  77,  77,  78,  76,  53,
  53, 103,  34,  34,  35,  35,  17,  17,  36,  36,
  37,  37,  38,  38,  39,  39,  43,  43,  44,  44,
  45,  45,  46,  46,  47,  47,  50,  50,  49,  49,
  51,  51,  41,  41,  42,  42,  52,  52 };
short yyr2[]={

   0,   1,   1,   1,   5,   2,   1,   1,   8,   1,
   2,   1,   2,   1,   2,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   3,   3,   3,   2,   6,
   1,   4,   2,   1,   1,   1,   1,   1,   2,   2,
   2,   1,   1,   1,   3,   3,   1,   1,   1,   1,
   7,   1,   2,   1,   2,   1,   1,   1,   1,   1,
   1,   1,   2,   1,   1,   3,   4,   2,   4,   6,
   1,   1,   1,   1,   3,   1,   1,   1,   8,   5,
   5,   3,   1,   1,   3,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   8,   4,   7,   1,   1,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,
   2,   2,   4,   3,   3,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,  10,   6,   4,   3,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   3,   3,   1,
   1,   0,   1,   1,   1,   3,   1,   2,   1,   3,
   1,   2,   1,   3,   1,   3,   1,   3,   1,   2,
   1,   3,   1,   3,   1,   2,   1,   3,   1,   3,
   1,   3,   1,   1,   1,   3,   1,   3 };
short yychk[]={

-1000,-102,-103, -47, -24, -81, 264, 256, -65, -80,
 303, 310, -24, -50, -79, 319, 286,  -3, 319,  -3,
 263, 258, -67,-103, 267, -90,-103, 306, -19, 319,
 -79, -83,-103, 265, -66, 319, -84,-103, 267, -54,
 319, 286, 294, -82, 319, -48,-103, 263, -82, -46,
-103, 294, -49, -82, 286, -68, -60,  -6, -26, -59,
 -87, -72, 256, -63, -53, -23, -55, -64, 289, 312,
 305, 302, 301,-103,  -3, 282, 283, -51,-103, 258,
 335, -45, -58,  -3, 280, -62, 319, -44, -57,  -3,
  -1,  -2,  -4, 326, 315, 320, 321, 322, -88, -89,
 337, -54, -77, -78, -76, 309, 308, 283, -25, 319,
 286, -85, -69,  -8, -13, -91, -95,  -6, -26, 256,
 -86, -11, 315, 289, 318, -54, 319, -82, 258, 324,
 -30, 259, -20, -70, -14, -92,  -5, -28, -61, -29,
 -40, -15, 291, -71, 334, 332, 296, -27, -62, -78,
 -76, 319, 314, 288, 285, -75,  -1,  -2,  -4, 281,
 290, 287, 306, 270, -57, -73, 326, 269, 263, 297,
 297, -25, -38,-103, 259, 335, -54, -54, -89, -52,
 -97, -93, -96,-100,-101, -98, 280, 283, 315, -54,
 -99, -94, -18, 337, 325, 323, -58, -82, 279, 298,
 294, 316, 293, 334, 332, 337, 336, 330, 331, 328,
 329, 327, 333, 307, 292, 311, 304, 326, -30, -30,
 -22, 319, -30, -30, -30, 259, 324, -21, 319, -74,
 -44, -43, -56, 319, -10, -12, 337, 319, -54, -54,
 -38, 327, 268, -39, -33, 319, 326, 270, 258,  -7,
 319, -25, -89, 325, 323, -41,-103, -42, -54, -34,
-103, -35,  -9,  -3, -30, -30, -30, -30, -30, -30,
 -30, -30, -30, -30, -30, -30, -30, -30, -30, -30,
 -30, -30, -30, -12, 260, 313, 292, -36, -30, -89,
 306, 294, 258, -73, 268, -30, -89, 260, 258, 324,
 -12, -74, -97, -18, -54, -10, 257, 258, 324, -30,
 -30, 260, 258, -30, -56, -43, -89, -33, -89, 270,
 -54,  -9, -89, -37,-103, 261, -30, -17,-103, 327,
 -74, 284, -32, 299, -30, 300, 286, -16, -89, -30,
 -30, -30, 266, 261, 261, 262, 313, -31, -30,-103,
 -30, -30, 266, 266, 286 };
short yydef[]={

  -2,  -2,   1,  -2, 194,   3,   0,   0,   6,   7,
   0,   0, 195,   0, 196, 161,   5, 171, 146, 171,
   0,   0, 171,  51,   0, 171,   9,   0,   0, 153,
 197,   0,  53,   0,  52, 160, 171,  11,   0,  10,
 157,   4, 171,  54, 162,   0,  13,   0,  12,  -2,
 192, 171,  14, 198,  50,   0,  55,  56,  57,  58,
  59,  60,  61,   0,   0,  75,  76,  77,   0,   0,
   0,  63,  64, 169, 170,   0,   0,  -2, 200,   0,
 193,  62, 190,   0,   0,   0, 159,  67, 188, 140,
 141, 142, 143, 144, 145, 147, 148, 149,   0,  72,
  73, 163, 164, 165, 166,   0,   0,   0, 171, 155,
   8,   0,  15,  16,  17,  18,  19,  20,  21,  22,
  23,  24,   0,   0,   0,   0,  -2, 199,   0,   0,
  74,   0,  85,  86,  87,  88,  89,  90,  91,  92,
  93,  94,   0,   0,   0,   0,   0,   0,   0, 125,
 126,  -2, 128, 129, 130, 131, 132, 133, 134,   0,
  98,  99, 139,   0, 189,   0,   0,  70,  71,   0,
   0, 171,   0, 182,   0, 201,  28, 163,   0,  32,
 206,  33,  34,  35,  36,  37,   0,   0,   0,  -2,
  42,  43,   0,  47, 171, 171, 191,  65,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 154, 119, 120, 121,   0,   0,   0, 152,  66,
  30,  68, 186, 158,   0,  48,  49, 151, 167, 168,
   0,   0,   0,   0, 184,   0,   0,   0,   0,  38,
 150,  39,  40,   0,   0,  25, 202, 203, 204,  26,
 172, 173, 174,   0, 100, 101, 102, 103, 104, 105,
 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
 116, 117, 118, 123,  84,   0,   0,   0, 178, 124,
 138,   0,   0,   0,   0,  79,  80, 183,   0,   0,
   0,  31, 207,  44,  46,  45,   0,   0,   0, 171,
   0, 122,   0, 171, 187,  69,   0, 185,  81,   0,
 205, 175,  27,   0, 180,   0, 179,   0, 176,   0,
  29,   0, 181,   0,   0,   0, 136, 177,   0,  78,
   0,   0,  97, 171,   0,  95,   0,   0,  82,  83,
   0,  96,   0, 137, 135 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 299 "parse.y"
{	TheCompUnit = NcompilationUnit;
		} break;
case 2:
# line 302 "parse.y"
{	TheCompUnit = NcompilationUnit;
			TheCompUnit->syn_body = yypvt[-0].VLDeclaration;
			if (!has_syntax_error)
			    TheCompUnit->lex_information = compUnitlexinfo;
		} break;
case 3:
# line 310 "parse.y"
{	yyval.VDeclaration.VStructureOrProcess = yypvt[-0].VStructureOrProcess;
		} break;
case 4:
# line 313 "parse.y"
{	yyval.VDeclaration.VImportDecl = NImportDecl;
			if (!has_syntax_error)
			    yyval.VDeclaration.VImportDecl->lex_information = importlexinfo;
			yyval.VDeclaration.VImportDecl->syn_specs = yypvt[-3].VLStPrRef;
			yyval.VDeclaration.VImportDecl->syn_compUnit = yypvt[-1].VcompUnitRef;
		} break;
case 5:
# line 320 "parse.y"
{	Recoverable0(51, lasttoken);
			declaration_error = TRUE;
			yyerrok;
			yyclearin;
		} break;
case 6:
# line 329 "parse.y"
{	yyval.VStructureOrProcess.VProcessEntity = yypvt[-0].VProcessEntity; 
			if (!has_syntax_error)
			    yyval.VStructureOrProcess.VProcessEntity->lex_information = processlexinfo;
			initializeSEQString(processlexinfo);
		} break;
case 7:
# line 335 "parse.y"
{	yyval.VStructureOrProcess.VStructureEntity = yypvt[-0].VStructureEntity; 
			if (!has_syntax_error)
			    yyval.VStructureOrProcess.VStructureEntity->lex_information = structurelexinfo;
			initializeSEQString(structurelexinfo);
		} break;
case 8:
# line 345 "parse.y"
{	yyval.VStructureEntity = NStructureEntity;
			yyval.VStructureEntity->lex_beginpos = GetKwdPos(yypvt[-7].VnameToken);
			yyval.VStructureEntity->lex_endpos = GetKwdPos(yypvt[-0].VnameToken);
			yyval.VStructureEntity->lex_name = yypvt[-6].VnameToken->lex_name;
			yyval.VStructureEntity->lex_namepos = yypvt[-6].VnameToken->lex_namepos;
			FreenameToken(yypvt[-6].VnameToken);
			yyval.VStructureEntity->syn_root = yypvt[-5].VTypeRefOrVoid;
			yyval.VStructureEntity->syn_refines = yypvt[-4].VStructureRefOrVoid;
			yyval.VStructureEntity->syn_from = yypvt[-3].VLStructureRef;
			yyval.VStructureEntity->syn_body = yypvt[-1].VLstructureStatement;
		} break;
case 9:
# line 359 "parse.y"
{	yyval.VTypeRefOrVoid.VVoid = NVoid; } break;
case 10:
# line 361 "parse.y"
{	yyval.VTypeRefOrVoid.VNamedTypeRef = yypvt[-0].VNamedTypeRef; 
		} break;
case 11:
# line 366 "parse.y"
{	yyval.VStructureRefOrVoid.VVoid = NVoid; } break;
case 12:
# line 368 "parse.y"
{	yyval.VStructureRefOrVoid.VStructureRef = yypvt[-0].VStructureRef; } break;
case 13:
# line 372 "parse.y"
{	yyval.VLStructureRef = NULL; } break;
case 14:
# line 374 "parse.y"
{	yyval.VLStructureRef = yypvt[-0].VLStructureRef; } break;
case 15:
# line 378 "parse.y"
{	yyval.VstructureStatement.Vproduction = yypvt[-0].Vproduction; 
		} break;
case 16:
# line 381 "parse.y"
{	yyval.VstructureStatement.VatomicDecl = yypvt[-0].VatomicDecl; 
		} break;
case 17:
# line 384 "parse.y"
{	yyval.VstructureStatement.VattributeRep = yypvt[-0].VattributeRep;
		} break;
case 18:
# line 387 "parse.y"
{	yyval.VstructureStatement.VtypeRepDecl = yypvt[-0].VtypeRepDecl; 
		} break;
case 19:
# line 390 "parse.y"
{	yyval.VstructureStatement.VwithoutClause = yypvt[-0].VwithoutClause; 
		} break;
case 20:
# line 393 "parse.y"
{	yyval.VstructureStatement.VAssertion = yypvt[-0].VAssertion; 
		} break;
case 21:
# line 396 "parse.y"
{	yyval.VstructureStatement.VDefInstance = yypvt[-0].VDefInstance;
		} break;
case 22:
# line 399 "parse.y"
{	statement_error = TRUE;
			Recoverable0(52, lasttoken);
		} break;
case 23:
# line 406 "parse.y"
{	yyval.Vproduction.VsubclassProduction = yypvt[-0].VsubclassProduction; } break;
case 24:
# line 408 "parse.y"
{	yyval.Vproduction.VattributeProduction = yypvt[-0].VattributeProduction; } break;
case 25:
# line 412 "parse.y"
{	yyval.VsubclassProduction = NsubclassProduction;
			yyval.VsubclassProduction->syn_class = yypvt[-2].VNamedTypeRef;
			yyval.VsubclassProduction->syn_subclasses = yypvt[-0].VLNamedTypeRef;
			yyval.VsubclassProduction->lex_stmtpos = GetTokenPos(yypvt[-1].VnameToken);
		} break;
case 26:
# line 421 "parse.y"
{	yyval.VattributeProduction = NattributeProduction;
			yyval.VattributeProduction->syn_class = yypvt[-2].VNamedTypeRef;
			yyval.VattributeProduction->syn_attributes = yypvt[-0].VLAttribute;
			yyval.VattributeProduction->lex_stmtpos = GetTokenPos(yypvt[-1].VnameToken);
		} break;
case 27:
# line 429 "parse.y"
{	yyval.VAttribute = NAttribute;
			yyval.VAttribute->lex_name = yypvt[-2].VnameToken->lex_name;
			yyval.VAttribute->lex_namepos = yypvt[-2].VnameToken->lex_namepos;
			FreenameToken(yypvt[-2].VnameToken);
			yyval.VAttribute->syn_type = yypvt[-0].VTypeRef;
		} break;
case 28:
# line 438 "parse.y"
{	yyval.VatomicDecl = NatomicDecl;
			yyval.VatomicDecl->syn_atomic = yypvt[-0].VNamedTypeRef;
			yyval.VatomicDecl->lex_stmtpos = GetKwdPos(yypvt[-1].VnameToken);
		} break;
case 29:
# line 446 "parse.y"
{	yyval.VattributeRep = NattributeRep;
			yyval.VattributeRep->syn_class = yypvt[-4].VNamedTypeRef;
			yyval.VattributeRep->syn_attribute = yypvt[-2].VAttributeRef;
			yyval.VattributeRep->syn_rep = yypvt[-0].VRepRef;
			yyval.VattributeRep->lex_stmtpos = GetKwdPos(yypvt[-5].VnameToken);
		} break;
case 30:
# line 455 "parse.y"
{	yyval.VRepRef = NRepRef;
			yyval.VRepRef->syn_id = yypvt[-0].VLparameter;
		} break;
case 31:
# line 461 "parse.y"
{	yyval.VtypeRepDecl = NtypeRepDecl;
			yyval.VtypeRepDecl->syn_type = yypvt[-2].VTypeRef;
			if (V2conform) {
			    if (typeof(yypvt[-2].VTypeRef)!=KNamedTypeRef) {
				Serious0(56, yypvt[-2].VTypeRef.VSetOrSeqRef.IDLclassCommon
						->lex_keywordpos);
			    }
			}
			yyval.VtypeRepDecl->syn_spec = yypvt[-0].VRepRef;
			yyval.VtypeRepDecl->lex_stmtpos = GetKwdPos(yypvt[-3].VnameToken);
		} break;
case 32:
# line 476 "parse.y"
{	yyval.VwithoutClause = NwithoutClause;
			yyval.VwithoutClause->syn_list = yypvt[-0].VLwithoutItem;
			yyval.VwithoutClause->lex_stmtpos = GetKwdPos(yypvt[-1].VnameToken);
		} break;
case 33:
# line 483 "parse.y"
{	yyval.VwithoutItem.VwithoutAssert = yypvt[-0].VwithoutAssert; } break;
case 34:
# line 485 "parse.y"
{	yyval.VwithoutItem.VwithoutDefine = yypvt[-0].VwithoutDefine; } break;
case 35:
# line 487 "parse.y"
{	yyval.VwithoutItem.VwithoutType = yypvt[-0].VwithoutType; } break;
case 36:
# line 489 "parse.y"
{	yyval.VwithoutItem.VwithoutType = yypvt[-0].VwithoutType; } break;
case 37:
# line 491 "parse.y"
{	yyval.VwithoutItem.VwithoutProduction = yypvt[-0].VwithoutProduction; } break;
case 38:
# line 494 "parse.y"
{	yyval.VwithoutAssert = NwithoutAssert;
			yyval.VwithoutAssert->syn_item = yypvt[-0].VAssertRef;
			yyval.VwithoutAssert->lex_itempos = GetKwdPos(yypvt[-1].VnameToken);
			if (V2conform) {
			    Serious0(58, yyval.VwithoutAssert->lex_itempos);
			}
		} break;
case 39:
# line 503 "parse.y"
{	yyval.VwithoutDefine = NwithoutDefine;
			yyval.VwithoutDefine->syn_item = yypvt[-0].VDefineRef;
			yyval.VwithoutDefine->lex_itempos = GetKwdPos(yypvt[-1].VnameToken);
			if (V2conform) {
			    Serious0(58, yyval.VwithoutDefine->lex_itempos);
			}
		} break;
case 40:
# line 512 "parse.y"
{	yyval.VwithoutType = NwithoutType;
			yyval.VwithoutType->syn_item = yypvt[-0].VTypeRef;
			yyval.VwithoutType->lex_itempos = GetKwdPos(yypvt[-1].VnameToken);
			if (V2conform) {
			    Serious0(58, yyval.VwithoutType->lex_itempos);
			}
		} break;
case 41:
# line 520 "parse.y"
{	/* for version 2.0 of IDL */
		 	yyval.VwithoutType = NwithoutType;
			yyval.VwithoutType->syn_item.VNamedTypeRef = yypvt[-0].VNamedTypeRef;
			yyval.VwithoutType->lex_itempos = yypvt[-0].VNamedTypeRef->lex_namepos;
		} break;
case 42:
# line 528 "parse.y"
{	yyval.VwithoutProduction.VwithoutSubclass = yypvt[-0].VwithoutSubclass; } break;
case 43:
# line 530 "parse.y"
{	yyval.VwithoutProduction.VwithoutAttribute = yypvt[-0].VwithoutAttribute; } break;
case 44:
# line 534 "parse.y"
{	yyval.VwithoutSubclass = NwithoutSubclass;
			yyval.VwithoutSubclass->syn_lefthandside = yypvt[-2].VClassOrAllClasses;
			yyval.VwithoutSubclass->syn_righthandside = yypvt[-0].VClassOrAllClasses;
			yyval.VwithoutSubclass->lex_itempos = GetTokenPos(yypvt[-1].VnameToken);
			if (V2conform) {
			    if ((typeof(yypvt[-2].VClassOrAllClasses)==KAllClasses) || 
				(typeof(yypvt[-0].VClassOrAllClasses)==KAllClasses)) {
				Serious0(58, yyval.VwithoutSubclass->lex_itempos);
			    }
			}
		} break;
case 45:
# line 548 "parse.y"
{	yyval.VwithoutAttribute = NwithoutAttribute;
			yyval.VwithoutAttribute->syn_lefthandside = yypvt[-2].VClassOrAllClasses;
			yyval.VwithoutAttribute->syn_righthandside = yypvt[-0].VAttributeOrAllAttributes;
			yyval.VwithoutAttribute->lex_itempos = GetTokenPos(yypvt[-1].VnameToken);
			if (V2conform) {
			    if ((typeof(yypvt[-2].VClassOrAllClasses)==KAllClasses) || 
				(typeof(yypvt[-0].VAttributeOrAllAttributes)==KAllAttributes)) {
				Serious0(58, yyval.VwithoutAttribute->lex_itempos);
			    }
			}
		} break;
case 46:
# line 561 "parse.y"
{	yyval.VClassOrAllClasses.VNamedTypeRef = yypvt[-0].VNamedTypeRef; } break;
case 47:
# line 563 "parse.y"
{	yyval.VClassOrAllClasses.VAllClasses = NAllClasses; 
			yyval.VClassOrAllClasses.VAllClasses->lex_allpos = GetTokenPos(yypvt[-0].VnameToken);
		} break;
case 48:
# line 570 "parse.y"
{	yyval.VAttributeOrAllAttributes.VAttributeRefs = NAttributeRefs;
			yyval.VAttributeOrAllAttributes.VAttributeRefs->lex_name = yypvt[-0].VAttributeRef->lex_name;
			yyval.VAttributeOrAllAttributes.VAttributeRefs->lex_namepos = yypvt[-0].VAttributeRef->lex_namepos;
		} break;
case 49:
# line 575 "parse.y"
{	yyval.VAttributeOrAllAttributes.VAllAttributes = NAllAttributes; 
			yyval.VAttributeOrAllAttributes.VAllAttributes->lex_allpos = GetTokenPos(yypvt[-0].VnameToken);
		} break;
case 50:
# line 583 "parse.y"
{	yyval.VProcessEntity = NProcessEntity;
			yyval.VProcessEntity->lex_name = yypvt[-5].VnameToken->lex_name;
			yyval.VProcessEntity->lex_namepos = yypvt[-5].VnameToken->lex_namepos;
			FreenameToken(yypvt[-5].VnameToken);
			yyval.VProcessEntity->lex_beginpos = GetKwdPos(yypvt[-6].VnameToken);
			yyval.VProcessEntity->lex_endpos = GetKwdPos(yypvt[-0].VnameToken);
			yyval.VProcessEntity->syn_refines = yypvt[-4].VProcessRefOrVoid;
			yyval.VProcessEntity->syn_invariant = yypvt[-3].VStructureRefOrVoid;
			yyval.VProcessEntity->syn_body = yypvt[-1].VLprocessStatement;
		} break;
case 51:
# line 596 "parse.y"
{	yyval.VProcessRefOrVoid.VVoid = NVoid; } break;
case 52:
# line 598 "parse.y"
{	yyval.VProcessRefOrVoid.VProcessRef = yypvt[-0].VProcessRef; } break;
case 53:
# line 602 "parse.y"
{	yyval.VStructureRefOrVoid.VVoid = NVoid; } break;
case 54:
# line 604 "parse.y"
{	yyval.VStructureRefOrVoid.VStructureRef = yypvt[-0].VStructureRef; } break;
case 55:
# line 608 "parse.y"
{	yyval.VprocessStatement.VportDefinition = yypvt[-0].VportDefinition; 
		} break;
case 56:
# line 611 "parse.y"
{	yyval.VprocessStatement.VAssertion = yypvt[-0].VAssertion; 
		} break;
case 57:
# line 614 "parse.y"
{	yyval.VprocessStatement.VDefInstance = yypvt[-0].VDefInstance; 
		} break;
case 58:
# line 617 "parse.y"
{	yyval.VprocessStatement.VportAssociation = yypvt[-0].VportAssociation; 
		} break;
case 59:
# line 620 "parse.y"
{	yyval.VprocessStatement.VtargetStmt = yypvt[-0].VtargetStmt; 
		} break;
case 60:
# line 623 "parse.y"
{	yyval.VprocessStatement.Vrestriction = yypvt[-0].Vrestriction; 
		} break;
case 61:
# line 626 "parse.y"
{	statement_error = TRUE;
			Recoverable0(53, lasttoken);
		} break;
case 62:
# line 632 "parse.y"
{	yyval.VportDefinition = NportDefinition;
			yyval.VportDefinition->syn_portType = yypvt[-1].VPortType;
			yyval.VportDefinition->syn_ports = yypvt[-0].VLPort;
			yyval.VportDefinition->lex_stmtpos = yypvt[-1].VPortType.IDLclassCommon->inv_pos;
			if (V2conform) {
			    if ((typeof(yypvt[-1].VPortType)==KMarkPort) ||
				(typeof(yypvt[-1].VPortType)==KUnmarkPort)) {
				Serious0(59, yyval.VportDefinition->lex_stmtpos);
			    }
			}
		} break;
case 63:
# line 646 "parse.y"
{	yyval.VPortType.VPrePort = NPrePort;
			yyval.VPortType.VPrePort->inv_pos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 64:
# line 650 "parse.y"
{	yyval.VPortType.VPostPort = NPostPort;
			yyval.VPortType.VPostPort->inv_pos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 65:
# line 666 "parse.y"
{	yyval.VPort = NPort;
			yyval.VPort->lex_name = yypvt[-2].VnameToken->lex_name;
			yyval.VPort->lex_namepos = yypvt[-2].VnameToken->lex_namepos;
			FreenameToken(yypvt[-2].VnameToken);
			yyval.VPort->syn_data = yypvt[-0].VStructureRef;
		} break;
case 66:
# line 675 "parse.y"
{	yyval.VportAssociation = NportAssociation;
			yyval.VportAssociation->syn_port = yypvt[-2].VPortRef;
			yyval.VportAssociation->syn_rep = yypvt[-0].VRepRef;
			yyval.VportAssociation->lex_stmtpos = GetKwdPos(yypvt[-3].VnameToken);
		} break;
case 67:
# line 684 "parse.y"
{	yyval.VtargetStmt = NtargetStmt;
			yyval.VtargetStmt->syn_id = yypvt[-0].VLparameter;
			yyval.VtargetStmt->lex_stmtpos = GetKwdPos(yypvt[-1].VnameToken);
			if (V2conform) {
			    Serious0(60, yyval.VtargetStmt->lex_stmtpos);
			}
		} break;
case 68:
# line 695 "parse.y"
{	yyval.Vrestriction.VtypeRestriction = NtypeRestriction;
			yyval.Vrestriction.VtypeRestriction->syn_type = yypvt[-2].VTypeOrAllTypes;
			yyval.Vrestriction.VtypeRestriction->syn_tofrom = yypvt[-1].VrestrictToOrFrom;
			yyval.Vrestriction.VtypeRestriction->syn_operations = yypvt[-0].VLOperRef;
			yyval.Vrestriction.VtypeRestriction->lex_stmtpos = GetKwdPos(yypvt[-3].VnameToken);
		} break;
case 69:
# line 703 "parse.y"
{	yyval.Vrestriction.VattributeRestriction = NattributeRestriction;
			yyval.Vrestriction.VattributeRestriction->syn_type = yypvt[-4].VTypeOrAllTypes;
			yyval.Vrestriction.VattributeRestriction->syn_attribute = yypvt[-2].VAttributeOrAllAttributes;
			yyval.Vrestriction.VattributeRestriction->syn_tofrom = yypvt[-1].VrestrictToOrFrom;
			yyval.Vrestriction.VattributeRestriction->syn_operations = yypvt[-0].VLOperRef;
			yyval.Vrestriction.VtypeRestriction->lex_stmtpos = GetKwdPos(yypvt[-5].VnameToken);
		} break;
case 70:
# line 712 "parse.y"
{	yyval.VrestrictToOrFrom.Vrestrictto = Nrestrictto;
		} break;
case 71:
# line 715 "parse.y"
{	yyval.VrestrictToOrFrom.Vrestrictfrom = Nrestrictfrom;
		} break;
case 72:
# line 720 "parse.y"
{	yyval.VTypeOrAllTypes.VTypeRef = yypvt[-0].VTypeRef; } break;
case 73:
# line 722 "parse.y"
{	yyval.VTypeOrAllTypes.VAllTypes = NAllTypes; 
			yyval.VTypeOrAllTypes.VAllTypes->lex_allpos = GetTokenPos(yypvt[-0].VnameToken);
		} break;
case 74:
# line 730 "parse.y"
{	yyval.VAssertion = NAssertion;
			if (typeof(yypvt[-2].VnameOrVoid) == KnameToken) {
			    yyval.VAssertion->lex_name = yypvt[-2].VnameOrVoid.VnameToken->lex_name;
			    yyval.VAssertion->lex_namepos = yypvt[-2].VnameOrVoid.VnameToken->lex_namepos;
			    FreenameToken(yypvt[-2].VnameOrVoid.VnameToken);
			}
			else yyval.VAssertion->lex_name = EMPTYSTRING;
			yyval.VAssertion->syn_body = yypvt[-0].Vexpression;
			yyval.VAssertion->lex_stmtpos = GetKwdPos(yypvt[-1].VnameToken);
		} break;
case 75:
# line 743 "parse.y"
{	yyval.VDefInstance.Vcyclicdef = yypvt[-0].Vcyclic; } break;
case 76:
# line 745 "parse.y"
{	yyval.VDefInstance.Vnoncyclicdef = yypvt[-0].Vnoncyclic; } break;
case 77:
# line 747 "parse.y"
{	yyval.VDefInstance.VPrivateDefInstance = yypvt[-0].VPrivateDefInstance; } break;
case 78:
# line 752 "parse.y"
{	yyval.Vcyclic = Ncyclicdef;
			yyval.Vcyclic->syn_def = yypvt[-5].VDefineRef;
			yyval.Vcyclic->lex_name = yypvt[-5].VDefineRef->lex_name;
			yyval.Vcyclic->lex_namepos = yypvt[-5].VDefineRef->lex_namepos;
			yyval.Vcyclic->syn_list = yypvt[-4].VLFormal;
			yyval.Vcyclic->syn_body = yypvt[-0].Vexpression;
			yyval.Vcyclic->lex_stmtpos = GetKwdPos(yypvt[-7].VnameToken);
			yyval.Vcyclic->syn_returnType = yypvt[-2].VTypeRef;
		} break;
case 79:
# line 765 "parse.y"
{	yyval.Vnoncyclic = Nnoncyclicdef;
			yyval.Vnoncyclic->syn_def = yypvt[-3].VDefineRef;
			yyval.Vnoncyclic->lex_name = yypvt[-3].VDefineRef->lex_name;
			yyval.Vnoncyclic->lex_namepos = yypvt[-3].VDefineRef->lex_namepos;
			yyval.Vnoncyclic->syn_list = yypvt[-2].VLFormal;
			yyval.Vnoncyclic->syn_body = yypvt[-0].Vexpression;
			yyval.Vnoncyclic->lex_stmtpos = GetKwdPos(yypvt[-4].VnameToken);
		} break;
case 80:
# line 776 "parse.y"
{	yyval.VPrivateDefInstance = NPrivateDefInstance;
			yyval.VPrivateDefInstance->syn_def = yypvt[-3].VDefineRef;
			yyval.VPrivateDefInstance->lex_name = yypvt[-3].VDefineRef->lex_name;
			yyval.VPrivateDefInstance->lex_namepos = yypvt[-3].VDefineRef->lex_namepos;
			yyval.VPrivateDefInstance->syn_list = yypvt[-2].VLFormal;
			yyval.VPrivateDefInstance->syn_returnType = yypvt[-0].VTypeRef;
			yyval.VPrivateDefInstance->lex_stmtpos = GetKwdPos(yypvt[-4].VnameToken);
		} break;
case 81:
# line 787 "parse.y"
{	yyval.VFormal = NFormal;
			yyval.VFormal->lex_name = yypvt[-2].VnameToken->lex_name;
			yyval.VFormal->lex_namepos = GetTokenPos(yypvt[-2].VnameToken);
			yyval.VFormal->syn_type = yypvt[-0].VTypeRef;
		} break;
case 82:
# line 796 "parse.y"
{	yyval.VexpOrVoid.Vexpression = yypvt[-0].Vexpression;
		} break;
case 83:
# line 799 "parse.y"
{
			yyval.VexpOrVoid.VVoid = NVoid;
		} break;
case 84:
# line 803 "parse.y"
{	yyval.Vexpression = yypvt[-1].Vexpression; } break;
case 85:
# line 805 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 86:
# line 807 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 87:
# line 809 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 88:
# line 811 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 89:
# line 813 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 90:
# line 815 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 91:
# line 817 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 92:
# line 819 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 93:
# line 821 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 94:
# line 823 "parse.y"
{	yyval.Vexpression = yypvt[-0].Vexpression; } break;
case 95:
# line 829 "parse.y"
{	yyval.Vexpression.Vconditional = Nconditional;
			yyval.Vexpression.Vconditional->syn_test = yypvt[-6].Vexpression;
			yyval.Vexpression.Vconditional->syn_then = yypvt[-4].Vexpression;
			yyval.Vexpression.Vconditional->syn_orif = yypvt[-3].VLexpressionPair;
			yyval.Vexpression.Vconditional->syn_else = yypvt[-1].Vexpression;
			yyval.Vexpression.Vconditional->lex_expos = GetKwdPos(yypvt[-7].VnameToken);
			yyval.Vexpression.Vconditional->lex_thenpos = GetKwdPos(yypvt[-5].VnameToken);
			yyval.Vexpression.Vconditional->lex_elsepos = GetKwdPos(yypvt[-2].VnameToken);
		} break;
case 96:
# line 840 "parse.y"
{	yyval.VexpressionPair = NexpressionPair;
			yyval.VexpressionPair->syn_test = yypvt[-2].Vexpression;
			yyval.VexpressionPair->syn_then = yypvt[-0].Vexpression;
			yyval.VexpressionPair->lex_orifpos = GetKwdPos(yypvt[-3].VnameToken);
			yyval.VexpressionPair->lex_thenpos = GetKwdPos(yypvt[-1].VnameToken);
		} break;
case 97:
# line 850 "parse.y"
{	yyval.Vexpression.Vquantifier = yypvt[-6].Vquantifier;
			yyval.Vexpression.Vquantifier.IDLclassCommon->syn_control = yypvt[-5].VControl;
			yyval.Vexpression.Vquantifier.IDLclassCommon->syn_set = yypvt[-3].Vexpression;
			yyval.Vexpression.Vquantifier.IDLclassCommon->syn_body = yypvt[-1].Vexpression;
		} break;
case 98:
# line 858 "parse.y"
{	yyval.Vquantifier.Vforallq = Nforallq; 
			yyval.Vquantifier.Vforallq->lex_expos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 99:
# line 862 "parse.y"
{	yyval.Vquantifier.Vexistsq = Nexistsq; 
			yyval.Vquantifier.Vexistsq->lex_expos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 100:
# line 871 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VandOp = NandOp;
		} break;
case 101:
# line 878 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VorOp = NorOp;
		} break;
case 102:
# line 885 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VisOp = NisOp;
		} break;
case 103:
# line 892 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VunionOp = NunionOp;
		} break;
case 104:
# line 899 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VintersectOp = NintersectOp;
		} break;
case 105:
# line 906 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vplus = Nplus;
		} break;
case 106:
# line 913 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vminus = Nminus;
		} break;
case 107:
# line 920 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vtimes = Ntimes;
		} break;
case 108:
# line 927 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vdivide = Ndivide;
		} break;
case 109:
# line 934 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vless = Nless;
		} break;
case 110:
# line 941 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VlessEq = NlessEq;
		} break;
case 111:
# line 948 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vgreater = Ngreater;
		} break;
case 112:
# line 955 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VgrtrEq = NgrtrEq;
		} break;
case 113:
# line 962 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vequal = Nequal;
		} break;
case 114:
# line 969 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VnotEqual = NnotEqual;
		} break;
case 115:
# line 976 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VsameOp = NsameOp;
		} break;
case 116:
# line 983 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VinSet = NinSet;
		} break;
case 117:
# line 990 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.Vsubset = Nsubset;
		} break;
case 118:
# line 997 "parse.y"
{	yyval.Vexpression.Vbinary = Nbinary;
			yyval.Vexpression.Vbinary->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vbinary->syn_right = yypvt[-0].Vexpression;
			yyval.Vexpression.Vbinary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
			yyval.Vexpression.Vbinary->syn_op.VpropSubset = NpropSubset;
		} break;
case 119:
# line 1006 "parse.y"
{	yyval.Vexpression.Vunary = Nunary;
			yyval.Vexpression.Vunary->syn_body = yypvt[-0].Vexpression;
			yyval.Vexpression.Vunary->syn_op.VUnaryPlus = NUnaryPlus;
			yyval.Vexpression.Vunary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
		} break;
case 120:
# line 1012 "parse.y"
{	yyval.Vexpression.Vunary = Nunary;
			yyval.Vexpression.Vunary->syn_body = yypvt[-0].Vexpression;
			yyval.Vexpression.Vunary->syn_op.VUnaryMinus = NUnaryMinus;
			yyval.Vexpression.Vunary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
		} break;
case 121:
# line 1018 "parse.y"
{	yyval.Vexpression.Vunary = Nunary;
			yyval.Vexpression.Vunary->syn_body = yypvt[-0].Vexpression;
			yyval.Vexpression.Vunary->syn_op.VnotOp = NnotOp;
			yyval.Vexpression.Vunary->lex_expos = GetKwdPos(yypvt[-1].VnameToken);
		} break;
case 122:
# line 1026 "parse.y"
{	yyval.Vexpression.Vapplication = Napplication;
			yyval.Vexpression.Vapplication->syn_instance = yypvt[-3].VDefInstanceOrDefineRef;
			yyval.Vexpression.Vapplication->syn_arguments = yypvt[-1].VLexpression;
			yyval.Vexpression.Vapplication->lex_expos = yypvt[-3].VDefInstanceOrDefineRef->lex_namepos;
		} break;
case 123:
# line 1033 "parse.y"
{	yyval.Vexpression.Vdotted = Ndotted;
			yyval.Vexpression.Vdotted->syn_left = yypvt[-2].Vexpression;
			yyval.Vexpression.Vdotted->syn_right = yypvt[-0].VAttributeRef;
			yyval.Vexpression.Vdotted->lex_expos = GetTokenPos(yypvt[-1].VnameToken);
		} break;
case 124:
# line 1040 "parse.y"
{	yyval.Vexpression.VportExpression = NportExpression;
			yyval.Vexpression.VportExpression->syn_portName = yypvt[-2].VPortRef;
			yyval.Vexpression.VportExpression->syn_type = yypvt[-0].VTypeRef;
			yyval.Vexpression.VportExpression->lex_expos = GetTokenPos(yypvt[-1].VnameToken);
		} break;
case 125:
# line 1047 "parse.y"
{	yyval.Vexpression.VExpSetRef = NExpSetRef;
			yyval.Vexpression.VExpSetRef->syn_component = yypvt[-0].VSetRef->syn_component;
			yyval.Vexpression.VExpSetRef->lex_expos = yypvt[-0].VSetRef->lex_keywordpos;
		} break;
case 126:
# line 1052 "parse.y"
{	yyval.Vexpression.VExpSeqRef = NExpSeqRef;
			yyval.Vexpression.VExpSeqRef->syn_component = yypvt[-0].VSeqRef->syn_component;
			yyval.Vexpression.VExpSeqRef->lex_expos = yypvt[-0].VSeqRef->lex_keywordpos;
		} break;
case 127:
# line 1057 "parse.y"
{	yyval.Vexpression.VExpNameRef = NExpNameRef;
			yyval.Vexpression.VExpNameRef->lex_name = yypvt[-0].VnameToken->lex_name;
			yyval.Vexpression.VExpNameRef->lex_expos = GetTokenPos(yypvt[-0].VnameToken);
		} break;
case 128:
# line 1064 "parse.y"
{	yyval.Vexpression.VtrueExp = NtrueExp; 
			yyval.Vexpression.VtrueExp->lex_expos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 129:
# line 1068 "parse.y"
{	yyval.Vexpression.VfalseExp = NfalseExp; 
			yyval.Vexpression.VfalseExp->lex_expos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 130:
# line 1072 "parse.y"
{	yyval.Vexpression.VemptyExp = NemptyExp; 
			yyval.Vexpression.VemptyExp->lex_expos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 131:
# line 1076 "parse.y"
{	yyval.Vexpression.VrootExp = yypvt[-0].Vroot; 
		} break;
case 132:
# line 1079 "parse.y"
{	yyval.Vexpression.VintegerToken = yypvt[-0].VintegerToken;
		} break;
case 133:
# line 1082 "parse.y"
{	yyval.Vexpression.VrationalToken = yypvt[-0].VrationalToken;
		} break;
case 134:
# line 1085 "parse.y"
{	yyval.Vexpression.VstringToken = yypvt[-0].VstringToken;
		} break;
case 135:
# line 1089 "parse.y"
{	
			yyval.Vexpression.VcaseExp = NcaseExp;
			yyval.Vexpression.VcaseExp->syn_casename = yypvt[-8].VCaseName;
			yyval.Vexpression.VcaseExp->syn_exp = yypvt[-6].Vexpression;
			yyval.Vexpression.VcaseExp->syn_select = yypvt[-5].VLcase_select;
			yyval.Vexpression.VcaseExp->syn_otherwise = yypvt[-2].VexpOrVoid;
			yyval.Vexpression.VcaseExp->lex_expos = GetKwdPos(yypvt[-9].VnameToken);
		} break;
case 136:
# line 1098 "parse.y"
{	
			yyval.Vexpression.VcaseExp = NcaseExp;
			yyval.Vexpression.VcaseExp->syn_casename = yypvt[-4].VCaseName;
			yyval.Vexpression.VcaseExp->syn_exp = yypvt[-2].Vexpression;
			yyval.Vexpression.VcaseExp->syn_select = yypvt[-1].VLcase_select;
			yyval.Vexpression.VcaseExp->syn_otherwise.VVoid = NVoid;
			yyval.Vexpression.VcaseExp->lex_expos = GetKwdPos(yypvt[-5].VnameToken);
		} break;
case 137:
# line 1109 "parse.y"
{
			yyval.Vcase_select = Ncase_select;
			yyval.Vcase_select->syn_type = yypvt[-3].VTypeRef;
			yyval.Vcase_select->syn_exp = yypvt[-1].Vexpression;
		} break;
case 138:
# line 1117 "parse.y"
{	yyval.Vroot = NrootExp;
			yyval.Vroot->syn_portName.VPortRef = yypvt[-2].VPortRef;
			yyval.Vroot->lex_expos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 139:
# line 1122 "parse.y"
{	yyval.Vroot = NrootExp;
			yyval.Vroot->syn_portName.VVoid = NVoid;
			yyval.Vroot->lex_expos = GetKwdPos(yypvt[-0].VnameToken);
		} break;
case 140:
# line 1130 "parse.y"
{	yyval.Vparameter.VnameToken = yypvt[-0].VnameToken; } break;
case 141:
# line 1132 "parse.y"
{	yyval.Vparameter.VintegerToken = yypvt[-0].VintegerToken; } break;
case 142:
# line 1134 "parse.y"
{	yyval.Vparameter.VrationalToken = yypvt[-0].VrationalToken; } break;
case 143:
# line 1136 "parse.y"
{	yyval.Vparameter.VstringToken = yypvt[-0].VstringToken; } break;
case 144:
# line 1138 "parse.y"
{	yyval.Vparameter.VnameToken = yypvt[-0].VnameToken; 
			if (!V2conform) {
			    /* change so it will be invalid for post IDL82 */
			    yyval.Vparameter.VnameToken->lex_name = "?";
			}
		} break;
case 145:
# line 1145 "parse.y"
{	yyval.Vparameter.VnameToken = yypvt[-0].VnameToken; 
			if (V2conform) {
			    Serious0(57, GetKwdPos(yypvt[-0].VnameToken));
			}
		} break;
case 146:
# line 1154 "parse.y"
{	yyval.VnameToken = yypvt[-0].VnameToken;
		} break;
case 147:
# line 1159 "parse.y"
{	yyval.VintegerToken = NintegerToken;
			yyval.VintegerToken->lex_externalform = yypvt[-0].VnameToken->lex_name;
			yyval.VintegerToken->lex_expos = yypvt[-0].VnameToken->lex_namepos;
		} break;
case 148:
# line 1166 "parse.y"
{	yyval.VrationalToken = NrationalToken;
			yyval.VrationalToken->lex_externalform = yypvt[-0].VnameToken->lex_name;
			yyval.VrationalToken->lex_expos = yypvt[-0].VnameToken->lex_namepos;
		} break;
case 149:
# line 1173 "parse.y"
{	yyval.VstringToken = NstringToken;
			yyval.VstringToken->lex_externalform = yypvt[-0].VnameToken->lex_name;
			yyval.VstringToken->lex_expos = yypvt[-0].VnameToken->lex_namepos;
		} break;
case 150:
# line 1180 "parse.y"
{	yyval.VAssertRef = NAssertRef;
			AssignRef(yyval.VAssertRef,yypvt[-0].VnameToken);
		} break;
case 151:
# line 1185 "parse.y"
{	yyval.VAttributeRef = NAttributeRef;
			AssignRef(yyval.VAttributeRef,yypvt[-0].VnameToken);
		} break;
case 152:
# line 1190 "parse.y"
{	yyval.VCaseName = NCaseName;
			AssignRef(yyval.VCaseName,yypvt[-0].VnameToken);
		} break;
case 153:
# line 1195 "parse.y"
{	yyval.VcompUnitRef = NcompUnitRef;
			AssignRef(yyval.VcompUnitRef, yypvt[-0].VnameToken);
		} break;
case 154:
# line 1200 "parse.y"
{	yyval.VControl = NControl;
			AssignRef(yyval.VControl,yypvt[-0].VnameToken);
		} break;
case 155:
# line 1205 "parse.y"
{	yyval.VDefineRef = NDefineRef;
			AssignRef(yyval.VDefineRef,yypvt[-0].VnameToken);
		} break;
case 156:
# line 1210 "parse.y"
{	yyval.VDefInstanceOrDefineRef = NDefInstanceOrDefineRef;
			AssignRef(yyval.VDefInstanceOrDefineRef,yypvt[-0].VnameToken);
		} break;
case 157:
# line 1215 "parse.y"
{	yyval.VNamedTypeRef = NNamedTypeRef;
			AssignRef(yyval.VNamedTypeRef,yypvt[-0].VnameToken);
		} break;
case 158:
# line 1220 "parse.y"
{	yyval.VOperRef = NOperRef;
			AssignRef(yyval.VOperRef,yypvt[-0].VnameToken);
		} break;
case 159:
# line 1225 "parse.y"
{	yyval.VPortRef = NPortRef;
			AssignRef(yyval.VPortRef,yypvt[-0].VnameToken);
		} break;
case 160:
# line 1230 "parse.y"
{	yyval.VProcessRef = NProcessRef;
			AssignRef(yyval.VProcessRef,yypvt[-0].VnameToken);
		} break;
case 161:
# line 1235 "parse.y"
{	yyval.VStructureOrProcessRef = NStructureOrProcessRef;
			AssignRef(yyval.VStructureOrProcessRef,yypvt[-0].VnameToken);
		} break;
case 162:
# line 1240 "parse.y"
{	yyval.VStructureRef = NStructureRef;
			AssignRef(yyval.VStructureRef,yypvt[-0].VnameToken);
		} break;
case 163:
# line 1245 "parse.y"
{	yyval.VTypeRef.VNamedTypeRef = yypvt[-0].VNamedTypeRef; } break;
case 164:
# line 1247 "parse.y"
{	yyval.VTypeRef.VSetOrSeqRef = yypvt[-0].VSetOrSeqRef; } break;
case 165:
# line 1251 "parse.y"
{	yyval.VSetOrSeqRef.VSetRef = yypvt[-0].VSetRef; } break;
case 166:
# line 1253 "parse.y"
{	yyval.VSetOrSeqRef.VSeqRef = yypvt[-0].VSeqRef; } break;
case 167:
# line 1258 "parse.y"
{	yyval.VSetRef = NSetRef;
			yyval.VSetRef->syn_component = yypvt[-0].VNamedTypeRef;
			yyval.VSetRef->lex_keywordpos = GetKwdPos(yypvt[-2].VnameToken);
		} break;
case 168:
# line 1265 "parse.y"
{	yyval.VSeqRef = NSeqRef;
			yyval.VSeqRef->syn_component = yypvt[-0].VNamedTypeRef;
			yyval.VSeqRef->lex_keywordpos = GetKwdPos(yypvt[-2].VnameToken);
		} break;
case 169:
# line 1274 "parse.y"
{	yyval.VnameOrVoid.VVoid = NVoid; } break;
case 170:
# line 1276 "parse.y"
{	yyval.VnameOrVoid.VnameToken = yypvt[-0].VnameToken; } break;
case 172:
# line 1283 "parse.y"
{	yyval.VLAttribute = NULL; } break;
case 173:
# line 1285 "parse.y"
{	yyval.VLAttribute = yypvt[-0].VLAttribute; } break;
case 174:
# line 1289 "parse.y"
{	yyval.VLAttribute = NULL; 
			appendrearSEQAttribute(yyval.VLAttribute, yypvt[-0].VAttribute); } break;
case 175:
# line 1292 "parse.y"
{	appendrearSEQAttribute(yypvt[-2].VLAttribute, yypvt[-0].VAttribute);
			yyval.VLAttribute = yypvt[-2].VLAttribute;
		} break;
case 176:
# line 1297 "parse.y"
{	yyval.VLcase_select = NULL;
		} break;
case 177:
# line 1300 "parse.y"
{	appendrearSEQcase_select(yypvt[-1].VLcase_select, yypvt[-0].Vcase_select);
			yyval.VLcase_select = yypvt[-1].VLcase_select;
		} break;
case 178:
# line 1305 "parse.y"
{	yyval.VLexpression = NULL; 
			appendrearSEQexpression(yyval.VLexpression, yypvt[-0].Vexpression); } break;
case 179:
# line 1308 "parse.y"
{	appendrearSEQexpression(yypvt[-2].VLexpression, yypvt[-0].Vexpression);
			yyval.VLexpression = yypvt[-2].VLexpression;
		} break;
case 180:
# line 1313 "parse.y"
{	yyval.VLexpressionPair = NULL; } break;
case 181:
# line 1315 "parse.y"
{ 	appendrearSEQexpressionPair(yypvt[-1].VLexpressionPair, yypvt[-0].VexpressionPair);
			yyval.VLexpressionPair = yypvt[-1].VLexpressionPair;
		} break;
case 182:
# line 1320 "parse.y"
{	yyval.VLFormal = NULL; } break;
case 183:
# line 1322 "parse.y"
{	yyval.VLFormal = yypvt[-1].VLFormal; } break;
case 184:
# line 1326 "parse.y"
{	yyval.VLFormal = NULL; 
			appendrearSEQFormal(yyval.VLFormal, yypvt[-0].VFormal); } break;
case 185:
# line 1329 "parse.y"
{	appendrearSEQFormal(yypvt[-2].VLFormal, yypvt[-0].VFormal);
			yyval.VLFormal = yypvt[-2].VLFormal;
		} break;
case 186:
# line 1335 "parse.y"
{	yyval.VLOperRef = NULL; 
			appendrearSEQOperRef(yyval.VLOperRef, yypvt[-0].VOperRef); } break;
case 187:
# line 1338 "parse.y"
{	appendrearSEQOperRef(yypvt[-2].VLOperRef, yypvt[-0].VOperRef);
			yyval.VLOperRef = yypvt[-2].VLOperRef;
		} break;
case 188:
# line 1344 "parse.y"
{	yyval.VLparameter = NULL; 
			appendrearSEQparameter(yyval.VLparameter, yypvt[-0].Vparameter);
		} break;
case 189:
# line 1348 "parse.y"
{	appendrearSEQparameter(yypvt[-1].VLparameter, yypvt[-0].Vparameter);
			yyval.VLparameter = yypvt[-1].VLparameter;
		} break;
case 190:
# line 1354 "parse.y"
{	yyval.VLPort = NULL; 
			appendrearSEQPort(yyval.VLPort, yypvt[-0].VPort); } break;
case 191:
# line 1357 "parse.y"
{	appendrearSEQPort(yypvt[-2].VLPort, yypvt[-0].VPort);
			yyval.VLPort = yypvt[-2].VLPort;
		} break;
case 192:
# line 1362 "parse.y"
{	yyval.VLprocessStatement = NULL; } break;
case 193:
# line 1364 "parse.y"
{	if (statement_error)
			 statement_error = FALSE;
			else
			 appendrearSEQprocessStatement(yypvt[-2].VLprocessStatement, yypvt[-1].VprocessStatement);
			yyval.VLprocessStatement = yypvt[-2].VLprocessStatement;
		} break;
case 194:
# line 1373 "parse.y"
{	yyval.VLDeclaration = NULL; 
			if (declaration_error)
			    declaration_error = FALSE;
			else appendrearSEQDeclaration(yyval.VLDeclaration, yypvt[-0].VDeclaration);
		} break;
case 195:
# line 1379 "parse.y"
{ 	
			if (declaration_error)
			    declaration_error = FALSE;
			else appendrearSEQDeclaration(yypvt[-1].VLDeclaration, yypvt[-0].VDeclaration);
			yyval.VLDeclaration = yypvt[-1].VLDeclaration;
		} break;
case 196:
# line 1387 "parse.y"
{	yyval.VLStPrRef = NULL; 
			appendrearSEQStructureOrProcessRef(yyval.VLStPrRef, yypvt[-0].VStructureOrProcessRef); } break;
case 197:
# line 1390 "parse.y"
{	appendrearSEQStructureOrProcessRef(yypvt[-2].VLStPrRef, yypvt[-0].VStructureOrProcessRef);
			yyval.VLStPrRef = yypvt[-2].VLStPrRef;
		} break;
case 198:
# line 1395 "parse.y"
{	yyval.VLStructureRef = NULL; 
			appendrearSEQStructureRef(yyval.VLStructureRef, yypvt[-0].VStructureRef); } break;
case 199:
# line 1398 "parse.y"
{	appendrearSEQStructureRef(yypvt[-2].VLStructureRef, yypvt[-0].VStructureRef);
			yyval.VLStructureRef = yypvt[-2].VLStructureRef;
		} break;
case 200:
# line 1403 "parse.y"
{	yyval.VLstructureStatement = NULL; } break;
case 201:
# line 1405 "parse.y"
{	if (statement_error)
			 statement_error = FALSE;
			else 
			 appendrearSEQstructureStatement(yypvt[-2].VLstructureStatement, yypvt[-1].VstructureStatement);
			yyval.VLstructureStatement = yypvt[-2].VLstructureStatement;
		} break;
case 202:
# line 1413 "parse.y"
{	yyval.VLNamedTypeRef = NULL; } break;
case 203:
# line 1415 "parse.y"
{	yyval.VLNamedTypeRef = yypvt[-0].VLNamedTypeRef;   } break;
case 204:
# line 1418 "parse.y"
{	yyval.VLNamedTypeRef = NULL;
			appendrearSEQNamedTypeRef(yyval.VLNamedTypeRef, yypvt[-0].VNamedTypeRef);
		} break;
case 205:
# line 1422 "parse.y"
{	appendrearSEQNamedTypeRef(yypvt[-2].VLNamedTypeRef, yypvt[-0].VNamedTypeRef);
			yyval.VLNamedTypeRef = yypvt[-2].VLNamedTypeRef;
		} break;
case 206:
# line 1427 "parse.y"
{	yyval.VLwithoutItem = NULL; 
			appendrearSEQwithoutItem(yyval.VLwithoutItem, yypvt[-0].VwithoutItem); } break;
case 207:
# line 1430 "parse.y"
{	appendrearSEQwithoutItem(yypvt[-2].VLwithoutItem, yypvt[-0].VwithoutItem);
			yyval.VLwithoutItem = yypvt[-2].VLwithoutItem;
		} break;
		}
		goto yystack;  /* stack new state and value */

	}
