/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/frontend/preparse.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Frontend.h"
#include "error.h"
#include <stdio.h>

SEQfiletransition buildtransitions(allfiles, beginpos)
FileSeq allfiles;	/* seq of file names and ptrs */
int beginpos;		/* beginning position first transition starts with */
{
    SEQfiletransition alltransitions;
    filetransition newtransition;
    SEQFilenameAndPtr Sf;
    FilenameAndPtr Af;
    long currentpos;
    long GetFileSize();

    /* initialize */
    currentpos = beginpos;
    initializeSEQfiletransition(alltransitions);

    /* process each file argument */
    foreachinSEQFilenameAndPtr(allfiles->files, Sf, Af) {

	/* create a new transition for file */
	newtransition = Nfiletransition;
	newtransition->filename = Af->name;
	newtransition->charoffset = currentpos;
	newtransition->filelinenumber = 1;

	/* count number of bytes in file and increment current pos */
	currentpos += GetFileSize(Af->ptr);

	/* add transition to sequence */
	appendrearSEQfiletransition(alltransitions, newtransition);
    }
    return(alltransitions);
}
