%{
/* ******************************************************************* *\
*									*
*   File: scorpion/src/idlc/frontend/parse.y
*									*
*   Copyright (C) 1991 Tim Maroney, Richard Snodgrass, Karen Shannon
*									*
*   The Scorpion System is free software in the public domain; you can  *
*   redistribute it and/or modify it as you wish. We ask that you 	*
*   retain credits referencing the University of Arizona and that you	*
*   identify any changes you make.					*
*									*
*   Report problems to scorpion-project@cs.arizona.edu			*
*   Direct all inquiries to:	The Scorpion Project			*
*				Department of Computer Science		*
*				Gould-Simpson Building			*
*				University of Arizona			*
*				Tucson, AZ 85721			*
*				U.S.A.					*
*									*
*   Function: Yacc code to recognize IDL notation grammar		*
*									*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: parse.y,v 1.1 89/07/05 16:30:40 kps Locked $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	parse.y,v $
 * Revision 1.1  89/07/05  16:30:40  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:01:14  cheung
 * parse.y  Ver 4.0
 * 
 * Revision 3.9  89/03/30  11:48:28  cheung
 * parse.y  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:58:37  cheung
 * parse.y  Ver 3.9
 * 
 * Revision 1.1  87/04/18  11:18:12  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*     March 1985 (shannon) Edited to add new list routines		*
*									*
\* ******************************************************************* */
# include <stdio.h>
# include "Frontend.h"
#include "macros.h"
extern compilationUnit TheCompUnit;

extern FILE *errout;
extern Boolean V2conform;
Boolean declaration_error = FALSE;
Boolean statement_error = FALSE;
Boolean has_syntax_error = FALSE; 
extern int lineNumber;
extern int charcount;
extern int lasttoken;
parameter aparm, parm1, parm2, parm3;	/* temporary parameters */
nameToken name;				/* temporary name */
extern Boolean instructure, inprocess;
extern SEQString  structurelexinfo, 
		  processlexinfo, 
		  importlexinfo,
		  compUnitlexinfo;
%}


%token  BAR COMMA LEFTPAREN RIGHTPAREN 
%token  Do Fi From Import Inv Od Refines Returns To Use 

%token  <VnameToken> DUMMY1 DUMMY2 DUMMY3 DUMMY4 DUMMY5 DUMMY6 DUMMY7 DUMMY8 
%token	<VnameToken> And Assert Case Cyclic Define
%token	<VnameToken> Else Empty End Exists 
%token  <VnameToken> False For ForAll If In Intersect Is Mark Not 
%token	<VnameToken> Of Or OrIf Otherwise Post Pre Process Psub 
%token	<VnameToken> Restrict Root Same 
%token	<VnameToken> Seq Set Structure Sub 
%token	<VnameToken> Target Then True Type Union Unmark Without

%token	<VnameToken> NAME INTEGER RATIONAL STRING

%token	<VnameToken> ANGLEARROW COLON COLONARROW DOT EQUAL
%token	<VnameToken> GREATER GREATEROREQ
%token	<VnameToken> LESS LESSOREQ MINUS NOTEQUAL PLUS
%token	<VnameToken> SEMICOLON SLASH STAR

%left	Or Union
%left	And Intersect 
%left	Not Is
%left	EQUAL NOTEQUAL LESS LESSOREQ GREATER GREATEROREQ In Same Psub Sub
%left	PLUS MINUS
%left	STAR SLASH
%right  DOT

%type	<VintegerToken> _integerToken
%type	<VrationalToken> _rationalToken
%type	<VnameToken> _nameToken
%type	<VstringToken> _stringToken

%type <Vexpression> _application
%type <VAssertion> _Assertion
%type <VAssertRef> _AssertRef
%type <VatomicDecl> _atomicDecl
%type <VAttribute> _Attribute
%type <VAttributeOrAllAttributes> _AttributeOrAllAttributes
%type <VattributeProduction> _attributeProduction
%type <VAttributeRef> _AttributeRef
%type <VattributeRep> _attributeRep
%type <Vexpression> _binary
%type <Vexpression> _caseExp
%type <Vcase_select> _case_select
%type <VLcase_select> _Lcase_select
%type <VClassOrAllClasses> _ClassOrAllClasses
%type <VcompUnitRef> _compRef
%type <Vexpression> _conditional
%type <VCaseName> _CaseName
%type <VControl> _Control
%type <Vcyclic> _cyclic
%type <VDeclaration> _Declaration
%type <VDefineRef> _DefineRef
%type <VDefInstance> _DefInstance
%type <VDefInstanceOrDefineRef> _DefInstanceOrDefineRef
%type <Vexpression> _dotted
%type <Vexpression> _expRef
%type <Vexpression> _expression 
%type <VexpOrVoid> _expOrVoid
%type <VexpressionPair> _expressionPair
%type <VFormal> _Formal
%type <VLAttribute> _LAttribute __LAttribute
%type <VLexpression> _Lexpression
%type <VLexpressionPair> _LexpressionPair
%type <VLFormal> _LFormal __LFormal
%type <Vexpression> _literal
%type <VLNamedTypeRef> _Lsubclasses _Lsubclasses2
%type <VLOperRef> _LOperRef
%type <VLparameter> _Lparameter
%type <VLPort> _LPort
%type <VLprocessStatement> _LprocessStatement
%type <VLDeclaration> _LDeclaration
%type <VLStructureRef> from _LStructureRef
%type <VLStPrRef> _LStPrRef
%type <VLstructureStatement> _LstructureStatement
%type <VLwithoutItem> _LwithoutItem
%type <VnameOrVoid> _nameOrVoid 
%type <VNamedTypeRef> _NamedTypeRef 
%type <Vnoncyclic> _noncyclic
%type <VOperRef> _OperRef
%type <Vparameter> _parameter
%type <VPort> _Port
%type <VportAssociation> _portAssociation
%type <VportDefinition> _portDefinition
%type <Vexpression> _portExpression
%type <VPortRef> _PortRef
%type <VPortType> _PortType
%type <VPrivateDefInstance> _PrivateDefInstance
%type <VProcessEntity> _ProcessEntity
%type <VProcessRef> _ProcessRef
%type <VProcessRefOrVoid> Prrefines 
%type <VprocessStatement> _processStatement
%type <Vproduction> _production
%type <Vexpression> _quantifier 
%type <Vquantifier> _quantifier2
%type <Vrestriction> _restriction
%type <VrestrictToOrFrom> _restrictToOrFrom
%type <VRepRef> _RepRef
%type <Vroot> _root
%type <VSeqRef> _SeqRef
%type <VSetOrSeqRef> _SetOrSeqRef
%type <VSetRef> _SetRef
%type <VStructureOrProcessRef> _StPrRef
%type <VStructureEntity> _StructureEntity
%type <VStructureOrProcess> _StructureOrProcess
%type <VStructureRef> _StructureRef
%type <VStructureRefOrVoid> invar Strefines
%type <VstructureStatement> _structureStatement
%type <VsubclassProduction> _subclassProduction
%type <VtargetStmt> _targetStmt
%type <VTypeOrAllTypes> _TypeOrAllTypes
%type <VTypeRef> _TypeRef
%type <VTypeRefOrVoid> structRoot
%type <VtypeRepDecl> _typeRepDecl
%type <Vexpression> _unary
%type <VwithoutAssert> _withoutAssert
%type <VwithoutAttribute> _withoutAttribute
%type <VwithoutClause> _withoutClause
%type <VwithoutDefine> _withoutDefine
%type <VwithoutItem> _withoutItem
%type <VwithoutProduction> _withoutProduction
%type <VwithoutSubclass> _withoutSubclass
%type <VwithoutType> _withoutType _withoutType2


%union {
Assertion VAssertion;
AssertRef VAssertRef;
atomicDecl VatomicDecl;
Attribute VAttribute;
AttributeOrAllAttributes VAttributeOrAllAttributes;
attributeProduction VattributeProduction;
AttributeRef VAttributeRef;
attributeRep VattributeRep;
CaseName VCaseName;
case_select Vcase_select;
SEQcase_select VLcase_select;
ClassOrAllClasses VClassOrAllClasses;
compUnitRef VcompUnitRef;
Control VControl;
cyclicdef Vcyclic;
Declaration VDeclaration;
DefineRef VDefineRef;
DefInstance VDefInstance;
DefInstanceOrDefineRef VDefInstanceOrDefineRef;
expression Vexpression;
expressionOrVoid VexpOrVoid;
expressionPair VexpressionPair;
Formal VFormal;
integerToken VintegerToken;
SEQAttribute VLAttribute;
SEQexpression VLexpression;
SEQexpressionPair VLexpressionPair;
SEQFormal VLFormal;
SEQNamedTypeRef VLNamedTypeRef;
SEQOperRef VLOperRef;
SEQparameter VLparameter;
SEQPort VLPort;
SEQprocessStatement VLprocessStatement;
SEQDeclaration VLDeclaration;
SEQStructureRef VLStructureRef;
SEQStructureOrProcessRef VLStPrRef;
SEQstructureStatement VLstructureStatement;
SEQwithoutItem VLwithoutItem;
NamedTypeRef VNamedTypeRef;
nameOrVoid VnameOrVoid;
nameToken VnameToken;
noncyclicdef Vnoncyclic;
OperRef VOperRef;
parameter Vparameter;
Port VPort;
portAssociation VportAssociation;
portDefinition VportDefinition;
PortRef VPortRef;
PortType VPortType;
PrivateDefInstance VPrivateDefInstance;
ProcessEntity VProcessEntity;
ProcessRef VProcessRef;
ProcessRefOrVoid VProcessRefOrVoid;
processStatement VprocessStatement;
production Vproduction;
quantifier Vquantifier;
rationalToken VrationalToken;
RepRef VRepRef;
restriction Vrestriction;
restrictToOrFrom VrestrictToOrFrom;
rootExp Vroot;
SeqRef VSeqRef;
SetOrSeqRef VSetOrSeqRef;
SetRef VSetRef;
stringToken VstringToken;
StructureEntity VStructureEntity;
StructureOrProcess VStructureOrProcess;
StructureOrProcessRef VStructureOrProcessRef;
StructureRef VStructureRef;
StructureRefOrVoid VStructureRefOrVoid;
structureStatement VstructureStatement;
subclassProduction VsubclassProduction;
targetStmt VtargetStmt;
TypeOrAllTypes VTypeOrAllTypes;
TypeRef VTypeRef;
TypeRefOrVoid VTypeRefOrVoid;
typeRepDecl VtypeRepDecl;
withoutAssert VwithoutAssert;
withoutAttribute VwithoutAttribute;
withoutClause VwithoutClause;
withoutDefine VwithoutDefine;
withoutItem VwithoutItem;
withoutProduction VwithoutProduction;
withoutSubclass VwithoutSubclass;
withoutType VwithoutType;
}


%start _compilationUnit

%%

_compilationUnit:	NOTHING
		{	TheCompUnit = NcompilationUnit;
		}
		|	_LDeclaration
		{	TheCompUnit = NcompilationUnit;
			TheCompUnit->syn_body = $1;
			if (!has_syntax_error)
			    TheCompUnit->lex_information = compUnitlexinfo;
		}
		;

_Declaration	:	_StructureOrProcess
		{	$$.VStructureOrProcess = $1;
		}
		|	Import _LStPrRef From _compRef End
		{	$$.VImportDecl = NImportDecl;
			if (!has_syntax_error)
			    $$.VImportDecl->lex_information = importlexinfo;
			$$.VImportDecl->syn_specs = $2;
			$$.VImportDecl->syn_compUnit = $4;
		}
		|	error End
		{	Recoverable0(51, lasttoken);
			declaration_error = TRUE;
			yyerrok;
			yyclearin;
		}
		;

_StructureOrProcess	
		:	_ProcessEntity
		{	$$.VProcessEntity = $1; 
			if (!has_syntax_error)
			    $$.VProcessEntity->lex_information = processlexinfo;
			initializeSEQString(processlexinfo);
		}
		|	_StructureEntity
		{	$$.VStructureEntity = $1; 
			if (!has_syntax_error)
			    $$.VStructureEntity->lex_information = structurelexinfo;
			initializeSEQString(structurelexinfo);
		}
		;


_StructureEntity:	Structure _nameToken structRoot Strefines from
			Is _LstructureStatement End
		{	$$ = NStructureEntity;
			$$->lex_beginpos = GetKwdPos($1);
			$$->lex_endpos = GetKwdPos($8);
			$$->lex_name = $2->lex_name;
			$$->lex_namepos = $2->lex_namepos;
			FreenameToken($2);
			$$->syn_root = $3;
			$$->syn_refines = $4;
			$$->syn_from = $5;
			$$->syn_body = $7;
		}
		;

structRoot		:	NOTHING
		{	$$.VVoid = NVoid; }
		|	Root _NamedTypeRef
		{	$$.VNamedTypeRef = $2; 
		}
		;

Strefines	:	NOTHING
		{	$$.VVoid = NVoid; }
		|	Refines _StructureRef
		{	$$.VStructureRef = $2; }
		;

from		:	NOTHING
		{	$$ = NULL; }
		|	From _LStructureRef
		{	$$ = $2; }
		;

_structureStatement:	_production
		{	$$.Vproduction = $1; 
		}
		|	_atomicDecl
		{	$$.VatomicDecl = $1; 
		}
		|	_attributeRep
		{	$$.VattributeRep = $1;
		}
		|	_typeRepDecl
		{	$$.VtypeRepDecl = $1; 
		}
		|	_withoutClause
		{	$$.VwithoutClause = $1; 
		}
		|	_Assertion
		{	$$.VAssertion = $1; 
		}
		|	_DefInstance
		{	$$.VDefInstance = $1;
		}
		|	error
		{	statement_error = TRUE;
			Recoverable0(52, lasttoken);
		}
		;


_production	:	_subclassProduction
		{	$$.VsubclassProduction = $1; }
		|	_attributeProduction
		{	$$.VattributeProduction = $1; }
		;

_subclassProduction:	_NamedTypeRef COLONARROW _Lsubclasses
		{	$$ = NsubclassProduction;
			$$->syn_class = $1;
			$$->syn_subclasses = $3;
			$$->lex_stmtpos = GetTokenPos($2);
		}
		;

_attributeProduction	
		:	_NamedTypeRef ANGLEARROW _LAttribute
		{	$$ = NattributeProduction;
			$$->syn_class = $1;
			$$->syn_attributes = $3;
			$$->lex_stmtpos = GetTokenPos($2);
		}
		;

_Attribute	:	_nameToken COLON _TypeRef
		{	$$ = NAttribute;
			$$->lex_name = $1->lex_name;
			$$->lex_namepos = $1->lex_namepos;
			FreenameToken($1);
			$$->syn_type = $3;
		}
		;

_atomicDecl	:	Type _NamedTypeRef
		{	$$ = NatomicDecl;
			$$->syn_atomic = $2;
			$$->lex_stmtpos = GetKwdPos($1);
		}
		;


_attributeRep	:	For _NamedTypeRef DOT _AttributeRef Use _RepRef
		{	$$ = NattributeRep;
			$$->syn_class = $2;
			$$->syn_attribute = $4;
			$$->syn_rep = $6;
			$$->lex_stmtpos = GetKwdPos($1);
		}
		;

_RepRef		:	_Lparameter
		{	$$ = NRepRef;
			$$->syn_id = $1;
		}
		;

_typeRepDecl	:	For _TypeRef Use _RepRef
		{	$$ = NtypeRepDecl;
			$$->syn_type = $2;
			if (V2conform) {
			    if (typeof($2)!=KNamedTypeRef) {
				Serious0(56, $2.VSetOrSeqRef.IDLclassCommon
						->lex_keywordpos);
			    }
			}
			$$->syn_spec = $4;
			$$->lex_stmtpos = GetKwdPos($1);
		}
		;


_withoutClause	:	Without _LwithoutItem
		{	$$ = NwithoutClause;
			$$->syn_list = $2;
			$$->lex_stmtpos = GetKwdPos($1);
		}
		;

_withoutItem	:	_withoutAssert
		{	$$.VwithoutAssert = $1; }
		|	_withoutDefine
		{	$$.VwithoutDefine = $1; }
		|	_withoutType
		{	$$.VwithoutType = $1; }
		|	_withoutType2
		{	$$.VwithoutType = $1; }
		|	_withoutProduction
		{	$$.VwithoutProduction = $1; }
		;
_withoutAssert	:	Assert _AssertRef
		{	$$ = NwithoutAssert;
			$$->syn_item = $2;
			$$->lex_itempos = GetKwdPos($1);
			if (V2conform) {
			    Serious0(58, $$->lex_itempos);
			}
		}
		;
_withoutDefine	:	Define _DefineRef
		{	$$ = NwithoutDefine;
			$$->syn_item = $2;
			$$->lex_itempos = GetKwdPos($1);
			if (V2conform) {
			    Serious0(58, $$->lex_itempos);
			}
		}
		;
_withoutType	:	Type _TypeRef
		{	$$ = NwithoutType;
			$$->syn_item = $2;
			$$->lex_itempos = GetKwdPos($1);
			if (V2conform) {
			    Serious0(58, $$->lex_itempos);
			}
		}
_withoutType2	:	_NamedTypeRef
		{	/* for version 2.0 of IDL */
		 	$$ = NwithoutType;
			$$->syn_item.VNamedTypeRef = $1;
			$$->lex_itempos = $1->lex_namepos;
		}
		;

_withoutProduction:	_withoutSubclass
		{	$$.VwithoutSubclass = $1; }
		|	_withoutAttribute
		{	$$.VwithoutAttribute = $1; }
		;

_withoutSubclass:	_ClassOrAllClasses COLONARROW _ClassOrAllClasses
		{	$$ = NwithoutSubclass;
			$$->syn_lefthandside = $1;
			$$->syn_righthandside = $3;
			$$->lex_itempos = GetTokenPos($2);
			if (V2conform) {
			    if ((typeof($1)==KAllClasses) || 
				(typeof($3)==KAllClasses)) {
				Serious0(58, $$->lex_itempos);
			    }
			}
		}
		;

_withoutAttribute:	_ClassOrAllClasses ANGLEARROW _AttributeOrAllAttributes
		{	$$ = NwithoutAttribute;
			$$->syn_lefthandside = $1;
			$$->syn_righthandside = $3;
			$$->lex_itempos = GetTokenPos($2);
			if (V2conform) {
			    if ((typeof($1)==KAllClasses) || 
				(typeof($3)==KAllAttributes)) {
				Serious0(58, $$->lex_itempos);
			    }
			}
		}
		;
_ClassOrAllClasses:	_NamedTypeRef
		{	$$.VNamedTypeRef = $1; }
		|	STAR
		{	$$.VAllClasses = NAllClasses; 
			$$.VAllClasses->lex_allpos = GetTokenPos($1);
		}
		;

_AttributeOrAllAttributes:
			_AttributeRef
		{	$$.VAttributeRefs = NAttributeRefs;
			$$.VAttributeRefs->lex_name = $1->lex_name;
			$$.VAttributeRefs->lex_namepos = $1->lex_namepos;
		}
		|	STAR
		{	$$.VAllAttributes = NAllAttributes; 
			$$.VAllAttributes->lex_allpos = GetTokenPos($1);
		}
		;


_ProcessEntity	:	Process _nameToken Prrefines invar
			Is _LprocessStatement End
		{	$$ = NProcessEntity;
			$$->lex_name = $2->lex_name;
			$$->lex_namepos = $2->lex_namepos;
			FreenameToken($2);
			$$->lex_beginpos = GetKwdPos($1);
			$$->lex_endpos = GetKwdPos($7);
			$$->syn_refines = $3;
			$$->syn_invariant = $4;
			$$->syn_body = $6;
		}
		;

Prrefines	:	NOTHING
		{	$$.VVoid = NVoid; }
		|	Refines _ProcessRef
		{	$$.VProcessRef = $2; }
		;
	
invar		:	NOTHING
		{	$$.VVoid = NVoid; }
		|	Inv _StructureRef
		{	$$.VStructureRef = $2; }
		;

_processStatement:	_portDefinition
		{	$$.VportDefinition = $1; 
		}
		|	_Assertion
		{	$$.VAssertion = $1; 
		}
		|	_DefInstance
		{	$$.VDefInstance = $1; 
		}
		|	_portAssociation
		{	$$.VportAssociation = $1; 
		}
		|	_targetStmt
		{	$$.VtargetStmt = $1; 
		}
		|	_restriction
		{	$$.Vrestriction = $1; 
		}
		|	error
		{	statement_error = TRUE;
			Recoverable0(53, lasttoken);
		}
		;

_portDefinition	:	_PortType _LPort
		{	$$ = NportDefinition;
			$$->syn_portType = $1;
			$$->syn_ports = $2;
			$$->lex_stmtpos = $1.IDLclassCommon->inv_pos;
			if (V2conform) {
			    if ((typeof($1)==KMarkPort) ||
				(typeof($1)==KUnmarkPort)) {
				Serious0(59, $$->lex_stmtpos);
			    }
			}
		}
		;

_PortType	:	Pre
		{	$$.VPrePort = NPrePort;
			$$.VPrePort->inv_pos = GetKwdPos($1);
		}
		|	Post
		{	$$.VPostPort = NPostPort;
			$$.VPostPort->inv_pos = GetKwdPos($1);
		}
		/****
		|	Mark
		{	$$.VMarkPort = NMarkPort;
			$$.VMarkPort->inv_pos = GetKwdPos($1);
		}
		|	Unmark
		{	$$.VUnmarkPort = NUnmarkPort;
			$$.VUnmarkPort->inv_pos = GetKwdPos($1);
		}
			****/
		;

_Port		:	_nameToken COLON _StructureRef
		{	$$ = NPort;
			$$->lex_name = $1->lex_name;
			$$->lex_namepos = $1->lex_namepos;
			FreenameToken($1);
			$$->syn_data = $3;
		}
		;

_portAssociation:	For _PortRef Use _RepRef
		{	$$ = NportAssociation;
			$$->syn_port = $2;
			$$->syn_rep = $4;
			$$->lex_stmtpos = GetKwdPos($1);
		}
		;


_targetStmt	:	Target _Lparameter
		{	$$ = NtargetStmt;
			$$->syn_id = $2;
			$$->lex_stmtpos = GetKwdPos($1);
			if (V2conform) {
			    Serious0(60, $$->lex_stmtpos);
			}
		}
		;


_restriction	:	Restrict _TypeOrAllTypes _restrictToOrFrom  _LOperRef
		{	$$.VtypeRestriction = NtypeRestriction;
			$$.VtypeRestriction->syn_type = $2;
			$$.VtypeRestriction->syn_tofrom = $3;
			$$.VtypeRestriction->syn_operations = $4;
			$$.VtypeRestriction->lex_stmtpos = GetKwdPos($1);
		}
		|	Restrict _TypeOrAllTypes DOT _AttributeOrAllAttributes 
			_restrictToOrFrom  _LOperRef
		{	$$.VattributeRestriction = NattributeRestriction;
			$$.VattributeRestriction->syn_type = $2;
			$$.VattributeRestriction->syn_attribute = $4;
			$$.VattributeRestriction->syn_tofrom = $5;
			$$.VattributeRestriction->syn_operations = $6;
			$$.VtypeRestriction->lex_stmtpos = GetKwdPos($1);
		}
		;
_restrictToOrFrom:	To 
		{	$$.Vrestrictto = Nrestrictto;
		}
		|	From 
		{	$$.Vrestrictfrom = Nrestrictfrom;
		}
		;

_TypeOrAllTypes:	_TypeRef
		{	$$.VTypeRef = $1; }
		|	STAR
		{	$$.VAllTypes = NAllTypes; 
			$$.VAllTypes->lex_allpos = GetTokenPos($1);
		}
		;



_Assertion	:	_nameOrVoid Assert _expression
		{	$$ = NAssertion;
			if (typeof($1) == KnameToken) {
			    $$->lex_name = $1.VnameToken->lex_name;
			    $$->lex_namepos = $1.VnameToken->lex_namepos;
			    FreenameToken($1.VnameToken);
			}
			else $$->lex_name = EMPTYSTRING;
			$$->syn_body = $3;
			$$->lex_stmtpos = GetKwdPos($2);
		}
		;

_DefInstance	:	_cyclic
		{	$$.Vcyclicdef = $1; }
		|	_noncyclic
		{	$$.Vnoncyclicdef = $1; }
		|	_PrivateDefInstance
		{	$$.VPrivateDefInstance = $1; }
		;

_cyclic		:	Cyclic Define _DefineRef _LFormal 
			Returns _TypeRef EQUAL _expression
		{	$$ = Ncyclicdef;
			$$->syn_def = $3;
			$$->lex_name = $3->lex_name;
			$$->lex_namepos = $3->lex_namepos;
			$$->syn_list = $4;
			$$->syn_body = $8;
			$$->lex_stmtpos = GetKwdPos($1);
			$$->syn_returnType = $6;
		}
		;


_noncyclic	:	Define _DefineRef _LFormal EQUAL _expression
		{	$$ = Nnoncyclicdef;
			$$->syn_def = $2;
			$$->lex_name = $2->lex_name;
			$$->lex_namepos = $2->lex_namepos;
			$$->syn_list = $3;
			$$->syn_body = $5;
			$$->lex_stmtpos = GetKwdPos($1);
		}
		;

_PrivateDefInstance:	Define _DefineRef _LFormal Returns _TypeRef
		{	$$ = NPrivateDefInstance;
			$$->syn_def = $2;
			$$->lex_name = $2->lex_name;
			$$->lex_namepos = $2->lex_namepos;
			$$->syn_list = $3;
			$$->syn_returnType = $5;
			$$->lex_stmtpos = GetKwdPos($1);
		}
		;

_Formal		:	NAME COLON _TypeRef
		{	$$ = NFormal;
			$$->lex_name = $1->lex_name;
			$$->lex_namepos = GetTokenPos($1);
			$$->syn_type = $3;
		}
		;


_expOrVoid	: 	_expression
		{	$$.Vexpression = $1;
		}
		|	NOTHING
		{
			$$.VVoid = NVoid;
		}
_expression	:	LEFTPAREN _expression RIGHTPAREN
		{	$$ = $2; }
		| 	_conditional
		{	$$ = $1; }
		|	_quantifier
		{	$$ = $1; }
		|	_binary
		{	$$ = $1; }
		|	_unary
		{	$$ = $1; }
		|	_application
		{	$$ = $1; }
		|	_dotted
		{	$$ = $1; }
		|	_portExpression
		{	$$ = $1; }
		|	_expRef
		{	$$ = $1; }
		|	_literal
		{	$$ = $1; }
		|	_caseExp
		{	$$ = $1; }
		;


_conditional	:	If _expression Then _expression _LexpressionPair
			Else _expression Fi
		{	$$.Vconditional = Nconditional;
			$$.Vconditional->syn_test = $2;
			$$.Vconditional->syn_then = $4;
			$$.Vconditional->syn_orif = $5;
			$$.Vconditional->syn_else = $7;
			$$.Vconditional->lex_expos = GetKwdPos($1);
			$$.Vconditional->lex_thenpos = GetKwdPos($3);
			$$.Vconditional->lex_elsepos = GetKwdPos($6);
		}
		;
_expressionPair	:	OrIf _expression Then _expression
		{	$$ = NexpressionPair;
			$$->syn_test = $2;
			$$->syn_then = $4;
			$$->lex_orifpos = GetKwdPos($1);
			$$->lex_thenpos = GetKwdPos($3);
		}
		;

_quantifier	:	_quantifier2 _Control In _expression 
			Do _expression Od
		{	$$.Vquantifier = $1;
			$$.Vquantifier.IDLclassCommon->syn_control = $2;
			$$.Vquantifier.IDLclassCommon->syn_set = $4;
			$$.Vquantifier.IDLclassCommon->syn_body = $6;
		}
		;

_quantifier2	:	ForAll
		{	$$.Vforallq = Nforallq; 
			$$.Vforallq->lex_expos = GetKwdPos($1);
		}
		|	Exists
		{	$$.Vexistsq = Nexistsq; 
			$$.Vexistsq->lex_expos = GetKwdPos($1);
		}
		;




_binary		:	_expression And _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VandOp = NandOp;
		}
		|	_expression Or _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VorOp = NorOp;
		}
		|	_expression Is _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VisOp = NisOp;
		}
		|	_expression Union _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VunionOp = NunionOp;
		}
		|	_expression Intersect _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VintersectOp = NintersectOp;
		}
		|	_expression PLUS _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vplus = Nplus;
		}
		|	_expression MINUS _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vminus = Nminus;
		}
		|	_expression STAR _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vtimes = Ntimes;
		}
		|	_expression SLASH _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vdivide = Ndivide;
		}
		|	_expression LESS _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vless = Nless;
		}
		|	_expression LESSOREQ _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VlessEq = NlessEq;
		}
		|	_expression GREATER _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vgreater = Ngreater;
		}
		|	_expression GREATEROREQ _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VgrtrEq = NgrtrEq;
		}
		|	_expression EQUAL _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vequal = Nequal;
		}
		|	_expression NOTEQUAL _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VnotEqual = NnotEqual;
		}
		|	_expression Same _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VsameOp = NsameOp;
		}
		|	_expression In _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VinSet = NinSet;
		}
		|	_expression Sub _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.Vsubset = Nsubset;
		}
		|	_expression Psub _expression
		{	$$.Vbinary = Nbinary;
			$$.Vbinary->syn_left = $1;
			$$.Vbinary->syn_right = $3;
			$$.Vbinary->lex_expos = GetKwdPos($2);
			$$.Vbinary->syn_op.VpropSubset = NpropSubset;
		}
		;

_unary		:	PLUS _expression
		{	$$.Vunary = Nunary;
			$$.Vunary->syn_body = $2;
			$$.Vunary->syn_op.VUnaryPlus = NUnaryPlus;
			$$.Vunary->lex_expos = GetKwdPos($1);
		}
		|	MINUS _expression
		{	$$.Vunary = Nunary;
			$$.Vunary->syn_body = $2;
			$$.Vunary->syn_op.VUnaryMinus = NUnaryMinus;
			$$.Vunary->lex_expos = GetKwdPos($1);
		}
		|	Not _expression
		{	$$.Vunary = Nunary;
			$$.Vunary->syn_body = $2;
			$$.Vunary->syn_op.VnotOp = NnotOp;
			$$.Vunary->lex_expos = GetKwdPos($1);
		}
		;
_application    :	_DefInstanceOrDefineRef 
			LEFTPAREN _Lexpression RIGHTPAREN
		{	$$.Vapplication = Napplication;
			$$.Vapplication->syn_instance = $1;
			$$.Vapplication->syn_arguments = $3;
			$$.Vapplication->lex_expos = $1->lex_namepos;
		}
		;
_dotted		:	_expression DOT _AttributeRef
		{	$$.Vdotted = Ndotted;
			$$.Vdotted->syn_left = $1;
			$$.Vdotted->syn_right = $3;
			$$.Vdotted->lex_expos = GetTokenPos($2);
		}
		;
_portExpression	:	_PortRef COLON _TypeRef
		{	$$.VportExpression = NportExpression;
			$$.VportExpression->syn_portName = $1;
			$$.VportExpression->syn_type = $3;
			$$.VportExpression->lex_expos = GetTokenPos($2);
		}
		;
_expRef		:	_SetRef
		{	$$.VExpSetRef = NExpSetRef;
			$$.VExpSetRef->syn_component = $1->syn_component;
			$$.VExpSetRef->lex_expos = $1->lex_keywordpos;
		}
		|	_SeqRef
		{	$$.VExpSeqRef = NExpSeqRef;
			$$.VExpSeqRef->syn_component = $1->syn_component;
			$$.VExpSeqRef->lex_expos = $1->lex_keywordpos;
		}
		|	NAME
		{	$$.VExpNameRef = NExpNameRef;
			$$.VExpNameRef->lex_name = $1->lex_name;
			$$.VExpNameRef->lex_expos = GetTokenPos($1);
		}
		;

_literal	:	True
		{	$$.VtrueExp = NtrueExp; 
			$$.VtrueExp->lex_expos = GetKwdPos($1);
		}
		|	False
		{	$$.VfalseExp = NfalseExp; 
			$$.VfalseExp->lex_expos = GetKwdPos($1);
		}
		|	Empty
		{	$$.VemptyExp = NemptyExp; 
			$$.VemptyExp->lex_expos = GetKwdPos($1);
		}
		|	_root
		{	$$.VrootExp = $1; 
		}
		|	_integerToken
		{	$$.VintegerToken = $1;
		}
		|	_rationalToken
		{	$$.VrationalToken = $1;
		}
		|	_stringToken
		{	$$.VstringToken = $1;
		}
_caseExp	:	Case _CaseName Is _expression _Lcase_select 
			Otherwise Do _expOrVoid Od End
		{	
			$$.VcaseExp = NcaseExp;
			$$.VcaseExp->syn_casename = $2;
			$$.VcaseExp->syn_exp = $4;
			$$.VcaseExp->syn_select = $5;
			$$.VcaseExp->syn_otherwise = $8;
			$$.VcaseExp->lex_expos = GetKwdPos($1);
		}
		| 	Case _CaseName Is _expression _Lcase_select End
		{	
			$$.VcaseExp = NcaseExp;
			$$.VcaseExp->syn_casename = $2;
			$$.VcaseExp->syn_exp = $4;
			$$.VcaseExp->syn_select = $5;
			$$.VcaseExp->syn_otherwise.VVoid = NVoid;
			$$.VcaseExp->lex_expos = GetKwdPos($1);
		}
		;

_case_select	:	_TypeRef Do _expression Od
		{
			$$ = Ncase_select;
			$$->syn_type = $1;
			$$->syn_exp = $3;
		}
		;

_root		:	_PortRef COLON Root
		{	$$ = NrootExp;
			$$->syn_portName.VPortRef = $1;
			$$->lex_expos = GetKwdPos($3);
		}
		|	Root
		{	$$ = NrootExp;
			$$->syn_portName.VVoid = NVoid;
			$$->lex_expos = GetKwdPos($1);
		}
		;


_parameter	:	_nameToken
		{	$$.VnameToken = $1; }
		|	_integerToken
		{	$$.VintegerToken = $1; }
		|	_rationalToken 
		{	$$.VrationalToken = $1; }
		|	_stringToken
		{	$$.VstringToken = $1; }
		|	DOT
		{	$$.VnameToken = $1; 
			if (!V2conform) {
			    /* change so it will be invalid for post IDL82 */
			    $$.VnameToken->lex_name = "?";
			}
		}
		|	Type
		{	$$.VnameToken = $1; 
			if (V2conform) {
			    Serious0(57, GetKwdPos($1));
			}
		}
		;


_nameToken	:	NAME
		{	$$ = $1;
		}
		;

_integerToken	:	INTEGER
		{	$$ = NintegerToken;
			$$->lex_externalform = $1->lex_name;
			$$->lex_expos = $1->lex_namepos;
		}
		;

_rationalToken	:	RATIONAL
		{	$$ = NrationalToken;
			$$->lex_externalform = $1->lex_name;
			$$->lex_expos = $1->lex_namepos;
		}
		;

_stringToken	:	STRING
		{	$$ = NstringToken;
			$$->lex_externalform = $1->lex_name;
			$$->lex_expos = $1->lex_namepos;
		}
		;

_AssertRef	:	NAME
		{	$$ = NAssertRef;
			AssignRef($$,$1);
		}
		;
_AttributeRef	:	NAME
		{	$$ = NAttributeRef;
			AssignRef($$,$1);
		}
		;
_CaseName	:	NAME
		{	$$ = NCaseName;
			AssignRef($$,$1);
		}
		;
_compRef	:	NAME
		{	$$ = NcompUnitRef;
			AssignRef($$, $1);
		}
		;
_Control	:	NAME
		{	$$ = NControl;
			AssignRef($$,$1);
		}
		;
_DefineRef	:	NAME
		{	$$ = NDefineRef;
			AssignRef($$,$1);
		}
		;
_DefInstanceOrDefineRef:	NAME
		{	$$ = NDefInstanceOrDefineRef;
			AssignRef($$,$1);
		}
		;
_NamedTypeRef	:	NAME
		{	$$ = NNamedTypeRef;
			AssignRef($$,$1);
		}
		;
_OperRef	:	NAME
		{	$$ = NOperRef;
			AssignRef($$,$1);
		}
		;
_PortRef	:	NAME
		{	$$ = NPortRef;
			AssignRef($$,$1);
		}
		;
_ProcessRef	:	NAME
		{	$$ = NProcessRef;
			AssignRef($$,$1);
		}
		;
_StPrRef	:	NAME
		{	$$ = NStructureOrProcessRef;
			AssignRef($$,$1);
		}
		;
_StructureRef	:	NAME
		{	$$ = NStructureRef;
			AssignRef($$,$1);
		}
		;
_TypeRef	:	_NamedTypeRef
		{	$$.VNamedTypeRef = $1; }
		|	_SetOrSeqRef
		{	$$.VSetOrSeqRef = $1; }
		;

_SetOrSeqRef	:	_SetRef
		{	$$.VSetRef = $1; }
		|	_SeqRef
		{	$$.VSeqRef = $1; }
		;


_SetRef		:	Set Of _NamedTypeRef
		{	$$ = NSetRef;
			$$->syn_component = $3;
			$$->lex_keywordpos = GetKwdPos($1);
		}
		;

_SeqRef		:	Seq Of _NamedTypeRef
		{	$$ = NSeqRef;
			$$->syn_component = $3;
			$$->lex_keywordpos = GetKwdPos($1);
		}
		;



_nameOrVoid	:	NOTHING
		{	$$.VVoid = NVoid; }
		|	_nameToken
		{	$$.VnameToken = $1; }
		;
NOTHING		:	;



_LAttribute	:	NOTHING
		{	$$ = NULL; }
		|	__LAttribute
		{	$$ = $1; }
		;

__LAttribute	:	_Attribute
		{	$$ = NULL; 
			appendrearSEQAttribute($$, $1); }
		|	__LAttribute COMMA _Attribute
		{	appendrearSEQAttribute($1, $3);
			$$ = $1;
		}
		;
_Lcase_select	:	NOTHING
		{	$$ = NULL;
		}
		|	_Lcase_select _case_select
		{	appendrearSEQcase_select($1, $2);
			$$ = $1;
		}
		;
_Lexpression	:	_expression
		{	$$ = NULL; 
			appendrearSEQexpression($$, $1); }
		|	_Lexpression COMMA _expression
		{	appendrearSEQexpression($1, $3);
			$$ = $1;
		}
		;
_LexpressionPair:	NOTHING
		{	$$ = NULL; }
		|	_LexpressionPair _expressionPair
		{ 	appendrearSEQexpressionPair($1, $2);
			$$ = $1;
		}
		;
_LFormal	:	NOTHING
		{	$$ = NULL; }
		|	LEFTPAREN __LFormal RIGHTPAREN
		{	$$ = $2; }
		;

__LFormal	:	_Formal
		{	$$ = NULL; 
			appendrearSEQFormal($$, $1); }
		|	__LFormal COMMA _Formal
		{	appendrearSEQFormal($1, $3);
			$$ = $1;
		}
		;

_LOperRef	:	_OperRef
		{	$$ = NULL; 
			appendrearSEQOperRef($$, $1); }
		|	_LOperRef COMMA _OperRef
		{	appendrearSEQOperRef($1, $3);
			$$ = $1;
		}
		;

_Lparameter	:	_parameter
		{	$$ = NULL; 
			appendrearSEQparameter($$, $1);
		}
		|	_Lparameter _parameter
		{	appendrearSEQparameter($1, $2);
			$$ = $1;
		}
		;

_LPort		:	_Port
		{	$$ = NULL; 
			appendrearSEQPort($$, $1); }
		|	_LPort COMMA _Port
		{	appendrearSEQPort($1, $3);
			$$ = $1;
		}
		;
_LprocessStatement:	NOTHING
		{	$$ = NULL; }
		|	_LprocessStatement _processStatement SEMICOLON
		{	if (statement_error)
			 statement_error = FALSE;
			else
			 appendrearSEQprocessStatement($1, $2);
			$$ = $1;
		}
		;

_LDeclaration	:	_Declaration
		{	$$ = NULL; 
			if (declaration_error)
			    declaration_error = FALSE;
			else appendrearSEQDeclaration($$, $1);
		}
		|	_LDeclaration _Declaration
		{ 	
			if (declaration_error)
			    declaration_error = FALSE;
			else appendrearSEQDeclaration($1, $2);
			$$ = $1;
		}
		;
_LStPrRef	:	_StPrRef
		{	$$ = NULL; 
			appendrearSEQStructureOrProcessRef($$, $1); }
		|	_LStPrRef COMMA _StPrRef
		{	appendrearSEQStructureOrProcessRef($1, $3);
			$$ = $1;
		}
		;
_LStructureRef	:	_StructureRef
		{	$$ = NULL; 
			appendrearSEQStructureRef($$, $1); }
		|	_LStructureRef COMMA _StructureRef
		{	appendrearSEQStructureRef($1, $3);
			$$ = $1;
		}
		;
_LstructureStatement:	NOTHING
		{	$$ = NULL; }
		|	_LstructureStatement _structureStatement SEMICOLON
		{	if (statement_error)
			 statement_error = FALSE;
			else 
			 appendrearSEQstructureStatement($1, $2);
			$$ = $1;
		}
		;
_Lsubclasses	:	NOTHING
		{	$$ = NULL; }
		|	_Lsubclasses2 
		{	$$ = $1;   }
		;
_Lsubclasses2	:	_NamedTypeRef
		{	$$ = NULL;
			appendrearSEQNamedTypeRef($$, $1);
		}
		|	_Lsubclasses2 BAR _NamedTypeRef 
		{	appendrearSEQNamedTypeRef($1, $3);
			$$ = $1;
		}
		;	
_LwithoutItem	:	_withoutItem
		{	$$ = NULL; 
			appendrearSEQwithoutItem($$, $1); }
		|	_LwithoutItem COMMA _withoutItem
		{	appendrearSEQwithoutItem($1, $3);
			$$ = $1;
		}
		;

%%


yyerror(s) char *s;
{	has_syntax_error = TRUE; }
