/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/frontend/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Frontend.h"
#include "macros.h"
#include <stdio.h>
#include <ctype.h>

compilationUnit TheCompUnit;

extern FILE *yyin;	/* the file sent to yyparse */
FILE *errout;		/* the error file */
extern int lasttoken;	/* position of last token parsed */
extern int charcount;	/* position of current character+1 */
Boolean V2conform=FALSE;/* indicator if conformance to IDL version 2.0 
			   should be enforced */
FileSeq allfiles;	/* sequence of file names and ptrs */
Boolean SeriousError=FALSE;
			/* indicator if there is a serious error */

/* the keyword structure */
extern keyword IDLkeywords[];
extern int num_IDLkeywords;


main(argc, argv)
int argc;
char *argv[];
{	
	int i;
	FILE *fp, *fopen();
	FILE *csout;
	register keyword *kwdptr;
	int sourcepos=1;
	FilenameAndPtr afile;
	SEQfiletransition thetransitions;
	Boolean no_lexinfo = FALSE;
	SEQDeclaration SDecl;
	Declaration ADecl;
	SEQfiletransition buildtransitions();
	FILE *GetNextFilePtr();
        void exit();

	/* initialize */
	errout = stderr;
	allfiles = NFileSeq;
	csout = stdout;

	for (i=1; i<argc; i++) {
	    /* verbose flag */
	    if (!strcmp(argv[i], "-v")) {
		(void) fprintf(stderr, "idlc: syntax analysis\n");
		(void) fflush(stderr);
	    }
	    /* IDL82 conformance flag */
	    else if (!strcmp(argv[i], "-V2")) {
		V2conform = TRUE;
	    }
	    else if (!strcmp(argv[i], "-nl")) {
		no_lexinfo = TRUE;
	    }
	    /* error file flag */
	    else if (!strcmp(argv[i], "-e")) {
		if (i+1 >= argc)
		    Fatal0(16, 0);
		else {
		    ++i;
		    if ((errout = fopen(argv[i], "w")) == NULL)
			Fatal1(17, 0, argv[i]);
		}
	    }
	    /* output file indicator */
	    else if (!strcmp(argv[i], "-f")) {
		if (i+1 >= argc)
		    Fatal1(22, 0, argv[i]);
		else {
		    ++i;
		    if ((csout = fopen(argv[i], "w")) == NULL)
			Fatal1(23, 0, argv[i]);
		}
	    }
	    /* source position indicator flag */
	    else if (!strcmp(argv[i], "-p")) {
		if (i+1 >= argc) {
		    Fatal1(22, 0, argv[i]);
		}
		else {
		    ++i;
		    if (isdigit(argv[i][0])) {
		       sourcepos = atoi(argv[i]);
		       charcount = sourcepos;
		    }
		    else Fatal1(23, 0, argv[i]);
		}
	    }
	    /* input file names */
	    else if (argv[i][0] != '-') {
		if ((fp=fopen(argv[i],"r"))==NULL) {
		    Fatal1(12,0, argv[i]);
		}
		else {
		    afile = NFilenameAndPtr;
		    afile->name = NewString(argv[i]);
		    afile->ptr = fp;
		    appendrearSEQFilenameAndPtr(allfiles->files, afile);
		}
	    }
	    else Warning1(13, 0, argv[i]);
	}


	/* determine number of keywords */
	num_IDLkeywords=0;
	for (kwdptr = IDLkeywords; kwdptr->characters != NULL; kwdptr++) {
	    ++num_IDLkeywords;
	}

	/* build transition structure */
	thetransitions = buildtransitions(allfiles, sourcepos);

	/* parse the input using the first file or stdin */
	if (!emptySEQFilenameAndPtr(allfiles->files))
	    yyin = GetNextFilePtr(allfiles);
	if (yyparse()){
		Fatal0(50, lasttoken);
		exit(1);
	}
	else if (1 || !SeriousError) {	/* always print out for now */
		TheCompUnit->lex_beginpos = sourcepos;
		TheCompUnit->lex_endpos = charcount-1;
		TheCompUnit->syn_transitions = thetransitions;
		if (no_lexinfo) {
		    foreachinSEQDeclaration(TheCompUnit->syn_body, SDecl,ADecl){
			/*ADecl.IDLclassCommon->lex_information = NULL;*/
			if (typeof(ADecl)==KStructureEntity)
			    ADecl.VStructureEntity->lex_information = NULL;
			else if (typeof(ADecl)==KProcessEntity)
			    ADecl.VProcessEntity->lex_information = NULL;
			else
			    ADecl.VImportDecl->lex_information = NULL;
		    }
		}
		ParseTreeOut(csout,TheCompUnit);
	}
        return 0;
}

FILE *GetNextFilePtr(allfiles)
FileSeq allfiles;
{
    FilenameAndPtr file;
    FILE *returnptr=NULL;

    if (!emptySEQFilenameAndPtr(allfiles->files)) {
	retrievefirstSEQFilenameAndPtr(allfiles->files, file);
	returnptr = file->ptr;
	allfiles->files = tailSEQFilenameAndPtr(allfiles->files);
    }
    return(returnptr);
}
