/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/frontend/macros.h 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Macros for commonly used defines 				*
*									*
*									*
\* ******************************************************************* */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	macros.h,v $
 * Revision 4.2  90/08/20  16:11:32  hkaram
 * @
 * 
 * Revision 1.1  89/07/05  16:30:25  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  00:59:04  cheung
 * macros.h  Ver 4.0
 * 
 * Revision 3.9  89/03/30  11:46:51  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:57:27  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:35:28  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:19:25  shannon
 * Initial revision
 * 
 * Revision 1.1  85/06/11  10:20:14  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

/* the keyword structure */
typedef struct {
    int token;		/* token value for this keyword */
    char *characters;	/* actual characters in keyword */
    char *lowercase;	/* characters in all lowercase */
} keyword;

/* macro for comparing strings */
#define strequal(s1, s2) !strcmp(s1,s2)
#define StringCmp(s1, s2) strcmp(s1,s2)

/* macros for parser */
#define GetKwdPos(k) k->lex_namepos
#define GetTokenPos(t) t->lex_namepos
#define AssignRef(r, n) \
	r->lex_name = n->lex_name; \
	r->lex_namepos = n->lex_namepos;
#define FreenameToken(n)
#define NewnameToken() NnameToken
#define EMPTYSTRING "\0"

/* macros for error handling */
#include "error.h"
