# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) (void) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* ******************************************************************* *\
*									*
*   Title: 	parse phase of the IDL translator			*
*   Filename:	/usr/softlab/src/idlc/Frontend/idltokens.l		*
*   Author:	Tim Maroney						*
*		Richard Snodgrass <rts@unc>				*
*		Karen Shannon <shannon@unc>				*
*		Department of Computer Science				*
*		University of North Carolina				*
*		Chapel Hill, NC  27514					*
*									*
*   Copyright (C) The University of North Carolina, 1985		*
*									*
*   All rights reserved. No part of this software may be sold or	*
*   distributed in any form or by any means without the prior written	*
*   permission of the SoftLab Software Distribution Coordinator.	*
*									*
*   Report problems to	softlab@unc (csnet) or				*
*			softlab!unc@CSNET-RELAY (ARPAnet)		*
*   Direct all inquiries to the SoftLab Software Distribution		*
*	Coordinator, at the above addresses.				*
*									*
*   Function: Lex code for recognizing IDL notation			*
*									*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/idlc/frontend/RCS/idltokens.l,v 4.0 89/04/12 00:58:53 cheung Exp Locker: cheung $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	idltokens.l,v $
 * Revision 4.0  89/04/12  00:58:53  cheung
 * idltokens.l  Ver 4.0
 * 
 * Revision 3.9  89/03/30  11:46:40  cheung
 * idltokens.l  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:57:11  cheung
 * idltokens.l  Ver 3.9
 * 
 * Revision 3.3  88/04/06  11:32:12  rajan
 * Some changes made to the frontend so that the strings in Candle are
 * set up right. This is especially for reserved words. This
 * modification done by Rick Snodgrass
 * Changed lex_information attribute for DOT, True, False, and Empty. rts
 * 
 * Revision 3.2  88/02/19  18:58:51  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:18:06  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:35:58  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.2  85/07/05  20:50:32  shannon
 * added new token Unmark for unmarker ports
 * 
 * Revision 1.1  85/06/11  10:25:24  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*									*
\* ******************************************************************* */

# include "Frontend.h"
# include "macros.h"
# include <ctype.h>
# include  <string.h>
# include "yacc_parse.h"
extern YYSTYPE yylval;
char *String_convert();
int lineNumber=1;
int charcount=1;
int lasttoken=1;
extern Boolean V2conform;

String lastlexinfo="\0";
char *templexinfo;
SEQString structurelexinfo, 
	  processlexinfo, 
	  importlexinfo,
	  compUnitlexinfo;
Boolean  instructure = FALSE,
	 inimport = FALSE,
	 inprocess = FALSE,
	 incasestmt = FALSE;
Boolean	 inforstmt = FALSE;

/* the keyword structure */
int num_IDLkeywords;
keyword IDLkeywords[] =
{   { And,  "And", "and"},
    { Assert, "Assert", "assert"},
    { Case, "Case", "case"},
    { Cyclic, "Cyclic", "cyclic"},
    { Define, "Define", "define"},
    { Do, "Do", "do"},
    { Else, "Else", "else"},
    { Empty, "Empty", "empty"},
    { End, "End", "end"},
    { Exists, "Exists", "exists"},
    { False, "False", "false"},
    { Fi, "Fi", "fi"},
    { For, "For", "for"},
    { ForAll, "ForAll", "forall"},
    { From, "From", "from"},
    { If, "If", "if"},
    { Import, "Import", "import"},
    { In, "In", "in"},
    { Intersect, "Intersect", "intersect"},
    { Inv, "Inv", "inv"},
    { Is, "Is", "is"},
    /**** { Mark, "Mark", "mark"}, ****/
    { Not, "Not", "not"},
    { Od, "Od", "od"},
    { Of, "Of", "of"},
    { Or, "Or", "or"},
    { OrIf, "OrIf", "orif"},
    { Otherwise, "Otherwise", "otherwise"},
    { Post, "Post", "post"},
    { Pre, "Pre", "pre"},
    { Process, "Process", "process"},
    { Psub, "Psub", "psub"},
    { Refines, "Refines", "refines"},
    { Restrict, "Restrict", "restrict"},
    { Returns, "Returns", "returns"},
    { Root, "Root", "root"},
    { Same, "Same", "same"},
    { Seq, "Seq", "seq"},
    { Set, "Set", "set"},
    { Structure, "Structure", "structure"},
    { Sub, "Sub", "sub"},
    { Target, "Target", "target"},
    { Then, "Then", "then"},
    { To, "To", "to"},
    { True, "True", "true"},
    { Type, "Type", "type"},
    { Union, "Union", "union"},
    /**** { Unmark, "Unmark", "unmark"}, ****/
    { Use, "Use", "use"},
    { Without, "Without", "without"},
    { 0, NULL, NULL}
};

int tokennumber, temptokennumber;
#define RecordLexInfo() \
	templexinfo = (char *)GetHeap(strlen(lastlexinfo)+yyleng+1);\
	(void)sprintf(templexinfo, "%s%s", lastlexinfo, yytext);\
	lastlexinfo = NewString(templexinfo);\
	IncrCount()
#define IncrCount() \
	lasttoken = charcount; \
	charcount += yyleng
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	{ CopyToken(); return (ANGLEARROW); }
break;
case 2:
	{ RecordLexInfo(); return (BAR); }
break;
case 3:
	{ CopyToken(); return (COLON); }
break;
case 4:
	{ CopyToken(); return (COLONARROW); }
break;
case 5:
	{ RecordLexInfo(); return (COMMA); }
break;
case 6:
	{ RecordLexInfo(); return (LEFTPAREN); }
break;
case 7:
	{ RecordLexInfo(); return (RIGHTPAREN); }
break;
case 8:
	{ CopyToken(); inforstmt = FALSE; return (SEMICOLON); }
break;
case 9:
	{ CopyToken(); return (STAR); }
break;
case 10:
	{ CopyToken(); return (EQUAL); }
break;
case 11:
	{ CopyToken(); return (NOTEQUAL); }
break;
case 12:
	{ CopyToken(); return (LESS); }
break;
case 13:
	{ CopyToken(); return (LESSOREQ); }
break;
case 14:
	{ CopyToken(); return (GREATER); }
break;
case 15:
	{ CopyToken(); return (GREATEROREQ); }
break;
case 16:
	{ CopyToken(); return (PLUS); }
break;
case 17:
	{ CopyToken(); return (MINUS); }
break;
case 18:
	{ CopyToken(); return (SLASH); }
break;
case 19:
	{
/*		  tokennumber = DOT;
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
*/
		  CopyToken(); 
/*		  tokennumber = -1;
*/
		  return (DOT); 
		}
break;
case 20:
{ tokennumber = INTEGER; 
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken(); 
		  tokennumber = -1;
		  return (INTEGER); 
		}
break;
case 21:
{ tokennumber = RATIONAL; 
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken(); 
		  tokennumber = -1;
		  return (RATIONAL); 
		}
break;
case 22:
{  /* context sensitivity of keyword
				    * Type also used as a definition.
				    * When used as definition, treat 
				    * as NAME token lookahead of "("
				    */
		  tokennumber = NAME;
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken(); 
		  tokennumber = -1;
		  return (NAME); 
		}
break;
case 23:

		{ tokennumber = GetNameType(); 
		  if ((tokennumber==Structure) || (tokennumber==Process) ||
		      (tokennumber==Import)) {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
			lastlexinfo = "\0";
		        if (tokennumber  == Structure) {
			    instructure = TRUE;
			    inprocess = FALSE;
			    inimport = FALSE;
		        }
		        else if (tokennumber  == Process) {
			    instructure = FALSE;
			    inprocess = TRUE;
			    inimport = FALSE;
		        }
		        else if (tokennumber  == Import) {
			    instructure = FALSE;
			    inprocess = FALSE;
			    inimport = TRUE;
		        }
		  }
		  CopyToken(); 
		  if (tokennumber==Use)	/* For .. Use .. ; */
		    inforstmt = TRUE;
		  else if (tokennumber==Case)
		    incasestmt = TRUE;
		  else if ((tokennumber==NAME)
		      || (tokennumber==End)
		      || (tokennumber==Empty)
		      || (tokennumber==True)
		      || (tokennumber==False)
		      || (tokennumber==Root)
		      ) {
			if (instructure) {
			    appendrearSEQString(structurelexinfo, lastlexinfo);
			}
			else if (inprocess){
			    appendrearSEQString(processlexinfo, lastlexinfo);
			}
		        else if (inimport) {
			    appendrearSEQString(importlexinfo, lastlexinfo);
		        }
			else {
			    appendrearSEQString(compUnitlexinfo, lastlexinfo);
			}
			lastlexinfo = "\0";
			if (tokennumber == End){
			    if (incasestmt) {
				incasestmt = FALSE;
			    }
			    else {
				instructure = FALSE;
				inprocess = FALSE;
				inimport = FALSE;
			    }
			}
		  }
		  temptokennumber = tokennumber;
		  tokennumber = -1;
		  return(temptokennumber);
		}
break;
case 24:
{
	/* was \"([^"~]*(\"\")*(~[~{@-_])*)*\"/[^"]	*/
		  tokennumber = STRING;
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken();
		  yylval.VnameToken->lex_name = String_convert(yytext,yyleng);
		  tokennumber = -1;
		  return (STRING); 
		}
break;
case 25:
{ RecordLexInfo(); lineNumber++ /* comment */ ; }
break;
case 26:
{ RecordLexInfo(); lineNumber++ /* preprocessor directive */ ; }
break;
case 27:
{ RecordLexInfo(); /* white space */ ; }
break;
case 28:
	{ RecordLexInfo(); lineNumber++ /* more white space */; }
break;
case 29:
	{ RecordLexInfo(); Warning0(40, lasttoken); }
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */


/***********************************************************************
 *
 * Function GetNameType
 *
 * Purpose: Get the token type associated with the name.
 *
 * Return Value: the token type.
 *
 * Algorithm: Change format of yytext to all lower case & store in buf.
 *		See if it  matches (using binary search)
 *		any kewords in hash table. If so return token associated with
 *		keyword. If not, return token 'NAME'. Also checks  for
 *		conformace with IDL Version 2.0.
 *
 * Errors Checked For: Conformace with IDL Version 2.0 if conformance switch
 *		       is set. Keywords must use proper case.
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
int GetNameType()
{
    register keyword *kwdptr;
    register char *cptr;
    register int ctr;
    register char *buf;
    int front, back, mid;
    int cmpresult;

    buf = (char *)GetHeap(yyleng+1);
    (void)strcpy(buf, yytext);
    cptr = buf;
    for (ctr=0; ctr<yyleng; ctr++, cptr++) {
	if (isupper(*cptr)) {
	    *cptr = tolower(*cptr);
	}
    }

    front = 0;
    back = num_IDLkeywords-1;
    while (front <= back) {
	mid = (front + back)/2;
	kwdptr = IDLkeywords + mid;
	cmpresult = strcmp(buf, kwdptr->lowercase);
	if (cmpresult == 0) {
	    if (V2conform && (strcmp(yytext, kwdptr->characters))) {
		Comment0(54, lasttoken);
		return(NAME);
	    }
	    return(kwdptr->token);
	}
	else if (cmpresult < 0) {
	    back = mid -1;
	}
	else {
	    front = mid +1;
	}
    }
    /* if this point is reached, name is not an IDL keyword */
    return (NAME); 
}

char * String_convert(st,len)
char *st;
int  len;
{
    char *result;
    char *save;
    int  i;

    result = (char *)GetHeap(len+1);
    save = result;
    st++;
    for(i=1;i<len-1;i++)
    {
	if(*st == '~')
	{
	    st++;
	    i++;
	    if(*st >= '@' && *st <= '_')
	    {
		*result = *st - '@';
		result++;
	    }
	    else if(*st == '~')
		 {
		     *result = '~';
		     result++;
		 }
		 else if(*st == '{')
		      {
			  *result = '\177';	/* DEL  */
			  result++;
		      }
	}
	else if(*st == '"')
	     {
		 st++;
		 i++;
		 *result = '"';
		 result++;
	     }
	     else { *result = *st; result++; }
    st++;
    }
	*result = '\0';
	result = save;
	return(result);
}

yywrap() 
{ 
    extern FileSeq allfiles;
    FILE *GetNextFilePtr();

    if (yyin = GetNextFilePtr(allfiles)){
	return(0);
    }
    else {
	appendrearSEQString(compUnitlexinfo, lastlexinfo);
	return(1); 
    }
}
CopyToken()
{
	yylval.VnameToken = NewnameToken(); 
	yylval.VnameToken->lex_name = NewString(yytext); 
	yylval.VnameToken->lex_namepos = charcount; 

	if ((tokennumber == NAME)||(tokennumber == INTEGER)||
	    (tokennumber==RATIONAL)||(tokennumber == STRING)) {
	    IncrCount();
	}

	  /* if you are in a For stmt, don't record lexinfo for
	   * Set,Seq, Of and treat as NAME token
	   */
	else if (inforstmt && 
		 (tokennumber==Seq || tokennumber==Set || tokennumber==Of)) {
	    tokennumber = NAME;
	    IncrCount();
        }

	else {
	    RecordLexInfo();
	}
}
int yyvstop[] ={
0,

27,
0,

27,
0,

29,
0,

27,
29,
0,

28,
0,

29,
0,

6,
29,
0,

7,
29,
0,

9,
29,
0,

16,
29,
0,

5,
29,
0,

17,
29,
0,

19,
29,
0,

18,
29,
0,

20,
29,
0,

3,
29,
0,

8,
29,
0,

12,
29,
0,

10,
29,
0,

14,
29,
0,

23,
29,
0,

23,
29,
0,

2,
29,
0,

29,
0,

29,
0,

27,
0,

24,
0,

20,
0,

13,
0,

1,
0,

15,
0,

23,
0,

23,
0,

11,
0,

26,
0,

25,
0,

21,
0,

21,
0,

21,
0,

4,
0,

23,
0,

21,
0,

23,
-22,
0,

21,
0,

21,
0,

21,
0,

22,
0,

21,
0,

21,
0,

21,
0,

21,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	1,4,	4,26,	0,0,	
0,0,	4,26,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,4,	1,3,	1,6,	
28,27,	4,26,	61,53,	76,72,	
46,53,	1,7,	1,8,	1,9,	
1,10,	1,11,	1,12,	1,13,	
1,14,	1,15,	12,31,	46,54,	
50,34,	15,32,	63,34,	71,34,	
0,0,	0,0,	0,0,	1,16,	
1,17,	1,18,	1,19,	1,20,	
15,33,	15,34,	1,21,	2,6,	
2,25,	16,36,	1,21,	18,37,	
1,21,	2,7,	2,8,	2,9,	
19,38,	2,11,	2,12,	2,13,	
2,14,	1,21,	20,39,	24,42,	
36,51,	1,22,	41,52,	15,35,	
30,32,	52,59,	1,21,	2,16,	
2,17,	2,18,	2,19,	2,20,	
1,3,	22,41,	47,34,	30,33,	
30,34,	53,34,	1,21,	10,30,	
10,30,	10,30,	10,30,	10,30,	
10,30,	10,30,	10,30,	10,30,	
10,30,	64,72,	65,74,	72,75,	
0,0,	0,0,	41,52,	0,0,	
47,55,	52,59,	30,35,	53,60,	
64,73,	1,23,	0,0,	1,24,	
0,0,	22,41,	32,46,	32,46,	
32,46,	32,46,	32,46,	32,46,	
32,46,	32,46,	32,46,	32,46,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	32,46,	
32,46,	32,46,	32,46,	32,46,	
32,46,	0,0,	0,0,	0,0,	
0,0,	2,23,	0,0,	2,24,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,0,	
6,0,	6,0,	6,0,	6,27,	
6,27,	6,28,	0,0,	48,56,	
59,68,	0,0,	0,0,	0,0,	
68,68,	0,0,	6,27,	0,0,	
0,0,	0,0,	48,57,	6,27,	
33,47,	33,47,	33,47,	33,47,	
33,47,	33,47,	33,47,	33,47,	
33,47,	33,47,	0,0,	59,68,	
0,0,	0,0,	0,0,	68,68,	
6,27,	0,0,	0,0,	59,69,	
6,27,	48,58,	6,27,	68,69,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	6,27,	
0,0,	0,0,	0,0,	6,27,	
0,0,	0,0,	0,0,	0,0,	
6,27,	0,0,	0,0,	0,0,	
0,0,	0,0,	6,27,	0,0,	
0,0,	0,0,	0,0,	0,0,	
6,27,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
0,0,	0,0,	0,0,	0,0,	
0,0,	6,29,	6,0,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	0,0,	0,0,	0,0,	
0,0,	21,40,	0,0,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	21,40,	21,40,	21,40,	
21,40,	25,43,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	25,43,	25,44,	0,0,	
25,43,	34,48,	34,48,	34,48,	
34,48,	34,48,	34,48,	34,48,	
34,48,	34,48,	34,48,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
25,43,	25,43,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	25,43,	
35,49,	0,0,	35,49,	0,0,	
25,43,	35,50,	35,50,	35,50,	
35,50,	35,50,	35,50,	35,50,	
35,50,	35,50,	35,50,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	25,43,	0,0,	0,0,	
0,0,	25,43,	0,0,	25,43,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
25,43,	0,0,	0,0,	0,0,	
25,43,	0,0,	0,0,	0,0,	
0,0,	25,43,	0,0,	0,0,	
0,0,	0,0,	0,0,	25,43,	
0,0,	0,0,	0,0,	0,0,	
0,0,	25,43,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	0,0,	0,0,	27,28,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	0,0,	
0,0,	29,0,	31,31,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	31,31,	31,45,	
0,0,	31,31,	49,50,	49,50,	
49,50,	49,50,	49,50,	49,50,	
49,50,	49,50,	49,50,	49,50,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	31,31,	31,31,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
31,31,	0,0,	0,0,	0,0,	
0,0,	31,31,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,29,	
27,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	31,31,	0,0,	
0,0,	0,0,	31,31,	0,0,	
31,31,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	31,31,	0,0,	0,0,	
0,0,	31,31,	0,0,	0,0,	
0,0,	0,0,	31,31,	0,0,	
0,0,	29,27,	29,0,	0,0,	
31,31,	0,0,	0,0,	0,0,	
0,0,	0,0,	31,31,	54,61,	
54,61,	54,61,	54,61,	54,61,	
54,61,	54,61,	54,61,	54,61,	
54,61,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
54,61,	54,61,	54,61,	54,61,	
54,61,	54,61,	55,62,	0,0,	
55,62,	0,0,	0,0,	55,63,	
55,63,	55,63,	55,63,	55,63,	
55,63,	55,63,	55,63,	55,63,	
55,63,	56,64,	56,64,	56,64,	
56,64,	56,64,	56,64,	56,64,	
56,64,	56,64,	56,64,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	56,64,	56,64,	
56,64,	56,64,	56,64,	56,64,	
57,65,	57,65,	57,65,	57,65,	
57,65,	57,65,	57,65,	57,65,	
57,65,	57,65,	58,66,	0,0,	
58,66,	0,0,	0,0,	58,67,	
58,67,	58,67,	58,67,	58,67,	
58,67,	58,67,	58,67,	58,67,	
58,67,	60,70,	0,0,	60,70,	
0,0,	0,0,	60,71,	60,71,	
60,71,	60,71,	60,71,	60,71,	
60,71,	60,71,	60,71,	60,71,	
62,63,	62,63,	62,63,	62,63,	
62,63,	62,63,	62,63,	62,63,	
62,63,	62,63,	66,67,	66,67,	
66,67,	66,67,	66,67,	66,67,	
66,67,	66,67,	66,67,	66,67,	
70,71,	70,71,	70,71,	70,71,	
70,71,	70,71,	70,71,	70,71,	
70,71,	70,71,	73,76,	73,76,	
73,76,	73,76,	73,76,	73,76,	
73,76,	73,76,	73,76,	73,76,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	73,76,	
73,76,	73,76,	73,76,	73,76,	
73,76,	74,77,	0,0,	74,77,	
0,0,	0,0,	74,78,	74,78,	
74,78,	74,78,	74,78,	74,78,	
74,78,	74,78,	74,78,	74,78,	
75,79,	0,0,	75,79,	0,0,	
0,0,	75,80,	75,80,	75,80,	
75,80,	75,80,	75,80,	75,80,	
75,80,	75,80,	75,80,	77,78,	
77,78,	77,78,	77,78,	77,78,	
77,78,	77,78,	77,78,	77,78,	
77,78,	79,80,	79,80,	79,80,	
79,80,	79,80,	79,80,	79,80,	
79,80,	79,80,	79,80,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+-33,	yysvec+1,	yyvstop+3,
yycrank+0,	0,		yyvstop+5,
yycrank+5,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+10,
yycrank+-159,	0,		yyvstop+12,
yycrank+0,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+17,
yycrank+0,	0,		yyvstop+20,
yycrank+55,	0,		yyvstop+23,
yycrank+0,	0,		yyvstop+26,
yycrank+5,	yysvec+10,	yyvstop+29,
yycrank+0,	0,		yyvstop+32,
yycrank+0,	0,		yyvstop+35,
yycrank+18,	yysvec+10,	yyvstop+38,
yycrank+11,	0,		yyvstop+41,
yycrank+0,	0,		yyvstop+44,
yycrank+10,	0,		yyvstop+47,
yycrank+14,	0,		yyvstop+50,
yycrank+21,	0,		yyvstop+53,
yycrank+222,	0,		yyvstop+56,
yycrank+8,	yysvec+21,	yyvstop+59,
yycrank+0,	0,		yyvstop+62,
yycrank+22,	0,		yyvstop+65,
yycrank+-344,	0,		yyvstop+67,
yycrank+0,	yysvec+4,	yyvstop+69,
yycrank+-445,	yysvec+6,	0,	
yycrank+2,	0,		yyvstop+71,
yycrank+-479,	yysvec+6,	0,	
yycrank+53,	yysvec+10,	yyvstop+73,
yycrank+-513,	0,		0,	
yycrank+82,	0,		0,	
yycrank+160,	0,		0,	
yycrank+309,	0,		0,	
yycrank+345,	0,		0,	
yycrank+23,	0,		0,	
yycrank+0,	0,		yyvstop+75,
yycrank+0,	0,		yyvstop+77,
yycrank+0,	0,		yyvstop+79,
yycrank+0,	yysvec+21,	yyvstop+81,
yycrank+6,	yysvec+21,	yyvstop+83,
yycrank+0,	0,		yyvstop+85,
yycrank+0,	yysvec+25,	0,	
yycrank+0,	0,		yyvstop+87,
yycrank+0,	0,		yyvstop+89,
yycrank+5,	yysvec+32,	0,	
yycrank+51,	yysvec+33,	yyvstop+91,
yycrank+160,	yysvec+34,	yyvstop+93,
yycrank+478,	0,		0,	
yycrank+5,	yysvec+49,	yyvstop+95,
yycrank+0,	0,		yyvstop+97,
yycrank+20,	yysvec+21,	yyvstop+99,
yycrank+54,	0,		yyvstop+101,
yycrank+567,	0,		0,	
yycrank+595,	0,		0,	
yycrank+605,	0,		0,	
yycrank+628,	0,		0,	
yycrank+643,	0,		0,	
yycrank+187,	yysvec+21,	yyvstop+103,
yycrank+658,	0,		0,	
yycrank+3,	yysvec+54,	0,	
yycrank+668,	0,		0,	
yycrank+7,	yysvec+62,	yyvstop+106,
yycrank+78,	yysvec+56,	0,	
yycrank+45,	yysvec+57,	yyvstop+108,
yycrank+678,	0,		0,	
yycrank+0,	yysvec+66,	yyvstop+110,
yycrank+191,	0,		0,	
yycrank+0,	0,		yyvstop+112,
yycrank+688,	0,		0,	
yycrank+8,	yysvec+70,	yyvstop+114,
yycrank+46,	0,		yyvstop+116,
yycrank+698,	0,		0,	
yycrank+726,	0,		0,	
yycrank+741,	0,		0,	
yycrank+4,	yysvec+73,	0,	
yycrank+751,	0,		0,	
yycrank+0,	yysvec+77,	yyvstop+118,
yycrank+761,	0,		0,	
yycrank+0,	yysvec+79,	yyvstop+120,
0,	0,	0};
struct yywork *yytop = yycrank+818;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,014 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
040 ,'!' ,01  ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'!' ,'!' ,'+' ,'!' ,'+' ,'!' ,'!' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,'!' ,'!' ,'!' ,'!' ,'!' ,'!' ,
'!' ,'A' ,'A' ,'A' ,'A' ,'E' ,'A' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'P' ,'G' ,'G' ,'G' ,'T' ,'G' ,'G' ,'G' ,
'G' ,'Y' ,'G' ,'!' ,'!' ,'!' ,'!' ,'_' ,
'!' ,'G' ,'G' ,'G' ,'G' ,'e' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'P' ,'G' ,'G' ,'G' ,'T' ,'G' ,'G' ,'G' ,
'G' ,'Y' ,'G' ,'!' ,'!' ,'!' ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
