%{
/* ******************************************************************* *\
*									*
*   File: scorpion/src/idlc/frontend/idltokens.l
*									*
*   Copyright (C) 1991 Tim Maroney, Karen Shannon, Richard Snodgrass
*									*
*   The Scorpion System is free software in the public domain; you can  *
*   redistribute it and/or modify it as you wish. We ask that you 	*
*   retain credits referencing the University of Arizona and that you	*
*   identify any changes you make.					*
*									*
*   Report problems to scorpion-project@cs.arizona.edu			*
*   Direct all inquiries to:	The Scorpion Project			*
*				Department of Computer Science		*
*				Gould-Simpson Building			*
*				University of Arizona			*
*				Tucson, AZ 85721			*
*				U.S.A.					*
*									*
*   Function: Lex code for recognizing IDL notation			*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: /phi/softlab2/IDLToolkit/distribution/4.0/idlsystem2/src/idlc/frontend/RCS/idltokens.l,v 4.0 89/04/12 00:58:53 cheung Exp Locker: cheung $";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	idltokens.l,v $
 * Revision 4.0  89/04/12  00:58:53  cheung
 * idltokens.l  Ver 4.0
 * 
 * Revision 3.9  89/03/30  11:46:40  cheung
 * idltokens.l  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:57:11  cheung
 * idltokens.l  Ver 3.9
 * 
 * Revision 3.3  88/04/06  11:32:12  rajan
 * Some changes made to the frontend so that the strings in Candle are
 * set up right. This is especially for reserved words. This
 * modification done by Rick Snodgrass
 * Changed lex_information attribute for DOT, True, False, and Empty. rts
 * 
 * Revision 3.2  88/02/19  18:58:51  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:18:06  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:35:58  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.2  85/07/05  20:50:32  shannon
 * added new token Unmark for unmarker ports
 * 
 * Revision 1.1  85/06/11  10:25:24  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*									*
\* ******************************************************************* */

# include "Frontend.h"
# include "macros.h"
# include <ctype.h>
# include  <string.h>
# include "yacc_parse.h"
extern YYSTYPE yylval;
char *String_convert();
int lineNumber=1;
int charcount=1;
int lasttoken=1;
extern Boolean V2conform;

String lastlexinfo="\0";
char *templexinfo;
SEQString structurelexinfo, 
	  processlexinfo, 
	  importlexinfo,
	  compUnitlexinfo;
Boolean  instructure = FALSE,
	 inimport = FALSE,
	 inprocess = FALSE,
	 incasestmt = FALSE;
Boolean	 inforstmt = FALSE;

/* the keyword structure */
int num_IDLkeywords;
keyword IDLkeywords[] =
{   { And,  "And", "and"},
    { Assert, "Assert", "assert"},
    { Case, "Case", "case"},
    { Cyclic, "Cyclic", "cyclic"},
    { Define, "Define", "define"},
    { Do, "Do", "do"},
    { Else, "Else", "else"},
    { Empty, "Empty", "empty"},
    { End, "End", "end"},
    { Exists, "Exists", "exists"},
    { False, "False", "false"},
    { Fi, "Fi", "fi"},
    { For, "For", "for"},
    { ForAll, "ForAll", "forall"},
    { From, "From", "from"},
    { If, "If", "if"},
    { Import, "Import", "import"},
    { In, "In", "in"},
    { Intersect, "Intersect", "intersect"},
    { Inv, "Inv", "inv"},
    { Is, "Is", "is"},
    /**** { Mark, "Mark", "mark"}, ****/
    { Not, "Not", "not"},
    { Od, "Od", "od"},
    { Of, "Of", "of"},
    { Or, "Or", "or"},
    { OrIf, "OrIf", "orif"},
    { Otherwise, "Otherwise", "otherwise"},
    { Post, "Post", "post"},
    { Pre, "Pre", "pre"},
    { Process, "Process", "process"},
    { Psub, "Psub", "psub"},
    { Refines, "Refines", "refines"},
    { Restrict, "Restrict", "restrict"},
    { Returns, "Returns", "returns"},
    { Root, "Root", "root"},
    { Same, "Same", "same"},
    { Seq, "Seq", "seq"},
    { Set, "Set", "set"},
    { Structure, "Structure", "structure"},
    { Sub, "Sub", "sub"},
    { Target, "Target", "target"},
    { Then, "Then", "then"},
    { To, "To", "to"},
    { True, "True", "true"},
    { Type, "Type", "type"},
    { Union, "Union", "union"},
    /**** { Unmark, "Unmark", "unmark"}, ****/
    { Use, "Use", "use"},
    { Without, "Without", "without"},
    { 0, NULL, NULL}
};

int tokennumber, temptokennumber;
#define RecordLexInfo() \
	templexinfo = (char *)GetHeap(strlen(lastlexinfo)+yyleng+1);\
	(void)sprintf(templexinfo, "%s%s", lastlexinfo, yytext);\
	lastlexinfo = NewString(templexinfo);\
	IncrCount()
#define IncrCount() \
	lasttoken = charcount; \
	charcount += yyleng
%}

sign	([+-]?)
unint	([0-9]+)
unrat	({brat}|({intrat}"/"{intrat}))
intrat	({unint}|{brat})
brat	({brat1}|{brat2}|{brat3})
brat1	({unint}\.{unint}{exp}?)
brat2	({unint}(\.{unint})?{exp})
brat3	({unint}\#{based}(\.{based})?\#{exp}?)
exp	(E{sign}{unint})
based	([0-9A-F]+)
sschar	[A-Za-z0-9!#$%&'()*+,\-./:;<=>?@[\\\]^_`{|} ]
%%
"=>"		{ CopyToken(); return (ANGLEARROW); }
"|"		{ RecordLexInfo(); return (BAR); }
":"		{ CopyToken(); return (COLON); }
"::="		{ CopyToken(); return (COLONARROW); }
","		{ RecordLexInfo(); return (COMMA); }
"("		{ RecordLexInfo(); return (LEFTPAREN); }
")"		{ RecordLexInfo(); return (RIGHTPAREN); }
";"		{ CopyToken(); inforstmt = FALSE; return (SEMICOLON); }
"*"		{ CopyToken(); return (STAR); }
"="		{ CopyToken(); return (EQUAL); }
"~="		{ CopyToken(); return (NOTEQUAL); }
"<"		{ CopyToken(); return (LESS); }
"<="		{ CopyToken(); return (LESSOREQ); }
">"		{ CopyToken(); return (GREATER); }
">="		{ CopyToken(); return (GREATEROREQ); }
"+"		{ CopyToken(); return (PLUS); }
"-"		{ CopyToken(); return (MINUS); }
"/"		{ CopyToken(); return (SLASH); }
"."		{
/*		  tokennumber = DOT;
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
*/
		  CopyToken(); 
/*		  tokennumber = -1;
*/
		  return (DOT); 
		}
{sign}{unint}	{ tokennumber = INTEGER; 
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken(); 
		  tokennumber = -1;
		  return (INTEGER); 
		}
{sign}{unrat}	{ tokennumber = RATIONAL; 
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken(); 
		  tokennumber = -1;
		  return (RATIONAL); 
		}
[Tt][Yy][Pp][Ee]/[ \t]*"("	{  /* context sensitivity of keyword
				    * Type also used as a definition.
				    * When used as definition, treat 
				    * as NAME token lookahead of "("
				    */
		  tokennumber = NAME;
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken(); 
		  tokennumber = -1;
		  return (NAME); 
		}

[a-zA-Z][a-zA-Z0-9_]*	
		{ tokennumber = GetNameType(); 
		  if ((tokennumber==Structure) || (tokennumber==Process) ||
		      (tokennumber==Import)) {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
			lastlexinfo = "\0";
		        if (tokennumber  == Structure) {
			    instructure = TRUE;
			    inprocess = FALSE;
			    inimport = FALSE;
		        }
		        else if (tokennumber  == Process) {
			    instructure = FALSE;
			    inprocess = TRUE;
			    inimport = FALSE;
		        }
		        else if (tokennumber  == Import) {
			    instructure = FALSE;
			    inprocess = FALSE;
			    inimport = TRUE;
		        }
		  }
		  CopyToken(); 
		  if (tokennumber==Use)	/* For .. Use .. ; */
		    inforstmt = TRUE;
		  else if (tokennumber==Case)
		    incasestmt = TRUE;
		  else if ((tokennumber==NAME)
		      || (tokennumber==End)
		      || (tokennumber==Empty)
		      || (tokennumber==True)
		      || (tokennumber==False)
		      || (tokennumber==Root)
		      ) {
			if (instructure) {
			    appendrearSEQString(structurelexinfo, lastlexinfo);
			}
			else if (inprocess){
			    appendrearSEQString(processlexinfo, lastlexinfo);
			}
		        else if (inimport) {
			    appendrearSEQString(importlexinfo, lastlexinfo);
		        }
			else {
			    appendrearSEQString(compUnitlexinfo, lastlexinfo);
			}
			lastlexinfo = "\0";
			if (tokennumber == End){
			    if (incasestmt) {
				incasestmt = FALSE;
			    }
			    else {
				instructure = FALSE;
				inprocess = FALSE;
				inimport = FALSE;
			    }
			}
		  }
		  temptokennumber = tokennumber;
		  tokennumber = -1;
		  return(temptokennumber);
		}
\"((\"\")|(\~{sschar})|(\~\~)|({sschar}))*\"	{
	/* was \"([^"~]*(\"\")*(~[~{@-_])*)*\"/[^"]	*/
		  tokennumber = STRING;
		  if (instructure) {
			appendrearSEQString(structurelexinfo, lastlexinfo);
		  }
		  else if (inprocess){
			appendrearSEQString(processlexinfo, lastlexinfo);
		  }
		  else if (inimport) {
			appendrearSEQString(importlexinfo, lastlexinfo);
		  }
		  else {
			appendrearSEQString(compUnitlexinfo, lastlexinfo);
		  }
		  lastlexinfo = "\0";
		  CopyToken();
		  yylval.VnameToken->lex_name = String_convert(yytext,yyleng);
		  tokennumber = -1;
		  return (STRING); 
		}
"--".*\n	{ RecordLexInfo(); lineNumber++ /* comment */ ; }
^"#".*\n	{ RecordLexInfo(); lineNumber++ /* preprocessor directive */ ; }
[ \t]*	{ RecordLexInfo(); /* white space */ ; }
\n		{ RecordLexInfo(); lineNumber++ /* more white space */; }
.		{ RecordLexInfo(); Warning0(40, lasttoken); }
%%


/***********************************************************************
 *
 * Function GetNameType
 *
 * Purpose: Get the token type associated with the name.
 *
 * Return Value: the token type.
 *
 * Algorithm: Change format of yytext to all lower case & store in buf.
 *		See if it  matches (using binary search)
 *		any kewords in hash table. If so return token associated with
 *		keyword. If not, return token 'NAME'. Also checks  for
 *		conformace with IDL Version 2.0.
 *
 * Errors Checked For: Conformace with IDL Version 2.0 if conformance switch
 *		       is set. Keywords must use proper case.
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/
int GetNameType()
{
    register keyword *kwdptr;
    register char *cptr;
    register int ctr;
    register char *buf;
    int front, back, mid;
    int cmpresult;

    buf = (char *)GetHeap(yyleng+1);
    (void)strcpy(buf, yytext);
    cptr = buf;
    for (ctr=0; ctr<yyleng; ctr++, cptr++) {
	if (isupper(*cptr)) {
	    *cptr = tolower(*cptr);
	}
    }

    front = 0;
    back = num_IDLkeywords-1;
    while (front <= back) {
	mid = (front + back)/2;
	kwdptr = IDLkeywords + mid;
	cmpresult = strcmp(buf, kwdptr->lowercase);
	if (cmpresult == 0) {
	    if (V2conform && (strcmp(yytext, kwdptr->characters))) {
		Comment0(54, lasttoken);
		return(NAME);
	    }
	    return(kwdptr->token);
	}
	else if (cmpresult < 0) {
	    back = mid -1;
	}
	else {
	    front = mid +1;
	}
    }
    /* if this point is reached, name is not an IDL keyword */
    return (NAME); 
}

char * String_convert(st,len)
char *st;
int  len;
{
    char *result;
    char *save;
    int  i;

    result = (char *)GetHeap(len+1);
    save = result;
    st++;
    for(i=1;i<len-1;i++)
    {
	if(*st == '~')
	{
	    st++;
	    i++;
	    if(*st >= '@' && *st <= '_')
	    {
		*result = *st - '@';
		result++;
	    }
	    else if(*st == '~')
		 {
		     *result = '~';
		     result++;
		 }
		 else if(*st == '{')
		      {
			  *result = '\177';	/* DEL  */
			  result++;
		      }
	}
	else if(*st == '"')
	     {
		 st++;
		 i++;
		 *result = '"';
		 result++;
	     }
	     else { *result = *st; result++; }
    st++;
    }
	*result = '\0';
	result = save;
	return(result);
}

yywrap() 
{ 
    extern FileSeq allfiles;
    FILE *GetNextFilePtr();

    if (yyin = GetNextFilePtr(allfiles)){
	return(0);
    }
    else {
	appendrearSEQString(compUnitlexinfo, lastlexinfo);
	return(1); 
    }
}
CopyToken()
{
	yylval.VnameToken = NewnameToken(); 
	yylval.VnameToken->lex_name = NewString(yytext); 
	yylval.VnameToken->lex_namepos = charcount; 

	if ((tokennumber == NAME)||(tokennumber == INTEGER)||
	    (tokennumber==RATIONAL)||(tokennumber == STRING)) {
	    IncrCount();
	}

	  /* if you are in a For stmt, don't record lexinfo for
	   * Set,Seq, Of and treat as NAME token
	   */
	else if (inforstmt && 
		 (tokennumber==Seq || tokennumber==Set || tokennumber==Of)) {
	    tokennumber = NAME;
	    IncrCount();
        }

	else {
	    RecordLexInfo();
	}
}
