/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/frontend/error.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: This file contains miscellaneous files for error 		*
*		handling, etc 						*
*									*
*           ErrHandler							*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: ";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	error.c,v $
 * Revision 1.1  89/07/05  16:30:08  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  00:58:11  cheung
 * error.c  Ver 4.0
 * 
 * Revision 3.9  89/03/30  11:46:15  cheung
 * error.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:56:51  cheung
 * error.c  Ver 3.9
 * 
 * Revision 3.2  88/02/19  18:35:23  rajan
 * Version 3.2
 * 
 * Revision 1.1  87/04/18  11:18:16  shannon
 * Initial revision
 * 
 * Revision 2.0  86/01/22  07:36:10  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.1  85/06/11  10:18:21  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

#include <stdio.h>
#include "error.h"
extern FILE *errout;
#define strequal(s1, s2) (!strcmp(s1,s2))
extern char SeriousError;
#define TRUE 1

/***********************************************************************
 *
 * Procedure ErrHandler
 *
 * Purpose: Write an error message to errout and handle error appropriately
 *
 * Errors Checked For: none
 *
 * Assumptions/Limitations: none
 *
 **********************************************************************/

ErrHandler(type, number, sourcepos, arg1, arg2)

int type;		/* type of error */
int number;		/* error number */
int sourcepos;		/* source position of error */
char *arg1,*arg2;	/* arguments */
{

        void exit();
        extern void ERRNewErrorInstance();
        extern void ERRAddStringArg();
        extern void ERRWriteErrorInstance();

	ERRNewErrorInstance(errout, number, sourcepos);
	if (!strequal(arg1, "")) {
	    ERRAddStringArg(arg1);
	    if (!strequal(arg2, "")) 
		ERRAddStringArg(arg2);
	}
	ERRWriteErrorInstance();

	if (type == SERIOUS)
	    SeriousError = TRUE;
	else if (type == FATAL)
	    exit(1);
}
