/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/stat.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Backend.h"
#include "macros.h"
#include <stdio.h>
#include <ctype.h>	

PrintStatistics(sfile, compUnit)
FILE *sfile;
compilationUnit compUnit;
{
	SEQDeclaration SStPr;
	Declaration AStPr;
	StructureEntity invst;
	ProcessEntity pr;

	Assume(((sfile != NULL)&& IscompilationUnit(compUnit)), 
		"PrintStatistics");

	foreachinSEQDeclaration(compUnit->syn_body, SStPr, AStPr) {
	    if (typeof(AStPr)==KStructureEntity) {
	  	PrintStructureStatistics(sfile, AStPr.VStructureEntity); 
	    }
	    else if (typeof(AStPr)==KProcessEntity){
		pr = AStPr.VProcessEntity;
		invst = pr->sem_invariant;
		PrintStructureStatistics(sfile, invst);
	    }
	}
}

PrintStructureStatistics(sfile, st)
FILE *sfile;
StructureEntity st;
{
    SEQAttribute SAtt;
    Attribute AnAtt;
    SETTypeEntity SType;
    TypeEntity AType;
    SEQClass SClass;
    Class AClass;
    SEQAtomic SAtomic;
    Atomic AnAtomic;
    Attribute last_att;
    String name;		/* temporary for name */
    int numsets=0;		/* number of sets */
    int numseqs=0;		/* number of sequences */
    int numclasses=0;		/* number of classes */
    int numnodes=0;		/* number of nodes */
    int numprivates=0;		/* number of privates */
    int numattributes=0;	/* number of attributes for Class or Node */
    int numpropatts=0;		/* number of propagated attributes */
    int numintatts=0;		/* number of internal attributes for node */
    int numextatts=0;		/* number of external attributes for node */
    int totalattributes=0;	/* number of distinct attributes for all classes
				   and nodes */
    int totalnodeattributes=0;	/* number of attributes for all nodes */
    int totalattsize=0;		/* total size for all distinct attributes */
    int numwnodes=0;		/* number of nodes which are sent to a writer */
    int numrnodes=0;		/* number of nodes which are sent to a reader */
    int min_nodesize = -1;
    int max_nodesize = -1;
    Class max_node;		/* node with maximum size */
    Class min_node;		/* node with minimum size */
    int nodesize;		/* size of node attributes */
    int realnodesize;		/* size of node including header, placeholders*/
    int totalnodesize = 0;	/* accumlated size of allnodes */
    int attsize;
    TypeEntity att_type;
    SEQAtomic privates;
    SEQClass nodes;
    SEQClass classes;
    Class c1, c2, c3;
    int cseqlen, len1, len2, len3;
    int i;
    Boolean InsertTypeAtomic();
    Boolean InsertTypeClass();

    Assume(((sfile != NULL) && IsStructureEntity(st)), 
	    "PrintStructureStatistics");


    initializeSEQAtomic(privates);
    initializeSEQClass(nodes);
    initializeSEQClass(classes);

    foreachinSETTypeEntity(st->sem_types, SType, AType) {
	switch (typeof(AType)) {
	    case KClass:
		if (emptySETClass(AType.VClass->sem_subclasses)) /* Node */
		    orderedinsertSEQClass(nodes, AType.VClass, InsertTypeClass);
		else orderedinsertSEQClass(classes, AType.VClass, InsertTypeClass);
		break;
	    case KAtomic:
		orderedinsertSEQAtomic(privates, AType.VAtomic, InsertTypeAtomic);
		break;
	    case KSetOf:
		++numsets;
		break;
	    case KSeqOf:
		++numseqs;
		break;
	}
    }

    (void) fprintf(sfile, "\nStructure %s:\n", st->lex_name);
    (void) fprintf(sfile, "\nPrivates:\n\n");
    foreachinSEQAtomic(privates, SAtomic, AnAtomic) {
	(void) fprintf(sfile, "\t%s\n", AnAtomic->sem_name);
	++numprivates;
    }
    (void) fprintf(sfile, "\nClasses:\n\n");
    cseqlen = lengthSEQClass(classes);
    if (cseqlen > 9) { /* 2 or 3 columns */
	if (cseqlen > 20) /* 3 columns */
	    len3 = (int)(cseqlen/3);
	else    /* 2 columns */
	    len3 = 0;
	len2 = (int)((cseqlen-len3)/2);	/* len2 >= len3 */
	len1 = cseqlen - len2 - len3;	/* len1 >= len2 */
	for (i=1; i<=len3; i++) {
	    ithinSEQClass(classes, i, c1);
	    ithinSEQClass(classes, i+len2, c2);
	    ithinSEQClass(classes, i+len2+len3, c3);
	    (void) fprintf(sfile, "%-25s %-25s %-25s\n", 
		c1->sem_name, c2->sem_name, c3->sem_name);
	}
	for (i=len3+1; i<=len2; i++) {
	    ithinSEQClass(classes, i, c1);
	    ithinSEQClass(classes, i+len2, c2);
	    (void) fprintf(sfile, "%-25s %-25s\n", c1->sem_name, c2->sem_name);
	}
	for (i=len2+1; i<=len1; i++) {
	    ithinSEQClass(classes, i, c1);
	    (void) fprintf(sfile, "%-25s \n", c1->sem_name);
	}
    }
    else {	/* 1 column */
	foreachinSEQClass(classes, SClass, AClass) {
	    (void) fprintf(sfile, "\t%s\n", AClass->sem_name);
	}
    }
    foreachinSEQClass(classes, SClass, AClass) {
	++numclasses;
	foreachinSEQAttribute(AClass->sem_allattributes, SAtt, AnAtt){
	    if (AnAtt->inv_parent == AClass) {
		++totalattributes;
	    }
	}
    }

    (void) fprintf(sfile, "\nNodes:\n");
    (void) fprintf(sfile, 
        "\n%-25s Size  AttSize Number  Number   Number   Number   Number",
	"Node Name");
    (void) fprintf(sfile, 
        "\n%-25s  in      in     of  = Direct + Prpgtd = Intrnl + Extrnl", " ");
    (void) fprintf(sfile, 
        "\n%-25s Bits    Bits  Attrs   Attrs    Attrs    Attrs    Attrs\n\n",
        " ");

    foreachinSEQClass(nodes, SClass, AClass) {
	nodesize = 0;	
	numattributes = 0;
	numintatts = 0;
	numextatts = 0;
	numpropatts = 0;
	attsize = 0;
	last_att = NULL;
	foreachinSEQAttribute(AClass->sem_allattributes, SAtt, AnAtt){
	    if (AnAtt->inv_parent == AClass) {
		++totalattributes;
	    }
	    else {
		++numpropatts;
	    }
	    ++numattributes;
	    att_type = GetAttributeType(AnAtt);
	    if (typeof(att_type)==KAtomic)
		++numintatts;
	    else ++numextatts;
	    attsize = att_type.IDLclassCommon->rep_size;
	    totalattsize += attsize;
	    nodesize += attsize;
	    last_att = AnAtt;
	}
	/* tot calculate real size take offset of last attribute and add size */
	if (last_att)
	    realnodesize = Att_Offset(last_att) + attsize;
	else
	    realnodesize = 32; /* size of header */

	totalnodeattributes += numattributes;
	++numnodes;
	if (inSETflag(AClass->inv_flags, KWSELF))
	    ++numwnodes;
	if (inSETflag(AClass->inv_flags, KGSELF))
	    ++numrnodes;
	totalnodesize += nodesize;
	if (min_nodesize == -1) {
	    min_nodesize = nodesize;
	    max_nodesize = nodesize;
	    min_node = AClass;
	    max_node = AClass;
	}
	else if (nodesize < min_nodesize) {
	    min_nodesize = nodesize;
	    min_node = AClass;
	}
	else if (nodesize > max_nodesize) {
	    max_nodesize = nodesize;
	    max_node = AClass;
	}
	name = AClass->sem_name;
	(void) fprintf(sfile, 
            "%-25s %4d   %4d    %2d      %2d       %2d       %2d       %2d\n", 
	    name, realnodesize, nodesize, numattributes, 
            (numattributes-numpropatts), numpropatts, numintatts, numextatts);
    }
    (void) fprintf(sfile, "\nSummary: \n");
    (void) fprintf(sfile, "\tNumber of Privates  : %d\n", numprivates);
    (void) fprintf(sfile, "\tNumber of Sets      : %d\n", numsets);
    (void) fprintf(sfile, "\tNumber of Sequences : %d\n", numseqs);
    (void) fprintf(sfile, "\tNumber of Classes   : %d\n", numclasses);
    (void) fprintf(sfile, "\tNumber of Nodes     : %d\n", numnodes);
    (void) fprintf(sfile, "\tNumber of Attributes: %d\n", totalattributes);
    (void) fprintf(sfile, "\tAvg Attribute Size  : %4.2f\n", 
        ((float)totalattsize/totalnodeattributes));
    (void) fprintf(sfile, "\tMininum Node Size   : %d (%d atts)\n", 
        min_nodesize, lengthSEQAttribute(min_node->sem_allattributes));
    (void) fprintf(sfile, "\tMaximum Node Size   : %d (%d atts)\n", 
        max_nodesize, lengthSEQAttribute(max_node->sem_allattributes));
    (void) fprintf(sfile, "\tAverage Node Size   : %4.2f (%4.2f atts)\n", 
        ((float)totalnodesize/numnodes), ((float)totalnodeattributes/numnodes));
    (void) fprintf(sfile,"\tNumber of nodes sent to a writer: %d\n", numwnodes);
    (void) fprintf(sfile,"\tNumber of nodes sent to a reader: %d\n", numrnodes);
    (void) fprintf(sfile,
        "\n-----------------------------------------------------\n");
}
