/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/misc.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Revision Log:							* 
*	$Log:$ 
*									* 
*   Edit Log:								* 
*									* 
\***********************************************************************/ 

#ifndef lint 
static char rcsid[] = "$Header:$"; 
#endif 

#include "Backend.h"
#include "macros.h"
#include <stdio.h>
#include <ctype.h>	
#include "gencfile.h"

TypeEntity FindInvarType();
TypeEntity FindUltimateInternalType();

/* calculates extra fields needed for code generator */
void CalculateExtraFields(invst)
StructureEntity invst;	/* invariant structure of process */
{
	SETTypeEntity SType;
	TypeEntity AType;
	SEQClass SClass;
	Class AClass;
	SETClass Ssubclass;
	Class Asubclass;
	SETAtomic SAtomic;
	Atomic AnAtomic;
	Atomic Atomic2;
	SEQAttribute SAtt;
	Attribute AnAtt;
	SEQClass allclasses;
	SEQClass allnodes;
	Boolean IsDescendantClass();
	Boolean SwapNodes();

	Assume((IsStructureEntity(invst)), "CalculateExtraFields");

	/* determine all indirect descendants of classes */
	PropogateDescendantsUp(invst);

	/* extract out all classes, nodes, sets, seqs, and privates 
	   from types */
	initializeSEQClass(allclasses);
	initializeSEQClass(allnodes);
    	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    switch (typeof(AType)) {
	    case KClass:
		if (!emptySETClass(AType.VClass->sem_subclasses))
		    appendfrontSEQClass(allclasses, AType.VClass);
		else appendfrontSEQClass(allnodes, AType.VClass);
		break;
	    case KSetOf:
		addSETSetOf(invst->inv_sets, AType.VSetOf);
		break;
	    case KSeqOf:
		addSETSeqOf(invst->inv_seqs, AType.VSeqOf);
		break;
	    case KAtomic:
		addSETAtomic(invst->inv_privates, AType.VAtomic);
		break;
	    }
	}
	/* calculate extra fields for atomics */
	foreachinSETAtomic(invst->inv_privates, SAtomic, AnAtomic) {
	    Atomic2 = AnAtomic;

	    /* determine final types for atomics */
	    while (typeof(Atomic2->rep_internalType)==KAtomic) {
		if (Atomic2->rep_internalType.VAtomic->sem_isPreludeType) 
		    break;
		else Atomic2 = Atomic2->rep_internalType.VAtomic;
	    }
	    AnAtomic->inv_internal = Atomic2->rep_internalType;

	}
	
	/* sort the classes from least-inclusive to most-inclusive */
	invst->inv_classes = (SEQClass)IDLListSort((pGenList) allclasses, 
					IsDescendantClass);

	/* sort the nodes by alphabet */
	invst->inv_nodes = (SEQClass)IDLListSort((pGenList) allnodes, SwapNodes);

	/* determine the parent field for attributes */
	foreachinSEQClass(invst->inv_nodes, SClass, AClass) {
	    foreachinSEQAttribute(AClass->sem_allattributes, SAtt, AnAtt)
		AnAtt->inv_parent = AClass;
	}
	foreachinSEQClass(invst->inv_classes, SClass, AClass) {
	    foreachinSEQAttribute(AClass->sem_allattributes, SAtt, AnAtt)
		AnAtt->inv_parent = AClass;
	}

	/* determine empty classes */
	foreachinSEQClass(invst->inv_nodes, SClass, AClass) {
	    AClass->inv_emptyclass = 
			emptySEQAttribute(AClass->sem_allattributes);
	}
	foreachinSEQClass(invst->inv_classes, SClass, AClass) {
	    AClass->inv_emptyclass = TRUE;
	    foreachinSETClass(AClass->inv_alldescendants, Ssubclass, Asubclass){
		if (!Asubclass->inv_emptyclass) {
		    AClass->inv_emptyclass = FALSE;
		    break;
		}
	    }
	}
}


/* calculates the invariant pointers and determines ports */
void CalculateInvarPtrs(pr)
ProcessEntity pr;
{
	SETPort SPort;
	Port APort;
	SETTypeEntity SType;
	TypeEntity AType, inttype;
	SEQAttribute SAtt;
	Attribute AnAtt;
	SEQAttribute SAtt2;
	Attribute AnAtt2;
	StructureEntity invst;
	StructureEntity portst;
	Boolean attfound;
	TargetEntity target;

	Assume((IsProcessEntity(pr)),
	       "CalculateInvarPtrs");
	
	invst = pr->sem_invariant;
	Assume((typeof(pr->sem_target)==KTargetEntity), "CalculateInvarPtrs2");
	target = pr->sem_target.VTargetEntity;

	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    AType.IDLclassCommon->invar = AType;
	}
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    portst = GetStructureEntity(APort->syn_data);
	    foreachinSETTypeEntity(portst->sem_types, SType, AType) {
		AType.IDLclassCommon->invar
		  = FindInvarType(invst, AType, APort->lex_name, target);
		addSETPort(AType.IDLclassCommon->invar.IDLclassCommon
			   ->inv_ports, APort);
		if (typeof(AType)==KClass) {
		    foreachinSEQAttribute(AType.IDLclassCommon->invar.VClass
					->sem_allattributes, SAtt, AnAtt) {
			attfound = FALSE;
			foreachinSEQAttribute(AType.VClass->sem_allattributes,
						SAtt2, AnAtt2) {
			    if (strequal(AnAtt->lex_name, AnAtt2->lex_name)) {
				attfound = TRUE;
				break;
			    }
			}
			if (attfound) {
			    addSETPort(AnAtt->inv_ports, APort);
			}
		    }
		}
		if ((typeof(AType)==KAtomic) &&
		    !(AType.VAtomic->sem_isPreludeType)) {
				/* AType is a private type */
		  if (IsTypeEntity(AType.VAtomic->rep_internalType)) {
		    inttype = FindUltimateInternalType(AType.VAtomic
						       ->rep_internalType.VTypeEntity);
		    if (typeof(inttype)==KClass) {
		      addSETPort(inttype.IDLclassCommon->invar.IDLclassCommon
				 ->inv_ports, APort);
		      foreachinSEQAttribute(inttype.VClass->sem_allattributes,
					    SAtt, AnAtt) {
			attfound = FALSE;
			/* Use internal type in port, if a class;
			   otherwise use internal type in invariant,
			   effectively involving all attributes */
			if (!IsClassType(inttype.VClass))
			  inttype = inttype.VClass->invar;
			foreachinSEQAttribute(inttype.VClass->sem_allattributes,
					      SAtt2, AnAtt2) {
			  if (strequal(AnAtt->lex_name, AnAtt2->lex_name)) {
			    attfound = TRUE;
			    break;
			  }
			}
			if (attfound) {
			  addSETPort(AnAtt->inv_ports, APort);
			}
		      }
		    }
		  }
		}
	      }
	  }
}


TypeEntity FindUltimateInternalType(thetype)
TypeEntity thetype;
{
	Assume((IsStructureEntity(invst)&&IsTypeEntity(thetype)),
		"FindUltimateInternalType");

	if (thetype.IDLclassCommon->sem_isPreludeType) {
	  return thetype;
	}
	else if (typeof(thetype)==KAtomic) { /* is a private */
	      if (IsTypeEntity(thetype.VAtomic->rep_internalType)) {
		return FindUltimateInternalType(thetype.VAtomic->rep_internalType.VTypeEntity);
	      }
	      else return thetype;
	    }
	else return thetype;
}


TypeEntity FindInvarType(invst, thetype, portname, target)
StructureEntity invst;
TypeEntity thetype;
String portname;
TargetEntity target;
{
    	SETTypeEntity SType;
	TypeEntity AType;
	Boolean found=FALSE;
	TypeEntity GetCorrespPreludeType();

	Assume((IsStructureEntity(invst)&&IsTypeEntity(thetype)),
		"FindInvarType");

	if (thetype.IDLclassCommon->sem_isPreludeType) {
	  return(GetCorrespPreludeType(target,thetype));
	}
	else {
	  foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if (typeof(AType)==typeof(thetype) &&
	        strequal(AType.IDLclassCommon->sem_name,
			 thetype.IDLclassCommon->sem_name)){
	      found = TRUE;
	      break;
	    }
	  }

	  if (found)
	    return AType;
	  else Fatal2(1002, invst->lex_endpos, 
		      thetype.IDLclassCommon->sem_name, portname);
	}
        /*NOTREACHED*/
}


int FindSet(st, component, setfound)
StructureEntity st;
NamedType component;
SetOf *setfound;
{
	SETSetOf SSet;
	SetOf ASet;
	char buf[81];

	(void)sprintf(buf, "FindSet %s", component.IDLclassCommon->sem_name);
	Assume((IsStructureEntity(st)&&IsNamedType(component)&&
		(setfound!=NULL)),
		buf);
	foreachinSETSetOf(st->inv_sets, SSet, ASet) {
	    if (EqualClasses(ASet->sem_component, component)) {
		*setfound = ASet;
		return(FOUND);
	    }
	}
	return(NOTFOUND);
}


int FindSeq(st, component, seqfound)
StructureEntity st;
NamedType component;
SeqOf *seqfound;
{
	SETSeqOf SSeq;
	SeqOf ASeq;

	Assume((IsStructureEntity(st)&&IsNamedType(component)&&
		(seqfound!=NULL)),
		"FindSeq");

	foreachinSETSeqOf(st->inv_seqs, SSeq, ASeq) {
	    if (EqualClasses(ASeq->sem_component, component)) {
		*seqfound = ASeq;
		return(FOUND);
	    }
	}
	return(NOTFOUND);
}


Boolean ShouldGenerateMacros(target)
TargetEntity target;
{
	SEQString SStr;
	String AStr;
	Boolean Version=FALSE;
	Boolean NCStringMatch();

	foreachinSEQString(target->sem_id, SStr, AStr) {
	    if (Version && NCStringMatch(AStr, "B")) {
		return(TRUE);
	    }
	    else if (NCStringMatch(AStr, "Version")) {
		Version = TRUE;
	    }
	}
	return(FALSE);
}


Boolean CTarget(target)
TargetEntity target;
{
	SEQString SStr;
	String AStr;
	Boolean NCStringMatch();

	foreachinSEQString(target->sem_id, SStr, AStr) {
	    if (NCStringMatch(AStr, "C"))
		return(TRUE);
	}
	return(FALSE);
}


Boolean PascalTarget(target)
TargetEntity target;
{
	SEQString SStr;
	String AStr;
	Boolean NCStringMatch();

	foreachinSEQString(target->sem_id, SStr, AStr) {
	    if (NCStringMatch(AStr, "Pascal"))
		return(TRUE);
	}
	return(FALSE);
}


void CheckprintString(str, numargs) 
char * str;
int numargs;
{
    int i;
    int len;
    int count=0;
    len = strlen(str);
    for (i=0; i<len; i++)
	if (str[i]=='%') {
	    if (str[i+1]!='%') ++count;
	    else ++i;
	}
    if (count != numargs)
	Assume1((FALSE), "wrong # of args for output%d", numargs);
}


Boolean InsertTypeAtomic(n1, n2)
Atomic n1, n2;
{
	register char c1, c2;
	register char *cp1, *cp2;
	Boolean insert=FALSE;

/*	Assume((IsNamedType(n1)&&IsNamedType(n2)), "SwapTypes"); */

	cp1 = n1->sem_name;
	cp2 = n2->sem_name;
	 
	while (*cp1 && *cp2) {
	    if (isupper(*cp1))
		c1 = tolower(*cp1);
	    else c1 = *cp1;
	    if (isupper(*cp2))
		c2 = tolower(*cp2);
	    else c2 = *cp2;
	    if (c2 < c1) {
		insert = TRUE;
		break;
	    }
	    else if (c1 < c2) {
		break;
	    }
	    else {  /* equal so far */
		++cp1;
		++cp2;
		if ( *cp2 == '\0') { /* if names are same, insert n2 before n1*/
		    insert = TRUE;
		    break;
		}
	    }
	}
	return(insert); /* n2 inserted before n1 if insert=TRUE*/
}

Boolean InsertTypeClass(n1, n2)
Class n1, n2;
{
	register char c1, c2;
	register char *cp1, *cp2;
	Boolean insert=FALSE;

/*	Assume((IsNamedType(n1)&&IsNamedType(n2)), "SwapTypes"); */

	cp1 = n1->sem_name;
	cp2 = n2->sem_name;
	 
	while (*cp1 && *cp2) {
	    if (isupper(*cp1))
		c1 = tolower(*cp1);
	    else c1 = *cp1;
	    if (isupper(*cp2))
		c2 = tolower(*cp2);
	    else c2 = *cp2;
	    if (c2 < c1) {
		insert = TRUE;
		break;
	    }
	    else if (c1 < c2) {
		break;
	    }
	    else {  /* equal so far */
		++cp1;
		++cp2;
		if ( *cp2 == '\0') { /* if names are same, insert n2 before n1*/
		    insert = TRUE;
		    break;
		}
	    }
	}
	return(insert); /* n2 inserted before n1 if insert=TRUE*/
}

TypeEntity GetCorrespPreludeType(target, type)
TargetEntity target;
TypeEntity type;
{
    SEQRefinedTypePair SPr;
    RefinedTypePair APr;

    foreachinSEQRefinedTypePair(target->pre_refinedtypePrs, SPr, APr) {
	if (SameType(type, APr->pre_targetIndependent)) {
	    return(APr->pre_targetDependent);
	}
    }

    /* if this point is reached, type is in target */
    return(type);
}


Atomic GetPortAtomic(aport, atom)
Port aport;
Atomic atom;
{
    StructureEntity st;
    SETTypeEntity SType;
    TypeEntity AType;

    if (TypeOfEntity(aport->syn_data)==KStructureEntity) {
      st = GetStructureEntity(aport->syn_data);
      foreachinSETTypeEntity(st->sem_types, SType, AType) {
	if (typeof(AType)==KAtomic && AType.VAtomic->sem_name == atom->sem_name)
	    return(AType.VAtomic);
      }
    }

    /* if this point is reached there is an error since atom must
     * have a type in the port structure
     * return atom so there is no core dump but should exit in DEBUG mode
     */
     Assume(FALSE, "GetPortAtomic");
     return(atom);
}
