/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/main.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									*
*   Function: The Backend phase of the idl compiler.			*
*									*
*           main    GetVersion             				*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: main.c,v 1.1 89/07/05 16:35:42 kps Locked $";
#endif

/* modified by Bong Uichanco 5/30/88 to handle 3 instead of 2 files */
/*   when the splitCode (-s) option is used.                        */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	main.c,v $
 * Revision 1.1  89/07/05  16:35:42  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/14  18:34:55  cheung
 * main.c version 4.0
 * 
 * Revision 4.0  89/04/12  14:43:49  cheung
 * main.c version 4.0
 * 
 * Revision 3.9  89/04/12  14:43:16  cheung
 * main.c version 3.9
 * 
 * Revision 4.0  89/04/12  01:22:46  cheung
 * main.c  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:23:24  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/30  14:12:09  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:26:10  cheung
 * main.c  Ver 3.9
 * 
 * Revision 3.2  87/11/30  14:58:25  rajan
 * *** empty log message ***
 * 
 * Revision 1.1  87/04/18  11:58:48  shannon
 * Initial revision
 * 
 * Revision 2.4  86/05/15  05:27:45  shannon
 * Version 2.4
 * 
 * Revision 2.3  86/05/05  15:16:42  shannon
 * Version 2.3 of IDL System
 * 
 * Revision 2.2  86/04/08  12:52:38  shannon
 * Version2.2
 * 
 * Revision 2.1  86/03/20  16:57:02  shannon
 * SEI Relase
 * 
 * Revision 2.0  86/01/22  07:27:00  shannon
 * Release 2.0 of IDL System
 * 
 * Revision 1.8  85/08/27  20:27:13  shannon
 * moved init statement outside loop for keyword list
 * 
 * Revision 1.7  85/07/31  09:51:44  shannon
 * changed code for different representation of null class
 * 
 * Revision 1.6  85/07/23  21:08:39  shannon
 * changed null class restrictions in CheckForNull
 * 
 * 
 * Revision 1.5  85/07/18  19:52:11  shannon
 * added special representation processing
 * 
 * Revision 1.4  85/07/05  20:48:44  shannon
 * added unmarker port processing
 * 
 * Revision 1.3  85/07/03  19:47:43  shannon
 * added check for different target languages other than C
 * 
 * Revision 1.2  85/06/25  18:36:36  shannon
 * moved generateincludefile routine from this file to gencfile.c
 * 
 * Revision 1.1  85/06/11  10:05:13  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (rts) Created.						*
*									*
\* ******************************************************************* */

#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include "Backend.h"
#include "macros.h"
#include "misc.h"
#include "gencfile.h"
#include "genpfile.h"
#include "gencfile2.h"
#include "flags.h"

# define MAXFILENAMELENGTH 81

FILE *err_out;			/* error file */
Boolean absinclpath=TRUE; /* use absolute path names for include files*/
extern Boolean ReaderOK;	/* set by reader */
TypeEntity IDLTypeEntity;

char *IDLstrrchr();

char WRITERFILE[100];
char READERFILE[100];
char GLOBALFILE[100];
char PASCALWRITERFILE[100];
char PASCALREADERFILE1[100];
char PASCALREADERFILE2[100];
char PASCALGLOBALFILE[100];
char PASCALGLOBALFILE2[100];
char PASCALGLOBALFILE3[100];
		    
main(argc, argv)
int argc; 
char *argv[];
{
	
	SEQProcessEntity SPr;	    /* seq traversal*/
	ProcessEntity Thisprocess;  /* current process */
	SETPort SPort;		    /* set traversal*/
	Port Thisport;		    /* current port */
	compilationUnit compUnit;   /* the compilation unit */
	StructureEntity invst;	    /* invariant structure of a process */
	Boolean verbosemode = FALSE;/* indicator of verbode mode */
	Boolean keepCfile = FALSE;  /* indicator to keep code file */
	Boolean compileCodefile=TRUE;  /* indicator to compile Code file */
	Boolean hascodefile=TRUE;   /* indicator of a code file present */
	Boolean splitCodefile=FALSE;   /* indicator to split code file */
	char buf[512];		    /* buffer for system commands */
	int i;			    /* index */
	int status;		    /* status of code generator */
	char *ccErrors;		    /* name of file for cc errors */
	Boolean printstats=FALSE;   /* indicator to print statistics */
	FILE *statsfile;	    /* statistics file */
	char ccflags[512];	    /* flags for C compiler */
	char pcflags[512];	    /* flags for Pascal compiler */
	char ccompiler[512];	    /* C compiler */
	char pcompiler[512];	    /* Pascal compiler */
	char *compiler;		    /* Compiler name */
	char cflags[512];	    /* flags of compiler */
	char *suffix;		    /* ".c" or ".p" */
	char *lang_name;	    /* C or Pascal */
	char *incdir;		    /* include directory */
	char candlefile[600];      /* path of candle file */
	char *cp;
	char *GetInternalName();
	char curdir[1024];
	FILE *fopen();
        void exit();
#ifndef hpux
	char *getwd();
#endif
#ifdef hpux
	char *getcwd();
#endif


	/* initialize */
	candlefile[0] = '\0';
	err_out = stderr;
	cflags[0] = '\0';
	ccErrors = "/tmp/IDLccErrors";
	incdir = ".";

	/* process command line arguments */
	for (i=1; i<argc; i++) {
	    if (!strcmp(argv[i],"-k"))
		keepCfile = TRUE;
	    else if (!strcmp(argv[i],"-nc")) {
		compileCodefile = FALSE;
	    }
	    else if (!strcmp(argv[i],"-S")) {
		splitCodefile = TRUE;
	    }
	    else if (!strcmp(argv[i],"-v")) {
		verbosemode = TRUE;
	    }
	    else if (!strcmp(argv[i],"-h")) {
		absinclpath = FALSE;
	    }
	    else if (!strncmp(argv[i], "-P", 2)) {
		argv[i][1] = 'I';
		(void) strcat(cflags, argv[i]);
	    }
	    else if (!strcmp(argv[i], "-c")) {
		if (i+1 < argc){
		    ++i;
		    ccErrors = argv[i];
		}
	    }
	    else if (!strcmp(argv[i], "-ps")) {
		if (i+1 < argc){
		    ++i;
		    if ((statsfile = fopen(argv[i], "w")) == NULL) {
			Fatal1(21, 0, argv[i]);
		    }
		    printstats = TRUE;
		}
		else Fatal0(20, 0);
	    }
	    else if (!strcmp(argv[i], "-cc")) {
                if (i+1 < argc) {
                    ++i;
                    (void) strcpy(ccompiler,argv[i]);
                }
                /* No error checking : all done by shell file */
            }
	    else if (!strcmp(argv[i], "-cf")) {
                if (i+1 < argc) {
                    ++i;
                    (void) strcpy(ccflags,argv[i]);
                }
                /* No error checking : all done by shell file */
            }
	    else if (!strcmp(argv[i], "-pc")) {
                if (i+1 < argc) {
                    ++i;
                    (void) strcpy(pcompiler,argv[i]);
                }
                /* No error checking : all done by shell file */
            }
	    else if (!strcmp(argv[i], "-pf")) {
                if (i+1 < argc) {
                    ++i;
                    (void) strcpy(pcflags,argv[i]);
                }
                /* No error checking : all done by shell file */
            }
	    else if (!strncmp(argv[i], "-ID", 3)) {
		incdir = &argv[i][3];
	    }
	    else if (!strcmp(argv[i], "-e")) {
		if (i+1 >= argc)
		    Fatal0(16, 0);
		else {
		    ++i;
		    if ((err_out = fopen(argv[i], "w")) == NULL){
			Fatal1(17, 0, argv[i]);
		    }
		}
	    }
	    else if (!strcmp(argv[i], "-C")) {
		if (++i < argc){	/* no error checking for this */
		    if (cp=IDLstrrchr(argv[i], '/')) {
			*cp = '\0';
			(void) chdir(argv[i]);
			++cp;
		    }
		    else cp = argv[i];
#ifndef hpux
		    (void)getwd(curdir);
#endif
#ifdef hpux
		    (void)getcwd(curdir,1024);
#endif
		    (void)sprintf(candlefile, "%s/%s", curdir, cp);
		}
	    }
	}


    /* initialize include file paths */
    if (absinclpath == TRUE)
      {
       (void)sprintf(WRITERFILE, "%s/C/writer.h", incdir);
       (void)sprintf(READERFILE, "%s/C/reader.h", incdir);
       (void)sprintf(GLOBALFILE, "%s/C/global.h", incdir);
       (void)sprintf(PASCALWRITERFILE, "%s/Pascal/writer.h", incdir);
       (void)sprintf(PASCALREADERFILE1, "%s/Pascal/reader1.i", incdir);
       (void)sprintf(PASCALREADERFILE2, "%s/Pascal/reader2.i", incdir);
       (void)sprintf(PASCALGLOBALFILE, "%s/Pascal/global.h", incdir);
       (void)sprintf(PASCALGLOBALFILE2, "%s/Pascal/global2.h", incdir);
       (void)sprintf(PASCALGLOBALFILE3, "%s/Pascal/global3.h", incdir);
      }
    else
      {
       (void)sprintf(WRITERFILE, "C/writer.h");
       (void)sprintf(READERFILE, "C/reader.h");
       (void)sprintf(GLOBALFILE, "C/global.h");
       (void)sprintf(PASCALWRITERFILE, "Pascal/writer.h");
       (void)sprintf(PASCALREADERFILE1, "Pascal/reader1.i");
       (void)sprintf(PASCALREADERFILE2, "Pascal/reader2.i");
       (void)sprintf(PASCALGLOBALFILE, "Pascal/global.h");
       (void)sprintf(PASCALGLOBALFILE2, "Pascal/global2.h");
       (void)sprintf(PASCALGLOBALFILE3, "Pascal/global3.h");
      }

    /* Read in the Candle structure */

    status = 1;
    compUnit = INCandle(stdin);
    if (!ReaderOK) {
	exit(status);
    }
    if (verbosemode) {
	(void) fprintf(stderr, "idlc: code generation\n");
	(void) fflush(stderr);
    }

    foreachinSEQProcessEntity(compUnit->sem_processes, SPr, Thisprocess) {
	if (typeof(Thisprocess->sem_target) == KVoid) {
	    Warning0(403, Thisprocess->lex_endpos);
	    continue;
	}
	if ((typeof(Thisprocess->syn_invariant) == KVoid)&&
		emptySETPort(Thisprocess->sem_ports)) {
	    Warning0(402, Thisprocess->lex_endpos);
	    continue;
	}

	invst = Thisprocess->sem_invariant;

	if (verbosemode) {
	    (void) fprintf(stderr, 
                "idlc:    generating code for process '%s'\n", 
                Thisprocess->lex_name);
	    (void) fflush(stderr);
	}

	/* calculate invariant pointers for types */
	CalculateInvarPtrs(Thisprocess);

	/* calculate extra fields needed */
	CalculateExtraFields(invst);

	/* For each port in this process calculate the extra fields */
	foreachinSETPort(Thisprocess->sem_ports,SPort,Thisport)
	  CalculateExtraFields(Thisport->syn_data->sem_entity.VStructureEntity);

	/* determine flag sets */
	SetFlags(Thisprocess);

	/* generate the code files for each language */

	if (CTarget(Thisprocess->sem_target.VTargetEntity)) {
	    lang_name = "C";

	    /* set special representation types */
	    SetCTypes(invst);


	    /* Generate the .h file	*/

	    generateincludefile(Thisprocess);

	    /* if there are ports, generate and compile the .c file */

	    if (!emptySETPort(Thisprocess->sem_ports) || 
		ShouldGenerateMacros(Thisprocess->sem_target.VTargetEntity))
	      {
		/* Generate the .c file */
		/* eventually add a check here to determine Version A or B */
		generateCcodefileA(Thisprocess, splitCodefile, 
				   (long) compUnit->rep_comptimestamp, 
                                   candlefile);
		compiler = ccompiler;
                (void) strcat(cflags, " ");
                (void) strcat(cflags, ccflags);
		suffix = ".c";
	        hascodefile = TRUE;
	      }
	    else hascodefile = FALSE;

	    /* generate interface macros file if specified */
	    if (ShouldGenerateMacros(Thisprocess->sem_target.VTargetEntity)) {
		GenerateCMacros(Thisprocess);
	    }
	}
	else if (PascalTarget(Thisprocess->sem_target.VTargetEntity)) {
	    lang_name = "Pascal";
	    /* Generate the .h file */
	    genPascalincludefile(Thisprocess);

	    /* Generate the .p file */
	    compiler = pcompiler;
            (void) strcat(cflags, " ");
            (void) strcat(cflags, pcflags);
	    suffix = ".p";
	    genPascalcodefile(Thisprocess, splitCodefile);
	    hascodefile = TRUE;

	    /* generate interface macros file if specified */
	    if (ShouldGenerateMacros(Thisprocess->sem_target.VTargetEntity)) {
		 GeneratePascalMacros(Thisprocess); 
	    }
	}
	else {
	    Warning1(406, Thisprocess->lex_endpos, "C");
	    continue;
	}

	/*if -h option given compile code with name of include dir 
         (-Iincdir) flag */
	if (absinclpath == FALSE)
	  {
	   (void) strcat (cflags, " -I");
           (void) strcat (cflags,incdir);
	  }


	if (hascodefile && compileCodefile ) {
	    /* Compile the code file(s) */

	    if (verbosemode) {
		(void) fprintf(stderr, 
		    "idlc:    compiling port routines for process '%s'\n", 
		    Thisprocess->lex_name);
		(void) fflush(stderr);
	    }
	    /* The 3>&1 is necessary because some compilers, e.g., pc on a
	       Sequent, write to file descriptor 3. */
	    if (splitCodefile) {
		(void)sprintf(buf, "(%s -c %s %s1%s 2>&1 3>&1)>>%s; (%s -c %s %s2%s 2>&1 3>&1)>>%s; (%s -c %s %s3%s 2>&1 3>&1)>>%s", 
			    compiler,
			    cflags, Thisprocess->lex_name, suffix, ccErrors,
			    compiler,
			    cflags, Thisprocess->lex_name, suffix, ccErrors,
			    compiler,
			    cflags, Thisprocess->lex_name, suffix, ccErrors);
	    }
	    else {
		(void)sprintf(buf, "(%s -c %s %s%s 2>&1 3>&1)>>%s", 
			    compiler,
			    cflags, Thisprocess->lex_name, suffix, ccErrors);
	    }
	    if (system(buf)) {
		Recoverable2(367, 0, lang_name, ccErrors);
		keepCfile = TRUE;
	    }
	    else { /* remove temporary file for compile errors */
		(void) unlink(ccErrors);
	    }

	    if (!keepCfile) {
		if (splitCodefile) {
		    (void)sprintf(buf, "%s1%s", Thisprocess->lex_name, suffix);
		    (void) unlink(buf);
		    (void)sprintf(buf, "%s2%s", Thisprocess->lex_name, suffix);
		    (void) unlink(buf);
		    (void)sprintf(buf, "%s3%s", Thisprocess->lex_name, suffix);
		    (void) unlink(buf);
		}
		else {
		    (void)sprintf(buf, "%s%s", Thisprocess->lex_name, suffix);
		    (void) unlink(buf);
		}
	    }
	} /* end if compile code file(s) */
    } /* end foreachinSEQStructureOrProcess */

    /* print statistics */
    if (printstats) {
	if (verbosemode) {
	  (void) fprintf(stderr, "idlc:    printing statistics\n");
	  (void) fflush(stderr);
	}
	PrintStatistics(statsfile, compUnit);
    }
    return 0;
		    
} /* main */




/* get the version number of the translator */
char *GetVersion()
{
	static Boolean firstcall=TRUE;
	static char *version;

	if (firstcall) {
	    firstcall = FALSE;
	    version = "5.0";
	}
	return(version);
}

