/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/macros.h 
*				 					* 
*   Copyright (C) 1991 Karen Shannon
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Macros for commonly used defines 				*
*									*
*									*
\* ******************************************************************* */


/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	macros.h,v $
 * Revision 1.1  89/07/05  16:35:38  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:22:38  cheung
 * macros.h  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:23:16  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.9  89/03/30  14:12:02  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:26:01  cheung
 * macros.h  Ver 3.9
 * 
 * Revision 3.3  88/04/06  11:24:39  rajan
 * Modification made by Karen Shannon so that structures that have a class
 * as the root are supported.
 * 
 * Revision 3.2  88/04/06  11:21:22  rajan
 * Version supplied with the 3.2 distribution
 * 
 * Revision 3.2  87/11/30  14:58:21  rajan
 * *** empty log message ***
 * 
 * Revision 1.1  87/04/18  11:59:13  shannon
 * Initial revision
 * 
 * Revision 1.1  85/06/11  10:20:14  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     Jan 9 1985 (shannon) Created.					*
*									*
\* ******************************************************************* */

/* function declarations */
/*char *sprintf(); */


#define NOTFOUND 	0
#define FOUND 		1
#define NOTEQUAL 	0
#define EQUAL 		1


/* default names */

#define IDLDEFAULTINVARIANTNAME "IDLDefaultInvar"
#define IDLCOPIEDINVNAME "IDLCopiedInvariant"
#define DEFAULT_LANG	"C"
#define DEFAULTROOTNAME "defaultrootname"

#define ARRAY "array"
#define BITVECTOR "bitvector"

#define MAXFILENAMELENGTH 81
#define DARRAYPREFIX "DARR"
#define FARRAYPREFIX "FARR"
#define LLISTPREFIX "L"
#define ARRAYPREFIX "ARR"
#define SEQPREFIX "SEQ"
#define SETPREFIX "SET"


/* output macros (checks # of arguments) */
#define output0(f, str)				\
	{Check(str, 0); (void) fprintf(f, str);}
#define output1(f, str, a1)			\
	{Check(str, 1); (void) fprintf(f, str, a1);}
#define output2(f, str, a1, a2)			\
	{Check(str, 2); (void) fprintf(f, str, a1, a2);}
#define output3(f, str, a1, a2, a3)		\
	{Check(str, 3); (void) fprintf(f, str, a1, a2, a3);}
#define output4(f, str, a1, a2, a3, a4)		\
	{Check(str, 4); (void) fprintf(f, str, a1, a2, a3, a4);}
#define output5(f, str, a1, a2, a3, a4, a5)	\
	{Check(str, 5); (void) fprintf(f, str, a1, a2, a3, a4, a5);}


/* macros for debugging --eventually will be conditionally compiled out */
#ifdef DEBUG1
char Assumebuf[100];
#define Assume(cond, procname)	\
	{if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", procname);\
		       exit(1); } \
	 else (void) fprintf(stderr, "DEBUG: %s\n", procname); }
#define Assume1(cond, string, arg)	\
	 {(void)sprintf(Assumebuf, string, arg); \
	 if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", Assumebuf);\
		       exit(1); } \
	 else (void) fprintf(stderr, "DEBUG: %s\n", Assumebuf); }
#define Check(s, n) CheckprintString(s, n)
#else 
#ifdef DEBUG2
char Assumebuf[100];
#define Assume(cond, procname)	\
	{if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", procname);\
		       exit(1); } }
#define Assume1(cond, string, arg)	\
	 {(void)sprintf(Assumebuf, string, arg); \
	 if (!(cond)) {(void) fprintf(stderr,"DEBUG: failed in %s\n", Assumebuf);\
		       exit(1); } }
#define Check(s, n) CheckprintString(s, n)
#else
#define Assume(cond, procname)
#define Assume1(cond, string, arg)
#define Check(s, n)
#endif
#endif

/* macro for setting an entity to error */
#define SetErrorEntity(ref)	ref->sem_entity.Verror = Nerror;

/* macro for testing if an entity is error */
#define EntityIsError(ref)	(typeof(ref->sem_entity) == Kerror)


/* macros for returning the type of an entity */
#define TypeOfEntity(ref)	typeof(ref->sem_entity)

/* macros for setting entities of references to th correct types */
#define SetAssertEntity(ref, as)	ref->sem_entity.VAssertion = as
#define SetAtomicEntity(ref, at)	ref->sem_entity.VAtomic = at
#define SetAttOpEntity(ref, op)		ref->sem_entity.VAttributeOperation = op
#define SetAttributeEntity(ref, att)	ref->sem_entity.VAttribute = att
#define SetClassEntity(ref, cl)		ref->sem_entity.VClass = cl
#define SetClassOpEntity(ref, op)	ref->sem_entity.VClassOperation = op
#define SetDefineEntity(ref, def)	ref->sem_entity.VDefinition = def
#define SetNamedTypeEntity(ref, nt)	ref->sem_entity.VNamedType = nt
#define SetOpEntity(ref, op)		ref->sem_entity.VOperation = op
#define SetPortEntity(ref, aport)	ref->sem_entity.VPort = aport
#define SetProcessEntity(ref, pr)	ref->sem_entity.VProcessEntity = pr
#define SetRepEntity(ref, arep)		ref->sem_entity.VRep = arep
#define SetSetEntity(ref, aset)		ref->sem_entity.VSetOf = aset
#define SetSeqEntity(ref, aseq)		ref->sem_entity.VSeqOf = aseq
#define SetStructureEntity(ref, st)	ref->sem_entity.VStructureEntity = st
#define SetTypeEntity(ref, t)	ref.IDLclassCommon->sem_entity.VTypeEntity = t

/* macros for getting entities of references */
#define GetAssertEntity(ref) ref->sem_entity.VAssertion
#define GetAtomicEntity(ref) ref->sem_entity.VAtomic
#define GetAttOpEntity(ref) ref->sem_entity.VAttOp
#define GetAttributeEntity(ref) ref->sem_entity.VAttribute
#define GetClassEntity(ref) ref->sem_entity.VClass
#define GetClassOpEntity(ref) ref->sem_entity.VClassOp
#define GetDefineEntity(ref) ref->sem_entity.VDefinition
#define GetNamedTypeEntity(ref) ref->sem_entity.VNamedType
#define GetOpEntity(ref)  ref->sem_entity.VOperation
#define GetPortEntity(ref) ref->sem_entity.VPort
#define GetProcessEntity(ref) ref->sem_entity.VProcessEntity
#define GetRepEntity(ref) ref->sem_entity.VRep
#define GetSeqEntity(ref) ref->sem_entity.VSeqOf
#define GetSetEntity(ref) ref->sem_entity.VSetOf
#define GetStructureEntity(ref) ref->sem_entity.VStructureEntity
#define GetTypeEntity(ref) ref.IDLclassCommon->sem_entity.VTypeEntity

/* macro for getting a type name */
#define GetTypeName(t)	t.IDLclassCommon->sem_name

/* macro for testing the equivalence of types */
#define SameType(t1, t2) (t1.IDLinternal == t2.IDLinternal)

/* macro for testing equality of 2 strings */
#define strequal(s1,s2) (s1 == s2)

/* macros to get position of type */
#define GetTypePos(t)  (typeof(t)==KNamedTypeRef) ? \
			t.VNamedTypeRef->lex_namepos : \
			t.VSetOrSeqRef.IDLclassCommon->lex_keywordpos

/* macros for testing for correct node type */
#define ntypeof(n)	(n->IDLhidden.TypeID)
#define IsAssertion(n) (ntypeof(n)==KAssertion)
#define IsAtomic(n)	(ntypeof(n)==KAtomic)
#define IsAtomicRep(n) (ntypeof(n)==KAtomicRep)
#define IsAttOrAll(n)  ((typeof(n)==KAttributeRef)||(typeof(n)==KAllAttributes))
#define IsAttribute(n) (ntypeof(n)==KAttribute)
#define IsattributeProduction(n) (ntypeof(n)==KattributeProduction)
#define IsattributeRestriction(n) (ntypeof(n)==KattributeRestriction)
#define IsBoolean(n) ((n==TRUE)||(n==FALSE))
#define IsClass(n) (ntypeof(n)==KClass)
#define IsClassOrAll(n) ((typeof(n)==KNamedTypeRef)||(typeof(n)==KAllClasses))
#define IsClassRep(n) (ntypeof(n)==KClassRep)
#define IscompilationUnit(n) (ntypeof(n)==KcompilationUnit)
#define IsContext(n) (ntypeof(n)==KContext)
#define IsDefInstance(n) ((typeof(n)==Kcyclic)||(typeof(n)==Knoncyclic)||\
		(typeof(n)==KPrivateDefInstance))
#define IsExpRef(n) ((typeof(n)==KExpSetRef)||(typeof(n)==KExpSeqRef)||\
			 (typeof(n)==KExpNameRef))
#define Isexpression(n) ((typeof(n)==Kconditional)||(typeof(n)==Kforall)||\
			 (typeof(n)==Kexists)||(typeof(n)==Kbinary)||\
			 (typeof(n)==Kunary)||(typeof(n)==Kapplication)||\
			 (typeof(n)==Kdotted)||(typeof(n)==KportExpression)||\
			 IsExpRef(n)||Isliteral(n))
#define IsInputPort(n)  (typeof(n->sem_portType)==KPrePort)
#define Isliteral(n) ((typeof(n)==KintegerToken)||(typeof(n)==KstringToken)||\
		      (typeof(n)==KrationalToken)||(typeof(n)==Kroot)||\
		      (typeof(n)==Kempty)||(typeof(n)==Ktrue)||\
		      (typeof(n)==Kfalse))
#define IsNamedType(n)	((typeof(n)==KClass) || (typeof(n)==KAtomic))
#define IsNamedTypeRef(n) (ntypeof(n)==KNamedTypeRef)
#define IsOutputPort(n) (typeof(n->sem_portType)==KPostPort)
#define IsportDefinition(n) (ntypeof(n)==KportDefinition)
#define IsProcessEntity(n) (ntypeof(n)==KProcessEntity)
#define Isproduction(n) \
	((typeof(n)==KattributeProduction)||(typeof(n)==KsubclassProduction))
#define Isrestriction(n) \
	((typeof(n)==KtypeRestriction)||(typeof(n)==KattributeRestriction))
#define IsSeqRep(n) (ntypeof(n)==KSeqRep)
#define IsSeqOf(n) (ntypeof(n)==KSeqOf)
#define IsSetOf(n) (ntypeof(n)==KSetOf)
#define IsSetOrSeq(n) ((typeof(n)==KSetOf)||(typeof(n)==KSeqOf))
#define IsSetRep(n) (ntypeof(n)==KSetRep)
#define IsString(n) (n!=NULL)
#define IsStructureEntity(n) (ntypeof(n)==KStructureEntity)
#define IsStructureRef(n) (ntypeof(n)==KStructureRef)
#define IssubclassProduction(n) (ntypeof(n)==KsubclassProduction)
#define IsTargetLanguage(n) (ntypeof(n)==KTargetLanguage)
#define IstargetStmt(n) (ntypeof(n)==KtargetStmt)
#define IsTypeEntity(n) ((typeof(n)==KClass)||(typeof(n)==KAtomic)||\
			 (typeof(n)==KSetOf)||(typeof(n)==KSeqOf))
#define IsTypeRef(n) ((typeof(n)==KNamedTypeRef)||(typeof(n)==KSetRef)||\
		(typeof(n)==KSeqRef))
#define IsTypeRefOrVoid(n) (IsTypeRef(n)||typeof(n)==KVoid)
#define IsTypeRep(n) (typeof(n)==KClassRep || typeof(n)==KAtomicRep || \
			typeof(n) == KSetRep || typeof(n) == KSeqRep )
#define IstypeRestriction(n) (ntypeof(n)==KtypeRestriction)
#define IswithoutAssert(n) (ntypeof(n)==KwithoutAssert)
#define IswithoutClause(n) (ntypeof(n)==KwithoutClause)
#define IswithoutDefine(n) (ntypeof(n)==KwithoutDefine)
#define IswithoutProduction(n) \
		((typeof(n)==KwithoutAttribute)||(typeof(n)==KwithoutSubclass))
#define IswithoutType(n) (ntypeof(n)==KwithoutType)

/* macros for checking if two classes are equivalent */
#define EqualClasses(c1, c2) \
	((typeof(c1)==typeof(c2))&&(c1.IDLclassCommon==c2.IDLclassCommon))


/* macros for de-referencing */
#define GetComponentType(setorseq) setorseq.IDLclassCommon->sem_component
#define IsClassType(c)  \
	(!emptySETClass(c->sem_subclasses))
#define IsNodeType(c)   \
	(emptySETClass(c->sem_subclasses))
#define GetRoot(st) st->sem_root.VTypeEntity.IDLclassCommon->invar
#define RootName(st) \
	st->sem_root.VTypeEntity.IDLclassCommon->invar.IDLclassCommon->rep_name
#define GetExternalRepName(er) \
	er.VTypeEntity.IDLclassCommon->rep_name

/* attribute routines */
int 		Att_Offset();
TypeEntity 	GetAttributeType();
String 		GetAttTypeName();
int 		AttributeType();

/* macros for error handling */
#include "error.h"

/* macros for type conversion */

extern TypeEntity IDLTypeEntity;
#define SetOfToTypeEntity(IDLA) (IDLTypeEntity.VSetOf=IDLA, IDLTypeEntity)
extern TypeEntity IDLTypeEntity;
#define SeqOfToTypeEntity(IDLA) (IDLTypeEntity.VSeqOf=IDLA, IDLTypeEntity)
extern TypeEntity IDLTypeEntity;
#define ClassToTypeEntity(IDLA) (IDLTypeEntity.VClass=IDLA, IDLTypeEntity)
extern TypeEntity IDLTypeEntity;
#define AtomicToTypeEntity(IDLA) (IDLTypeEntity.VAtomic=IDLA, IDLTypeEntity)
