/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/genpfile.c 
*				 					* 
*   Copyright (C) 1991 Micahel Shapiro, Karen Shannon, Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Routines used for generating Pascal .h and .p file	*
*									*
*           genPascalcodefile genPascalincludefile			*
*									*
\* ******************************************************************* */

#ifndef lint
    static char rcsid[] = "$Header: genpfile.c,v 1.1 89/07/05 16:35:35 kps Locked $";
#endif

/* ******************************************************************* *\
 *   Revision Log:							*
 *	$Log:	genpfile.c,v $
 * Revision 1.1  89/07/05  16:35:35  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/16  00:36:19  cheung
 * genpfile.c version 4.0
 * 
 * Revision 4.0  89/04/12  01:20:30  cheung
 * genpfile.c  Ver 4.0
 * 
 * Revision 3.9  89/04/10  17:11:45  cheung
 * genpfile.c version 3.9
 * 
 * Revision 3.9  89/04/07  23:22:24  cheung
 * genpfile.c  Ver 3.9
 * 
 * Revision 3.9  89/03/30  14:11:17  cheung
 * genpfile.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:25:12  cheung
 * genpfile.c  Ver 3.9
 * 
 *									*
 *   Edit Log:								*
 *     Mar  1985 (shannon) Created.					*
 *									*
\* ******************************************************************* */

#include "Backend.h"
#include "macros.h"
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include "flags.h"
#include "gencfile2.h"

char *IDLstrchr();

Boolean DefineOperation();

#define DEFAULTSETINTSIZE 1
#define MAXFILENAMELENGTH 81
#define MAXTYPELENGTH 81
#define PREFIX "T"
extern Boolean absinclpath;
extern char PASCALWRITERFILE[];
extern char PASCALREADERFILE1[];
extern char PASCALREADERFILE2[];
extern char PASCALGLOBALFILE[];
extern char PASCALGLOBALFILE2[];
extern char PASCALGLOBALFILE3[];

/*
 *    Forward References:
 */
void    generate_priv_includes();
void    GeneratePascalWriteMarkRoutines();
void    GeneratePascalReadRoutines();
void    AddPascalSetSeqDeclarations();
void    AddPascalSetSeqOpDecls();
void    AddPascalSetSeqOperations();
void    GeneratePascalMacros();
void    TestPort();
char    *GetAttInit();
String  GetAttPath();
void    gen_with_for_new();
String  GetAncPath();
String  GetShortAncPath();
Boolean GetAncPath2();
String  GetDescPath();
String  GetDescConst();
void    write_rootclass_case();
void    write_indent();

/************************************/
/* generate the .h file		    */
/************************************/
void genPascalincludefile(Thisprocess )
ProcessEntity Thisprocess;
{
	FILE *incfile, *incfile2, *fopen();
	SETAtomic SAtomic;		/* set/seq traversals and values */
	Atomic AnAtomic;
	SETClass SClass;
	Class AClass;
	SEQClass SClass2;
	Class AClass2;
	SETClass SClass3;
	SETTypeEntity SType;
	TypeEntity AType;
	SETPort SPort;
	Port APort;
	SEQAttribute SAttribute;
	Attribute AnAttribute;
	SETflag flagset;
	StructureEntity invst;		/* invariant structure of process */
	String name;			/* for de-referencing */
	String name2;
	String packagename;
	char incfilename[MAXFILENAMELENGTH];
	int first_node=1;
	int NextPortId=0;
	int cnt, class_len;
	SEQString priv_files;		/* seq of private files included */
	char *GetDate();
	char *GetVersion();

	/* de-reference invariant structure of process */
	invst = Thisprocess->sem_invariant;

	(void)sprintf(incfilename, "%s.h", Thisprocess->lex_name);
	if ((incfile = fopen(incfilename, "w")) == NULL){
	    Fatal1(14, 0, Thisprocess->lex_name);
	}
	(void) fprintf(incfile, 
            "(* %s - IDL Pascal type definitions\n\tgenerated by idlc,",
	    incfilename);
	(void) fprintf(incfile, " version %s on %s*)\n", GetVersion(), 
            GetDate());

	(void)sprintf(incfilename, "%s.i", Thisprocess->lex_name);
	if ((incfile2 = fopen(incfilename, "w")) == NULL){
 	    Fatal1(14, 0, Thisprocess->lex_name);
	}
	(void) fprintf(incfile2, "(* %s - IDL Pascal function and procedure definitions\n\tgenerated by idlc,", incfilename);
	(void) fprintf(incfile2, " version %s on %s*)\n", GetVersion(), 
            GetDate());

	/* declare constants before types */
	(void) fputs("\n(* Node constants *)\n", incfile);
	foreachinSEQClass(invst->inv_nodes, SClass2, AClass){
	    name = AClass->rep_name;
	    if (first_node) {
		(void) fprintf(incfile, "const ");
		first_node = 0;
	    }
	    (void) fprintf(incfile, "\tK%s = %d;\n", name, AClass->rep_typeId);
	}
	(void) fprintf(incfile, "\n(* Port constants *)\n");
	NextPortId = 0;
	foreachinSETPort(Thisprocess->sem_ports, SPort, APort) {
	    if (first_node) {
		(void) fprintf(incfile, "const ");
		first_node = 0;
	    }
	    (void) fprintf(incfile, "\tP%s = %d;\n", APort->rep_name, 
                NextPortId);
	    NextPortId += 2;
	}

	(void) fprintf(incfile, "#include \'%s\'\n", PASCALGLOBALFILE2);

/*	class header declarations				*/
/*	Each class name is represented by a pointer to a	*/
/*	record that defines the class.				*/

	if (!emptySETClass(invst->inv_classes)) {
	    (void) fputs("\n(* Class Declarations *)\n\n", incfile);
	    foreachinSETClass(invst->inv_classes, SClass, AClass){
		name = AClass->rep_name;
		(void) fprintf(incfile, "\t%s = ^R%s;\n", name, name);
	    }
	}

	(void) fputs("\n(* Node Declarations *)\n\n", incfile);
	foreachinSEQClass(invst->inv_nodes, SClass2, AClass){
	    name = AClass->rep_name;
	    (void) fprintf(incfile, "\t%s = ^R%s;\n", name, name);
	}
	output0(incfile, "\tRNodeType  = record\n");
	output0(incfile, "   case Kind:integer of\n");
	foreachinSEQClass(invst->inv_nodes, SClass2, AClass) {
	    name = AClass->rep_name;
	    output3(incfile, "        K%s:(V%s:%s);\n", name, name, name);
	}
	output0(incfile, "   end;\n");
	output0(incfile, "nodeType = ^RNodeType;\n");
	output0(incfile, "\n");

	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if (typeof(AType)==KSetOf || typeof(AType)==KSeqOf) {
		(void) fputs("\n(* Sets and Sequences *)\n\n", incfile);
		break;
	    }
	}
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if ((typeof(AType)!=KClass) &&
		(typeof(AType)!=KAtomic)) 
		    continue;

	    name = AType.IDLclassCommon->rep_name;
	    flagset = AType.IDLclassCommon->inv_flags;

	    if (inSETflag(flagset, KILSET)) {
		(void) fprintf(incfile, "\tSET%s = ^CT%s;\n", name, name);
	    }
	    if (inSETflag(flagset, KILSEQ)) {
		(void) fprintf(incfile, "\tSEQ%s = ^CQ%s;\n", name, name);
	    }
	}

	/* process Private type declarations	*/

	if (!emptySETAtomic(invst->inv_privates)) 
	    (void) fputs("\n(* Private Types *)\n", incfile);

	/* first make sure that the private types are defined.*/
	initializeSEQString(priv_files);
	foreachinSETAtomic(invst->inv_privates, SAtomic, AnAtomic) {
	    if (!(AnAtomic->sem_isPreludeType)) {
	        if (typeof(AnAtomic->inv_internal)==KPackage) {
	 	    name = AnAtomic->rep_name;
		    packagename = AnAtomic->inv_internal.VPackage->rep_name;
		    if (!inSEQString(priv_files, packagename)) {
		        appendfrontSEQString(priv_files, packagename);
		        output1(incfile, "# include \"%s.h\"\n", packagename);
	            }
	        }
	        else if (IsTypeEntity(AnAtomic->inv_internal)) {
                    name = AnAtomic->rep_name;
	            output2(incfile, "\t%s = %s;\n",name,
	                AnAtomic->inv_internal.VTypeEntity.
                        IDLclassCommon->rep_name);
	        }
	    }
	}

	/* Node record declarations.	*/
	(void) fputs("\n(* Node record declarations *)\n", incfile);
	foreachinSEQClass(invst->inv_nodes, SClass2, AClass){
	    name = AClass->rep_name;
	    (void) fprintf(incfile, "\tR%s =  record\n",  name);
	    (void) fprintf(incfile, "\t    IDLhidden: IDLinternal;\n");

	    /* Generate pointers to all direct class ancestors		*/

	    if (!emptySETClass( AClass->sem_ancestors)) {
	        foreachinSETClass( AClass->sem_ancestors, SClass ,AClass2) {
		    name2 = AClass2->rep_name;
	            (void) fprintf(incfile, "\t    P%s:  %s;\n", name2, name2);
	        }
	    } 

	    /* Generate node attribute declarations */

	    foreachinSEQAttribute(AClass->sem_allattributes,
		SAttribute, AnAttribute) {

		   /* if attribute is propagated, don't print */
		   if (AnAttribute->inv_parent != AClass)
			continue;

		   (void) fprintf(incfile, "\t    %s:  %s;\n", 
                       AnAttribute->rep_name, GetAttTypeName(AnAttribute));
	    }
	    (void) fprintf(incfile, "\tend;\n");

	}
	(void) fprintf(incfile, "\n");

	/* class declarations */

	(void) fputs("\n(* Classes *)\n", incfile);
	foreachinSETClass(invst->inv_classes,SClass,AClass) {
	    name = AClass->rep_name;
	    (void) fprintf(incfile, "\tQ%s = (", name);
	    cnt = 0;
	    foreachinSETClass(AClass->sem_subclasses,SClass3,AClass2) {
		name2 = AClass2->rep_name;
		(void) fprintf(incfile, "K%s%s,", name, name2);
		if (++cnt % 2 == 0)
		    (void) fprintf(incfile, "\n\t\t");
	    }
	    (void) fprintf(incfile, "K%snull);\n", name);
	
	    (void) fprintf(incfile, "\tR%s  = record\n", name);
	    (void) fprintf(incfile, "\t    IDLhidden: IDLinternal;\n");
	    foreachinSETClass(AClass->sem_ancestors,SClass3,AClass2){
		name2 = AClass2->rep_name;
		(void) fprintf(incfile, "\t    P%s: %s;\n", name2, name2);
	    }
	    foreachinSEQAttribute(AClass->sem_allattributes,
		SAttribute, AnAttribute){

		   /* if attribute is propagated, don't print */
		   if (AnAttribute->inv_parent != AClass)
			continue;

		   (void) fprintf(incfile, "\t    %s:  %s;\n", 
                       AnAttribute->rep_name, GetAttTypeName(AnAttribute));
	    }

	    /* only print fields for direct descendants ??? */
	   (void) fprintf(incfile, "\tcase E%s: Q%s of\n", name, name);
	    foreachinSETClass(AClass->sem_subclasses,SClass3,AClass2){
		name2 = AClass2->rep_name;
		(void) fprintf(incfile, "\t\tK%s%s: (V%s: %s);\n", name, name2, 
		    name2, name2);
	    }
	    (void) fprintf(incfile, "\t\tK%snull: ();\n", name);
	    (void) fprintf(incfile, "\tend;\n");
	}

	(void) fprintf(incfile, "\tIDLClassEnumType = (");
	cnt=0;
	class_len = sizeSETClass(invst->inv_classes);
	foreachinSETClass(invst->inv_classes,SClass,AClass) {
	    (void) fprintf(incfile, "Pr%s", AClass->rep_name);
/*	    if (SClass->next != NULL) */
	    if (--class_len != 0)
		(void) fprintf(incfile, ", ");
	    if (++cnt % 4 == 0)
		(void) fprintf(incfile, "\n\t\t");
	}
	if (cnt == 0)
	    (void) fprintf(incfile, "IDLdummy");
	(void) fprintf(incfile,");\n");
	(void) fprintf(incfile, 
            "\tIDLClassSetType = set of IDLClassEnumType;\n\n");

	/*	set and sequences declarations 				*/
	/*	Each set or sequence is represented by a linked list	*/
	/*	of cells. Each set or sequence type is defined by a	*/
	/*	pointer to the first cell.				*/

	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if (typeof(AType)==KSetOf || typeof(AType)==KSeqOf) {
		(void) fputs("\n(* Sets and Sequence Declarations *)\n\n", 
                    incfile);
		break;
	    }
	}
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    AddPascalSetSeqDeclarations(invst, AType, incfile);
	}  /* end foreachinSETTypeEntity */ 
	(void) fprintf(incfile, "\n");

	/* global variable declarations */
	(void) fprintf(incfile, "#include \'%s\'\n", PASCALGLOBALFILE);

	/* set and seq function declarations */
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if (typeof(AType)==KSetOf || typeof(AType)==KSeqOf) {
		(void) fputs(
                    "\n(* Sets and Sequences Operation Declarations *)\n\n",
		    incfile2);
		break;
	    }
	}
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    AddPascalSetSeqOpDecls(invst, AType, incfile2);
	}  /* end foreachinSETTypeEntity */ 
	(void) fprintf(incfile2, "\n");

	/* Port declarations */
	if (!emptySETPort(Thisprocess->sem_ports))
	    (void) fputs("\n(* Port Declarations *)\n", incfile2);
	foreachinSETPort(Thisprocess->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) == KPrePort) {
		(void) fprintf(incfile2, "function %s(var f: text; var readerok: boolean): %s; external;\n", APort->rep_name, RootName(GetStructureEntity(APort->syn_data)));
	    }
	    else if (typeof(APort->sem_portType) == KPostPort) {
		(void) fprintf(incfile2, "procedure %s(var f: text; root: %s); external;\n", APort->rep_name, RootName(GetStructureEntity(APort->syn_data)));
	    }
	}

	/* Declare the initialization and free routines external */
	(void) fputs("\n(* Initialization function Declarations *)\n", 
            incfile2);
	foreachinSEQClass(invst->inv_nodes, SClass2, AClass){
	    name = AClass->rep_name;
	    if (!DefineOperation(ClassToTypeEntity(AClass), 
                "DefaultInitialize")) {
		    (void) fprintf(incfile2, 
                        "function I%s(A%sInstance: %s): %s;\n", name, name, 
                        name, name);
	    }
	    if (!DefineOperation(ClassToTypeEntity(AClass), 
                "DefaultFinalize")) {
		    (void) fprintf(incfile2, 
                        "procedure F%s(A%sInstance: %s);\n", name, name, name);
	    }
	}
	/* Declare the New routines external */
	foreachinSEQClass(invst->inv_nodes, SClass, AClass) {
	    name = AClass->rep_name;
	    output2(incfile2, "function N%s: %s; external;\n", name, name);
	}
	output0(incfile2, "\n");

	/* global procedure declarations */
	(void) fprintf(incfile2, "#include \'%s\'\n", PASCALGLOBALFILE3);

	(void) fflush(incfile);
	(void) fclose(incfile);
	(void) fflush(incfile2);
	(void) fclose(incfile2);
}

/***********************************/
/* generate the .p file		   */
/***********************************/
void genPascalcodefile(pr, SplitFile)
ProcessEntity pr;	/* process */
Boolean SplitFile;	/* indicator if .p file should be split into 2 */
{

	FILE *pfile1, *pfile2,
	     *fopen();				/* file pointer and fn */
	char pfilename1[MAXFILENAMELENGTH];	/* name of pfile generated */
	char pfilename2[MAXFILENAMELENGTH];	/* name of pfile generated */

	if (SplitFile) {
	    (void)sprintf(pfilename1, "%s1.p", pr->lex_name);
	    if ((pfile1 = fopen(pfilename1, "w")) == NULL){
	        Fatal1(15, 0, pr->lex_name);
	    }
	    (void)sprintf(pfilename2, "%s2.p", pr->lex_name);
	    if ((pfile2 = fopen(pfilename2, "w")) == NULL){
	        Fatal1(15, 0, pr->lex_name);
	    }
	}
	else {
	    (void)sprintf(pfilename1, "%s.p", pr->lex_name);
	    (void)sprintf(pfilename2, "%s.p", pr->lex_name);
	    if ((pfile1 = fopen(pfilename1, "w")) == NULL){
	        Fatal1(15, 0, pr->lex_name);
	    }
	    pfile2 = pfile1;
	}
	if (pfile1 != pfile2) {
	    output1(pfile1,"(* %s - IDL mark/write routines generated by idlc,",
	        pfilename1);
	    output2(pfile1, "\n\tversion %s on %s*)\n",GetVersion(), GetDate());
	    output1(pfile1, "#include \'%s.h\'\n", pr->lex_name);
	    output1(pfile1, "#include \'%s.i\'\n", pr->lex_name);
	    generate_priv_includes(pfile1, pr);

	    output1(pfile2,
                "(* %s - IDL read/set/seq routines generated by idlc,",
	        pfilename2);
	    output2(pfile2, "\n\tversion %s on %s*)\n",GetVersion(), GetDate());
	    output1(pfile2, "#include \'%s.h\'\n", pr->lex_name);
	    output1(pfile2, "#include \'%s.i\'\n", pr->lex_name);
	    generate_priv_includes(pfile2, pr);
	}
	else {
	    output1(pfile1, "(* %s - IDL read/mark/write/set/seq routines generated by idlc,", pfilename1);
	    output2(pfile1, "\n\tversion %s on %s*)\n",GetVersion(), GetDate());
	    output1(pfile1, "# include \'%s.h\'\n", pr->lex_name);
	    output1(pfile1, "#include \'%s\'\n\n", PASCALWRITERFILE);
	    output1(pfile1, "# include \'%s.i\'\n", pr->lex_name);
	    generate_priv_includes(pfile1, pr);
	}

	GeneratePascalWriteMarkRoutines(pfile1, pr);
	GeneratePascalReadRoutines(pfile2, pr);
	AddPascalSetSeqOperations(pfile2, pr);
	(void) fclose(pfile1);
	if (pfile2 != pfile1) 
	    (void) fclose(pfile2);
}


void generate_priv_includes(pfile, pr)
FILE *pfile;
ProcessEntity pr;
{
	SETPort		SPort;
	Port		APort;
	SETAtomic 	SAtomic;
	Atomic    	AnAtomic;
	Atomic    	AnAtomic2;
	TypeEntity	ext_type;
	TypeEntity	int_type;
	String		name;
	Atomic		GetPortAtomic();

	foreachinSETAtomic(pr->sem_invariant->inv_privates, SAtomic, AnAtomic){
	    if (AnAtomic->sem_isPreludeType)
		continue;

	    if (inSETflag(AnAtomic->inv_flags, KGSELF) ||
	        inSETflag(AnAtomic->inv_flags, KWSELF))
	    {
		name = AnAtomic->rep_name;
		foreachinSETPort(AnAtomic->inv_ports, SPort, APort) {
		    AnAtomic2 = GetPortAtomic(APort, AnAtomic);
		    ext_type = AnAtomic2->rep_externalType.VTypeEntity;

		    if (IsTypeEntity(AnAtomic->inv_internal)) {
			int_type = AnAtomic->inv_internal.VTypeEntity;
			if (int_type.IDLclassCommon->rep_name !=
			    ext_type.IDLclassCommon->rep_name) {

			    output1(pfile, "#include '%s.i'\n", name);
			    break;
			}
		    }
		    else {
			output1(pfile, "#include '%s.i'\n", name);
			break;
		    }
		}
	    }
	}
}


void GeneratePascalWriteMarkRoutines(pfile, pr)
FILE *pfile;	   /* file pointer */
ProcessEntity pr;  /* process */
{
	SEQClass 	SNode;
	Class 		ANode;
	SETClass	SClass;
	Class		AClass;
	SETClass	SClass2;
	Class		AClass2;
	SETAtomic	SAtomic;
	Atomic		AnAtomic;
	Atomic		AnAtomic2;
	SEQAttribute	SAtt;
	Attribute	Att;
	SETPort		SPort;
	Port		APort;
	SETTypeEntity	SType;
	TypeEntity	AType;
	TypeEntity	att_type;
	StructureEntity	invst;
	String		name;
	String		name2;
	String		ext_name;
	String		int_name;
	TypeEntity	ext_type;
	TypeEntity	root;
	SETflag		flagset;
	SETString 	root_names;
	Boolean		has_output_port=FALSE;
/*	Boolean		mark_ext;      Commented out below  */
	Atomic		GetPortAtomic();

	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) == KPostPort) {
		has_output_port=TRUE;
		break;
	    }
	}
	if (!has_output_port)
	    return;

	invst = pr->sem_invariant;

	output0(pfile, 
            "procedure writer(var IDLoutFile: text; root: nodeType);\n");

	/* generate forward decls of mark and write routines */
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    if (AType.IDLclassCommon->sem_isPreludeType)
		continue;
	    if (typeof(AType)==KSetOf || typeof(AType)==KSeqOf)
		continue;

	    name = AType.IDLclassCommon->rep_name;
	    flagset = AType.IDLclassCommon->inv_flags;

	    if (inSETflag(AType.IDLclassCommon->inv_flags, KWSELF)) {
		output2(pfile, "procedure W%s(IDLn: %s); forward;\n", 
		    name, name);
	    }
	    if (inSETflag(flagset, KWSEQ)) {
		output2(pfile, "procedure WSEQ%s(IDLn: SEQ%s); forward;\n", 
		    name, name);
	    }
	    if (inSETflag(flagset, KWSET)) {
		output2(pfile, "procedure WSET%s(IDLn: SET%s); forward;\n", 
		    name, name);
	    }
	    if (inSETflag(flagset, KMSELF)) {
		output2(pfile, "procedure M%s(IDLn: %s); forward;\n", 
		    name, name);
	    }
	    if (inSETflag(flagset, KMSEQ)) {
		output2(pfile, "procedure MSEQ%s(IDLn: SEQ%s); forward;\n", 
		    name, name);
	    }
	    if (inSETflag(flagset, KMSET)) {
		output2(pfile, "procedure MSET%s(IDLn: SET%s); forward;\n", 
		    name, name);
	    }
	}

	/* generate mark routines */
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    if (!inSETflag(ANode->inv_flags, KMSELF))
		continue;
	    name = ANode->rep_name;
	    output1(pfile, "procedure M%s;\n", name);
	    output0(pfile, "begin\n");
#ifdef DEBUGP
	    output1(pfile, "writeln('in procedure M%s');\n", name);
#endif
	    output0(pfile, "    if (IDLn <> nil) then begin\n");
	    output0(pfile, "        if (Touched(IDLn^.IDLhidden))\n");
	    output0(pfile, "            then MarkShared(IDLn^.IDLhidden)\n");
	    output0(pfile, "        else begin\n");
	    output0(pfile, "            MarkTouched(IDLn^.IDLhidden);\n");
	    /* mark all direct attributes */
	    foreachinSEQAttribute(ANode->sem_allattributes, SAtt, Att) {
	        /* if attribute is propagated, don't mark here */
	        if (Att->inv_parent != ANode)
		    continue;
		if (!ShouldMark(GetAttributeType(Att)))
		    continue;
		if (!InOnePort(pr, Att->inv_ports, KPostPort))
		    continue;
		if (!InAllPorts(pr, Att->inv_ports, KPostPort)) 
		    TestPort(pfile, Att, KPostPort);
		output2(pfile, "            M%s(IDLn^.%s);\n",
		    GetAttTypeName(Att), Att->rep_name);
	    }
	    /* mark all inherited attributes */
	    foreachinSEQAttribute(ANode->sem_allattributes, SAtt, Att) {
	        if (Att->inv_parent == ANode)
		    continue;
		if (!ShouldMark(GetAttributeType(Att)))
		    continue;

		if (!InOnePort(pr, Att->inv_ports, KPostPort))
		    continue;
		if (!InAllPorts(pr, Att->inv_ports, KPostPort)) 
		    TestPort(pfile, Att, KPostPort);
		output2(pfile, "                M%s(IDLn^.%s);\n",
		    GetAttTypeName(Att), GetAttPath(ANode, Att));
	    }
	    output0(pfile, "        end\n");
	    output0(pfile, "    end\n");
	    output0(pfile, "end;\n");
	}
	foreachinSETClass(invst->inv_classes, SClass, AClass) {
	    if (!inSETflag(AClass->inv_flags, KMSELF))
		continue;
	    name = AClass->rep_name;
	    output1(pfile, "procedure M%s;\n", name);
	    output0(pfile, "begin\n");
#ifdef DEBUGP
	    output1(pfile, "writeln('in procedure M%s');\n", name);
#endif
	    output1(pfile, "    case IDLn^.E%s of\n", name);
	    foreachinSETClass(AClass->sem_subclasses, SClass2, AClass2) {
		name2 = AClass2->rep_name;
		output4(pfile, "        K%s%s: M%s(IDLn^.V%s);\n",
		    name, name2, name2, name2);
	    }
	    output0(pfile, "   end\n");
	    output0(pfile, "end;\n");
	}
	foreachinSETAtomic(invst->inv_privates, SAtomic, AnAtomic) {
	    if (AnAtomic->sem_isPreludeType)
		continue;
	    if (!inSETflag(AnAtomic->inv_flags, KMSELF))
		continue;
	    name = AnAtomic->rep_name;
	    output1(pfile, "procedure M%s;\nbegin\nend;\n", name);
	    /***
	    output1(pfile, "procedure M%s;\n", name);
	    output0(pfile, "var ");
	    mark_ext = FALSE;
	    foreachinSETPort(AnAtomic->inv_ports, SPort, APort) {
		if (typeof(APort->sem_portType) != KPostPort)
		    continue;

		AnAtomic2 = GetPortAtomic(APort, AnAtomic);
		ext_type = AnAtomic2->rep_externalType.VTypeEntity;
		if (!ShouldMark(ext_type))
		    continue;
		ext_name = ext_type.IDLclassCommon->rep_name;
		output2(pfile, "    IDLto%s: %s;\n", APort->rep_name, ext_name);
		mark_ext = TRUE;
	    }
	    output0(pfile, "begin\n");
	    output0(pfile, "  case IDLportState of\n");
	    foreachinSETPort(AnAtomic->inv_ports, SPort, APort) {
		if (typeof(APort->sem_portType) != KPostPort)
		    continue;

		AnAtomic2 = GetPortAtomic(APort, AnAtomic);
		ext_type = AnAtomic2->rep_externalType.VTypeEntity;
		if (!ShouldMark(ext_type))
		    continue;

		ext_name = ext_type.IDLclassCommon->rep_name;

		output1(pfile, "    P%s: begin\n", APort->rep_name);
		if (IsTypeEntity(AnAtomic->inv_internal))
		{
		    int_name = AnAtomic->inv_internal.VTypeEntity.
				IDLclassCommon->rep_name;
		    if (int_name == ext_name) {
			output1(pfile, "      IDLto%s := IDLn;\n",
				APort->rep_name);
		    }
		    else {
			output3(pfile, "      %sTo%s(IDLn, IDLto%s);\n", 
				int_name, ext_name, APort->rep_name);
		    }
		}
		else {
		    output3(pfile, "      %sTo%s(IDLn, IDLto%s);\n", 
			    name,ext_name, APort->rep_name);
		}
		output2(pfile, "    M%s(IDLto%s)\n", ext_name, APort->rep_name);
		output0(pfile, "    end;\n");
	    }
	    output0(pfile, " end (* case *)\n");
	    output0(pfile, "end;\n");
	    *****/
	}
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    name = AType.IDLclassCommon->rep_name;
	    flagset = AType.IDLclassCommon->inv_flags;
	    if (inSETflag(flagset, KMSEQ)) {
		output1(pfile, "procedure MSEQ%s;\n",name);
		output1(pfile, "var IDLn2: SEQ%s;\n", name);
		output0(pfile, "begin\n");
		output0(pfile, "    if not (IDLn = nil) then begin\n");
		output1(pfile, "        M%s(IDLn^.value);\n", name);
		output0(pfile, "        IDLn2 := IDLn^.next;\n");
		output0(pfile, "        while not (IDLn2 = nil) do begin\n");
		output1(pfile, "            M%s(IDLn2^.value);\n", name);
		output0(pfile, "            IDLn2 := IDLn2^.next;\n");
		output0(pfile, "        end\n");
		output0(pfile, "    end\n");
		output0(pfile, "end;\n");
	    }
	    if (inSETflag(flagset, KMSET)) {
		output1(pfile, "procedure MSET%s;\n", name);
		output1(pfile, "var IDLn2: SET%s;\n", name);
		output0(pfile, "begin\n");
		output0(pfile, "    if not (IDLn = nil) then begin\n");
		output1(pfile, "        M%s(IDLn^.value);\n", name);
		output0(pfile, "        IDLn2 := IDLn^.next;\n");
		output0(pfile, "        while not (IDLn2 = nil) do begin\n");
		output1(pfile, "            M%s(IDLn2^.value);\n", name);
		output0(pfile, "            IDLn2 := IDLn2^.next;\n");
		output0(pfile, "        end\n");
		output0(pfile, "    end\n");
		output0(pfile, "end;\n");
	    }
	}

	/* generate write routines */
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    if (!inSETflag(ANode->inv_flags, KWSELF))
		continue;
	    name = ANode->rep_name;
	    output1(pfile, "procedure W%s;\n", name);
	    output0(pfile, "    var Sep: char;\n");
	    output0(pfile, "begin\n");
#ifdef DEBUGP
	    output1(pfile, "writeln('in procedure W%s');\n", name);
#endif
	    output0(pfile, "    if (IDLn = nil)\n");
	    output0(pfile, "        then WError(ErrNullNode)\n");
	    output0(pfile, "    else begin\n");
	    output0(pfile, "        Sep := ' ';\n");
	    output0(pfile, "        if (not Touched(IDLn^.IDLhidden))\n");
	    output0(pfile, "            then begin\n");
	    output0(pfile, 
                "              IDLoutLabel(IDLoutFile,IDLn^.IDLhidden);\n");
	    output0(pfile, "              write(IDLoutFile, '^');\n");
	    output0(pfile, "            end\n");
	    output0(pfile, "        else begin \n");
	    output0(pfile, "            if (Shared(IDLn^.IDLhidden))\n");
	    output0(pfile, "                then begin\n");
	    output0(pfile, "                    IDLoutLabel(IDLoutFile,IDLn^.IDLhidden);\n");
	    output0(pfile, "                    write(IDLoutFile, ':');\n");
	    output0(pfile, 
                "                    UnmarkTouched(IDLn^.IDLhidden);\n");
	    output0(pfile, 
                "                    UnmarkShared(IDLn^.IDLhidden);\n");
	    output0(pfile, "                end\n");
	    output0(pfile, "            else\n");
	    output0(pfile, "                UnmarkTouched(IDLn^.IDLhidden);\n");
	    output1(pfile, "            write(IDLoutFile, '%s');\n", 
	        ANode->sem_name);
	    if (!emptySEQAttribute(ANode->sem_allattributes))
		output0(pfile, "            write(IDLoutFile, '[');\n");
	    /* print all direct attributes */
	    foreachinSEQAttribute(ANode->sem_allattributes, SAtt, Att) {
	        /* if attribute is propagated, don't print */
	        if (Att->inv_parent != ANode)
		    continue;
		if (!InOnePort(pr, Att->inv_ports, KPostPort))
		    continue;
		if (!InAllPorts(pr, Att->inv_ports, KPostPort)) 
		    TestPort(pfile, Att, KPostPort);
		output0(pfile, "            begin\n");
		output0(pfile, "            writeln(IDLoutFile, Sep);\n");
		output1(pfile, "            write(IDLoutFile, '%s');\n", 
		    Att->lex_name);
		output0(pfile, "            write(IDLoutFile, ' ');\n");
		att_type = GetAttributeType(Att);
		if (att_type.IDLclassCommon->sem_isPreludeType) {
		    output2(pfile, "            W%s(IDLoutFile,IDLn^.%s);\n",
			GetAttTypeName(Att), Att->rep_name);
		}
		else {
		    output2(pfile, "            W%s(IDLn^.%s);\n",
			GetAttTypeName(Att), Att->rep_name);
		}
		output0(pfile, "            Sep := ';';\n");
		output0(pfile, "            end;\n");
	    }
	    /* print all inherited attributes */
	    foreachinSEQAttribute(ANode->sem_allattributes, SAtt, Att) {
	        if (Att->inv_parent == ANode)
		    continue;
		if (!InOnePort(pr, Att->inv_ports, KPostPort))
		    continue;
		if (!InAllPorts(pr, Att->inv_ports, KPostPort)) 
		    TestPort(pfile, Att, KPostPort);

		output0(pfile, "		begin\n");
		output0(pfile, "                    write(IDLoutFile, Sep);\n");
		output0(pfile, "                    writeln(IDLoutFile);\n");
		output1(pfile, 
                    "                    write(IDLoutFile, '%s');\n", 
                    Att->lex_name);
                output0(pfile, "                    write(IDLoutFile, ' ');\n");
		att_type = GetAttributeType(Att);
		if (att_type.IDLclassCommon->sem_isPreludeType) {
		    output2(pfile, 
                        "                    W%s(IDLoutFile,IDLn^.%s);\n",
			GetAttTypeName(Att), GetAttPath(ANode, Att));
		}
		else {
		    output2(pfile, "                    W%s(IDLn^.%s);\n",
			GetAttTypeName(Att), GetAttPath(ANode, Att));
		}
		output0(pfile, "                    Sep := ';'\n");
		output0(pfile, "                end;\n");
	    }
	    if (!emptySEQAttribute(ANode->sem_allattributes))
		output0(pfile, "            write(IDLoutFile, ']');\n");
	    output0(pfile, "            writeln(IDLoutFile);\n");
	    output0(pfile, "         end\n");
	    output0(pfile, "  end;\n");
	    output0(pfile, "end;\n");
	}

	foreachinSETClass(invst->inv_classes, SClass, AClass) {
	    if (!inSETflag(AClass->inv_flags, KWSELF))
		continue;
	    name = AClass->rep_name;
	    output1(pfile, "procedure W%s;\n", name);
	    output0(pfile, "begin\n");
#ifdef DEBUGP
	    output1(pfile, "writeln('in procedure W%s');\n", name);
#endif
	    output1(pfile, "    case IDLn^.E%s of\n", name);
	    foreachinSETClass(AClass->sem_subclasses, SClass2, AClass2) {
		name2 = AClass2->rep_name;
		output4(pfile, "        K%s%s: W%s(IDLn^.V%s);\n",
		    name, name2, name2, name2);
	    }
	    output1(pfile, "        K%snull: WError(ErrBadClassType);\n", name);
	    output0(pfile, "   end\n");
	    output0(pfile, "end;\n");
	}
	foreachinSETAtomic(invst->inv_privates, SAtomic, AnAtomic) {
	    if (AnAtomic->sem_isPreludeType)
		continue;
	    if (!inSETflag(AnAtomic->inv_flags, KWSELF))
		continue;
	    name = AnAtomic->rep_name;
	    output1(pfile, "procedure W%s;\n", name);
	    output0(pfile, "var ");
	    foreachinSETPort(AnAtomic->inv_ports, SPort, APort) {
		if (typeof(APort->sem_portType) != KPostPort)
		    continue;

		AnAtomic2 = GetPortAtomic(APort, AnAtomic);
		ext_type = AnAtomic2->rep_externalType.VTypeEntity;
		ext_name = ext_type.IDLclassCommon->rep_name;
		output2(pfile, "    IDLto%s: %s;\n", APort->rep_name, ext_name);
	    }

	    output0(pfile, "begin\n");
	    output0(pfile, "  case IDLportState of\n");
	    foreachinSETPort(AnAtomic->inv_ports, SPort, APort) {
		if (typeof(APort->sem_portType) != KPostPort)
		    continue;

		AnAtomic2 = GetPortAtomic(APort, AnAtomic);
		ext_type = AnAtomic2->rep_externalType.VTypeEntity;
		ext_name = ext_type.IDLclassCommon->rep_name;

		output1(pfile, "    P%s: begin\n", APort->rep_name);
		if (IsTypeEntity(AnAtomic->inv_internal))
		{
		    int_name = AnAtomic->inv_internal.VTypeEntity.
			IDLclassCommon->rep_name;
		    if (int_name == ext_name) {
			output1(pfile, "      IDLto%s := IDLn;\n",
			    APort->rep_name);
		    }
		    else {
			output3(pfile, "      %sTo%s(IDLn, IDLto%s);\n", 
			    int_name, ext_name, APort->rep_name);
		    }
		}
		else {
		    output3(pfile, "      %sTo%s(IDLn, IDLto%s);\n", 
			name,ext_name, APort->rep_name);
		}
		if (ext_type.IDLclassCommon->sem_isPreludeType) {
		    output2(pfile, "      W%s(IDLoutFile, IDLto%s)\n", 
			ext_name, APort->rep_name);
		}
		else {
		    output2(pfile, "      W%s(IDLto%s)\n", 
			ext_name,APort->rep_name);
		}
		output0(pfile, "    end;\n");
	    }
	    output0(pfile, " end (* case *)\n");
	    output0(pfile, "end;\n");
	}

	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    name = AType.IDLclassCommon->rep_name;
	    flagset = AType.IDLclassCommon->inv_flags;
	    if (inSETflag(flagset, KWSEQ)) {
		output1(pfile, "procedure WSEQ%s;\n", name);
		output1(pfile, "var IDLn2: SEQ%s;\n", name);
		output0(pfile, "begin\n");
		output0(pfile, "    write(IDLoutFile, '<');\n");
		output0(pfile, "    if not (IDLn = nil) then begin\n");
		output1(pfile, "        W%s(IDLn^.value);\n", name);
		output0(pfile, "        IDLn2 := IDLn^.next;\n");
		output0(pfile, "        while not (IDLn2 = nil) do begin\n");
		output1(pfile, "            W%s(IDLn2^.value);\n", name);
		output0(pfile, "            IDLn2 := IDLn2^.next;\n");
		output0(pfile, "        end\n");
		output0(pfile, "    end;\n");
		output0(pfile, "    write(IDLoutFile, '>')\n");
		output0(pfile, "end;\n");
	    }
	    if (inSETflag(flagset, KWSET)) {
		output1(pfile, "procedure WSET%s;\n", name);
		output1(pfile, "var IDLn2: SET%s;\n", name);
		output0(pfile, "begin\n");
		output0(pfile, "    write(IDLoutFile, '{');\n");
		output0(pfile, "    if not (IDLn = nil) then begin\n");
		output1(pfile, "        W%s(IDLn^.value);\n", name);
		output0(pfile, "        IDLn2 := IDLn^.next;\n");
		output0(pfile, "        while not (IDLn2 = nil) do begin\n");
		output1(pfile, "            W%s(IDLn2^.value);\n", name);
		output0(pfile, "            IDLn2 := IDLn2^.next;\n");
		output0(pfile, "        end\n");
		output0(pfile, "    end;\n");
		output0(pfile, "    write(IDLoutFile, '}')\n");
		output0(pfile, "end;\n");
	    }
	}

	/* generate body of writer routine */
	output0(pfile, "begin (* writer *)\n");
	output0(pfile, "    case root^.Kind of\n");
	initializeSETString(root_names);
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) != KPostPort)
		continue;
	    name = RootName(GetStructureEntity(APort->syn_data));
	    root = GetRoot(GetStructureEntity(APort->syn_data));
	    if (typeof(root) != KClass)
		continue;
	    if (IsClassType(root.VClass)) {
		foreachinSETClass(root.VClass->inv_alldescendants, SClass, 
		    AClass) {
		    if (IsNodeType(AClass)) {
			name = AClass->rep_name;
			if (inSETString(root_names, name))
			    continue;
			addSETString(root_names, name);
			output1(pfile, "    K%s: begin\n", name);
			output2(pfile, "        M%s(root^.V%s);\n",name, name);
			output2(pfile, "        W%s(root^.V%s);\n",name, name);
			output0(pfile, "    end;\n");
		    }
		}
	    }
	    else { /* node */
		if (inSETString(root_names, name))
		    continue;
		addSETString(root_names, name);
		output1(pfile, "    K%s: begin\n", name);
		output2(pfile, "        M%s(root^.V%s);\n",name, name);
		output2(pfile, "        W%s(root^.V%s);\n",name, name);
		output0(pfile, "    end;\n");
	    }
	}
	output0(pfile, "    end;\n");
	output0(pfile, "    write(IDLoutFile, '#');\n");
	output0(pfile, "    writeln(IDLoutFile);\n");
	output0(pfile, "end;\n");

	/* write output port routines */
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) != KPostPort)
		continue;
	    name = RootName(GetStructureEntity(APort->syn_data));
	    root = GetRoot(GetStructureEntity(APort->syn_data));
	    if (typeof(root) != KClass)
		continue;
	    output1(pfile, "procedure %s;\n", APort->rep_name);
	    output0(pfile, "var thisroot: nodeType;\n");
	    output0(pfile, "begin\n");
	    output1(pfile, "    writeln(f, '-- structure %s');\n",
		GetStructureEntity(APort->syn_data)->lex_name);
	    if (IsClassType(root.VClass)) {
		write_rootclass_case(pfile, root.VClass, root.VClass, APort,2);
	    }
	    else { /* node */
		output1(pfile, "    new(thisroot, K%s);\n", name);
		output1(pfile, "    thisroot^.V%s := root;\n", name);
		output1(pfile, "    thisroot^.Kind := K%s;\n", name);
		output1(pfile, "    IDLportState := P%s;\n", APort->rep_name);
		output0(pfile, "    writer(f, thisroot);\n");
	    }
	    output0(pfile, "end;\n");
	}
	output0(pfile, "\n");
}

	
void GeneratePascalReadRoutines(pfile, pr)
FILE *pfile;		    /* file pointer */
ProcessEntity pr;	    /* process */
{
	SETTypeEntity	SType;
	TypeEntity	AType;
	SEQClass 	SNode;
	Class 		ANode;
	SETClass	SClass;
	Class		AClass;
	SETClass	SClass2;
	Class		AClass2;
	SETAtomic	SAtomic;
	Atomic		AnAtomic;
	Atomic		AnAtomic2;
	SEQAttribute	SAtt;
	Attribute	Att;
	SETPort		SPort;
	Port		APort;
	TypeEntity	att_type;
	SETflag		flagset;
	StructureEntity	invst;
	TypeEntity	root;
	String		name;
	String		name2;
	String 		ext_name;
	String 		int_name;
	Boolean 	has_input_port=FALSE;
	int		ctr;
	SEQClass	path;
	char		*sep;
	Atomic		GetPortAtomic();

	invst = pr->sem_invariant;

	/* generate node allocation and default initialization routines */
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    if (!DefineOperation(ClassToTypeEntity(ANode), "Create"))
		continue;
	    name = ANode->rep_name;
	    output1(pfile, "function N%s;\n", name);
	    output2(pfile, "    var new%s: %s;\n", name, name);
	    output0(pfile, "begin\n");
	    output1(pfile, "    new(new%s);\n", name);
	    output2(pfile, "    new%s^.IDLhidden.TypeID := K%s;\n", name, name);
	    output1(pfile, "    new%s^.IDLhidden.Shared := false;\n", name);
	    output1(pfile, "    new%s^.IDLhidden.Touched := false;\n", name);
	    output1(pfile, "    new%s^.IDLhidden.Label := labelAllocator;\n", 
        	name);
	    output0(pfile, "    labelAllocator := labelAllocator + 1;\n");

	    foreachinSETClass(ANode->sem_ancestors, SClass, AClass) {
		initializeSEQClass(path);
		gen_with_for_new(pfile, ANode, path, AClass);
	    }
	    output1(pfile, "    with new%s^ do begin\n", name);
	    foreachinSEQAttribute(ANode->sem_allattributes, SAtt, Att){
		if (Att->inv_parent != ANode)
		    continue;
		output1(pfile, "        %s;\n", GetAttInit(Att));
	    }
	    output0(pfile, "    end;\n");
	    if (!DefineOperation(ClassToTypeEntity(ANode),"DefaultInitialize")){
		output3(pfile, "    N%s := I%s(new%s);\n", name, name, name);
	    }
	    else {
		output2(pfile, "    N%s := new%s\n", name, name);
	    }
	    output0(pfile, "end;\n");
	}
	output0(pfile, "\n");

	/* if there are no input ports return */
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) == KPrePort) {
		has_input_port=TRUE;
		break;
	    }
	}
	if (!has_input_port)
	    return;

	output1(pfile, "#include \'%s\'\n\n", PASCALREADERFILE1);
	/* generate G<name> routines */
	    /* first for nodes */
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    name = ANode->rep_name;
	    flagset = ANode->inv_flags;
	    if (inSETflag(flagset, KGSELF)) { 
		output2(pfile, "function G%s(Val:RepType): %s;\n", name, name);
		output1(pfile, "var Dest: %s;\n", name);
		output0(pfile, "begin\n");
		output0(pfile, "    Dest := nil;\n");
		output0(pfile, "    if Val<>nil\n");
		output0(pfile, "        then begin\n");
		output0(pfile, "            case Val^.Kind of\n");
		output0(pfile, "	    	RepNode:\n");
		output1(pfile, 
                    "		    Dest := Val^.NodeField^.V%s\n", name);
		output0(pfile, "	    end;\n");
		output0(pfile, "	    DelRep(Val)\n");
		output0(pfile, "	end;\n");
		output0(pfile, 
                    "    if Dest=nil then Error(ErrBadNodeType,Lex.Pos)\n");
		output1(pfile, "    else G%s := Dest\n", name);
		output0(pfile, "end;\n\n");
	    }

	}
	    /* next for classes */
	foreachinSETClass(invst->inv_classes, SClass, AClass) {
	    name = AClass->rep_name;
	    flagset = AClass->inv_flags;

	    if (inSETflag(flagset, KGSELF)) {
		output2(pfile, "function G%s (IDLR: RepType): %s;\nvar ", 
		    name, name);
		output1(pfile, "\tDest: %s;\n", name);
		foreachinSETClass(AClass->inv_alldescendants, SClass2,AClass2) {
		    if (IsNodeType(AClass2)) {
			name2 = AClass2->rep_name;
			output2(pfile, "\tIDL%s: %s;\n", name2, name2);
		    }
		}
		output0(pfile, "begin\n");
		output0(pfile, "    Dest := nil;\n");
		output0(pfile, "    case IDLR^.NodeField^.Kind of\n");
		foreachinSETClass(AClass->inv_alldescendants, SClass2,AClass2) {
		    if (IsNodeType(AClass2)) {
			name2 = AClass2->rep_name;
			output3(pfile, 
                            "	K%s: begin IDL%s := G%s(IDLR);\n",
			    name2, name2, name2);
			output2(pfile, "	Dest := IDL%s^.P%s end;\n",
			    name2, GetShortAncPath(AClass2, AClass));
		    }
		}
		output0(pfile, "    end; (* case *)\n");
		output0(pfile, 
                    "    if Dest=nil then Error(ErrBadNodeType,Lex.Pos)\n");
		output1(pfile, "    else G%s := Dest\n", name);
		output0(pfile, "end;\n\n");
	    }
	}

	    /* next for privates */
	foreachinSETAtomic(invst->inv_privates, SAtomic, AnAtomic) {
	    if (AnAtomic->sem_isPreludeType)
		continue;
	    if (!inSETflag(AnAtomic->inv_flags, KGSELF)) 
		continue;

	    name = AnAtomic->rep_name;

	    output2(pfile, "procedure G%s(Val: RepType; var IDLTo:%s);\n",
		name, name);
	    output0(pfile, "begin\n");
	    output0(pfile, "  case IDLportState of\n");

	    foreachinSETPort(AnAtomic->inv_ports, SPort, APort) {
		if (typeof(APort->sem_portType) != KPrePort)
		    continue;

		AnAtomic2 = GetPortAtomic(APort, AnAtomic);
		ext_name = AnAtomic2->rep_externalType.VTypeEntity.
		    IDLclassCommon->rep_name;

		output1(pfile, "    P%s: begin\n", APort->rep_name);

		if (IsTypeEntity(AnAtomic->inv_internal)) {
		    int_name = AnAtomic->inv_internal.VTypeEntity.
		        IDLclassCommon->rep_name;
		    if (int_name == ext_name) {
			output1(pfile, "        IDLTo := G%s(Val);\n",ext_name);
		    }
		    else {
			output3(pfile, "        %sTo%s(G%s(Val), IDLTo);\n",
			    ext_name, int_name, ext_name);
		    }
		}
		else if (typeof(AnAtomic->inv_internal)==KPackage) { 
		    output3(pfile, "        %sTo%s(G%s(Val), IDLTo);\n",
			ext_name, name, ext_name);
		}
		output0(pfile, "    end;\n");
	    }
	    output0(pfile, "  end (* case *)\n");
	    output0(pfile, "end;\n");
	}

	    /* next for sets and sequences */
	foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	    name = AType.IDLclassCommon->rep_name;
	    flagset = AType.IDLclassCommon->inv_flags;

	    if (inSETflag(flagset, KGSEQ)) {
		output2(pfile, "function GSEQ%s (R:RepType): SEQ%s;\n", 
		    name, name);
		output0(pfile, "var S1: SeqType;\n");
		output1(pfile, "    S2, P, retval: SEQ%s;\n", name);
		output0(pfile, "begin\n");
		output0(pfile, "    S1 := R^.seqVal;\n");
		output0(pfile, "    if S1 <> nil\n");
		output0(pfile, "        then begin\n");
		output0(pfile, "            new(P);\n");
		output0(pfile, "            retval := P;\n");
		if (typeof(AType)==KAtomic &&
		    !AType.VAtomic->sem_isPreludeType) {
		    output1(pfile, "            G%s(S1^.value, P^.value);\n",
			name);
		}
		else {
		    output1(pfile, "            P^.value := G%s(S1^.value);\n",
			name);
		}
		output0(pfile, "            S1 := S1^.next;\n");
		output0(pfile, " 	    while S1 <> nil do\n");
		output0(pfile, "	    begin\n");
		output0(pfile, "	    	new(S2);\n");
		if (typeof(AType)==KAtomic &&
		    !AType.VAtomic->sem_isPreludeType) {
		    output1(pfile, "		G%s(S1^.value,S2^.value);\n",
		        name);
		}
		else {
		    output1(pfile, "		S2^.value := G%s(S1^.value);\n",
			name);
		}
		output0(pfile, "		P^.next := S2;\n");
		output0(pfile, "		P := S2;\n");
		output0(pfile, "		S1 := S1^.next;\n");
		output0(pfile, "	    end;\n");
		output0(pfile, "	    P^.next := nil;\n");
		output1(pfile, "	    GSEQ%s := retval;\n", name);
		output0(pfile, "	end\n");
		output1(pfile, "    else GSEQ%s := nil;\n", name);
		output0(pfile, "end;\n");
	    }
	    if (inSETflag(flagset, KGSET)) {
		output2(pfile, "function GSET%s (R:RepType): SET%s;\n",
		    name, name);
		output0(pfile, "var S1: SeqType;\n");
		output1(pfile, "    S2, P, retval: SET%s;\n", name);
		output0(pfile, "begin\n");
		output0(pfile, "    S1 := R^.seqVal;\n");
		output0(pfile, "    if S1 <> nil\n");
		output0(pfile, "        then begin\n");
		output0(pfile, "            new(P);\n");
		output0(pfile, "            retval := P;\n");
		if (typeof(AType)==KAtomic &&
		    !AType.VAtomic->sem_isPreludeType) {
		    output1(pfile, "            G%s(S1^.value, P^.value);\n",
			name);
		}
		else {
		    output1(pfile, "            P^.value := G%s(S1^.value);\n",
			name);
		}
		output0(pfile, "            S1 := S1^.next;\n");
		output0(pfile, " 	    while S1 <> nil do\n");
		output0(pfile, "	    begin\n");
		output0(pfile, "	    	new(S2);\n");
		if (typeof(AType)==KAtomic &&
		    !AType.VAtomic->sem_isPreludeType) {
		    output1(pfile, "		G%s(S1^.value,S2^.value);\n",
		        name);
		}
		else {
		    output1(pfile, "		S2^.value := G%s(S1^.value);\n",
			name);
		}
		output0(pfile, "		P^.next := S2;\n");
		output0(pfile, "		P := S2;\n");
		output0(pfile, "		S1 := S1^.next;\n");
		output0(pfile, "	    end;\n");
		output0(pfile, "	    P^.next := nil;\n");
		output1(pfile, "	    GSET%s := retval;\n", name);
		output0(pfile, "	end\n");
		output1(pfile, "    else GSET%s := nil;\n", name);
		output0(pfile, "end;\n");
	    }
	}

	/* generate AttrStore procedure */
	output0(pfile, "procedure AttrStore;\n");
	output0(pfile, "begin\n");
	output0(pfile, "   if (Ref <> nil) and (Desc <> 0) then begin\n");
	output0(pfile, "        case Ref^.Kind of\n");
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    if (!inSETflag(ANode->inv_flags, KGSELF))
		continue;
	    if (emptySEQAttribute(ANode->sem_allattributes))
		continue;
	    name = ANode->rep_name;
	    output1(pfile, "        K%s:\n", name);
	    output0(pfile, "            case Desc of\n");
	    ctr = 0;
	    foreachinSEQAttribute(ANode->sem_allattributes, SAtt, Att) {
		att_type = GetAttributeType(Att);
		if (typeof(att_type) == KAtomic &&
		    !att_type.VAtomic->sem_isPreludeType) 
		{
		     output4(pfile, 
                         "              %d: G%s(Val, Ref^.V%s^.%s);\n", ++ctr, 
			 GetAttTypeName(Att), name, GetAttPath(ANode, Att));
		}
		else {
		    output4(pfile, 
                        "              %d: Ref^.V%s^.%s := G%s(Val);\n",
			++ctr, name,GetAttPath(ANode, Att),GetAttTypeName(Att));
		}
	    }
	    output0(pfile, "            end;\n");
	}
	output0(pfile, "        end (* case *)\n");
	output0(pfile, "   end (* if *)\n");
	output0(pfile, "end;\n");

	output0(pfile, "procedure FindNodeType;\n");
	output0(pfile, "begin\n");
	output0(pfile, "    OK := false;\n");
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    name = ANode->rep_name;
	    output2(pfile, "    if CompStrings(NodeName, '%s ', %d) then\n",
		ANode->sem_name, strlen(ANode->sem_name));
	    output0(pfile, "       begin\n");
	    output0(pfile, "           OK := true;\n");
	    output1(pfile, "           K  := K%s;\n", name);
	    output0(pfile, "       end;\n");
	}
	output0(pfile, "end;\n");

	output0(pfile, "procedure FindAttribute;\n");
	output0(pfile, "begin\n");
	output0(pfile, "    Attribute := 0;\n");
	output0(pfile, "    case K of\n");
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    if (emptySEQAttribute(ANode->sem_allattributes))
		continue;
	    name = ANode->rep_name;
	    output1(pfile, "        K%s:\n", name);
	    output0(pfile, "        begin\n");
	    ctr = 0;
	    foreachinSEQAttribute(ANode->sem_allattributes, SAtt, Att) {
		output2(pfile, "            if CompStrings(AttrName.Token, '%s ', %d) then\n", Att->lex_name, strlen(Att->lex_name));
		output1(pfile, "                Attribute := %d;\n", ++ctr);
	    }
	    output0(pfile, "        end;\n");
	}
	output0(pfile, "    end; (* case *)\n");
	output0(pfile, "    GoodPair := Attribute > 0;\n");
	output0(pfile, "end;\n");

	output0(pfile, "function NodeAlloc;\n");
	output0(pfile, "    var Ret: nodeType;\n");
	output0(pfile, "begin\n");
	output0(pfile, "    new(Ret);\n");
	output0(pfile, "    Ret^.Kind := K;\n");
	output0(pfile, "    case K of\n");
	foreachinSEQClass(invst->inv_nodes, SNode, ANode) {
	    name = ANode->rep_name;
	    output1(pfile, "       K%s:\n", name);
	    output0(pfile, "           begin\n");
	    output2(pfile, "               Ret^.V%s := N%s;\n", name, name);
	    output0(pfile, "           end;\n");
	}
	output0(pfile, "    end; (* case *)\n");
	output0(pfile, "    NodeAlloc := Ret;\n");
	output0(pfile, "end;\n");

	/* input port routines */
	output0(pfile, "function InRootSet(TheRoot: integer): boolean;\n");
	output0(pfile, "begin\n");
	output0(pfile, "\tInRootSet := TheRoot in [");
	sep = " ";
	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) != KPrePort)
		continue;
	    root = GetRoot(GetStructureEntity(APort->syn_data));
	    if (typeof(root)==KClass) {
		if (IsClassType(root.VClass)) {
		    foreachinSETClass(root.VClass->inv_alldescendants, SClass, 
					AClass) {
			if (IsNodeType(AClass)) {
			    output1(pfile, "%s",sep);
			    output1(pfile, "K%s ", AClass->rep_name);
			    sep = ",";
			}
		    }
		}
		else {
		    output1(pfile, "%s",sep);
		    output1(pfile, "K%s", root.VClass->rep_name);
		    sep = ",";
		}
	    }
	}
	output0(pfile, "]\n");
	output0(pfile, "end;\n");

	output1(pfile, "#include \'%s\'\n\n", PASCALREADERFILE2);

	foreachinSETPort(pr->sem_ports, SPort, APort) {
	    if (typeof(APort->sem_portType) != KPrePort)
		continue;
	    root = GetRoot(GetStructureEntity(APort->syn_data));
	    output1(pfile, "function %s;\n", APort->rep_name);
	    output0(pfile, "    var Root: nodeType;\n");
	    output0(pfile, "begin\n");
	    output1(pfile, "    IDLportState := P%s;\n", APort->rep_name);
	    output0(pfile, "    Reader(f, readerok, Root);\n");
	    if (typeof(root)==KClass) {
		if (IsClassType(root.VClass)) {
		    output0(pfile, "    case Root^.Kind of\n");
		    foreachinSETClass(root.VClass->inv_alldescendants, SClass, 
		        AClass) {
			if (IsNodeType(AClass)) {
			    output1(pfile, "\tK%s: begin\n",AClass->rep_name);
			    output2(pfile, "\t         %s := Root^.V%s\n",
			       APort->rep_name,GetAncPath(AClass, root.VClass));
			    output0(pfile, "\tend;\n");
			}
		    }
		    output0(pfile, "    end\n");
		}
		else { /* node */
		    output2(pfile, "    %s := Root^.V%s;\n", APort->rep_name,
			root.VClass->rep_name);
		}
	    }
	    output0(pfile, "end;\n");
	}

}


/*ARGSUSED*/
void AddPascalSetSeqDeclarations(st, AType, incfile)
StructureEntity st;
TypeEntity AType;
FILE *incfile;
{
	SETflag flagset;	/* flag set of the nonterminal */
	String name;		/* name of the nonterminal */

	if ((typeof(AType)!=KClass) &&
	    (typeof(AType)!=KAtomic)) 
		return;

	name = AType.IDLclassCommon->rep_name;
	flagset = AType.IDLclassCommon->inv_flags;

	if (inSETflag(flagset, KILSET)) {
	    (void) fprintf(incfile,"\tCT%s =\n\t  record\n",name);
	    (void) fprintf(incfile,"\t    next:   SET%s;\n",name);
	    (void) fprintf(incfile,"\t    value:  %s\n\t  end;\n\n",name);
	} 
	if (inSETflag(flagset, KILSEQ)) {
	    (void) fprintf(incfile,"\tCQ%s =\n\t  record\n",name);
	    (void) fprintf(incfile,"\t    next:   SEQ%s;\n",name);
	    (void) fprintf(incfile,"\t    value:  %s\n\t  end;\n\n",name);
	}

} /* end AddPascalSetSeqDeclarations */


void AddPascalSetSeqOpDecls(st, AType, incfile)
StructureEntity st;
TypeEntity AType;
FILE *incfile;
{
	SETflag flagset;	/* flag set of the nonterminal */
	String name;		/* name of the nonterminal */
	Boolean hasset=FALSE;
	Boolean hasseq=FALSE;
	SetOf aset;
	SeqOf aseq;

	if ((typeof(AType)!=KClass) &&
	    (typeof(AType)!=KAtomic)) 
		return;

	if (FindSet(st, AType.VNamedType, &aset) ==FOUND) {
	    hasset = TRUE;
	}
	if (FindSeq(st, AType.VNamedType, &aseq) ==FOUND) {
	    hasseq = TRUE;
	}
	if (!(hasset || hasseq))
	    return;

	name = AType.IDLclassCommon->rep_name;
	flagset = AType.IDLclassCommon->inv_flags;

	/* set operation definitions */
	if (inSETflag(flagset, KILSET)) {
	    if (DefineOperation(SetOfToTypeEntity(aset), "inSET") ||
	        DefineOperation(SetOfToTypeEntity(aset), "equalSET")) {

		(void) fprintf(incfile, "function inSET%s(aset: SET%s; value: %s): boolean; external;\n", name, name, name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "equalSET")) {
		(void) fprintf(incfile, "function equalSET%s(set1: SET%s; set2: SET%s): boolean; external;\n", name, name, name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "initializeSET")) {
		(void) fprintf(incfile, "procedure initializeSET%s(var aset: SET%s); external;\n", name, name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "addSET")) {
		(void) fprintf(incfile, "procedure addSET%s( var aset: SET%s; value: %s); external;\n", name, name, name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "removeSET")) {
		(void) fprintf(incfile, "procedure removeSET%s( var aset: SET%s; value: %s); external;\n", name, name, name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "foreachinSET")) {
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "emptySET")) {
		(void) fprintf(incfile, 
                    "function emptySET%s( aset: SET%s): boolean; external;\n",
                    name, name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "sizeSET")) {
		(void) fprintf(incfile,
		    "function sizeSET%s( aset: SET%s): integer; external;\n", 
		    name, name);
	    }
	    if (DefineOperation(SetOfToTypeEntity(aset), "copySET")) {
		(void) fprintf(incfile,
		    "function copySET%s( aset: SET%s): SET%s; external;\n", 
		    name, name, name);
	    }
	}

	/* add sequence operation definitions				*/
	if (inSETflag(flagset, KILSEQ)) {
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "inSEQ") ||
	        DefineOperation(SeqOfToTypeEntity(aseq), "equalSEQ")) {

		(void) fprintf(incfile, "function inSEQ%s( aseq: SEQ%s; value: %s): boolean; external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "equalSEQ")) {
		(void) fprintf(incfile, "function equalSEQ%s(seq1: SEQ%s; seq2: SEQ%s): boolean; external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "initializeSEQ")) {
		(void) fprintf(incfile, "procedure initializeSEQ%s( var aseq: SEQ%s); external;\n", name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "appendfrontSEQ")) {
		(void) fprintf(incfile, "procedure appendfrontSEQ%s( var aseq: SEQ%s; value: %s); external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "appendrearSEQ")) {
		(void) fprintf(incfile, "procedure appendrearSEQ%s(var aseq:SEQ%s; value:%s); external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "modifyithinSEQ")) {
		(void) fprintf(incfile, "procedure modifyithinSEQ%s( var aseq:SEQ%s; index: integer; value:%s); external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "orderedinsertSEQ")) {
		(void) fprintf(incfile, "procedure orderedinsertSEQ%s(var aseq:SEQ%s; value:%s); external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "retrievefirstSEQ")) {
		(void) fprintf(incfile, "function retrievefirstSEQ%s( aseq: SEQ%s): %s; external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "retrievelastSEQ")) {
		(void) fprintf(incfile, "function retrievelastSEQ%s( aseq: SEQ%s): %s; external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "ithinSEQ")) {
		(void) fprintf(incfile, "function ithinSEQ%s( aseq:SEQ%s; index:integer): %s; external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "tailSEQ")) {
		(void) fprintf(incfile, "function tailSEQ%s( aseq:SEQ%s): SEQ%s; external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "removeithinSEQ")) {
		(void) fprintf(incfile, "procedure removeithinSEQ%s(  var aseq: SEQ%s; index: integer); external;\n", name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "removefirstSEQ")) {
		(void) fprintf(incfile, "procedure removefirstSEQ%s(  var aseq: SEQ%s); external;\n", name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "removeSEQ")) {
		(void) fprintf(incfile, "procedure removeSEQ%s( var aseq: SEQ%s; value: %s); external;\n", name, name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "removelastSEQ")) {
		(void) fprintf(incfile, "procedure removelastSEQ%s(  var aseq: SEQ%s); external;\n", name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "foreachinSEQ")) {
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "emptySEQ")) {
		(void) fprintf(incfile,"function emptySEQ%s( aseq: SEQ%s): boolean; external;\n", name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "lengthSEQ")) {
		(void) fprintf(incfile,"function lengthSEQ%s( aseq: SEQ%s): integer; external;\n", name, name);
	    }
	    if (DefineOperation(SeqOfToTypeEntity(aseq), "copySEQ")) {
		(void) fprintf(incfile,"function copySEQ%s( aseq: SEQ%s): SEQ%s; external;\n", name, name, name);
	    }
	}

} /* end AddPascalSetSeqOpDecls */


void AddPascalSetSeqOperations(pfile, pr)
FILE *pfile;
ProcessEntity pr;
{
    SETflag flagset;		/* flag set of the nonterminal */
    String name;		/* name of the type */
    StructureEntity invst;  	/* invariant structure of process */
    SETTypeEntity SType;
    TypeEntity AType;
    NamedType component;

    Assume((IsProcessEntity(pr)), "AddPascalSetSeqOperations");

    invst = pr->sem_invariant;
    foreachinSETTypeEntity(invst->sem_types, SType, AType) {

	if ((typeof(AType)!=KSetOf) && (typeof(AType)!=KSeqOf))
	    continue;

	component = AType.VSetOrSeq.IDLclassCommon->sem_component;
	name = component.IDLclassCommon->rep_name;
	flagset = component.IDLclassCommon->inv_flags;

	if (typeof(AType)==KSetOf && inSETflag(flagset, KILSET)) {
	    if (DefineOperation(AType, "inSET") ||
	        DefineOperation(AType, "equalSET")) {

		(void) fprintf(pfile,"function inSET%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    inSET%s := false;\n", name);
		(void) fprintf(pfile,"    while (aset <> nil) do begin\n");
		(void) fprintf(pfile,"       if (aset^.value = value)\n");
		(void) fprintf(pfile,"       then begin\n");
		(void) fprintf(pfile,"           inSET%s := true;\n", name);
		(void) fprintf(pfile,"           aset := nil\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"       else begin\n");
		(void) fprintf(pfile,"           aset := aset^.next\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "equalSET")) {
		(void) fprintf(pfile,"function equalSET%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    equalSET%s := true;\n", name);
		(void) fprintf(pfile,"    while (set1 <> nil) do begin\n");
		(void) fprintf(pfile,
                    "       if (not inSET%s(set2, set1^.value))\n", name);
		(void) fprintf(pfile,"       then begin\n");
		(void) fprintf(pfile,"           equalSET%s := false;\n", name);
		(void) fprintf(pfile,"           set1 := nil;\n");
		(void) fprintf(pfile,"           set2 := nil\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"       else begin\n");
		(void) fprintf(pfile,"           set1 := set1^.next\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"    end;\n");
		(void) fprintf(pfile,"    while (set2 <> nil) do begin\n");
		(void) fprintf(pfile,
                    "       if (not inSET%s(set1, set2^.value))\n", name);
		(void) fprintf(pfile,"       then begin\n");
		(void) fprintf(pfile,"           equalSET%s := false;\n", name);
		(void) fprintf(pfile,"           set2 := nil\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"       else begin\n");
		(void) fprintf(pfile,"           set2 := set2^.next\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "initializeSET")) {
		(void) fprintf(pfile,"procedure initializeSET%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    aset := nil\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "addSET")) {
		(void) fprintf(pfile,"procedure addSET%s;\n", name);
		(void) fprintf(pfile,"var tempset: SET%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    new( tempset);\n");
		(void) fprintf(pfile,"    tempset^.value := value;\n");
		(void) fprintf(pfile,"    tempset^.next := aset;\n");
		(void) fprintf(pfile,"    aset := tempset\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "removeSET")) {
		(void) fprintf(pfile,"procedure removeSET%s;\n",name);
		(void) fprintf(pfile,"var tempset: SET%s;\n", name);
		(void) fprintf(pfile,"var tempset1: SET%s;\n", name);
		(void) fprintf(pfile,"var done: boolean;\n");
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aset <> nil)\n");
		(void) fprintf(pfile,"    then begin\n");
		(void) fprintf(pfile,"        if (aset^.value = value)\n");
		(void) fprintf(pfile,"        then begin\n");
		(void) fprintf(pfile,"            tempset := aset;\n");
		(void) fprintf(pfile,"            aset := aset^.next;\n");
		(void) fprintf(pfile,"            dispose(tempset);\n");
		(void) fprintf(pfile,"        end\n");
		(void) fprintf(pfile,"        else begin\n");
		(void) fprintf(pfile,"            done := false;\n");
		(void) fprintf(pfile,"            tempset := aset;\n");
		(void) fprintf(pfile,"            while (done=false) and (tempset^.next <> nil) do begin\n");
		(void) fprintf(pfile,
                    "                if (tempset^.next^.value = value)\n");
		(void) fprintf(pfile,"                then begin\n");
		(void) fprintf(pfile,
                    "                    tempset1 := tempset^.next^.next;\n");
		(void) fprintf(pfile,
                    "                    dispose(tempset^.next);\n");
		(void) fprintf(pfile,
                    "                    tempset^.next := tempset1;\n");
		(void) fprintf(pfile,"                    done := true;\n");
		(void) fprintf(pfile,"                end else \n");
		(void) fprintf(pfile,
                    "                    tempset := tempset^.next\n");
		(void) fprintf(pfile,"           end\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"   end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "foreachinSET")) {
	    }
	    if (DefineOperation(AType, "emptySET")) {
		(void) fprintf(pfile,"function emptySET%s;\n", name, name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aset = nil)\n");
		(void) fprintf(pfile,"    then emptySET%s := TRUE\n", name);
		(void) fprintf(pfile,"    else emptySET%s := FALSE\n", name);
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "sizeSET")) {
		(void) fprintf(pfile, "function sizeSET%s;\n", name);
		(void) fprintf(pfile, "var size: integer;\n");
		(void) fprintf(pfile, "begin\n");
		(void) fprintf(pfile, "    size := 0;\n");
		(void) fprintf(pfile, "    while (aset <> nil) do begin\n");
		(void) fprintf(pfile, "        size := size + 1;\n");
		(void) fprintf(pfile, "        aset := aset^.next;\n");
		(void) fprintf(pfile, "    end;\n");
		(void) fprintf(pfile, "    sizeSET%s := size\n", name);
		(void) fprintf(pfile, "end;\n");
	    }
	    if (DefineOperation(AType, "copySET")) {
		(void) fprintf(pfile,"function copySET%s;\n", name);
		(void) fprintf(pfile,
                    "var tempset, tempset2, newset: SET%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    newset := nil;\n");
		(void) fprintf(pfile,"    while (aset <> nil) do begin\n");
		(void) fprintf(pfile,"        new( tempset);\n");
		(void) fprintf(pfile,
                    "        tempset^.value := aset^.value;\n");
		(void) fprintf(pfile,"        tempset^.next := nil;\n");
		(void) fprintf(pfile,"        if (newset = nil) \n");
		(void) fprintf(pfile,"            then newset := tempset\n");
		(void) fprintf(pfile,
                    "            else tempset2^.next := tempset;\n");
		(void) fprintf(pfile,"        aset := aset^.next;\n");
		(void) fprintf(pfile,"        tempset2 := tempset\n");
		(void) fprintf(pfile,"    end;\n");
		(void) fprintf(pfile,"    copySET%s := newset\n", name);
		(void) fprintf(pfile,"end;\n");
	    }
	}

	/* add sequence operations	*/
	if (typeof(AType)==KSeqOf && inSETflag(flagset, KILSEQ)) {
	    if (DefineOperation(AType, "inSEQ") ||
	        DefineOperation(AType, "equalSEQ")) {

		(void) fprintf(pfile,"function inSEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    inSEQ%s := false;\n", name);
		(void) fprintf(pfile,"    while (aseq <> nil) do begin\n");
		(void) fprintf(pfile,"       if (aseq^.value = value)\n");
		(void) fprintf(pfile,"       then begin\n");
		(void) fprintf(pfile,"           inSEQ%s := true;\n", name);
		(void) fprintf(pfile,"           aseq := nil\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"       else begin\n");
		(void) fprintf(pfile,"           aseq := aseq^.next\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "equalSEQ")) {
		(void) fprintf(pfile,"function equalSEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    equalSEQ%s := true;\n", name);
		(void) fprintf(pfile,"    while (seq1 <> nil) do begin\n");
		(void) fprintf(pfile,
                    "       if (not inSEQ%s(seq2, seq1^.value))\n", name);
		(void) fprintf(pfile,"       then begin\n");
		(void) fprintf(pfile,"           equalSEQ%s := false;\n", name);
		(void) fprintf(pfile,"           seq1 := nil;\n");
		(void) fprintf(pfile,"           seq2 := nil\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"       else begin\n");
		(void) fprintf(pfile,"           seq1 := seq1^.next\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"    end;\n");
		(void) fprintf(pfile,"    while (seq2 <> nil) do begin\n");
		(void) fprintf(pfile,
                    "       if (not inSEQ%s(seq1, seq2^.value))\n", name);
		(void) fprintf(pfile,"       then begin\n");
		(void) fprintf(pfile,"           equalSEQ%s := false;\n", name);
		(void) fprintf(pfile,"           seq2 := nil\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"       else begin\n");
		(void) fprintf(pfile,"           seq2 := seq2^.next\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "initializeSEQ")) {
		(void) fprintf(pfile,"procedure initializeSEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    aseq := nil\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "appendfrontSEQ")) {
		(void) fprintf(pfile,"procedure appendfrontSEQ%s;\n", name);
		(void) fprintf(pfile,"var tempseq: SEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    new(tempseq);\n");
		(void) fprintf(pfile,"    tempseq^.value := value;\n");
		(void) fprintf(pfile,"    tempseq^.next := aseq;\n");
		(void) fprintf(pfile,"    aseq := tempseq\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "appendrearSEQ")) {
		(void) fprintf(pfile,"procedure appendrearSEQ%s;\n", name);
		(void) fprintf(pfile,"var tempseq: SEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aseq = nil)\n");
		(void) fprintf(pfile,"    then begin\n");
		(void) fprintf(pfile,"        new(aseq);\n");
		(void) fprintf(pfile,"        aseq^.value := value;\n");
		(void) fprintf(pfile,"        aseq^.next := nil\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"    else begin\n");
		(void) fprintf(pfile,"        tempseq := aseq;\n");
		(void) fprintf(pfile,
                    "        while( tempseq^.next <> nil) do\n");
		(void) fprintf(pfile,"            tempseq := tempseq^.next;\n");
		(void) fprintf(pfile,"        new(tempseq^.next);\n");
		(void) fprintf(pfile,
                    "        tempseq^.next^.value := value;\n");
		(void) fprintf(pfile,"        tempseq^.next^.next := nil\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "modifyithinSEQ")) {
                (void) fprintf(pfile,"procedure modifyithinSEQ%s;\n",name);
                (void) fprintf(pfile,"var tempseq: SEQ%s;\n",name);
                (void) fprintf(pfile,"var count: integer;\n");
                (void) fprintf(pfile,"begin\n");
                (void) fprintf(pfile,"    tempseq := aseq;\n");
                (void) fprintf(pfile,"    count := 1;\n");
                (void) fprintf(pfile,"    while (tempseq <> nil) and (count <= index) do begin\n");
                (void) fprintf(pfile,"      if (count=index) then\n");
                (void) fprintf(pfile,"        tempseq^.value := value;\n");
                (void) fprintf(pfile,"      tempseq := tempseq^.next;\n");
                (void) fprintf(pfile,"      count := count + 1\n");
                (void) fprintf(pfile,"      end\n");
                (void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "orderedinsertSEQ")) {
	    }
	    if (DefineOperation(AType, "retrievefirstSEQ")) {
		(void) fprintf(pfile,"function retrievefirstSEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aseq <> nil)\n");
		(void) fprintf(pfile,"    then begin\n");
		(void) fprintf(pfile,
                    "        retrievefirstSEQ%s := aseq^.value\n", name);
		(void) fprintf(pfile,"    end\n");
		if (typeof(component) != KAtomic)
		    (void) fprintf(pfile,
                        "    else retrievefirstSEQ%s := nil\n",name);
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "retrievelastSEQ")) {
		(void) fprintf(pfile,"function retrievelastSEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aseq <> nil)\n");
		(void) fprintf(pfile,"    then begin\n");
		(void) fprintf(pfile,"        while (aseq^.next <> nil) do\n");
		(void) fprintf(pfile,"            aseq := aseq^.next;\n");
		(void) fprintf(pfile,
                    "        retrievelastSEQ%s := aseq^.value\n",name);
		(void) fprintf(pfile,"    end\n");
		if (typeof(component) != KAtomic)
		    (void) fprintf(pfile,
                        "    else retrievelastSEQ%s := nil\n",name);
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "ithinSEQ")) {
		(void) fprintf(pfile,"function ithinSEQ%s;\n", name);
		(void) fprintf(pfile,"var i: integer;\n");
		(void) fprintf(pfile,"var ok: boolean;\n");
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    ok := true;\n");
		(void) fprintf(pfile,"    for i := 1 to index-1 do\n");
		(void) fprintf(pfile,"        if (aseq <> nil)\n");
		(void) fprintf(pfile,"        then\n");
		(void) fprintf(pfile,"            aseq := aseq^.next\n");
		(void) fprintf(pfile,"        else ok := false;\n");
		(void) fprintf(pfile,"    if ok and (aseq <> nil)  \n");
		(void) fprintf(pfile,"        then ithinSEQ%s := aseq^.value\n", name);
		if (typeof(component) != KAtomic)
		    (void) fprintf(pfile,"    else ithinSEQ%s := nil\n", name);
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "tailSEQ")) {
		(void) fprintf(pfile, "function tailSEQ%s;\n", name);
		(void) fprintf(pfile, "begin\n");
		(void) fprintf(pfile, "    if (aseq <> nil)\n");
		(void) fprintf(pfile, 
                    "        then tailSEQ%s := aseq^.next\n", name);
		(void) fprintf(pfile, "    else tailSEQ%s := nil\n", name);
		(void) fprintf(pfile, "end;\n");
	    }
	    if (DefineOperation(AType, "removefirstSEQ")) {
		(void) fprintf(pfile,"procedure removefirstSEQ%s;\n", name);
		(void) fprintf(pfile,"var tempseq: SEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aseq <> nil)\n");
		(void) fprintf(pfile,"    then begin\n");
		(void) fprintf(pfile,"        tempseq := aseq^.next;\n");
		(void) fprintf(pfile,"        dispose(aseq);\n");
		(void) fprintf(pfile,"        aseq := tempseq\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "removeSEQ")) {
		(void) fprintf(pfile,"procedure removeSEQ%s;\n", name);
		(void) fprintf(pfile,"var tempseq: SEQ%s;\n", name);
		(void) fprintf(pfile,"var tempseq1: SEQ%s;\n", name);
		(void) fprintf(pfile,"var done: boolean;\n");
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aseq <> nil)\n");
		(void) fprintf(pfile,"    then begin\n");
		(void) fprintf(pfile,"        if (aseq^.value = value)\n");
		(void) fprintf(pfile,"        then begin\n");
		(void) fprintf(pfile,"            tempseq := aseq;\n");
		(void) fprintf(pfile,"            aseq := aseq^.next;\n");
		(void) fprintf(pfile,"            dispose(tempseq);\n");
		(void) fprintf(pfile,"        end\n");
		(void) fprintf(pfile,"        else begin\n");
		(void) fprintf(pfile,"            done := false;\n");
		(void) fprintf(pfile,"            tempseq := aseq;\n");
		(void) fprintf(pfile,"            while (done=false) and (tempseq^.next <> nil) do begin\n");
		(void) fprintf(pfile,
                    "                if (tempseq^.next^.value = value)\n");
		(void) fprintf(pfile,"                then begin\n");
		(void) fprintf(pfile,
                    "                    tempseq1 := tempseq^.next^.next;\n");
                (void) fprintf(pfile,
                    "                    dispose(tempseq^.next);\n");
		(void) fprintf(pfile,
                    "                    tempseq^.next := tempseq1;\n");
		(void) fprintf(pfile,"                    done := true;\n");
		(void) fprintf(pfile,"                end else \n");
		(void) fprintf(pfile,
                    "                    tempseq := tempseq^.next\n");
		(void) fprintf(pfile,"           end\n");
		(void) fprintf(pfile,"       end\n");
		(void) fprintf(pfile,"   end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "removeithinSEQ")) {
                (void) fprintf(pfile,"procedure removeithinSEQ%s;\n",name);
                (void) fprintf(pfile,"var tempseq: SEQ%s;\n",name);
                (void) fprintf(pfile,"var prev: SEQ%s;\n",name);
                (void) fprintf(pfile,"var count: integer;\n");
                (void) fprintf(pfile,"var found: boolean;\n");
                (void) fprintf(pfile,"begin\n");
                (void) fprintf(pfile,"    tempseq := aseq;\n",name);
                (void) fprintf(pfile,"    prev := nil;\n");
                (void) fprintf(pfile,"    count := 1;\n");
                (void) fprintf(pfile,"    found := false;\n");
                (void) fprintf(pfile,"    while (tempseq <> nil) and (count <= index) do begin\n");
                (void) fprintf(pfile,"      if (count=index) then begin\n");
                (void) fprintf(pfile,"        if (prev=nil) then\n");
                (void) fprintf(pfile,"           aseq := aseq^.next\n",name,name);
                (void) fprintf(pfile,"        else\n");
                (void) fprintf(pfile,"           prev^.next := tempseq^.next;\n");
                (void) fprintf(pfile,"        found := true\n");
                (void) fprintf(pfile,"        end\n");
                (void) fprintf(pfile,"      else begin\n");
                (void) fprintf(pfile,"        prev := tempseq;\n");
                (void) fprintf(pfile,"        tempseq := tempseq^.next\n");
                (void) fprintf(pfile,"        end;\n");
                (void) fprintf(pfile,"      count := count + 1\n");
                (void) fprintf(pfile,"      end;\n");
                (void) fprintf(pfile,"    if found then\n");
                (void) fprintf(pfile,"      dispose(tempseq)\n");
                (void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "removelastSEQ")) {
		(void) fprintf(pfile,"procedure removelastSEQ%s;\n", name);
		(void) fprintf(pfile,"var tempseq: SEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aseq <> nil)\n");
		(void) fprintf(pfile,"    then begin\n");
		(void) fprintf(pfile,"        if( aseq^.next = nil)\n");
		(void) fprintf(pfile,"        then begin\n");
		(void) fprintf(pfile,"            dispose(aseq);\n");
		(void) fprintf(pfile,"            aseq := nil\n");
		(void) fprintf(pfile,"        end\n");
		(void) fprintf(pfile,"        else begin\n");
		(void) fprintf(pfile,"            tempseq := aseq;\n");
		(void) fprintf(pfile,
                    "            while (tempseq^.next^.next <> nil) do\n");
		(void) fprintf(pfile,
                    "                tempseq := tempseq^.next;\n");
		(void) fprintf(pfile,"            dispose(tempseq^.next);\n");
		(void) fprintf(pfile,"            tempseq^.next := nil\n");
		(void) fprintf(pfile,"        end\n");
		(void) fprintf(pfile,"    end\n");
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "foreachinSEQ")) {
	    }
	    if (DefineOperation(AType, "emptySEQ")) {
		(void) fprintf(pfile,"function emptySEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    if (aseq = nil)\n");
		(void) fprintf(pfile,"    then\n");
		(void) fprintf(pfile,"        emptySEQ%s := TRUE\n", name);
		(void) fprintf(pfile,"    else\n");
		(void) fprintf(pfile,"        emptySEQ%s := FALSE\n", name);
		(void) fprintf(pfile,"end;\n");
	    }
	    if (DefineOperation(AType, "lengthSEQ")) {
		(void) fprintf(pfile, "function lengthSEQ%s;\n", name);
		(void) fprintf(pfile, "var size: integer;\n");
		(void) fprintf(pfile, "begin\n");
		(void) fprintf(pfile, "    size := 0;\n");
		(void) fprintf(pfile, "    while (aseq <> nil) do begin\n");
		(void) fprintf(pfile, "        size := size + 1;\n");
		(void) fprintf(pfile, "        aseq := aseq^.next;\n");
		(void) fprintf(pfile, "    end;\n");
		(void) fprintf(pfile, "    lengthSEQ%s := size\n", name);
		(void) fprintf(pfile, "end;\n");
	    }
	    if (DefineOperation(AType, "copySEQ")) {
		(void) fprintf(pfile,"function copySEQ%s;\n", name);
		(void) fprintf(pfile,
                    "var tempseq, tempseq2, newseq: SEQ%s;\n", name);
		(void) fprintf(pfile,"begin\n");
		(void) fprintf(pfile,"    newseq := nil;\n");
		(void) fprintf(pfile,"    while (aseq <> nil) do begin\n");
		(void) fprintf(pfile,"        new( tempseq);\n");
		(void) fprintf(pfile,
                    "        tempseq^.value := aseq^.value;\n");
                (void) fprintf(pfile,"        tempseq^.next := nil;\n");
		(void) fprintf(pfile,"        if (newseq = nil) \n");
		(void) fprintf(pfile,"            then newseq := tempseq\n");
		(void) fprintf(pfile,
                    "            else tempseq2^.next := tempseq;\n");
		(void) fprintf(pfile,"        aseq := aseq^.next;\n");
		(void) fprintf(pfile,"        tempseq2 := tempseq\n");
		(void) fprintf(pfile,"    end;\n");
		(void) fprintf(pfile,"    copySEQ%s := newseq\n", name);
		(void) fprintf(pfile,"end;\n");
	    }
	} /* end define sequence operations */
    }  /* end foreachinSETTypeEntity */
} /*end AddPascalSetSeqOperation */


void GeneratePascalMacros(pr)
ProcessEntity pr;
{
    SETClass SClass;		/* set/seq traversals and values */
    Class AClass;
    SETTypeEntity SType;
    TypeEntity AType;
    SEQAttribute SAtt;
    Attribute AnAtt;
    SETClass Ssubclass;
    Class Asubclass;
    String name;		/* for de-referencing */
    String dname;
    StructureEntity invst;
    char *anc_path;
    char buf[81];		/* to construct name of file */
    FILE *mfile, *fopen();	/* file ptr and function */

    Assume((IsProcessEntity(pr)), "GeneratePascalMacros");

    (void)sprintf(buf, "%sFunctions.h", pr->lex_name);
    if ((mfile=fopen(buf, "w")) == NULL) {
	(void) fprintf(stderr, "Can't open macros file %s\n", buf);
	return;
    }

    invst = pr->sem_invariant;

    /* generate attribute accesses */
    (void) fprintf(mfile,"(* Class and Node Attribute accessing macros *)\n\n");
    foreachinSETTypeEntity(invst->sem_types, SType, AType) {
	if (typeof(AType) != KClass)
	    continue;
	AClass = AType.VClass;
	name = AClass->rep_name;
	foreachinSEQAttribute(AClass->sem_allattributes, SAtt, AnAtt) {
	    (void) fprintf(mfile, "#define %sOf%s(IDLnc) IDLnc^.%s\n",
		AnAtt->rep_name, name, GetAttPath(AClass, AnAtt));
	}
    }

    /* generate conversion macros */
    (void) fprintf(mfile, "\n(* Widening Conversion macros *)\n\n");
    foreachinSEQClass(invst->inv_classes, SClass, AClass) {
	name = AClass->rep_name;
	foreachinSETClass(AClass->inv_alldescendants, Ssubclass, Asubclass) {
	    dname = Asubclass->rep_name;
	    /* descendant to class */
	    anc_path = GetAncPath(Asubclass, AClass);
	    anc_path = IDLstrchr(anc_path, '^');
	    anc_path += 3;
	    (void) fprintf(mfile, "#define %sTo%s(IDLnc) IDLnc^.V%s\n",
		dname, name, anc_path);
	}
	(void) fprintf(mfile, "\n");
    }
    /* generate conversion macros */
    (void) fprintf(mfile, "\n(* Narrowing Conversion macros *)\n\n");
    foreachinSEQClass(invst->inv_classes, SClass, AClass) {
	name = AClass->rep_name;
	foreachinSETClass(AClass->inv_alldescendants, Ssubclass, Asubclass) {
	    dname = Asubclass->rep_name;

	    (void) fprintf(mfile, "#define %sTo%s(IDLnc) IDLnc%s^.V%s\n",
		name, dname, GetDescPath(Asubclass, AClass), dname);
	}
	(void) fprintf(mfile, "\n");
    }
}


void TestPort(pfile, Att, porttype)
FILE *pfile;
Attribute Att;
int porttype;
{
	SETPort SPort;
	Port APort;

	output0(pfile, "            if (IDLportState in [");
	foreachinSETPort(Att->inv_ports, SPort, APort) {
	    if (typeof(APort->sem_portType)==porttype)
		output1(pfile, "P%s ", APort->rep_name);
	}
	output0(pfile, "] ) then \n");
}


char *GetAttInit(Att)
Attribute 	Att;
{
	static	char 	buf[3000];
	String		atom_name;
	String		att_name;
	Attribute	new_att;
	TypeEntity	att_type;
	Atomic		atom;

	att_name = Att->rep_name;
	att_type = GetAttributeType(Att);
	switch (typeof(att_type)) {
	    case KClass:
	    case KSetOf:
	    case KSeqOf:
		(void)sprintf(buf, "%s := nil", att_name);
		break;
	    case KAtomic:
		atom = att_type.VAtomic;
		atom_name = att_type.VAtomic->sem_name;
		if (!strcmp(atom_name, "Integer"))
		    (void)sprintf(buf, "%s := 0", att_name);
		else if (!strcmp(atom_name, "Boolean"))
		    (void)sprintf(buf, "%s := false", att_name);
		else if (!strcmp(atom_name, "String"))
		    (void)sprintf(buf, "%s := nil", att_name);
		else if (!strcmp(atom_name, "Rational"))
		    (void)sprintf(buf, "%s := 0.0", att_name);
		else if (typeof(atom->inv_internal)==KPackage){
		    if (!DefineOperation(AtomicToTypeEntity(atom),
                        "DefaultInitialize"))
			(void)sprintf(buf, "I%s(%s)", atom_name, att_name);
		    else buf[0] = '\0';
		}
		else if (IsTypeEntity(att_type.VAtomic->inv_internal)) {
		    new_att = NAttribute;
		    new_att->rep_name = att_name;
		    new_att->rep_descriptor = Ndescriptor;
		    new_att->rep_descriptor->rep_type.VTypeEntity = 
			att_type.VAtomic->inv_internal.	VTypeEntity;
		    return(GetAttInit(new_att));
		}
		else /* shouldn't happen ??? */
		    buf[0] = '\0';
		break;
	}
	return(buf);
}


String GetAttPath(aclass, att)
Class aclass;
Attribute att;
{
	char 		buf[2000];
	SETClass	SCl;
	Class		ACl;
        void            exit();

	if (aclass == att->inv_parent)
	    return(att->rep_name);
	
	/* else propagated so find real parent */
	foreachinSETClass(aclass->sem_ancestors, SCl, ACl) {
	    if (inSEQAttribute(ACl->sem_allattributes, att)) {
		/* found an ancestor */
		(void)sprintf(buf, "P%s^.%s", ACl->rep_name, GetAttPath(ACl, att));
		return(NewString(buf));
	    }
	}

	/* if we get to this point something is wrong */
	(void) fprintf(stderr, "Error in GetAttPath Class = '%s' att = '%s'\n",
	    aclass->sem_name, att->lex_name);
	exit(1);
        /*NOTREACHED*/
}


void gen_with_for_new(pfile, ANode, path, anc_class)
FILE *pfile;
Class ANode;
SEQClass path;
Class anc_class;
{
	String 		name;
	String 		name2;
	String 		name3;
	SETClass	SClass2;
	SEQClass	SClass;
	Class		AClass;
	SEQAttribute	SAtt;
	Attribute	Att;
	String		AStr;
	SEQString	rev_path;
	char		path_str[2000];
	char		K_str[2000];
	int		path_len;

	path_len = lengthSEQClass(path);

	/* build path */
	initializeSEQString(rev_path);
	path_str[0] = '\0';
	foreachinSEQClass(path, SClass, AClass) {
	    name2 = AClass->rep_name;
	    (void) strcat(path_str, "^.P");
	    (void) strcat(path_str, name2);
	    appendfrontSEQString(rev_path, name2);
	}

	/* build K constant string */
	K_str[0] = '\0';

	if (lengthSEQString(rev_path) > 0) {
	    retrievefirstSEQString(rev_path, AStr);
	    (void) strcat(K_str, AStr);
	}
	else
	    (void) strcpy(K_str, ANode->rep_name);

	name = ANode->rep_name;
	name2 = anc_class->rep_name;

	output5(pfile, "    new(new%s%s^.P%s, K%s%s);\n", name, path_str, 
            name2,  name2, K_str);
	output3(pfile, "    with new%s%s^.P%s^ do begin\n", name, path_str, 
            name2 );
	output3(pfile, "        E%s := K%s%s;\n", name2, name2, K_str);

	if (path_len > 0) {
	    retrievefirstSEQString(rev_path, name3);
	}
	else {
	    name3 = name;
	}

	output3(pfile, "        V%s := new%s%s;\n", name3, name, path_str);
	foreachinSEQAttribute(anc_class->sem_allattributes, SAtt, Att){
	    if (Att->inv_parent != anc_class)
		continue;
	    output1(pfile, "        %s;\n", GetAttInit(Att));
	}
	output0(pfile, "    end;\n");

	appendrearSEQClass(path, anc_class);
	foreachinSETClass(anc_class->sem_ancestors, SClass2, AClass)
	    gen_with_for_new(pfile, ANode, path, AClass);
	removeSEQClass(path, anc_class);
}


String GetAncPath(node, anc_class)
Class node;
Class anc_class;
{
	char buf[2000];
	SEQClass 	SClass;
	Class		AClass;
	SEQClass	path;

	initializeSEQClass(path);
	appendfrontSEQClass(path, node);
	(void)GetAncPath2(node, anc_class, &path);
	buf[0] = '\0';
	foreachinSEQClass(path,SClass, AClass) {
	    (void) strcat(buf, AClass->rep_name);
	    (void) strcat(buf, "^.P");
	}
	(void) strcat(buf, anc_class->rep_name);
	return(NewString(buf));
}


String GetShortAncPath(node, anc_class)
Class node;
Class anc_class;
{
	char buf[2000];
	SEQClass 	SClass;
	Class		AClass;
	SEQClass	path;

	initializeSEQClass(path);
	(void)GetAncPath2(node, anc_class, &path);
	buf[0] = '\0';
	foreachinSEQClass(path,SClass, AClass) {
	    (void) strcat(buf, AClass->rep_name);
	    (void) strcat(buf, "^.P");
	}
	(void) strcat(buf, anc_class->rep_name);
	return(NewString(buf));
}


Boolean GetAncPath2(node, anc_class, path)
Class 		node;
Class 		anc_class;
SEQClass 	*path;
{
	SEQClass 	SClass;
	Class		AClass;

	if (inSEQClass(node->sem_ancestors, anc_class)) {
	    return(TRUE);
	}
	foreachinSEQClass(node->sem_ancestors, SClass, AClass) {
	    appendrearSEQClass(*path, AClass);
	    if (GetAncPath2(AClass, anc_class, path)) {
		return(TRUE);
	    }
	    else removeSEQClass(*path, AClass);
	}
	return(FALSE);
}


String GetDescPath(node, anc_class)
Class node;
Class anc_class;
{
	char buf[2000];
	SEQClass 	SClass;
	Class		AClass;
	SEQClass	anc_path;
	SEQClass	desc_path;

	initializeSEQClass(anc_path);
	(void)GetAncPath2(node, anc_class, &anc_path);

	initializeSEQClass(desc_path);
	foreachinSEQClass(anc_path,SClass, AClass) {
	    appendfrontSEQClass(desc_path, AClass);
	}

	buf[0] = '\0';
	foreachinSEQClass(desc_path,SClass, AClass) {
	    (void) strcat(buf, "^.V");
	    (void) strcat(buf, AClass->rep_name);
	}
	return(NewString(buf));
}


String GetDescConst(node, anc_class)
Class node;
Class anc_class;
{
	char buf[2000];
	Class		AClass;
	SEQClass	anc_path;

	initializeSEQClass(anc_path);
	(void)GetAncPath2(node, anc_class, &anc_path);

	if ((lengthSEQClass(anc_path)) > 0) {
	    retrievefirstSEQClass(anc_path, AClass);
	    (void)sprintf(buf, "K%s%s", AClass->rep_name, node->rep_name);
	}
	else {
	    (void)sprintf(buf, "K%s", node->rep_name);
	}
	return(NewString(buf));
}


void write_rootclass_case(pfile, root, curr_class, APort, indent)
FILE *pfile;
Class root;
Class curr_class;
Port APort;
int indent;
{
	String name, name2;
	SETClass SClass;
	Class AClass;

	name2 = curr_class->rep_name;
	write_indent(pfile, indent-1);
	if (root == curr_class) {
	    output1(pfile, "case root^.E%s of\n", name2);
	}
	else {
	    output3(pfile, "case root%s^.V%s^.E%s of\n", 
		GetDescPath(curr_class, root), name2, name2);
	}
	foreachinSETClass(curr_class->sem_subclasses, SClass, AClass) {
	    if (IsNodeType(AClass)) {
		name = AClass->rep_name;
		write_indent(pfile, indent);
		output2(pfile, "K%s%s: begin\n", name2, name);
		write_indent(pfile, indent);
		output1(pfile, "    new(thisroot, K%s);\n", name);
		write_indent(pfile, indent);
		output3(pfile, "    thisroot^.V%s := root%s^.V%s;\n", 
		    name, GetDescPath(AClass, root), name);
		write_indent(pfile, indent);
		output1(pfile, "    thisroot^.Kind := K%s;\n", name);
		write_indent(pfile, indent);
		output1(pfile, "    IDLportState := P%s;\n", APort->rep_name);
		write_indent(pfile, indent);
		output0(pfile, "    writer(f, thisroot);\n");
		write_indent(pfile, indent);
		output0(pfile, "end;\n");
	    }
	    else {
		name = AClass->rep_name;
		write_indent(pfile, indent);
		output2(pfile, "K%s%s: begin\n", name2, name);
		write_rootclass_case(pfile, root, AClass, APort, indent+2);
		write_indent(pfile, indent);
		output0(pfile, "end;\n");
	    }
	}
	write_indent(pfile, indent-1);
	output0(pfile, "end;\n");
}


void write_indent(pfile, indent)
FILE *pfile;
int indent;
{
	register int i;
	for (i=0; i<indent; i++)
	    output0(pfile, "    ");
}
