/***********************************************************************\ 
*									* 
*   File: scorpion/src/idlc/backend/gencfile2.c 
*				 					* 
*   Copyright (C) 1991 Karen Shannon and Richard Snodgrass
*									* 
*   The Scorpion System is free software in the public domain; you can  * 
*   redistribute it and/or modify it as you wish. We ask that you 	* 
*   retain credits referencing the University of Arizona and that you	* 
*   identify any changes you make.					* 
*									* 
*   Report problems to scorpion-project@cs.arizona.edu			* 
*   Direct all inquiries to:	The Scorpion Project			* 
*				Department of Computer Science		* 
*				Gould-Simpson Building			* 
*				University of Arizona			* 
*				Tucson, AZ 85721			* 
*				U.S.A.					* 
*									* 
*   Function: Support routines used for generating .h and .c file	*
*									*
*           DefineOperation SetCTypes 					*
*	    SetCsetseqType GetAttrStoreTypeCase				*
*	    GetAttTypeName InOnePort InAllPorts SwapNodes ReadAttribute	*
*	    GetDate							*
*									*
\* ******************************************************************* */

#ifndef lint
static char rcsid[] = "$Header: ";
#endif

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	gencfile2.c,v $
 * Revision 4.2  90/08/20  16:09:50  hkaram
 * @
 * 
 * Revision 1.1  89/07/05  16:35:32  kps
 * Initial revision
 * 
 * Revision 4.0  89/04/12  01:20:15  cheung
 * gencfile2.c  Ver 4.0
 * 
 * Revision 3.9  89/04/07  23:22:16  cheung
 * gencfile2.c  Ver 3.9
 * 
 * Revision 3.9  89/03/30  14:11:07  cheung
 * gencfile2.c  Ver 3.9
 * 
 * Revision 3.9  89/03/26  14:25:03  cheung
 * gencfile2.c  Ver 3.9
 * 
 * Revision 3.2  87/11/30  14:58:12  rajan
 * *** empty log message ***
 * 
 * Revision 1.1  87/04/18  11:58:55  shannon
 * Initial revision
 * 
 * Revision 2.4  86/05/15  05:28:27  shannon
 * Version 2.4
 * 
 * Revision 2.3  86/05/05  15:17:22  shannon
 * Version 2.3 of IDL System
 * 
 * Revision 2.2  86/04/08  12:55:43  shannon
 * Version2.2
 * 
 * Revision 2.1  86/03/20  16:58:01  shannon
 * SEI Relase
 * 
 * Revision 2.0  86/01/22  07:28:25  shannon
 * Release 2.0 of IDL System
 * 
*									*
*   Edit Log:								*
*     Mar  1985 (shannon) Created.					*
*									*
\* ******************************************************************* */
#include "Backend.h"
#include "macros.h"
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

#ifndef sgi
#include <sys/timeb.h>
#endif



# define DEFAULTSETINTSIZE 1
# define MAXTYPELENGTH 81
# define PREFIX "T"

/*
 *    Forward References:
 */
void SetCsetseqType();
Boolean HasSubclass();

/*************************************************************/
/* check if an operation should be defined for a type        */
/*************************************************************/
Boolean DefineOperation(TheType, theoperation)
TypeEntity TheType;
String theoperation;
{

	SETSeqOperation SSeqOp;		/* set traversals and values */
	SeqOperation ASeqOp;
	SETSetOperation SSetOp;
	SetOperation ASetOp;
	SETClassOperation SClOp;
	ClassOperation AClOp;
	SETAtomicOperation SAtOp;
	AtomicOperation AAtOp;
	String opname;

	Assume((IsTypeEntity(TheType)&&IsString(theoperation)),
		"DefineOperation");
	opname = NewString(theoperation);

	switch (typeof(TheType)) {
	    case KClass:
		foreachinSETClassOperation(TheType.VClass->rep_allowedOps,
					    SClOp, AClOp){
		    if (strequal(opname, AClOp->rep_name))
			return(TRUE);
		}
		break;
	    case KAtomic:
		foreachinSETAtomicOperation(TheType.VAtomic->rep_allowedOps,
					    SAtOp, AAtOp){
		    if (strequal(opname, AAtOp->rep_name))
			return(TRUE);
		}
		break;
	    case KSetOf:
		foreachinSETSetOperation(TheType.VSetOf->rep_allowedOps,
					    SSetOp, ASetOp){
		    if (strequal(opname, ASetOp->rep_name))
			return(TRUE);
		}
		break;
	    case KSeqOf:
		foreachinSETSeqOperation(TheType.VSeqOf->rep_allowedOps,
					    SSeqOp, ASeqOp){
		    if (strequal(opname, ASeqOp->rep_name))
			return(TRUE);
		}
		break;
	}

	/* if this point is reached operation is not defined */
	return(FALSE);
}

/************************************************/
/* add special representation for c types	*/
/************************************************/
void SetCTypes(st)
StructureEntity st; /* invariant structure of the process */
{
	SETTypeEntity SType;
	TypeEntity AType;

	foreachinSETTypeEntity(st->sem_types, SType, AType) {
	    if ((typeof(AType)==KSetOf) || (typeof(AType)==KSeqOf))
		SetCsetseqType(AType.VSetOrSeq);
	}
}


void SetCsetseqType(ASetOrSeq)
SetOrSeq ASetOrSeq;
{
	
	NamedType component;		/* for de-referencing */
	SETflag flagset;		/* for de-referencing */
	Boolean NCStringMatch();

	component = ASetOrSeq.IDLclassCommon->sem_component;
	flagset = component.IDLclassCommon->inv_flags;

	if (NCStringMatch(ASetOrSeq.IDLclassCommon->rep_package, BITVECTOR)){
	   if (typeof(ASetOrSeq)==KSetOf) {
                if (inSETflag(flagset, KILSET)){
                    removeSETflag(flagset, KILSET);
                    addSETflag(flagset, KIBSET);
                }
                if (inSETflag(flagset, KWSET)){
                    removeSETflag(flagset, KWSET);
                    addSETflag(flagset, KWBARR);
                }
	        if (inSETflag(flagset, KMSET)) {
		    removeSETflag(flagset, KMSET);
		    addSETflag(flagset, KMBARR);
	        }
	        if (inSETflag(flagset, KUSET)) {
		    removeSETflag(flagset, KUSET);
		    addSETflag(flagset, KUBARR);
	        }
	        if (inSETflag(flagset, KGSET)) {
		    removeSETflag(flagset, KGSEQ);
		    addSETflag(flagset, KGBARR);
	        }
            }    
	}
	else if (NCStringMatch(ASetOrSeq.IDLclassCommon->rep_package, ARRAY)){
	    if (typeof(ASetOrSeq)==KSetOf) {
		if (inSETflag(flagset, KILSET)){
		    removeSETflag(flagset, KILSET);
		    addSETflag(flagset, KIASET);
		}
		if (inSETflag(flagset, KWSET)){
		    removeSETflag(flagset, KWSET);
		    addSETflag(flagset, KWASET);
		}
	    }
	    else {
		if (inSETflag(flagset, KILSEQ)) {
		     removeSETflag(flagset, KILSEQ);
		     addSETflag(flagset, KIASEQ);
		}
		if (inSETflag(flagset, KWSEQ)){
		    removeSETflag(flagset, KWSEQ);
		    addSETflag(flagset, KWASEQ);
		}
	    }
	    if (inSETflag(flagset, KMSET) || inSETflag(flagset, KMSEQ)) {
		if (typeof(ASetOrSeq)==KSeqOf)
		    removeSETflag(flagset, KMSEQ);
		else removeSETflag(flagset, KMSET);
		addSETflag(flagset, KMARR);
	    }
	    if (inSETflag(flagset, KUSET) || inSETflag(flagset, KUSEQ)) {
		if (typeof(ASetOrSeq)==KSeqOf)
		    removeSETflag(flagset, KUSEQ);
		else removeSETflag(flagset, KUSET);
		addSETflag(flagset, KUARR);
	    }
	    if (inSETflag(flagset, KGSET) || inSETflag(flagset, KGSEQ)) {
		if (typeof(ASetOrSeq)==KSetOf)
		    removeSETflag(flagset, KGSET);
		else removeSETflag(flagset, KGSEQ);
		addSETflag(flagset, KGARR);
	    }
	}
	component.IDLclassCommon->inv_flags = flagset;
}

/********************************/
/* get the string for the case	*/
/*   stmt			*/
/********************************/
char *GetAttrStoreTypeCase(att)
Attribute att;
{

    static char buf[2000];
    char *name;

    Assume((IsAttribute(att)), "GetAttrStoreTypeCase");
    name = GetAttTypeName(att);
    (void)sprintf(buf, "G%s(IDLR); ", name);

    return (buf);
}

	   
Boolean InOnePort(pr, portset, typePort)
ProcessEntity pr;
SETPort portset;
int typePort;
{
	SETPort tp;		/* traversal of Port set */
	Port pval;		/* value of Port in set */

	Assume((IsProcessEntity(pr)&&(typePort!=0)),
		"InOnePort");
	foreachinSETPort(pr->sem_ports, tp, pval) 
	    if (typeof(pval->sem_portType) == typePort) {
	       if (inSETPort(portset, pval))
		   return(TRUE);
	    }
	
	return(FALSE);
}

Boolean SubclassInOnePort(pr, Pclass, subclass, typePort)
ProcessEntity pr;
Class Pclass, subclass;
int typePort;
{
	SETPort tp;		/* traversal of Port set */
	Port pval;		/* value of Port in set */
	SETPort portset;


	Assume((IsProcessEntity(pr)&&(typePort!=0)),
		"SubclassInOnePort");
	portset = subclass->inv_ports;

	foreachinSETPort(pr->sem_ports, tp, pval) 
	    if (typeof(pval->sem_portType) == typePort) {
	       if (inSETPort(portset, pval) && 
		   HasSubclass(pval, Pclass, subclass)) {
		   	return(TRUE);
	       }
	    }
	
	return(FALSE);
}



Boolean InAllPorts(pr, portset, typePort)
ProcessEntity pr;
SETPort portset;
int typePort;
{
	SETPort tp;		/* traversal of Port set */
	Port pval;		/* value of Port in set */

	Assume((IsProcessEntity(pr)&&(typePort!=0)), "InAllPorts");

	foreachinSETPort(pr->sem_ports, tp, pval) 
	    if (typeof(pval->sem_portType) == typePort) {
	        if (!inSETPort(portset, pval))
		    return(FALSE);
	    }
	
	return(TRUE);
}
Boolean SubclassInAllPorts(pr, Pclass, subclass, typePort)
ProcessEntity pr;
Class Pclass, subclass;
int typePort;
{
	SETPort tp;		/* traversal of Port set */
	Port pval;		/* value of Port in set */
	SETPort portset;

	Assume((IsProcessEntity(pr)&&(typePort!=0)), "SubclassInAllPorts");

	portset = subclass->inv_ports;
	foreachinSETPort(pr->sem_ports, tp, pval) 
	    if (typeof(pval->sem_portType) == typePort) {
	        if (!(inSETPort(portset, pval) && 
		      HasSubclass(pval, Pclass, subclass)))
		    return(FALSE);
	    }
	
	return(TRUE);
}



Boolean SwapNodes(n1, n2)
Class n1, n2;
{

	Assume((IsClass(n1)&&IsClass(n2)), "SwapNodes");
	if (strcmp(n1->sem_name, n2->sem_name) > 0) /* n2 should be before n1 */
		return(TRUE);
	else return(FALSE);			/* the names are equal or
						   n1 should be before n2 */
}


Boolean ReadAttribute(att)
Attribute att;
{

	SETPort tPort;
	Port APort;

	Assume((IsAttribute(att)), "ReadAttribute");

	foreachinSETPort(att->inv_ports, tPort, APort)
		if (typeof(APort->sem_portType) == KPrePort)
			return(TRUE);

	return(FALSE);
}

char *GetDate()
{
    long t;
    char *d;
    char *ctime();
    long time();
    static int init = 1;
    static char thedate[80];

    if (init) {
	init = 0;
	(void)time(&t);
	d = ctime(&t);
	(void)sprintf(thedate, "%s", d);
    }
    return(thedate);
}


Boolean IntTypeSameExtType(atom)
Atomic atom;
{
    Boolean ret_val = FALSE;

    Assume((IsAtomic(atom)), "IntTypeSameExtType");

    if (IsTypeEntity(atom->rep_internalType)) {
	if (IsTypeEntity(atom->rep_externalType)) {
	    if (SameType(atom->rep_internalType.VTypeEntity,
		 atom->rep_externalType.VTypeEntity))
		ret_val = TRUE;
	}
    }
    return(ret_val);
}

Boolean HasSubclass(port, pclass, subclass)
Port port;
Class pclass, subclass;
{
	StructureEntity st;
	SETTypeEntity	Stype;
	TypeEntity	atype;
	SETClass 	SClass;
	Class	 	AClass;
	Class 		foundclass;
	Boolean		found=FALSE;

	/* find the parent class in the port structure */
	st = GetStructureEntity(port->syn_data);
	foreachinSETTypeEntity(st->sem_types, Stype, atype) {
		if ((typeof(atype) == KClass) &&
		    (atype.VClass->sem_name == pclass->sem_name)) {
			foundclass = atype.VClass;
			found = TRUE;
		}
	}
	/* if parent class is found, check by name it is has the subtype */
	if (found) {
	    foreachinSETClass(foundclass->inv_alldescendants, SClass, AClass) {
		    if (subclass->sem_name == AClass->sem_name)
			    return(TRUE);
	    }
	    return(FALSE);
	}
	else return(FALSE);
}
